% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assumptions.R
\name{assumptions_manova}
\alias{assumptions_manova}
\title{Determine the assumptions for the MANOVA test}
\usage{
assumptions_manova(data, factors)
}
\arguments{
\item{data}{Data used for the MANOVA test (rows correspond to observations,
columns to dependent variables).}

\item{factors}{Groups to which rows of \code{data} belong to (independent
variables).}
}
\value{
An object of class \code{assumptions_manova} which is a list
containing two elements:
\describe{
 \item{\code{mvntest}}{List of results from the Royston multivariate
       normality test (\code{\link[MVN]{roystonTest}}), one result per
       group.}
 \item{\code{vartest}}{Result of Box's M test for homogeneity of covariance
       matrices (\code{\link[biotools]{boxM}}).}
}
}
\description{
Determine two assumptions for the MANOVA test: a) multivariate normality
of each group; b) homogeneity of covariance matrices.
}
\note{
This function requires the \code{MVN} and \code{biotools} packages.
}
\examples{

# Determine the assumptions of applying MANOVA to the iris data
# (i.e. multivariate normality of each group and homogeneity of covariance
# matrices)
a <- assumptions_manova(iris[, 1:4], iris[, 5])

}

