% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpoutput.R
\name{summary.assumptions_cmpoutput}
\alias{summary.assumptions_cmpoutput}
\title{Summary method for the assumptions of parametric tests used in a comparison
of an output}
\usage{
\method{summary}{assumptions_cmpoutput}(object, ...)
}
\arguments{
\item{object}{Object of class \code{assumptions_cmpoutput}.}

\item{...}{Currently ignored.}
}
\value{
A list with the following items:
\describe{
 \item{manova}{A matrix of \emph{p}-values for the MANOVA assumptions. All
       rows, expect the last one, correspond to the Royston test for
       multivariate normality for each group; the last row corresponds to
       Box's M test for homogeneity of covariance matrices. Columns
       correspond to number of principal components required to explain the
       percentage of user-specified variance.}
 \item{ttest}{A matrix of \emph{p}-values for the \emph{t}-test assumptions.
       All rows, expect the last one, correspond to the Shapiro-Wilk
       normality test for each group; the last row corresponds to Bartlett's
       for equality of variances. Columns correspond to the principal
       components on which the \emph{t}-test was applied.}
}
}
\description{
Summary method for objects of class \code{assumptions_cmpoutput}, which
contain the assumptions for the parametric tests used in a comparison of an
output.
}
\examples{

# Create a cmpoutput object from the provided datasets
cmp <- cmpoutput("All", c(0.5, 0.6, 0.7),
                 pphpc_ok$data[["All"]], pphpc_ok$obs_lvls)

# Obtain the summary of the assumptions of the cmpoutput object
summary(assumptions(cmp))

}
