% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex_tables.R
\name{toLatex.cmpoutput}
\alias{toLatex.cmpoutput}
\title{Convert \code{cmpoutput} object to \code{LaTeX} table}
\usage{
\method{toLatex}{cmpoutput}(object, cmp_name = "Comp. 1", ...)
}
\arguments{
\item{object}{A \code{\link{cmpoutput}} object.}

\item{cmp_name}{Comparison name (to appear in table).}

\item{...}{Any options accepted by the \code{\link{toLatex.micomp}} function.}
}
\value{
A character vector where each element holds one line of the
corresponding \code{LaTeX} table.
}
\description{
This method converts \code{\link{cmpoutput}} objects to character vectors
representing \code{LaTeX} tables.
}
\details{
This method simply wraps the \code{\link{cmpoutput}} object into a
\code{\link{micomp}} object, and invokes \code{\link{toLatex.micomp}} on the
wrapped object.
}
\examples{

# Create a cmpoutput object by comparing the first output ("Pop.Sheep") of
# one the provided datasets.
cmp <-
 cmpoutput("SheepPop", 0.9, pphpc_ok$data[["Pop.Sheep"]], pphpc_ok$obs_lvls)

# Print latex table source to screen
toLatex(cmp)

}
