% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_scatter.R
\name{st_scatter}
\alias{st_scatter}
\title{Plot a scatter and side boxplot of the stability results}
\usage{
st_scatter(data, order = "none", times, grid_lines = FALSE, side_scale = 0.3)
}
\arguments{
\item{data}{input data frame resulting from \code{\link[=st_previz]{st_previz()}}.}

\item{order}{character: none, mean or median; if the scatter plot should be sorted by any of those statistics of the stability values by individuals.}

\item{times}{a vector with the names of each paired time, e.g. "t1_t2".}

\item{grid_lines}{logical; FALSE to print a blank background or TRUE to include a gray grid}

\item{side_scale}{numeric; scale of the side boxplot}
}
\value{
A scatter plot and a side boxplot of the stability values in the form of a "ggplot" object.
}
\description{
Plot a scatter and side boxplot of the stability results
}
\examples{
t1_t2 <- paired_times(data = clr[,1:25], first = "_1",
                      second = "_25", common = "_0_")
t2_t3 <- paired_times(data = clr[,1:25], first = "_25",
                      second = "_26", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
klist_t2_t3 <- iterative_clustering(data = t2_t3, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
result_t2_t3 <- stabilitas(klist_t2_t3, common = "_0_")
results <- st_previz(results = list(result_t1_t2, result_t2_t3),
                     times = c("t1_t2", "t2_t3"))
st_scatter(data = results, order = "median",
            times = c("t1_t2", "t2_t3"), grid_lines = TRUE,
            side_scale = 0.2)
}
