% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_device.R
\name{query_enphaseenvoy_device}
\alias{query_enphaseenvoy_device}
\title{Enphase Envoy single device query}
\usage{
query_enphaseenvoy_device(
  device_ip = "enphase.local",
  query,
  username = Sys.getenv("ENPHASE_USERNAME"),
  password = Sys.getenv("ENPHASE_PASSWORD")
)
}
\arguments{
\item{device_ip}{IP address or name of the device}

\item{query}{the API query string}

\item{username}{the username needed to authenticate to the inverter.
Defaults to the `ENPHASE_USERNAME` environment variable.}

\item{password}{the password needed to authenticate to the inverter.
Defaults to the `ENPHASE_PASSWORD` environment variable.}
}
\value{
a data-frame with a `device_id` column and the `$Body$Data` turned into
   as many columns as expected
}
\description{
as a port of https://github.com/Matthew1471/Enphase-API/blob/main/Documentation/IQ Gateway API/IVP/Meters/Reports/Production.adoc
}
\examples{
\dontrun{
query_enphaseenvoy_device(query = "reports/production")
}
}
\seealso{
Other device queries: 
\code{\link{query_ap_device}()},
\code{\link{query_ap_devices}()},
\code{\link{query_enphaseenergy_device}()},
\code{\link{query_fronius_device}()},
\code{\link{query_fronius_devices}()}
}
\concept{device queries}
