%% $Id: bClust.Rd 160 2014-07-08 09:04:30Z larssn $

\name{bClust}
\alias{bClust}
\title{
  Clustering sequences based on pairwise distances
}
\description{
  Sequences are clustered by hierarchical clustering based on a set of pariwise distances. The distances must take values between 0.0 and 1.0, and all pairs \emph{not} listed are assumed to have distance 1.0.
}
\usage{
bClust(dist.table,linkage="single",threshold=1.0)
}
\arguments{
  \item{dist.table}{A \code{data.frame} with pairwise distances. The columns \samp{Sequence.A} and \samp{Sequence.B} contain tags identifying pairs of sequences. The column \samp{Distance} contains the distances, always a number from 0.0 to 1.0.}
  \item{linkage}{A text indicating what type of clustering to perform, either \samp{single} (default), \samp{average} or \samp{complete}.}
  \item{threshold}{Specifies the maximum size of a cluster. Must be a distance, i.e. a number between 0.0 and 1.0.}
}
\details{
  Computing clusters (gene families) is an essential step in many comparative studies. \code{\link{bClust}} will assign sequences into gene families by a hierarchical clustering approach. Since the number of sequences may be huge, a full all-against-all distance matrix will be impossible to handle in memory. However, most sequence pairs will have an \sQuote{infinite} distance between them, and only the pairs with a finite (smallish) distance need to be considered.
  
  This function takes as input the distances in a \code{data.frame} where only the interesting distances are listed. Typically, this \code{data.frame} is the output from \code{\link{bDist}}. All pairs of sequence \emph{not} listed are assumed to have distance 1.0, which is considered the \sQuote{infinite} distance. Note that \samp{dist.table} must have the columns \samp{Sequence.A}, \samp{Sequence.B} and \samp{Distance}. The first two contain texts identifying sequences, the latter contains the distances. All sequences must be listed at least once. This should pose no problem, since all sequences have distance 0.0 to themselves, and should be listed with this distance once. 
  
  The \samp{linkage} defines the type of clusters produced. The \samp{threshold} indicates the size of the clusters. A \samp{single} linkage clustering means all members of a cluster have at least one other member of the same cluster within distance \samp{threshold} from itself. An \samp{average} linkage means all members of a cluster are within the distance \samp{threshold} from the center of the cluster. A \samp{complete} linkage means all members of a cluster are no more than the distance \samp{threshold} away from any other member of the same cluster. 
  
  Typically, \samp{single} linkage produces big clusters where members may differ a lot, since they are only required to be close to something, which is close to something,...,which is close to some other member. On the other extreme, \samp{complete} linkage will produce small and tight clusters, since all must be similar to all. The \samp{average} linkage is between, but closer to \samp{complete} linkage. If you want the \samp{threshold} to specify directly the maximum distance tolerated between two members of the same gene family, you must use \samp{complete} linkage. The \samp{single} linkage is the fastest alternative to compute. Using the default setting of \samp{single} linkage and maximum \samp{threshold} (1.0) will produce the largest and fewest clusters possible.
}
\value{
  The function returns a vector of integers, indicating the cluster membership of every unique sequence from the \samp{Sequence.A} and \samp{Sequence.B} columns of the input \samp{dist.table}. The name of each element indicates the sequence. Sequences having the same number are in the same cluster.
}
\author{
  Lars Snipen and Kristian Hovde Liland.
}
\note{The \code{\link{igraph}} package is required by this function.}

\seealso{
  \code{\link{bDist}}, \code{\link{hclust}}, \code{\link{dClust}}, \code{\link{isOrtholog}}.
}
\examples{
# Loading distance data in the micropan package
data(Mpneumoniae.blast.distances,package="micropan")

# Clustering with default settings
clustering.blast.single <- bClust(Mpneumoniae.blast.distances)

# Clustering with complete linkage and a liberal threshold
clustering.blast.complete <- bClust(Mpneumoniae.blast.distances,linkage="complete",threshold=0.75)
}
