% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutatorSequential.R
\name{dict_mutators_sequential}
\alias{dict_mutators_sequential}
\alias{MutatorSequential}
\title{Run Multiple Mutator Operations in Sequence}
\description{
\code{\link{Mutator}} that wraps multiple other \code{\link{Mutator}}s given during construction and uses them for mutation in sequence.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Mutator}}s that it wraps: The configuration parameters of the operator given to the \code{mutators} construction
argument are prefixed with \code{"mutator_1"}, \code{"mutator_2"}, ... up to \code{"mutator_#"}, where \verb{#} is \code{length(mutators)}.
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are the set intersection of supported classes of the \code{\link{Mutator}}s given in \code{mutators}.
}

\section{Dictionary}{

This \code{\link{Mutator}} can be created with the short access form \code{\link[=mut]{mut()}}
(\code{\link[=muts]{muts()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_mutators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
mut("sequential", <mutators>)
muts("sequential", <mutators>)  # takes vector IDs, returns list of Mutators

# long form:
dict_mutators$get("sequential", <mutators>)
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)

# dataset:
#  - x1 is mutated around +- 10
#  - x2 influences sdev of mutation of x1
ds = data.frame(x1 = 0, x2 = c(.01, 0.1, 1))
p = ps(x1 = p_dbl(-10, 10), x2 = p_dbl(0, 10))

# operator that only mutates x1, with sdev given by x2
gauss_x1 = mut("combine",
  operators = list(
    x1 = mut("gauss", sdev_is_relative = FALSE),
    x2 = mut("null")
  ),
  adaptions = list(x1.sdev = function(x) x$x2)
)

gauss_x1$prime(p)
gauss_x1$operate(ds)  # see how x1[1] changes little, x1[3] changes a lot

# operator that mutates x1  with sdev given by x2, as well as x2. However,
# the value that x2 takes after mutation does not influence the value that
# the mutator of x1 "sees" -- although x2 is mutated to extreme values,
# mutation of x1 happens as in `gauss_x1`.
gauss_x1_x2 = mut("combine",
  operators = list(
    x1 = mut("gauss", sdev_is_relative = FALSE),
    x2 = mut("gauss", sdev = 100)
  ),
  adaptions = list(x1.sdev = function(x) x$x2)
)

gauss_x1_x2$prime(p)
gauss_x1_x2$operate(ds)  # see how x1 changes in similar ways to above

# operator that mutates sequentially: first x2, and then x1 with sdev given
# by x2. The value that x2 takes after mutation *does* influence the value
# that the mutator of x1 "sees": x1 is mutated either to a large degree,
# or not at all.

gauss_x2_then_x1 = mut("sequential", list(
    mut("combine",
      operators = list(
        x1 = mut("null"),
        x2 = mut("gauss", sdev = 100)
      )
    ),
    mut("combine",
      operators = list(
        x1 = mut("gauss", sdev_is_relative = FALSE),
        x2 = mut("null")
      ),
      adaptions = list(x1.sdev = function(x) x$x2)
    )
))

gauss_x2_then_x1$prime(p)
gauss_x2_then_x1$operate(ds)
}
\seealso{
Other mutators: 
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{Mutator}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_erase}},
\code{\link{dict_mutators_gauss}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_unif}}

Other mutator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_proxy}}
}
\concept{mutator wrappers}
\concept{mutators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Mutator]{miesmuschel::Mutator}} -> \code{MutatorSequential}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mutators}}{(\code{list} of \code{\link{Mutator}})\cr
\code{\link{Mutator}}s being wrapped. These operators get run sequentially in order.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MutatorSequential-new}{\code{MutatorSequential$new()}}
\item \href{#method-MutatorSequential-prime}{\code{MutatorSequential$prime()}}
\item \href{#method-MutatorSequential-clone}{\code{MutatorSequential$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorSequential-new"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorSequential-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{MutatorSequential} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorSequential$new(mutators)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mutators}}{(\code{list} of \code{\link{Mutator}})\cr
\code{\link{Mutator}}s to wrap. The operations are run in order given to \code{mutators}.
The constructed object gets a \emph{clone} of this argument. The \verb{$mutators} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorSequential-prime"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorSequential-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{mutator} and \code{mutator_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorSequential$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorSequential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorSequential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorSequential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
