% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorGenerationStagnation.R
\name{mlr_terminators_genstag}
\alias{mlr_terminators_genstag}
\alias{TerminatorGenerationStagnation}
\title{Terminator That Stops When a Generation-Wise Aggregated Value Stagnates}
\description{
\code{\link[bbotk:Terminator]{Terminator}} that terminates when a value, aggregated over generations, stagnates.

The user-supplied \code{fitness_aggregator} function is called whenever the archive of evaluated configurations contains a new generation.
The function is supplied with the fitness values, and optionally other data, of all individuals that are alive at that point
(\code{include_previous_generations = FALSE}) or at any point (\code{include_previous_generations = TRUE}).
Its result is saved inside the \verb{$data_extra} field of the \code{\link[bbotk:Archive]{Archive}} object.
Termination is then signaled when the aggregated value has stagnated, or not improved enough, for a given number of generations.

The \code{\link[=mies_aggregate_single_generation]{mies_aggregate_single_generation()}} function is used, see the documentation there for the functioning of \code{fitness_aggregator}.
The \code{fitness_aggregator} functions used for termination must return a scalar value or \code{NULL}, if a generation should be ignored.
The value returned by \code{fitness_aggregator} should be increasing for better performance, even if the underlying objective is being minimized.

Termination is triggered in generation \code{i} when the aggregated value, returned by \code{fitness_aggregator}, of generation \code{i - patience}
is not greater than the maximum of all later generations (\code{i - patience + 1} .. \code{i}) by at least \code{min_delta}.

If the aggregated value for generation \code{i - patience} is not known, for example because fewer than \code{patience + 1} generations
have been evaluated so far, because \code{fitness_aggregator} returned \code{NULL}, or because previous generations were evaluated
when \code{TerminatorGenerationStagnation} was not used, then termination is not triggered, regardless of whether values are known
for generations \emph{before} generation \code{i - patience}.
}
\section{Multi-Fidelity Optimization}{


Multi-fidelity optimization can introduce a few edge-cases, for one because the individuals inside the generation(s) being aggregated may have
been evaluated with different fidelity values, which can give biased results. Besides that, it may also be problematic that increase of
fidelity could lead to "worse" aggregated results (e.g. because of reduced noise making max-aggregation worse), triggering an undesired termination.
\subsection{Termination from fidelity changes}{

Higher fidelity values can sometimes lead to worse aggregated fitness values, which can trigger undesired termination.
However, in many multi-fidelity-setups, terminating before the last fidelity increase, controlled e.g. by the \code{fidelity}
configuration parameter of \code{\link{OptimizerMies}}, may be undesirable to begin with.

If the fidelity increase follows a fixed schedule based on evaluations or generations, one solution may be to use a
\code{\link[bbotk:mlr_terminators_combo]{TerminatorCombo}} together with a \code{\link[bbotk:mlr_terminators_evals]{TerminatorEvals}} or \code{\link{TerminatorGenerations}}
that prevents premature termination. Termination should happen at least \code{patience} generations after the last switch to the
highest fidelity if termination from biased values because of fidelity changes should be avoided.

Otherwise it may be necessary to check whether the \code{budget} value given to \code{fitness_aggregator} reached the desired level,
and to prevent comparisons by letting \code{fitness_aggregator} return \code{NULL} if not.

In both cases one may still have a problem with biased aggregations within an aggregated set of individuals if \code{include_previous_generations}
is \code{TRUE}.
}

\subsection{Biases within aggregated generation(s)}{

When \code{\link{OptimizerMies}} is constructed with \code{multi_fidelity} set to \code{TRUE}, it typically evaluates some configurations multiple times,
at first with a lower fidelity, followed by an evaluation at "full" fidelity.
\code{fitness_aggregator} will only be called for generations containing entirely full-fidelity-evaluations will be aggregated.

This is achieved by caching aggregated fitness values in the \verb{$data_extra} field of the \code{\link[bbotk:Archive]{Archive}} and only ever calling
\code{fitness_aggregator} for a generation that does not have a cached value. Since \code{\link[=mies_step_fidelity]{mies_step_fidelity()}} will
count low-fidelity evaluations as part of the "previous" generation, \code{fitness_aggregator} will not see them.
Note, however that if \code{fitness_aggregator} returns \code{NULL}, it will be called again should a second evaluation occur in the same generation,
since \code{NULL} is not cached and instead treated as absent.

It is possible for \code{fitness_aggregator} to see fitness values that were evaluated with different fidelities when using \code{\link{OptimizerMies}},
and
\enumerate{
\item \code{fidelity_monotonic} is set to \code{TRUE} and fidelity decreases (unlikely setup), or
\item if \code{fidelity_current_gen_only} is set to \code{FALSE} (advanced usage), or
\item The value returned by the \code{fidelity} configuration parameter (not \code{fidelity_offspring}) changes over the course of optimization and
\code{include_previous_generations} of \code{TerminatorGenerationStagnation} is set to \code{TRUE}.
}

(1) and (2) only need consideration in advanced scenarios, but (3) may be a common, e.g. when doing multi-fidelity optimization
and stopping on overall dominated hypervolume stagnation. In this case, it may be necessary to inspect the \code{budget} value given to \code{fitness_aggregator}
and to remove all individuals evaluated with a different than the current fidelity.

When using a custom-written optimization loop, case (1) relates to \code{fidelity_monotonic} argument of \code{\link[=mies_step_fidelity]{mies_step_fidelity()}} and \code{\link[=mies_init_population]{mies_init_population()}},
and case (2) relates to the \code{current_gen_only} argument of \code{\link[=mies_step_fidelity]{mies_step_fidelity()}} and the \code{fidelity_new_individuals_only} argument of \code{\link[=mies_init_population]{mies_init_population()}}.
Case (3) relates to changing the fidelity given to \code{\link[=mies_step_fidelity]{mies_step_fidelity()}} if that function is used, or to changing the fidelity given to \code{\link[=mies_evaluate_offspring]{mies_evaluate_offspring()}} if
\code{\link[=mies_step_fidelity]{mies_step_fidelity()}} is not used.
}
}

\section{Dictionary}{

This \code{\link[bbotk:Terminator]{Terminator}} can be created with the short access form \code{\link[bbotk:trm]{trm()}} (\code{\link[bbotk:trm]{trms()}} to get a list),
or through the \link[mlr3misc:Dictionary]{dictionary} \code{\link[bbotk:mlr_terminators]{mlr_terminators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred
trm("genstag")
trms("genstag")  # takes vector IDs, returns list of Terminators

# long form
mlr_terminators$get("genstag")
}\if{html}{\out{</div>}}
}

\section{Configuration Parameters}{

\itemize{
\item \code{fitness_aggregator} :: \code{function}\cr
Aggregation function, called with information about alive individuals of each generation.
This argument is passed to \code{\link[=mies_aggregate_single_generation]{mies_aggregate_single_generation()}}, see there for more details.
The aggregated values returned by \code{fitness_aggregator} should be maximized, so a larger value must be returned to indicate improvement in a generation,
even if an underlying objective is being minimized. The return value must be a scalar \code{numeric(1)}.
\item \code{include_previous_generations} :: \code{logical(1)}\cr
Whether to aggregate over all individuals that were evaluated (\code{TRUE}), or only the individuals alive in the current generation (\code{FALSE}).
If multi-fidelity optimization is being performed and individuals were re-evaluated with a different fidelity, their \code{x_id} will be the same and only
the last fidelity-reevaluation will be given to \code{fitness_aggregator}. However, individuals from different generations may still have been evaluated
with different fidelity and it may be necessary to inspect the \code{budget} value given to \code{fitness_aggregator} if \code{include_previous_generations} is \code{TRUE} in a
multi-fidelity-setting. See the "Multi-Fidelity Optimization" section for more.
\item \code{min_delta} :: \code{numeric(1)}\cr
Minimum positive change of aggregated value to count as improvement.
This value may also be negative, resulting in termination only when aggregated value \emph{decreases} by at least the given amount.
However, depending on the survival setup, or on \code{include_previous_generations}, it is possible that aggregate values never decrease; in this
case, setting \code{min_delta} to a negative value may never trigger termination.
Initialized to 0.
\item \code{patience} :: \code{integer(1)}\cr
Number of generations with no improvement better than \code{min_delta} after which to terminate.
Initialized to 1.
}
}

\examples{
set.seed(1)
library("bbotk")
lgr::threshold("warn")

# Terminate when hypervolume with nadir `c(0, 0, ...)`
# does not improve for 3 generations by at least 0.1:
tg <- trm("genstag",
  fitness_aggregator = function(fitnesses) domhv(fitnesses),
  include_previous_generations = TRUE,
  min_delta = 0.1,
  patience = 3
)

set.seed(1)
objective <- ObjectiveRFun$new(
  fun = function(xs) {
    list(y1 = xs$x1, y2 = xs$x2)
  },
  domain = ps(x1 = p_dbl(0, 1), x2 = p_dbl(-1, 0)),
  codomain = ps(y1 = p_dbl(0, 1, tags = "maximize"),
    y2 = p_dbl(-1, 0, tags = "minimize"))
)

oi <- OptimInstanceMultiCrit$new(objective, terminator = tg)

op <- opt("mies",
  lambda = 4, mu = 4,
  mutator = mut("gauss", sdev = 0.1),
  recombinator = rec("xounif"),
  parent_selector = sel("random"),
  survival_selector = sel("best", scl("hypervolume"))
)

op$optimize(oi)

# the observed aggregated values:
oi$archive$data_extra$TerminatorGenerationStagnation

# ... or as calculated by mies_generation_apply
mies_generation_apply(oi$archive, function(fitnesses) {
  domhv(fitnesses)
}, include_previous_generations = TRUE)
#' @export
}
\section{Super class}{
\code{\link[bbotk:Terminator]{bbotk::Terminator}} -> \code{TerminatorGenerationStagnation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TerminatorGenerationStagnation-new}{\code{TerminatorGenerationStagnation$new()}}
\item \href{#method-TerminatorGenerationStagnation-is_terminated}{\code{TerminatorGenerationStagnation$is_terminated()}}
\item \href{#method-TerminatorGenerationStagnation-clone}{\code{TerminatorGenerationStagnation$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="format"><a href='../../bbotk/html/Terminator.html#method-Terminator-format'><code>bbotk::Terminator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="print"><a href='../../bbotk/html/Terminator.html#method-Terminator-print'><code>bbotk::Terminator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="remaining_time"><a href='../../bbotk/html/Terminator.html#method-Terminator-remaining_time'><code>bbotk::Terminator$remaining_time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="status"><a href='../../bbotk/html/Terminator.html#method-Terminator-status'><code>bbotk::Terminator$status()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorGenerationStagnation-new"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorGenerationStagnation-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{TerminatorGenerationStagnation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorGenerationStagnation$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorGenerationStagnation-is_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorGenerationStagnation-is_terminated}{}}}
\subsection{Method \code{is_terminated()}}{
Is \code{TRUE} if when the termination criterion is matched, \code{FALSE} otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorGenerationStagnation$is_terminated(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{\code{\link[bbotk:Archive]{Archive}}
Archive to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}: Whether to terminate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorGenerationStagnation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorGenerationStagnation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorGenerationStagnation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
