% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutatorErase.R
\name{dict_mutators_erase}
\alias{dict_mutators_erase}
\alias{MutatorErase}
\title{Uniform Sample Mutator}
\description{
"Mutates" individuals by forgetting the current value and sampling new individuals from scratch.

Since the information loss is very high, this should in most cases be combined with \code{\link{MutatorCmpMaybe}}.
}
\section{Configuration Parameters}{

\itemize{
\item \code{initializer} :: \code{function}\cr
Function that generates the initial population as a \code{\link[paradox:Design]{Design}} object,
with arguments \code{param_set} and \code{n}, functioning like \code{\link[paradox:generate_design_random]{paradox::generate_design_random}} or \code{\link[paradox:generate_design_lhs]{paradox::generate_design_lhs}}.
This is equivalent to the \code{initializer} parameter of \code{\link[=mies_init_population]{mies_init_population()}}, see there for more information. Initialized to
\code{\link[paradox:generate_design_random]{generate_design_random()}}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Mutator}} can be created with the short access form \code{\link[=mut]{mut()}}
(\code{\link[=muts]{muts()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_mutators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
mut("erase")
muts("erase")  # takes vector IDs, returns list of Mutators

# long form:
dict_mutators$get("erase")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
mer = mut("erase")
p = ps(x = p_lgl(), y = p_fct(c("a", "b", "c")), z = p_dbl(0, 1))
data = data.frame(x = rep(TRUE, 5), y = rep("a", 5),
  z = seq(0, 1, length.out = 5),
  stringsAsFactors = FALSE)  # necessary for R <= 3.6

mer$prime(p)
mer$operate(data)

}
\seealso{
Other mutators: 
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_gauss}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}},
\code{\link{dict_mutators_unif}}
}
\concept{mutators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Mutator]{miesmuschel::Mutator}} -> \code{MutatorErase}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MutatorErase-new}{\code{MutatorErase$new()}}
\item \href{#method-MutatorErase-clone}{\code{MutatorErase$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorErase-new"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorErase-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{MutatorErase} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorErase$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorErase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorErase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorErase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
