% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert}
\alias{convert}
\alias{as_matrix}
\alias{as_igraph}
\alias{as_tidygraph}
\alias{as_network}
\alias{is_twomode}
\title{migraph-consistent object classes}
\usage{
as_matrix(object)

as_igraph(object, twomode = FALSE)

as_tidygraph(object, twomode = FALSE)

as_network(object)

is_twomode(object)
}
\arguments{
\item{object}{A data frame edgelist, matrix, igraph, or tidygraph object.}

\item{twomode}{An option to override the heuristics for distinguishing incidence
from adjacency matrices. By default FALSE.}
}
\value{
An adjacency or incidence matrix, named if possible.

An igraph graph object.

A tidygraph tbl_graph class object

A sna/network network class object

A logical vector whether object is two-mode (TRUE) or not (FALSE)
}
\description{
The \code{as_} functions in \code{{migraph}}
typically accept edgelists (as data frames), matrices,
igraph graph objects, or tidygraph tbl_graph objects,
coercing them into the class designated in the function name.
}
\details{
Behaviour is a little different depending on the data format.

If the data frame is a 2 column edgelist,
the first column will become the rows
and the second column will become the columns.
If the data frame is a 3 column edgelist,
then the third column will be used as
the cell values or tie weights.
If the data frame is more than 3 columns,
the first column is full of character strings (i.e. is named)
and the second column is numeric (e.g. 0 and 1)
then it will be assumed that this is a matrix
embedded in a data frame.

Incidence matrices are typically inferred from unequal dimensions,
but since in rare cases a matrix with equal dimensions may still
be an incidence matrix, an additional argument \code{twomode} can be
specified to override this heuristic.
This information is usually already embedded in igraph and tidygraph objects.
}
\examples{
test <- data.frame(id1 = c("A","B","B","C","C"),
                   id2 = c("I","G","I","G","H"))
as_matrix(test)
test <- data.frame(id1 = c("A","B","B","C","C"),
                   id2 = c("I","G","I","G","H"))
as_igraph(test)
test <- data.frame(id1 = c("A","B","B","C","C"),
                   id2 = c("I","G","I","G","H"))
as_tidygraph(test)
test <- data.frame(id1 = c("A","B","B","C","C"),
                   id2 = c("I","G","I","G","H"))
as_network(test)
is_twomode(southern_women)
}
