% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create}
\alias{create}
\alias{create_empty}
\alias{create_complete}
\alias{create_ring}
\alias{create_components}
\alias{create_star}
\title{Create networks with particular structures}
\usage{
create_empty(n)

create_complete(n)

create_ring(n, width = 1, directed = FALSE, ...)

create_components(n, components = 2)

create_star(n, directed = "in")
}
\arguments{
\item{n}{Number of nodes.
If a single integer is given, e.g. \code{n = 10},
the function will create a one-mode network.
If a vector of two integers is given, e.g. \code{n = c(5,10)},
the function will create a two-mode network.}

\item{width}{The width or breadth of the ring. This is typically double the degree.}

\item{directed}{One of the following options: "in", "out", or "none".}

\item{...}{Additional arguments passed on to igraph.}

\item{components}{Number of components to create.}
}
\value{
By default an igraph object will be returned,
but this can be coerced into other types of objects
using \code{as_matrix()}, \code{as_tidygraph()}, or \code{as_network()}.
}
\description{
These functions create a variety of different network objects.
Despite the common function names and syntax with existing packages,
the common \code{n} argument can not only be passed
a single integer to return a one-mode network,
but also a vector of \emph{two} integers to return a two-mode network.
}
\details{
\code{create_empty()} creates an empty graph of the given dimensions.

\code{create_complete()} creates a filled graph of the given dimensions.

\code{create_ring()} creates a ring or chord graph of the given dimensions
that loops around is of a certain width or thickness.

\code{create_components()} creates a graph in which the nodes are clustered
into separate components.
}
\examples{
g <- create_empty(c(8,6))
autographr(g)
g <- create_complete(c(8,6))
autographr(g)
g <- create_ring(c(8,6), width = 2)
autographr(g)
autographr(create_components(c(10, 12), components = 3))
autographr(create_star(c(12,1)))
}
\seealso{
as_matrix as_tidygraph as_network

Other creation: 
\code{\link{generate}}
}
\concept{creation}
