% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_mpn.R
\docType{data}
\name{mpn_elite_mex}
\alias{mpn_elite_mex}
\title{One-mode Mexican power elite database (Knoke 1990)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> 
#> -- # Mexican power elite network -----------------------------------------------
#> # A labelled, undirected network of 35 elites and 117 common belonging or
#> interest ties
#> 
#> -- Nodes
#> # A tibble: 35 x 8
#>   name     full_name        entry_year military in_mpn PlaceOfBirth state region
#>   <chr>    <chr>                 <dbl>    <dbl>  <dbl> <chr>        <chr>  <dbl>
#> 1 Trevino  Trevino, Jacint~       1910        1      0 Guerrero     Coah~      1
#> 2 Madero   Madero, Francis~       1911        0      0 Parras de l~ Coah~      1
#> 3 Carranza Carranza, Venus~       1913        1      0 Cuatro Cien~ Coah~      1
#> 4 Aguilar  Aguilar, Candido       1918        1      0 Cordoba      Vera~      3
#> 5 Obregon  Obregon, Alvaro        1920        1      0 Siquisiva, ~ Sono~      1
#> 6 Calles   Calles, Plutarc~       1924        1      0 Guaymas      Sono~      1
#> # i 29 more rows
#> 
#> -- Ties
#> # A tibble: 117 x 2
#>    from    to
#>   <int> <int>
#> 1     2     3
#> 2     2     5
#> 3     2     6
#> 4     2     4
#> 5     1     2
#> 6     2     8
#> # i 111 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(mpn_elite_mex)
}
\description{
This data contains the full network of 35 members of the Mexican power elite.
The undirected lines connecting pairs of men represent any formal, informal,
or organizational relation between a dyad;
for example, “common belonging (school, sports, business, political participation),
or a common interest (political power)” (Mendieta et al. 1997: 37).
Additional nodal attributes include their full name, place of birth, state,
and region (1=North, 2=Centre, 3=South, original coding added by
\href{https://jameshollway.com/courses/ison/heber_post}{Frank Heber}),
as well as their year of entry into politics
and whether they are civilian (0) or affiliated with the military (1).
An additional variable "in_mpn" can be used to subset this network
to a network of 11 core members of the 1990s Mexican power elite (Knoke 2017),
three of which were successively elected presidents of Mexico:
José López Portillo (1976-82), Miguel de la Madrid (1982-88), and Carlos Salinas de Gortari (1988-94,
who was also the son of another core member, Raúl Salinas Lozano).
}
\details{
\if{html}{\figure{mpnelitemex.png}{options: width="360" alt="Figure: mpn_elite_mex"}}
\if{latex}{\figure{mpnelitemex.pdf}{options: width=7cm}}
}
\references{
Knoke, David. 1990. \emph{Political Networks: The Structural Perspective}.
Cambridge: Cambridge University Press.

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
Cambridge: Cambridge University Press.
}
\keyword{datasets}
