% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{migrate}
\alias{migrate}
\title{Summarize the migration of a data frame}
\usage{
migrate(
  data,
  date,
  state,
  id = NULL,
  metric = NULL,
  percent = TRUE,
  rating = NULL
)
}
\arguments{
\item{data}{A data frame or data frame extension (e.g., a tibble or data.table)
containing a minimum of three (3) column variables representing a date, a credit
risk state, and an ID identifying the credit facility (we would expect to see most
unique values in this column variable appear twice in the dataset; once at the
first date and again at the second date, unless the credit only existed at one of
those two dates).}

\item{date}{A symbol or string, representing the column variable of the `data` data
frame argument that contains the two unique date values.}

\item{state}{A symbol or string, representing the column variable of the `data` data
frame argument that contains the credit risk state values.}

\item{id}{(Optional) a symbol or string, representing the column variable of the
`data` data frame argument that contains the unique identifier to track where a
particular credit facility migrated to/from. If left null, `migrate()` will attempt
to use the first column variable from the data frame provided in the `data` argument.}

\item{metric}{(Optional) a symbol or string, representing the column variable of the
`data` data frame argument that contains the continuous metric values.}

\item{percent}{If `FALSE`, will calculate the migration on an absolute basis (rather
than a percentage basis, which is the default).}

\item{rating}{Deprecated; please use `state` instead.}
}
\value{
A data frame containing three (3) column variables representing the unique
combinations of starting & ending credit risk states and the calculated migration
observed during the period.
}
\description{
`migrate()` summarizes the transition amount (or percentage) of a continuous variable
from each beginning credit risk state category to each ending credit risk state,
given a data frame input.
}
\examples{
# Return the percent migration of the number of credit facilities
migrate(
  data = mock_credit,
  date = date,
  state = risk_rating,
  id = customer_id
)

# Return the absolute migration in `principal_balance`
migrate(
  data = mock_credit,
  date = date,
  state = risk_rating,
  id = customer_id,
  metric = principal_balance,
  percent = FALSE
)

}
