% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mean_roc}
\alias{plot_mean_roc}
\alias{plot_mean_prc}
\alias{plot_curves}
\title{Plot ROC and PRC curves}
\usage{
plot_mean_roc(dat, ribbon_fill = "#C6DBEF", line_color = "#08306B")

plot_mean_prc(
  dat,
  baseline_precision = NULL,
  ribbon_fill = "#C7E9C0",
  line_color = "#00441B"
)
}
\arguments{
\item{dat}{sensitivity, specificity, and precision data calculated by \code{calc_mean_roc()}}

\item{ribbon_fill}{ribbon fill color (default: "#D9D9D9")}

\item{line_color}{line color (default: "#000000")}

\item{baseline_precision}{baseline precision from \code{calc_baseline_precision()}}
}
\description{
Plot ROC and PRC curves
}
\section{Functions}{
\itemize{
\item \code{plot_mean_roc()}: Plot mean sensitivity over specificity

\item \code{plot_mean_prc()}: Plot mean precision over recall

}}
\examples{
\dontrun{
library(dplyr)
# get performance for multiple models
get_sensspec_seed <- function(seed) {
  ml_result <- run_ml(otu_mini_bin, "glmnet", seed = seed)
  sensspec <- calc_model_sensspec(
    ml_result$trained_model,
    ml_result$test_data,
    "dx"
  ) \%>\%
    mutate(seed = seed)
  return(sensspec)
}
sensspec_dat <- purrr::map_dfr(seq(100, 102), get_sensspec_seed)

# plot ROC & PRC
sensspec_dat \%>\%
  calc_mean_roc() \%>\%
  plot_mean_roc()
baseline_prec <- calc_baseline_precision(otu_mini_bin, "dx", "cancer")
sensspec_dat \%>\%
  calc_mean_prc() \%>\%
  plot_mean_prc(baseline_precision = baseline_prec)
}
}
\author{
Courtney Armour

Kelly Sovacool \email{sovacool@umich.edu}
}
