% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mild_df.R
\name{as_mild_df}
\alias{as_mild_df}
\title{Coerce to MILD data frame}
\usage{
as_mild_df(
  x,
  bag_label = "bag_label",
  bag_name = "bag_name",
  instance_name = "instance_name",
  instance_label = "instance_label",
  ...
)
}
\arguments{
\item{x}{A data-frame or similar to convert.}

\item{bag_label}{A character (default \code{'bag_label'}) describing which column
refers to the bag label.}

\item{bag_name}{A character (default \code{'bag_name'}) describing which column
refers to the bag name.}

\item{instance_name}{A character (default \code{'instance_name'}) describing which
column refers to the instance name.}

\item{instance_label}{A character (default \code{'instance_label'}) describing which
column refers to the instance labels. If NULL, no instance_labels will be
used.}

\item{...}{Arguments reserved for other methods.}
}
\value{
A 'mild_df' object. This data.frame-like has columns \code{bag_label},
\code{bag_name}, \code{instance_name}, and potentially others. It also inherits from
the \code{'tbl_df'} and \code{'tbl'} classes.
}
\description{
\code{as_mild_df()} turns an existing object, such as a data frame, into a MILD
data frame, a data frame with 'mild_df'. This is in contrast with
\code{\link[=mild_df]{mild_df()}}, which builds a MILD data frame from individual columns.
}
\examples{
x <- data.frame('bag_LABEL' = factor(c(1, 1, 0)),
               'bag_name' = c(rep('bag_1', 2), 'bag_2'),
               'instance_name' = c('bag_1_inst_1', 'bag_1_inst_2', 'bag_2_inst_1'),
               'X1' = c(-0.4, 0.5, 2),
               'instance_label' = c(0, 1, 0))

df <- as_mild_df(x)

}
\seealso{
\code{\link[=mild_df]{mild_df()}} to build a \code{mild_df} object.
}
\author{
Sean Kent
}
