% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_ls.R
\name{mc_ls}
\alias{mc_ls}
\title{List files and directories using mc command}
\usage{
mc_ls(target, recursive = FALSE, flags = "")
}
\arguments{
\item{target}{Character string specifying the target directory path.}

\item{recursive}{Logical indicating whether to recursively list directories.
Default is \code{FALSE}.}

\item{flags}{Additional flags to be passed to the \code{ls} command.
Default is an empty string.}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
This function uses the \code{mc} command to list files and directories
at the specified target location.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# list all buckets on play server
mc_ls("play/")

\dontshow{\}) # examplesIf}
}
