% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_alias.R
\name{mc_alias_set}
\alias{mc_alias_set}
\title{mc alias set}
\usage{
mc_alias_set(
  alias = "minio",
  endpoint = Sys.getenv("AWS_S3_ENDPOINT", "s3.amazonaws.com"),
  access_key = Sys.getenv("AWS_ACCESS_KEY_ID"),
  secret_key = Sys.getenv("AWS_SECRET_ACCESS_KEY"),
  scheme = "https"
)
}
\arguments{
\item{alias}{a short name for this endpoint, default is \code{minio}}

\item{endpoint}{the endpoint domain name}

\item{access_key}{access key (user), reads from AWS env vars by default}

\item{secret_key}{secret access key, reads from AWS env vars by default}

\item{scheme}{https or http (e.g. for local machine only)}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
Set a new alias for the minio client, possibly using env var defaults.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

mc_alias_set()
\dontshow{\}) # examplesIf}
}
\references{
\url{https://min.io/docs/minio/linux/reference/minio-mc.html}.
Note that keys can be omitted for anonymous use.
}
