% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemon.R
\name{daemon}
\alias{daemon}
\title{Daemon}
\usage{
daemon(
  url,
  asyncdial = FALSE,
  maxtasks = Inf,
  idletime = Inf,
  walltime = Inf,
  timerstart = 0L,
  output = FALSE,
  ...,
  cleanup = 7L,
  tls = NULL,
  rs = NULL
)
}
\arguments{
\item{url}{the character host or dispatcher URL to dial into, including the
port to connect to (and optionally for websockets, a path), e.g.
'tcp://10.75.32.70:5555' or 'ws://10.75.32.70:5555/path'.}

\item{asyncdial}{[default FALSE] whether to perform dials asynchronously. The
default FALSE will error if a connection is not immediately possible
(e.g. \code{\link{daemons}} has yet to be called on the host, or the
specified port is not open etc.). Specifying TRUE continues retrying
(indefinitely) if not immediately successful, which is more resilient but
can mask potential connection issues.}

\item{maxtasks}{[default Inf] the maximum number of tasks to execute (task
limit) before exiting.}

\item{idletime}{[default Inf] maximum idle time, since completion of the last
task (in milliseconds) before exiting.}

\item{walltime}{[default Inf] soft walltime, or the minimum amount of real
time taken (in milliseconds) before exiting.}

\item{timerstart}{[default 0L] number of completed tasks after which to start
the timer for 'idletime' and 'walltime'. 0L implies timers are started
upon launch.}

\item{output}{[default FALSE] logical value, to output generated stdout /
stderr if TRUE, or else discard if FALSE. Specify as TRUE in the '...'
argument to \code{\link{daemons}} or \code{\link{launch_local}} to provide
redirection of output to the host process (applicable only for local
daemons when not using dispatcher).}

\item{...}{reserved but not currently used.}

\item{cleanup}{[default 7L] Integer additive bitmask controlling whether to
perform cleanup of the global environment (1L), reset loaded packages to
an initial state (2L), reset options to an initial state (4L), and
perform garbage collection (8L) after each evaluation. This option should
not normally be modified. Do not set unless you are certain you require
persistence across evaluations. Note: it may be an error to reset options
but not loaded packages if packages set options on load.}

\item{tls}{[default NULL] required for secure TLS connections over 'tls+tcp://'
or 'wss://'. \strong{Either} the character path to a file containing
X.509 certificate(s) in PEM format, comprising the certificate authority
certificate chain starting with the TLS certificate and ending with the
CA certificate, \strong{or} a length 2 character vector comprising [i]
the certificate authority certificate chain and [ii] the empty character
\code{''}.}

\item{rs}{[default NULL] the initial value of .Random.seed. This is set
automatically using L'Ecuyer-CMRG RNG streams generated by the host
process and should not be independently supplied.}
}
\value{
Invisible NULL.
}
\description{
Implements a persistent executor for the remote process. Awaits data,
    evaluates an expression in an environment containing the supplied data,
    and returns the result to the host caller.
}
\details{
The network topology is such that daemons dial into the host or
    dispatcher, which listens at the 'url' address. In this way, network
    resources may be added or removed dynamically and the host or
    dispatcher automatically distributes tasks to all available daemons.
}
