% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{status}
\alias{status}
\title{Status Information}
\usage{
status(.compute = "default")
}
\arguments{
\item{.compute}{[default 'default'] character compute profile (each compute
profile has its own set of daemons for connecting to different resources).

\strong{or} a 'miraiCluster' to obtain its status.}
}
\value{
A named list comprising:
\itemize{
\item \strong{connections} - integer number of active daemon connections.
\item \strong{daemons} - character URL at which host / dispatcher is
listening, or else \code{0L} if daemons have not yet been set.
\item \strong{mirai} (present only if using dispatcher) - a named integer
vector comprising: \strong{awaiting} - number of tasks queued for execution at
dispatcher, \strong{executing} - number of tasks sent to a daemon for
execution, and \strong{completed} - number of tasks for which the result has
been received (either completed or cancelled).
}
}
\description{
Retrieve status information for the specified compute profile, comprising
current connections and daemons status.
}
\section{Events}{


If dispatcher is used combined with daemon IDs, an additional element
\strong{events} will report the positive integer ID when the daemon connects and
the negative value when it disconnects. Only the events since the previous
status query are returned.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
status()
daemons(url = "tcp://[::1]:0")
status()
daemons(0)
\dontshow{\}) # examplesIf}
}
