% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLCI.mirt.R
\name{PLCI.mirt}
\alias{PLCI.mirt}
\title{Compute profiled-likelihood (or posterior) confidence intervals}
\usage{
PLCI.mirt(mod, alpha = 0.05, parnum = NULL, ...)
}
\arguments{
\item{mod}{a converged mirt model}

\item{alpha}{two-tailed alpha critical level}

\item{parnum}{a numeric vector indicating which parameters to estimate.
Use \code{\link{mod2values}} to determine parameter numbers. If \code{NULL}, all possible
parameters are used}

\item{...}{additional arguments to pass to the estimation functions}
}
\description{
Computes profiled-likelihood based confidence intervals. Supports the inclusion of
equality constraints. Object returns the confidence intervals
and whether the respective interval could be found.
}
\examples{

\dontrun{
mirtCluster() #use all available cores to estimate CI's in parallel
dat <- expand.table(LSAT7)
mod <- mirt(dat, 1)

result <- PLCI.mirt(mod)
result

mod2 <- mirt(Science, 1)
result2 <- PLCI.mirt(mod2)
result2

#only estimate CI's slopes
sv <- mod2values(mod2)
parnum <- sv$parnum[sv$name == 'a1']
result3 <- PLCI.mirt(mod2, parnum=parnum)
result3

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\seealso{
\code{\link{boot.mirt}}
}
\keyword{likelihood}
\keyword{profiled}

