context('bfactor')

test_that('dich data', {
    key <- c(1,4,5,2,3,1,2,1,3,1,2,4,2,1,5,3,4,4,1,4,3,3,4,1,3,5,1,3,1,5,4,5)
    data <- key2binary(SAT12, key)
    specific <- c(2,3,2,3,3,2,1,2,1,1,1,3,1,3,1,2,1,1,3,3,1,1,3,1,3,3,1,3,2,3,1,2)
    mod1 <- bfactor(data, specific, verbose=FALSE, SE = TRUE, SE.type = 'crossprod')
    expect_is(mod1, 'ConfirmatoryClass')
    expect_equal(mod1@df, 4294967199)
    cfs <- do.call(c, coef(mod1, digits=4))
    cfs <- as.numeric(na.omit(cfs[cfs != 0 & cfs != 1]))
    expect_equal(cfs, c(0.7851, 0.5153, 1.0549, 0.4358, 0.008, 0.8636, -1.0717, -1.3099, -0.8335, 1.4896, 1.0658, 1.9133, 0.8156, 0.3083, 1.3228, 0.4711, 0.1912, 0.7509, 1.1475, 0.8268, 1.4682, -0.1538, -0.5548, 0.2471, -1.1727, -1.4358, -0.9096, 0.5263, 0.2949, 0.7578, 0.5811, 0.1593, 1.0029, -0.5573, -0.7683, -0.3464, 0.9675, 0.6682, 1.2669, 0.5152, 0.1002, 0.9303, 0.6284, 0.3894, 0.8674, 1.1361, 0.8027, 1.4696, 0.5778, 0.0218, 1.1338, -2.1255, -2.5137, -1.7373, 1.0436, 0.6612, 1.426, 0.9263, 0.3139, 1.5386, 1.5563, 1.1833, 1.9294, 0.6731, 0.3994, 0.9467, 0.5188, 0.0118, 1.0258, -1.5687, -1.8525, -1.2849, 0.454, 0.0543, 0.8538, 1.1079, 0.2295, 1.9862, 2.5243, 1.8543, 3.1944, 1.0477, 0.712, 1.3834, 0.8195, 0.296, 1.343, -0.4047, -0.646, -0.1635, 1.5918, 0.1728, 3.0108, 0.8203, -0.9844, 2.6249, 5.3883, 3.4262, 7.3504, 0.1206, -0.0935, 0.3348, 0.2754, -0.0619, 0.6128, -0.3506, -0.5322, -0.169, 1.1001, 0.7552, 1.4451, 0.5777, 0.1178, 1.0377, 0.8844, 0.6288, 1.14, 1.0876, 0.6898, 1.4855, 1.0359, 0.4305, 1.6413, 1.3602, 1.0081, 1.7122, 1.3332, 0.9101, 1.7564, 0.5342, 0.0149, 1.0535, 2.0112, 1.6289, 2.3935, 0.7362, 0.4783, 0.9941, 0.387, 0.0046, 0.7693, -0.3906, -0.5962, -0.1849, 1.5293, 0.7797, 2.2788, 0.2703, -0.57, 1.1106, 4.1835, 3.33, 5.0371, 1.758, 1.3203, 2.1957, 0.1904, -0.3472, 0.7279, -0.8748, -1.1652, -0.5843, 0.8626, 0.5773, 1.1479, 0.0379, -0.3026, 0.3784, 0.2387, 0.0303, 0.447, 1.5305, 0.9793, 2.0816, 0.4172, -0.136, 0.9704, 2.6498, 2.1182, 3.1814, 0.5334, 0.0892, 0.9777, 0.6559, -0.122, 1.4339, 2.6531, 2.1634, 3.1428, 1.6817, 0.8704, 2.4931, -0.0682, -0.7791, 0.6427, 3.6239, 2.7765, 4.4713, 0.6068, 0.3634, 0.8502, 0.4983, 0.0907, 0.9058, -0.8817, -1.1077, -0.6557, 1.2375, 0.858, 1.6169, 0.2174, -0.1761, 0.6109, 1.2886, 1.0025, 1.5748, 0.7326, 0.4733, 0.9919, 0.6474, 0.2191, 1.0756, -0.5997, -0.8254, -0.3741, 1.4874, 1.0972, 1.8776, 0.4916, 0.0539, 0.9293, -0.1725, -0.4278, 0.0829, 1.9096, 1.3112, 2.508, 0.4022, -0.1823, 0.9867, 2.807, 2.2381, 3.3758, 1.0559, 0.7602, 1.3515, 0.1523, -0.2299, 0.5345, 0.1725, -0.0413, 0.3862, 1.2577, -0.0526, 2.568, 2.1328, -1.3435, 5.609, -1.2139, -2.4667, 0.039, 0.4331, 0.194, 0.6723, -0.1688, -0.5199, 0.1823, -0.252, -0.4381, -0.0658, 2.599, 1.5569, 3.641, -0.2728, -0.9598, 0.4141, 3.0115, 2.0727, 3.9502, 0.1328, -0.118, 0.3837, 0.028, -0.3685, 0.4245, -1.6521, -1.8928, -1.4114),
                 tolerance = 1e-2)
    fs <- fscores(mod1, verbose = FALSE)
    expect_is(fs, 'matrix')
    expect_true(mirt:::closeEnough(fs[1:6,'F1'] - c(-0.72059353, -0.07439544, -1.91235316,
                                                    -1.99421796, -2.00030284, -1.92556420), -1e-2, 1e-2))
    cof <- coef(mod1, verbose = FALSE)
    expect_is(cof, 'list')
    sum <- summary(mod1, verbose = FALSE)
    expect_is(sum, 'list')
#     fit <- fitIndices(mod1)
#     expect_equal(fit$M2, 6772.915, tolerance = 1e-2)
#     expect_equal(fit$df.M2, 432, tolerance = 1e-2)
    pfit1 <- personfit(mod1)
    expect_is(pfit1, 'data.frame')
    ifit <- itemfit(mod1)
    expect_is(ifit, 'data.frame')
    
    #nestlogit
    scoredSAT12 <- data
    scoredSAT12[,1:5] <- as.matrix(SAT12[,1:5])
    nestmod <- mirt(scoredSAT12, 1, c(rep('2PLNRM',5),rep('2PL', 27)), key=key, verbose=FALSE)
    cfs <- as.numeric(do.call(c, coef(nestmod, digits=4)))
    cfs <- cfs[cfs != 0 & cfs != 1]
    expect_equal(cfs, c(0.7928, -1.0428, -0.5715, -0.5787, -3.1137, 1.4113, 0.2128, 0.07, -5.4259, -5.7802, 1.5217, 0.4431, -0.919, -0.4077, -0.2366, -1.6949, -2.9472, -1.3499, -0.6444, -6.4068, 1.063, -1.1381, 0.1255, -0.1845, -0.3254, -0.2015, 0.1254, 0.4052, -0.6207, -2.5713, 0.5877, -0.5306, 0.0333, -0.0066, 0.1137, -1.1324, -0.0994, 0.0382, -0.2306, -3.6532, 0.983, 0.605, 0.4158, 0.0505, -0.0696, -1.3233, 0.6194, 0.0295, -0.7007, -5.3263, 1.1315, -2.04, 1.0201, 1.3905, 0.7031, -1.5122, 0.5175, 2.1378, 0.9976, -0.3594, 1.7057, 5.2077, 0.1694, -0.3456, 1.0861, 0.847, 1.0424, 1.177, 1.327, 1.9449, 0.7268, -0.3816, 1.4883, 4.0989, 1.6847, -0.8479, 0.8226, 0.2359, 1.5806, 2.6433, 0.6012, 2.5153, 1.5424, 3.4789, 0.649, -0.8519, 1.2108, 1.2726, 0.7751, -0.567, 1.5423, -0.17, 1.8603, 2.7282, 1.076, 0.1748, 0.8315, -0.7493, 0.3816, -0.2479, 2.3798, 2.8218, 0.1269, -1.6513),
                 tolerance = 1e-2)
    expect_equal(nestmod@logLik, -11715.17, tolerance = 1e-4)

    #simulate data
    set.seed(1234)
    a <- matrix(c(
        1,0.5,NA,
        1,0.5,NA,
        1,0.5,NA,
        1,0.5,NA,
        1,0.5,NA,
        1,0.5,NA,
        1,0.5,NA,
        1,NA,0.5,
        1,NA,0.5,
        1,NA,0.5,
        1,NA,0.5,
        1,NA,0.5,
        1,NA,0.5,
        1,NA,0.5),ncol=3,byrow=TRUE)

    d <- matrix(c(
        -1.0,NA,NA,
        -1.5,NA,NA,
        1.5,NA,NA,
        0.0,NA,NA,
        0.0,-1.0,1.5,
        0.0,2.0,-0.5,
        3.0,2.0,-0.5,
        3.0,2.0,-0.5,
        2.5,1.0,-1,
        2.0,0.0,NA,
        -1.0,NA,NA,
        -1.5,NA,NA,
        1.5,NA,NA,
        0.0,NA,NA),ncol=3,byrow=TRUE)

    nominal <- matrix(NA, nrow(d), ncol(d))
    nominal[5, ] <- c(0,1.2,2)
    sigma <- diag(3)
    set.seed(1234)
    items <- itemtype <- c(rep('dich', 4), 'nominal', 'gpcm', rep('graded',4),rep('dich', 4))
    dataset <- simdata(a,d,3000,itemtype, sigma=sigma, nominal=nominal)

    specific <- c(rep(1,7),rep(2,7))
    items[items == 'dich'] <- '2PL'
    simmod <- suppressMessages(bfactor(dataset, specific, itemtype = items, verbose=FALSE))
    expect_is(simmod, 'ConfirmatoryClass')
    expect_equal(simmod@df, 442315)
    cfs <- as.numeric(do.call(c, coef(simmod, digits=4)))
    cfs <- cfs[cfs != 0 & cfs != 1]
    expect_equal(cfs, c(1.1041, 0.08, -1.0015, 1.1639, -0.5016, -1.5207, 1.1132, 0.6341, 1.6349, 0.9834, 0.0885, 0.0694, 1.1464, 0.2551, 1.1043, 2, -0.9361, 1.5983, 1.1543, -0.1421, 2, 2.0817, -0.4029, 1.1246, 0.0932, 3.0943, 2.0269, -0.4557, 0.9981, 0.6139, 3.0811, 2.0627, -0.4541, 0.8432, 0.6361, 2.4515, 0.9724, -0.9835, 1.018, 0.5648, 2.0248, -0.0309, 0.8408, 0.7581, -1.0135, 0.9375, 0.5238, -1.3633, 0.8808, 0.4932, 1.5456, 0.951, 0.7649, 0.0282),
                 tolerance = 1e-2)
    specific[1] <- NA
    simmod2 <- suppressMessages(bfactor(dataset, specific, itemtype = items, verbose=FALSE))
    expect_is(simmod2, 'ConfirmatoryClass')
    expect_equal(simmod2@df, 442316)
    cfs <- as.numeric(do.call(c, coef(simmod2, digits=4)))
    cfs <- cfs[cfs != 0 & cfs != 1]
    expect_equal(cfs, c(1.1073, -1.0015, 1.153, -0.5001, -1.5158, 1.1239, 0.6421, 1.6415, 0.9848, 0.0714, 0.0694, 1.15, 0.2443, 1.1028, 2, -0.9349, 1.5996, 1.1502, -0.1402, 2, 2.0788, -0.4023, 1.1264, 0.0702, 3.0944, 2.027, -0.4557, 0.997, 0.6156, 3.0811, 2.0627, -0.454, 0.8424, 0.6371, 2.4515, 0.9724, -0.9835, 1.0168, 0.5666, 2.0248, -0.0308, 0.8398, 0.7591, -1.0135, 0.938, 0.5235, -1.3634, 0.8795, 0.4952, 1.5456, 0.9501, 0.7663, 0.0282),
                 tolerance = 1e-2)
    fs <- fscores(simmod, verbose = FALSE)
    expect_true(mirt:::closeEnough(fs[1:6,'F1'] - c(-2.713717, -2.440282, -2.177029,
                                                    -2.265682, -2.249449, -2.416284), -1e-2, 1e-2))
    expect_is(fs, 'matrix')

    res <- residuals(simmod, verbose = FALSE)
    expect_is(res, 'matrix')
    sum <- summary(simmod, verbose = FALSE)
    expect_is(sum, 'list')
})
