% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/updateDesign.R
\name{updateDesign}
\alias{updateDesign}
\title{Update design elements}
\usage{
updateDesign(x, items, responses, Theta = NULL)
}
\arguments{
\item{x}{an object of class 'mirtCAT_design' returned from the \code{\link{mirtCAT}} function
when passing \code{design_elements = TRUE}}

\item{items}{a numeric vector indicating which items to select}

\item{responses}{a numeric vector indiciating the responses the the selected items}

\item{Theta}{(optional) vector indicating the value of Theta/latent traits to be set}
}
\value{
returns an object of class 'mirtCAT_design' with updated elements.
}
\description{
A function that will update the object returned from \code{\link{findNextItem}}.
}
\examples{
\dontrun{
# test defined in mirtCAT help file, first example
CATdesign <- mirtCAT(df, mod, criteria = 'MI', design_elements = TRUE)

# returns number 1 in this case, since that's the starting item
findNextItem(CATdesign)

# detemine next item if item 1 and item 10 were answered correctly, and Theta = 0.5
CATdesign <- updateDesign(CATdesign, items = c(1, 10), responses = c(1, 1), Theta = 0.5)
findNextItem(CATdesign)

# alternatively, update the Theta using the internal ReferenceClass method
Person$help('Update.thetas') # internal help file for class 'Person'
CATdesign$person$Update.thetas(CATdesign$design, CATdesign$test)
findNextItem(CATdesign)
}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\seealso{
\code{\link{mirtCAT}}, \code{\link{findNextItem}}
}

