% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misclassMLogit.R
\name{simulate_mlogit_dataset}
\alias{simulate_mlogit_dataset}
\title{Simulate a Data Set to Use With \code{misclassMlogit}}
\usage{
simulate_mlogit_dataset(n = 1000, const = c(0, 0), alpha = c(1, 2),
  beta = -2 * c(1, 2), beta2 = NULL)
}
\arguments{
\item{n}{number observations}

\item{const}{constants}

\item{alpha}{parameters for X}

\item{beta}{parameters for M(1)}

\item{beta2}{parameters for M2, if NULL, M is a binary covariate, otherwise a three-valued categorical}
}
\description{
simulates a data set with
- one continuous variable X drawn from a Gaussian distribution,
- a binary or trinary variable M with misclassification (M2)
- a dependent variable drawn from a multionomial distribution dependent on X and M.
}
\details{
This can be used to demonstrate the abilities of misclassMlogit. For an example
see \code{misclassMlogit}.
}
\seealso{
\code{\link{misclassMlogit}}
}

