#' @name str_rev
#' @keywords inverse reverse
#' @author Sven E. Templer
#' @title Reverse Text Strings
#' @description 
#' Create a reverse version of strings.
#' @param x vector with strings. Is coerced to character.
#' @return
#' Returns a character vector with reversed strings.
#' @seealso
#' \link{rev}
#' @examples 
#' #
#' 
#' s <- c("abc","asdf")
#' 
#' str_rev(s)
#' 
#' #

#' @export str_rev
str_rev <- function (x) {
  xna <- is.na(x)
  x <- as.character(x)
  x <- strsplit(x, "")
  x <- lapply(x, function (y) {
    y <- paste(rev(y), collapse="")
    return(y)
  })
  x <- unlist(x)
  x[xna] <- NA
  return(x)
}

#' @rdname str_rev
#' @export strrev
strrev <- function (x) {
  .Deprecated('str_rev')
  xna <- is.na(x)
  x <- as.character(x)
  x <- strsplit(x, "")
  x <- lapply(x, function (y) {
    y <- paste(rev(y), collapse="")
    return(y)
  })
  x <- unlist(x)
  x[xna] <- NA
  return(x)
}
