% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-import.R
\name{gtrack.import_mappedseq}
\alias{gtrack.import_mappedseq}
\title{Creates a track from a file of mapped sequences}
\usage{
gtrack.import_mappedseq(
  track = NULL,
  description = NULL,
  file = NULL,
  pileup = 0,
  binsize = -1,
  cols.order = c(9, 11, 13, 14),
  remove.dups = TRUE
)
}
\arguments{
\item{track}{track name}

\item{description}{a character string description}

\item{file}{name of mapped sequences file}

\item{pileup}{interval expansion}

\item{binsize}{bin size of a dense track}

\item{cols.order}{order of sequence, chromosome, coordinate and strand
columns in mapped sequences file or NULL if SAM file is used}

\item{remove.dups}{if 'TRUE' the duplicated coordinates are counted only
once.}
}
\value{
A list of conversion process statistics.
}
\description{
Creates a track from a file of mapped sequences.
}
\details{
This function creates a track from a file of mapped sequences. The file can
be in SAM format or in a general TAB delimited text format where each line
describes a single read.

For a SAM file 'cols.order' must be set to 'NULL'.

For a general TAB delimited text format the following columns must be
presented in the file: sequence, chromosome, coordinate and strand. The
position of these columns should be specified in 'cols.order' argument. The
default value of 'cols.order' is an array of (9, 11, 13, 14) meaning that
sequence is expected to be found at column number 9, chromosome - at column
11, coordinate - at column 13 and strand - at column 14. The column indices
are 1-based, i.e. the first column is referenced by 1. Chromosome needs a
prefix 'chr' e.g. 'chr1'. Valid strand values are '+' or 'F' for forward
strand and '-' or 'R' for the reverse strand.

Each read at given coordinate can be "expanded" to cover an interval rather
than a single point. The length of the interval is controlled by 'pileup'
argument. The direction of expansion depends on the strand value. If
'pileup' is '0', no expansion is performed and the read is converted to a
single point. The track is created in sparse format. If 'pileup' is greater
than zero, the output track is in dense format. 'binsize' controls the bin
size of the dense track.

If 'remove.dups' is 'TRUE' the duplicated coordinates are counted only once.

'description' is added as a track attribute.

'gtrack.import_mappedseq' returns the statistics of the conversion process.
}
\seealso{
\code{\link{gtrack.rm}}, \code{\link{gtrack.info}},
\code{\link{gdir.create}}
}
\keyword{~mapped}
\keyword{~sequence}
\keyword{~track}
