% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-dir.R
\name{gdir.cd}
\alias{gdir.cd}
\title{Changes current working directory in Genomic Database}
\usage{
gdir.cd(dir = NULL)
}
\arguments{
\item{dir}{directory path}
}
\value{
None.
}
\description{
Changes current working directory in Genomic Database.
}
\details{
This function changes the current working directory in Genomic Database (not
to be confused with shell's current working directory). The list of database
objects - tracks, intervals, track variables - is rescanned recursively
under 'dir'. Object names are updated with the respect to the new current
working directory. Example: a track named 'subdir.dense' will be referred as
'dense' once current working directory is set to 'subdir'. All virtual
tracks are removed.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gdir.cd("subdir")
gtrack.ls()
gdir.cd("..")
gtrack.ls()

}
\seealso{
\code{\link{gdb.init}}, \code{\link{gdir.cwd}},
\code{\link{gdir.create}}, \code{\link{gdir.rm}}
}
\keyword{~cd}
\keyword{~data}
\keyword{~database}
\keyword{~db}
\keyword{~dir}
\keyword{~directory}
\keyword{~folder}
