% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.simulate}
\alias{md.simulate}
\title{md.simulate}
\usage{
md.simulate(sim, N)
}
\arguments{
\item{sim}{a \code{\link{md.simparams}} object containg simulation parameters}

\item{N}{number of observations}
}
\description{
Creates a simulated dataset using the provided simulation parameters.
}
\examples{

\dontrun{
library(missDeaths)
ratetable = survexp.us

sim = md.simparams() +
          md.sex("sex", 1) + 
          md.uniform("Z1") +
          md.mvnorm(c("Z2", "Z3"), c(100, 0), matrix(c(225, 3, 2, 1), 2, 2)) +
          md.sample("Z4", c(1, 2, 3, 4), c(0.25, 0.25, 0.25, 0.25)) +
          md.dateuniform("birth", as.Date("1930-1-1"), as.Date("1930-1-1")) +
          md.dateuniform("start", as.Date("1930-2-1"), as.Date("1930-2-1")) +
          md.death("death", ratetable, "sex", "birth", "start") +
          md.eval("age", "as.numeric(start - birth)/365.2425", 80, FALSE) + 
          md.exp("event", "start", c("age", "sex", "Z1", "Z2"), 
             c(0.1, 2, 1, 0.01), 0.0001)
          
data = md.simulate(sim, 1000)
}
}

