% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pattern.R
\name{write_pattern}
\alias{write_pattern}
\title{An internal function to select which type of pattern mixture model to execute. 
Alternatives vary depending on the type of distribution assumed for the effect and cost variables,
type of missingness mechanism assumed and independence or joint modelling
This function selects which type of model to execute.}
\usage{
write_pattern(dist_e, dist_c, ind, type, pe, pc, d_list, d1, d2,
  restriction)
}
\arguments{
\item{dist_e}{Distribution assumed for the effects. Current available choices are: Normal ('norm') or Beta ('beta')}

\item{dist_c}{Distribution assumed for the costs. Current available choices are: Normal ('norm'), Gamma ('gamma') or LogNormal ('lnorm')}

\item{ind}{Logical; if TRUE independence between effectiveness and costs is assumed, else correlation is accounted for}

\item{type}{Type of missingness mechanism assumed. Choices are Missing At Random (MAR), Missing Not At Random for the effects (MNAR_eff),
Missing Not At Random for the costs (MNAR_cost), and Missing Not At Random for both (MNAR)}

\item{pe}{Number of covariates for the effectiveness model}

\item{pc}{Number of covariates for the cost model}

\item{d_list}{Number and type of patterns}

\item{d1}{Pattern indicator in the control}

\item{d2}{Pattern indicator in the intervention}

\item{restriction}{type of identifying restriction to be imposed}
}
\description{
An internal function to select which type of pattern mixture model to execute. 
Alternatives vary depending on the type of distribution assumed for the effect and cost variables,
type of missingness mechanism assumed and independence or joint modelling
This function selects which type of model to execute.
}
\examples{
# Internal function only
# No examples
#
#
}
\keyword{JAGS}
\keyword{Pattern}
\keyword{mixture}
\keyword{models}
