% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R, R/mixdist.R, R/standist.R,
%   R/trans_standist.R
\name{plim.compdist}
\alias{plim.compdist}
\alias{plim.mixdist}
\alias{plim}
\alias{plim.discrdist}
\alias{plim.contdist}
\alias{plim.trans_univdist}
\title{Left-Hand Limit of Distribution Function}
\usage{
\method{plim}{compdist}(O, q, lower.tail = TRUE, log.p = FALSE)

\method{plim}{mixdist}(O, q, lower.tail = TRUE, log.p = FALSE)

plim(O, q, lower.tail = TRUE, log.p = FALSE)

\method{plim}{discrdist}(O, q, lower.tail = TRUE, log.p = FALSE)

\method{plim}{contdist}(O, q, lower.tail = TRUE, log.p = FALSE)

\method{plim}{trans_univdist}(O, q, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{O}{distribution object.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X < x]} otherwise, \eqn{P[X \ge x]}, default: TRUE.}

\item{log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}
}
\value{
Vector of computed results.
}
\description{
\code{plim} is a generic function that evaluates the left-hand limit of distribution function
             for a distribution object at given values.
}
\details{
Methods of \code{plim} function evaluates the left-hand limit of any offered
         distribution from the package \code{\link{mistr}}. The left-hand limit is defined as
         \eqn{F(x-)=P(X<x)}.
         The function makes use of the p[sufix] and q[sufix] functions
         as \code{pnorm} or \code{qbeta} and thus, if a new distribution is added,
         these functions must be reachable through the search path.
}
\examples{
B <- binomdist(10, 0.3)
plim(B, c(NA, 1, 3, 5))

P <- poisdist()
M <- mixdist(B, P, weights = c(0.5, 0.5))
plim(M, c(NA, 1, 3, 5))

CC <- compdist(B, P, weights = c(0.5, 0.5), breakpoints = 1)
CCC <- 2*CC+5
plim(CCC, c(NA, 1, 3, 5))
}
