% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.poly.cor.R
\name{print.poly.cor}
\alias{print.poly.cor}
\title{Print poly.cor object}
\usage{
\method{print}{poly.cor}(x, tri = x$args$tri, digits = x$args$digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{poly.cor} object.}

\item{tri}{a character string indicating which triangular of the matrix to show on the console, i.e.,
\code{both} for upper and lower triangular, \code{lower} (default) for the lower triangular,
and \code{upper} for the upper triangular.}

\item{digits}{an integer value indicating the number of decimal places to be used for
displaying correlation coefficients.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods}
}
\description{
This function prints the \code{poly.cor} object
}
\examples{
dat <- data.frame(x1 = c(1, 1, 3, 2, 1, 2, 3, 2, 3, 1),
                  x2 = c(1, 2, 1, 1, 2, 2, 2, 1, 3, 1),
                  x3 = c(1, 3, 2, 3, 3, 1, 3, 2, 1, 2))

# Polychoric correlation matrix
dat.poly <- poly.cor(dat, output = FALSE)

# Print poly.cor object with 3 digits
print(dat.poly, digits = 3)
}
\seealso{
\code{\link{poly.cor}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
