% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.rename.R
\name{df.rename}
\alias{df.rename}
\title{Rename Columns in a Matrix or Variables in a Data Frame}
\usage{
df.rename(x, from, to, check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{from}{a character string or character vector indicating the column(s) or variable(s) to be renamed.}

\item{to}{a character string or character vector indicating the corresponding replacement values for
the column(s) or variable(s) specified in the argument \code{name}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a matrix or data frame with renamed columns or variables.
}
\description{
This function renames columns in a matrix or variables in a data frame by specifying a character string or
character vector indicating the columns or variables to be renamed and a character string or character
vector indicating the corresponding replacement values.
}
\examples{
dat <- data.frame(a = c(3, 1, 6),
                  b = c(4, 2, 5),
                  c = c(7, 3, 1))

# Rename variable b in the data frame 'dat' to y
df.rename(dat, from = "b", to = "y")

# Rename variabley a, b, and c in the data frame 'dat' to x, y, and z
df.rename(dat, from = c("a", "b", "c"), to = c("x", "y", "z"))
}
\seealso{
\code{\link{df.merge}}, \code{\link{df.rbind}}, \code{\link{df.sort}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
