% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.mean.diff.R
\name{ci.mean.diff}
\alias{ci.mean.diff}
\alias{ci.mean.diff.default}
\alias{ci.mean.diff.formula}
\title{Confidence Interval for the Difference in Arithmetic Means}
\usage{
ci.mean.diff(x, ...)

\method{ci.mean.diff}{default}(x, y, mu = 0, sigma = NULL, sigma2 = NULL,
             var.equal = FALSE, paired = FALSE,
             alternative = c("two.sided", "less", "greater"),
             conf.level = 0.95, group = NULL, split = NULL, sort.var = FALSE,
             digits = 2, as.na = NULL, write = NULL, append = TRUE,
             check = TRUE, output = TRUE, ...)

\method{ci.mean.diff}{formula}(formula, data, sigma = NULL, sigma2 = NULL,
             var.equal = FALSE, alternative = c("two.sided", "less", "greater"),
             conf.level = 0.95, group = NULL, split = NULL, sort.var = FALSE,
             na.omit = FALSE, digits = 2, as.na = NULL, write = NULL,
             append = TRUE, check = TRUE, output = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector of data values.}

\item{mu}{a numeric value indicating the population mean under the
null hypothesis. Note that the argument \code{mu} is only
used when \code{y = NULL}.}

\item{sigma}{a numeric vector indicating the population standard deviation(s)
when computing confidence intervals for the difference in
arithmetic means with known standard deviation(s). In case
of independent samples, equal standard deviations are assumed
when specifying one value for the argument \code{sigma}; when
specifying two values for the argument \code{sigma}, unequal
standard deviations are assumed. Note that either argument
\code{sigma} or argument \code{sigma2} is specified and it
is only possible to specify one value (i.e., equal variance
assumption) or two values (i.e., unequal variance assumption)
for the argument \code{sigma} even though multiple variables
are specified in \code{x}.}

\item{sigma2}{a numeric vector indicating the population variance(s) when
computing confidence intervals for the difference in arithmetic
means with known variance(s). In case of independent samples,
equal variances are assumed when specifying one value for the
argument \code{sigma2}; when specifying two values for the
argument \code{sigma}, unequal variances are assumed. Note
that either argument \code{sigma} or argument \code{sigma2}
is specified and it is only possible to specify one value
(i.e., equal variance assumption) or two values (i.e., unequal
variance assumption) for the argument \code{sigma} even though
multiple variables are specified in \code{x}.}

\item{var.equal}{logical: if \code{TRUE}, the population variance in the
independent samples are assumed to be equal.}

\item{paired}{logical: if \code{TRUE}, confidence interval for the difference
of arithmetic means in paired samples is computed.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"}
or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence
level of the interval.}

\item{group}{a numeric vector, character vector or factor as grouping
variable. Note that a grouping variable can only be used
when computing confidence intervals with unknown population
standard deviation and population variance.}

\item{split}{a numeric vector, character vector or factor as split variable.
Note that a split variable can only be used when computing
confidence intervals with unknown population}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables
when specifying \code{group}.}

\item{digits}{an integer value indicating the number of decimal places to
be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis. Note that \code{as.na()} function is only applied
to \code{x}, but not to \code{group} or \code{split}.}

\item{write}{a character string naming a text file with file extension
\code{".txt"} (e.g., \code{"Output.txt"}) for writing the
output into a text file.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}

\item{formula}{a formula of the form \code{y ~ group} for one outcome variable
or \code{cbind(y1, y2, y3) ~ group} for more than one outcome
variable where \code{y} is a numeric variable giving the data
values and \code{group} a numeric variable, character variable
or factor with two values or factor levels giving the corresponding
groups.}

\item{data}{a matrix or data frame containing the variables in the formula
\code{formula}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before
conducting the analysis (i.e., listwise deletion) when specifying
more than one outcome variable.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
  \item{\code{call}}{function call}
  \item{\code{type}}{type of analysis}
  \item{\code{data}}{list with the input specified in \code{x}, \code{group},
                     and \code{split}}
  \item{\code{args}}{specification of function arguments}
  \item{\code{result}}{result table}
}
\description{
This function computes a confidence interval for the difference in arithmetic
means in a one-sample, two-sample and paired-sample design with known or unknown
population standard deviation or population variance for one or more variables,
optionally by a grouping and/or split variable.
}
\examples{
#----------------------------------------------------------------------------
# One-sample design

# Example 1a: Two-Sided 95% CI for 'mpg'
# population mean = 20
ci.mean.diff(mtcars$mpg, mu = 20)

# Example 1a: One-Sided 95% CI for 'mpg'
# population mean = 20
ci.mean.diff(mtcars$mpg, mu = 20, alternative = "greater")

#----------------------------------------------------------------------------
# Two-sample design

# Example 2a: Two-Sided 95% CI for 'mpg' by 'vs'
# unknown population variances, unequal variance assumption
ci.mean.diff(mpg ~ vs, data = mtcars)

# Example 2b: Two-Sided 95% CI for 'mpg' by 'vs'
# unknown population variances, equal variance assumption
ci.mean.diff(mpg ~ vs, data = mtcars, var.equal = TRUE)

# Example 2c: Two-Sided 95% CI for 'mpg' by 'vs'
# known population standard deviations, equal standard deviation assumption
ci.mean.diff(mpg ~ vs, data = mtcars, sigma = 4)

# Example 2d: Two-Sided 95% CI for 'mpg' by 'vs'
# known population standard deviations, unequal standard deviation assumption
ci.mean.diff(mpg ~ vs, data = mtcars, sigma = c(4, 5))

# Example 2e: Two-Sided 95% CI for 'mpg', 'cyl', and 'disp' by 'vs'
# unknown population variances, unequal variance assumption
ci.mean.diff(cbind(mpg, cyl, disp) ~ vs, data = mtcars)

# Example 2f: Two-Sided 95% CI for 'mpg', 'cyl', and 'disp' by 'vs'
# unknown population variances, unequal variance assumption,
# analysis by am separately
ci.mean.diff(cbind(mpg, cyl, disp) ~ vs, data = mtcars, group = mtcars$am)

# Example 2g: Two-Sided 95% CI for 'mpg', 'cyl', and 'disp' by 'vs'
# unknown population variances, unequal variance assumption,
# split analysis by am
ci.mean.diff(cbind(mpg, cyl, disp) ~ vs, data = mtcars, split = mtcars$am)

# Example 2h: Two-Sided 95% CI for the mean difference between 'group1' and 'group2'
# unknown population variances, unequal variance assumption
group1 <- c(3, 1, 4, 2, 5, 3, 6, 7)
group2 <- c(5, 2, 4, 3, 1)

ci.mean.diff(group1, group2)

#----------------------------------------------------------------------------
# Paired-sample design

dat.p <- data.frame(pre = c(1, 3, 2, 5, 7, 6), post = c(2, 2, 1, 6, 8, 9),
                    group = c(1, 1, 1, 2, 2, 2))

# Example 3a: Two-Sided 95% CI for the mean difference in 'pre' and 'post'
# unknown poulation variance of difference scores
ci.mean.diff(dat.p$pre, dat.p$post, paired = TRUE)

# Example 21: Two-Sided 95% CI for the mean difference in 'pre' and 'post'
# unknown poulation variance of difference scores
# analysis by group separately
ci.mean.diff(dat.p$pre, dat.p$post, paired = TRUE, group = dat.p$group)

# Example 22: Two-Sided 95% CI for the mean difference in 'pre' and 'post'
# unknown poulation variance of difference scores
# analysis by group separately
ci.mean.diff(dat.p$pre, dat.p$post, paired = TRUE, split = dat.p$group)

# Example 23: Two-Sided 95% CI for the mean difference in 'pre' and 'post'
# known population standard deviation of difference scores
ci.mean.diff(dat.p$pre, dat.p$post, sigma = 2, paired = TRUE)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.
}
\seealso{
\code{\link{test.z}}, \code{\link{test.t}}, \code{\link{ci.mean}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.var}}, \code{\link{ci.sd}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
