% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prop_Pvalue.R
\name{Prop_Pvalue}
\alias{Prop_Pvalue}
\title{Loop and Find distribution of P values}
\usage{
Prop_Pvalue(x,N,B,t,m=NA,Part=FALSE,alpha=0.05)
}
\arguments{
\item{x}{a dataset of alleles. Each row denotes each individual.One allele in one cell.In the (2r-1)th column, there is the same locus with the 2r-th column; noted: no column for ID, make row.names=1 when importing.}

\item{N}{times of running this loop, also the number of p-values in the bundle.}

\item{B}{times of bootstrapping in Chi Squares Test.}

\item{t}{times of simulation in "Simulate_DistK" and "Simulate_DistX".}

\item{m}{when Part is TRUE, sub-samples are chosen from x. m is the number of loci in the subsample}

\item{Part}{a logical variable. If TRUE, this function will calculate p-values for sub-samples with a given sample size m.}

\item{alpha}{1- confidence level; if the confidence level is 95\%, alpha =0.05}
}
\value{
a list of bundle of cumulative probabilities for number of heterozygous loci and bundle for number of shared alleles; and the proportions of p values smaller than alpha.
}
\description{
Loop and Find distribution of P values
}
\details{
This function can generate a bundle of p-values for one sample or for fix-sized sub-samples. The bundle of cumulative probabilities and the proportion of p-values(1- cumulative probability, please refer to the description of Dist_SimuChisq.R) smaller than Alpha are exported.
}
\examples{
x0 <- data.frame(STR1=c(12,13,13,14,15,13,14,12,14,15),
                STR1_1=c(12,14,13,15,13,14,13,12,14,15),
                SNP1=c("A","T","A","A","T","A","A","T","T","A"),
                SNP1_1=c("A","T","T","T","A","T","A","A","T","T"),
                STR2=c(10,12,11,9,10,12,11,12,12,10),
                STR2_1=c(10,9,11,11,10,12,10,10,12,9),
                SNP2=c("C","C","G","G","G","G","C","G","G","C"),
                SNP2_1=c("C","C","G","G","C","G","C","C","G","G"))
Prop_Pvalue(x0,3,10,10,m=2,Part = TRUE,alpha = 0.05)
}
