% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComposPare_K.R
\name{ComposPare_K}
\alias{ComposPare_K}
\title{Generate Comparison Observed and Expected No. of Heterozygous Loci.}
\usage{
ComposPare_K(h,Ex,trans)
}
\arguments{
\item{h}{a double made up of "0" and "1" where 1 means heterozygous and 0 means homozygous; Outcome of function "Heterozygous"; Each column denotes each locus and each row denotes each individual.}

\item{Ex}{a dataframe of expected density, outcome of function "DistHetero", on each possible total number of heterozygous loci.}

\item{trans}{a logic variable, if True, the outcome is a dataframe of n x 2. n is the number of individuals of original imported database. First column is the observed No. of Heterozygous Loci and the second is the expected one. If False, the dataframe is 2n x 2, where n is the number of individuals of original imported database. The first column is a categorical variable denoting the frequency is observed or expected value; the second column is the frequency of No. of heterozygous loci.}
}
\value{
a dataframe of observed and expected No. of heterozygous loci for each individual.
}
\description{
Generate Comparison Observed and Expected No. of Heterozygous Loci.
}
\details{
This function generates a dataframe in which the observed and expected heterozygous loci for each sample are included. The observed ones are calculated from the original dataset. However, the expected ones are simulated according to the expected probability with the same sample size as observed sample.
}
\examples{
h<-matrix(rbinom(20,1,0.5),nrow=5)
Ex <- data.frame(K=c(0:5),Density=rnorm(6,mean = 0.5,sd=0.05))
ComposPare_K(h,Ex,trans = TRUE)
}
