\name{tune.rcc}
\encoding{latin1}
\alias{tune.rcc}
\alias{tune.rcc.default}

\title{Estimate the parameters of regularization for Regularized CCA}

\description{
Computes leave-one-out or M-fold cross-validation scores on a two-dimensional 
grid to determine optimal values for the parameters of regularization in 
\code{rcc}.
}

\usage{
tune.rcc(X, Y, grid1 = seq(0.001, 1, length = 5), 
            grid2 = seq(0.001, 1, length = 5), 
            validation = c("loo", "Mfold"),
            folds = 10, plot = TRUE)
}

\arguments{
  \item{X}{numeric matrix or data frame \eqn{(n \times p)}, the observations on the \eqn{X} variables.
    \code{NA}s are allowed.}
  \item{Y}{numeric matrix or data frame \eqn{(n \times q)}, the observations on the \eqn{Y} variables.
    \code{NA}s are allowed.}
  \item{grid1, grid2}{vector numeric defining the values of \code{lambda1} and \code{lambda2} 
	at which cross-validation score should be computed. Defaults to 
	\code{grid1=grid2=seq(0.001, 1, length=5)}.}
  \item{validation}{character string. What kind of (internal) cross-validation method to use, 
    (partially) matching one of \code{"loo"} (leave-one-out) or \code{"Mfolds"} (M-folds). See Details.}
  \item{folds}{positive integer. Number of folds to use if \code{validation="Mfold"}. Defaults to
    \code{folds=10}.}
  \item{plot}{logical argument indicating whether a image map should be
	plotted by calling the \code{imgCV} function.}	

}

\details{
If \code{validation="Mfolds"}, M-fold cross-validation is performed by calling 
\code{Mfold}. When \code{folds} is given, the elements of \code{folds} should be integer vectors 
specifying the indices of the validation sample and the argument \code{M} is
ignored. Otherwise, the folds are generated. The number of cross-validation 
folds is specified with the argument \code{M}. 

If \code{validation="loo"}, 
leave-one-out cross-validation is performed by calling the 
\code{loo} function. In this case the arguments \code{folds} and \code{M} are ignored.

The estimation of the missing values can be performed 
by the reconstitution of the data matrix using the \code{nipals} function. Otherwise, missing 
values are handled by casewise deletion in the \code{rcc} function.
}

\value{
The returned value is a list with components: 
  \item{opt.lambda1,}{}
  \item{opt.lambda2}{value of the parameters of regularization on which
    the cross-validation method reached it optimal.}
  \item{opt.score}{the optimal cross-validation score reached on the grid.}
  \item{grid1, grid2}{original vectors \code{grid1} and \code{grid2}.} 
  \item{mat}{matrix containing the cross-validation score computed on the grid.}
}

\author{Sebastien Dejean and Ignacio Gonzalez.}

\seealso{\code{\link{image.tune.rcc}} and http://www.mixOmics.org for more details.}

\examples{
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene

## this can take some seconds
\dontrun{
tune.rcc(X, Y, validation = "Mfold")
}
}

\keyword{multivariate}
\keyword{dplot}
