% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{plot_features}
\alias{plot_features}
\title{Plot cluster distribution for a subset of features features}
\usage{
plot_features(features, category_prob,
  classes = seq_len(length(category_prob[[1]])))
}
\arguments{
\item{features}{a character vector with feature names}

\item{category_prob}{a list over all features containing a
list of the probability of each answer for every class. It
is usually obtained from the result of a call to \code{mixdir()}.}

\item{classes}{which latent classes are plotted. By default all.}
}
\description{
Plot cluster distribution for a subset of features features
}
\examples{
  data("mushroom")
  res <- mixdir(mushroom[1:100, ], n_latent=4)
  plot_features(c("bruises", "edible"), res$category_prob)

  res2 <- mixdir(mushroom[1:100, ], n_latent=20)
  def_feats <- find_defining_features(res2, mushroom[1:100, ], n_features=Inf)
  plot_features(def_feats$features[1:6], category_prob = res2$category_prob,
               classes=which(res$lambda > 0.01))
}
