% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node.R
\name{is_reversed}
\alias{is_reversed}
\title{Report the ordering convention of the node}
\usage{
is_reversed(node)
}
\arguments{
\item{node}{a \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}}
}
\value{
\code{TRUE} if the node \code{node} use a reverse temporal ordering, \code{FALSE}
when this is not the case
}
\description{
This function returns \code{TRUE} if the node is using a reverse temporal ordering
and \code{FALSE} in the other case.
}
\examples{
dts <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 0)
dts_ctree <- ctx_tree(dts, min_size = 1, max_depth = 3)
is_reversed(find_sequence(dts_ctree, c(0, 0)))
is_reversed(find_sequence(dts_ctree, c(1, 0), reverse = TRUE))
}
\seealso{
\code{\link[=rev.ctx_node]{rev.ctx_node()}}
}
