% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getEGrowth}
\alias{getEGrowth}
\alias{getEGrowth,MizerParams,matrix,numeric,matrix,matrix-method}
\alias{getEGrowth,MizerParams,matrix,numeric,missing,missing-method}
\title{getEGrowth method for the size based model}
\usage{
getEGrowth(object, n, n_pp, e_spawning, e)

\S4method{getEGrowth}{MizerParams,matrix,numeric,matrix,matrix}(object, n, n_pp,
  e_spawning, e)

\S4method{getEGrowth}{MizerParams,matrix,numeric,missing,missing}(object, n,
  n_pp)
}
\arguments{
\item{object}{A \linkS4class{MizerParams} object.}

\item{n}{A matrix of species abundance (species x size).}

\item{n_pp}{A vector of the background abundance by size.}

\item{e_spawning}{The energy available for spawning (optional, although if
specified, e must also be specified). A matrix of size no. species x no.
size bins. If not supplied, is calculated internally using the
\code{\link{getESpawning}} method.}

\item{e}{The energy available for reproduction and growth (optional, although
if specified, e_spawning must also be specified). A matrix of size no.
species x no. size bins. If not supplied, is calculated internally using
the \code{\link{getEReproAndGrowth}} method.}
}
\value{
A two dimensional array (prey species x prey size)
}
\description{
Calculates the energy rate \eqn{g_i(w)} available by species and size for growth
after metabolism, movement and reproduction have been accounted for. Used by
the \code{\link{project}} method for performing simulations.

\code{getEGrowth} method with \code{e_spawning} and \code{e} arguments.

\code{getEGrowth} method without \code{e_spawning} and \code{e} arguments.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getEGrowth(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
\code{\link{project}}
}
