% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getFMort}
\alias{getFMort}
\title{Get the total fishing mortality rate from all fishing gears by time, species
and size.}
\usage{
getFMort(object, effort, time_range, drop = TRUE)
}
\arguments{
\item{object}{A \code{MizerParams} object or a \code{MizerSim} object}

\item{effort}{The effort of each fishing gear. Only used if the object
argument is of class \code{MizerParams}. See notes below.}

\item{time_range}{Subset the returned fishing mortalities by time. The time
range is either a vector of values, a vector of min and max time, or a
single value. Default is the whole time range. Only used if the
\code{object} argument is of type \code{MizerSim}.}

\item{drop}{Only used when object is of type \code{MizerSim}. Should
dimensions of length 1 be dropped, e.g. if your community only has one
species it might make presentation of results easier. Default is TRUE.}
}
\value{
An array. If the effort argument has a time dimension, or object is
of class \code{MizerSim}, the output array has three dimensions (time x
species x size). If the effort argument does not have a time dimension, the
output array has two dimensions (species x size).

The \code{effort} argument is only used if a \code{MizerParams} object is
passed in. The \code{effort} argument can be a two dimensional array (time x
gear), a vector of length equal to the number of gears (each gear has a
different effort that is constant in time), or a single numeric value (each
gear has the same effort that is constant in time). The order of gears in the
\code{effort} argument must be the same as in the \code{MizerParams}
object.

If the object argument is of class \code{MizerSim} then the effort slot of
the \code{MizerSim} object is used and the \code{effort} argument is not
used.
}
\description{
Calculates the total fishing mortality  (in units 1/year) from all gears by
species and size and possibly time.
}
\details{
The total fishing mortality is just the sum of the fishing mortalities
imposed by each gear, \eqn{\mu_{f.i}(w)=\sum_g F_{g,i,w}}.
The fishing mortality for each gear is obtained as catchability x
selectivity x effort.
}
\section{Your own fishing mortality function}{

By default \code{\link[=getFMort]{getFMort()}} calls \code{\link[=mizerFMort]{mizerFMort()}}. However you can
replace this with your own alternative fishing mortality function. If
your function is called \code{"myFMort"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "FMort", "myFMort")
}

Your function will then be called instead of \code{\link[=mizerFMort]{mizerFMort()}}, with the
same arguments.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Get the total fishing mortality when effort is constant for all 
# gears and time:
getFMort(params, effort = 1)
# Get the total fishing mortality when effort is different
# between the four gears but constant in time:
getFMort(params, effort = c(0.5,1,1.5,0.75))
# Get the total fishing mortality when effort is different
# between the four gears and changes with time:
effort <- array(NA, dim = c(20,4))
effort[, 1] <- seq(from = 0, to = 1, length = 20)
effort[, 2] <- seq(from = 1, to = 0.5, length = 20)
effort[, 3] <- seq(from = 1, to = 2, length = 20)
effort[, 4] <- seq(from = 2, to = 1, length = 20)
getFMort(params, effort = effort)
# Get the total fishing mortality using the effort already held in a 
# MizerSim object.
sim <- project(params, t_max = 20, effort = 0.5)
getFMort(sim)
getFMort(sim, time_range = c(10, 20))
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
