% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steady.R
\name{retune_erepro}
\alias{retune_erepro}
\title{Retune reproduction efficiency to maintain initial egg abundances}
\usage{
retune_erepro(params, species = species_params(params)$species)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{species}{The species to be selected. Optional. By default all target
species are selected. A vector of species names, or a
numeric vector with the species indices, or a logical vector indicating for
each species whether it is to be selected (TRUE) or not.}
}
\value{
A MizerParams object with updated values for the \code{erepro} column
in the \code{species_params} data frame.
}
\description{
Sets the reproductive efficiency for all species so that the rate of egg
production exactly compensates for the loss from the first size class due
to growth and mortality. Turns off the external density dependence in the
reproduction rate by setting the \code{RDD} function to
\code{\link[=noRDD]{noRDD()}}
}
\concept{helper}
