% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_params.R
\name{validSpeciesParams}
\alias{validSpeciesParams}
\title{Validate species parameter data frame}
\usage{
validSpeciesParams(species_params)
}
\arguments{
\item{species_params}{The user-supplied species parameter data frame}
}
\value{
A valid species parameter data frame

This function throws an error if
\itemize{
\item the \code{species} column does not exist or contains duplicates
\item the \code{w_inf} column does not exist or contains NAs or is not numeric
}

It sets default values if any of the following are missing or NA
\itemize{
\item \code{w_mat} is set to \code{w_inf/4}
\item \code{w_min} is set to \code{0.001}
\item \code{alpha} is set to \code{0.6}
\item \code{interaction_resource} is set to \code{1}
}

Any \code{w_mat25} that is given that is not smaller than \code{w_mat} is set to
\code{w_mat * 3^(-0.1)}.

If \code{species_params} was provided as a tibble it is converted back to an
ordinary data frame.
}
\description{
Check validity of species parameters and set defaults for missing but
required parameters
}
\concept{helper}
