% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduction.R
\name{BevertonHoltRDD}
\alias{BevertonHoltRDD}
\title{Beverton Holt function to calculate density-dependent reproduction rate}
\usage{
BevertonHoltRDD(rdi, species_params, ...)
}
\arguments{
\item{rdi}{Vector of density-independent reproduction rates
\eqn{R_{di}}{R_di} for all species.}

\item{species_params}{A species parameter dataframe. Must contain a column
R_max holding the maximum reproduction rate \eqn{R_{max}}{R_max} for each species.}

\item{...}{Unused}
}
\value{
Vector of density-dependent reproduction rates.
}
\description{
Takes the density-independent rates \eqn{R_{di}}{R_di} of egg production (as
calculated by \code{\link[=getRDI]{getRDI()}}) and returns
reduced, density-dependent reproduction rates \eqn{R_{dd}}{R_dd} given as
\deqn{R_{dd} = R_{di}
\frac{R_{max}}{R_{di} + R_{max}}}{R_dd = R_di R_max/(R_di + R_max)} where
\eqn{R_{max}}{R_max} are the maximum possible reproduction rates that must be
specified in a column in the species parameter dataframe.
(All quantities in the above equation are species-specific but we dropped
the species index for simplicity.)
}
\details{
This is only one example of a density-dependence. You can write your own
function based on this example, returning different density-dependent
reproduction rates. Three other examples provided are \code{\link[=RickerRDD]{RickerRDD()}},
\code{\link[=SheperdRDD]{SheperdRDD()}}, \code{\link[=noRDD]{noRDD()}} and \code{\link[=constantRDD]{constantRDD()}}. For more explanation see
\code{\link[=setReproduction]{setReproduction()}}.
}
\seealso{
Other functions calculating density-dependent reproduction rate: 
\code{\link{RickerRDD}()},
\code{\link{SheperdRDD}()},
\code{\link{constantEggRDI}()},
\code{\link{constantRDD}()},
\code{\link{noRDD}()}
}
\concept{functions calculating density-dependent reproduction rate}
