% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_params.R
\name{get_h_default}
\alias{get_h_default}
\title{Get default value for h}
\usage{
get_h_default(params)
}
\arguments{
\item{params}{A MizerParams object or a species parameter data frame}
}
\value{
A vector with the values of h for all species
}
\description{
Sets \code{h} so that the species reaches maturity size \code{w_mat} at the maturity
age \code{age_mat} if it feeds at feeding level \code{f0}.
}
\details{
If \code{age_mat} is missing in the species parameter data frame, then it is
calculated from the von Bertalanffy growth curve parameters \code{k_vb} and
(optionally \code{t0}) taken from the species parameter data frame. This is not
reliable and a warning is issued.
}
\seealso{
Other functions calculating defaults: 
\code{\link{get_f0_default}()},
\code{\link{get_gamma_default}()},
\code{\link{get_ks_default}()}
}
\concept{functions calculating defaults}
\concept{helper}
\keyword{internal}
