% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInitialValues.R
\name{setInitialValues}
\alias{setInitialValues}
\title{Set initial values to values from a simulation}
\usage{
setInitialValues(params, sim, time_range, geometric_mean = FALSE)
}
\arguments{
\item{params}{A \code{MizerParams} object in which to set the initial values}

\item{sim}{A \code{MizerSim} object from which to take the values.}

\item{time_range}{The time range to average the abundances over. Can be a
vector of values, a vector of min and max time, or a single value. Only the
range of times is relevant, i.e., all times between the smallest and
largest will be selected.  Default is the final time step.}

\item{geometric_mean}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If TRUE then the average of the abundances over the
time range is a geometric mean instead of the default arithmetic mean. This
does not affect the average of the effort or of other components, which is
always arithmetic.}
}
\value{
The \code{params} object with updated initial values and initial effort.
Because of the way the
R language works, \code{setInitialValues()} does not make the changes to the
params object that you pass to it but instead returns a new params object.
So to affect the change you call the function in the form
\code{params <- setInitialValues(params, sim)}.
}
\description{
This is used to use the results from one simulation as the starting values
for another simulation.
}
\details{
The initial abundances (for both species and resource) in the \code{params}
object are set to the abundances in a MizerSim object, averaged over
a range of times. Similarly, the initial effort in the \code{params} object is
set to the effort in the MizerSim object, again averaged over that range
of times.
When no time range is specified, the initial values are taken from the final
time step of the simulation.

If the model described by \code{sim} and \code{params} has additional components
created with \code{\link[=setComponent]{setComponent()}} then the values of these components are also
averaged and copied to \code{params}.

The MizerSim object must come from a model with the same set of species and
gears and other components and the same size bins as the MizerParams object.
Otherwise an error is raised.
}
\examples{
\donttest{
params <- NS_params
sim <- project(params, t_max = 20, effort = 0.5)
params <- setInitialValues(params, sim)
}
}
\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
