% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_params.R
\name{completeSpeciesParams}
\alias{completeSpeciesParams}
\title{Complete species parameter data frame with default values}
\usage{
completeSpeciesParams(species_params)
}
\arguments{
\item{species_params}{The user-supplied species parameter data frame}
}
\value{
A completed species parameter data frame

The function sets default values if any of the following species parameters
are missing or NA:
\itemize{
\item \code{w_mat} is set to \code{w_max/4}
\item \code{w_min} is set to \code{0.001}
\item \code{alpha} is set to \code{0.6}
\item \code{interaction_resource} is set to \code{1}
\item \code{n} is set to \code{3/4}
}

It calls \code{\link[=validSpeciesParams]{validSpeciesParams()}} to check the validity of the species
parameters. Nevertheless the species parameters returned by this function are not guaranteed
to produce a viable model. More checks of the parameters are performed by the
individual rate-setting functions (see \code{\link[=setParams]{setParams()}} for the list of these
functions).
}
\description{
Sets defaults for missing but required species parameters.
}
\seealso{
\code{\link[=species_params]{species_params()}}, \code{\link[=validSpeciesParams]{validSpeciesParams()}}
}
\concept{helper}
