% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSpectra}
\alias{plotSpectra}
\alias{plotlySpectra}
\title{Plot the abundance spectra}
\usage{
plotSpectra(
  object,
  species = NULL,
  time_range,
  geometric_mean = FALSE,
  wlim = c(NA, NA),
  ylim = c(NA, NA),
  power = 1,
  biomass = TRUE,
  total = FALSE,
  resource = TRUE,
  background = TRUE,
  highlight = NULL,
  return_data = FALSE,
  ...
)

plotlySpectra(
  object,
  species = NULL,
  time_range,
  geometric_mean = FALSE,
  wlim = c(NA, NA),
  ylim = c(NA, NA),
  power = 1,
  biomass = TRUE,
  total = FALSE,
  resource = TRUE,
  background = TRUE,
  highlight = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \linkS4class{MizerSim} or
\linkS4class{MizerParams}.}

\item{species}{The species to be selected. Optional. By default all target
species are selected. A vector of species names, or a
numeric vector with the species indices, or a logical vector indicating for
each species whether it is to be selected (TRUE) or not.}

\item{time_range}{The time range (either a vector of values, a vector of min
and max time, or a single value) to average the abundances over. Default is
the final time step. Ignored when called with a \linkS4class{MizerParams}
object.}

\item{geometric_mean}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If TRUE then the average of the abundances over the
time range is a geometric mean instead of the default arithmetic mean.}

\item{wlim}{A numeric vector of length two providing lower and upper limits
for the w axis. Use NA to refer to the existing minimum or maximum.}

\item{ylim}{A numeric vector of length two providing lower and upper limits
for the y axis. Use NA to refer to the existing minimum or maximum. Any
values below 1e-20 are always cut off.}

\item{power}{The abundance is plotted as the number density times the weight
raised to \code{power}. The default \code{power = 1} gives the biomass
density, whereas \code{power = 2} gives the biomass density with respect
to logarithmic size bins.}

\item{biomass}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Only used if \code{power} argument is missing. Then
\code{biomass = TRUE} is equivalent to \code{power=1} and
\code{biomass = FALSE} is equivalent to \code{power=0}}

\item{total}{A boolean value that determines whether the total over all
species in the system is plotted as well. Note that even if the plot
only shows a selection of species, the total is including all species.
Default is FALSE.}

\item{resource}{A boolean value that determines whether resource is included.
Default is TRUE.}

\item{background}{A boolean value that determines whether background species
are included. Ignored if the model does not contain background species.
Default is TRUE.}

\item{highlight}{Name or vector of names of the species to be highlighted.}

\item{return_data}{A boolean value that determines whether the formatted data
used for the plot is returned instead of the plot itself. Default value is FALSE}

\item{...}{Other arguments (currently unused)}
}
\value{
A ggplot2 object, unless \code{return_data = TRUE}, in which case a data
frame with the four variables 'w', 'value', 'Species', 'Legend' is
returned.
}
\description{
Plots the number density multiplied by a power of the weight, with the power
specified by the \code{power} argument.
}
\details{
When called with a \linkS4class{MizerSim} object, the abundance is averaged
over the specified time range (a single value for the time range can be used
to plot a single time step). When called with a \linkS4class{MizerParams}
object the initial abundance is plotted.
}
\examples{
\donttest{
params <-  NS_params
sim <- project(params, effort=1, t_max=20, t_save = 2, progress_bar = FALSE)
plotSpectra(sim)
plotSpectra(sim, wlim = c(1e-6, NA))
plotSpectra(sim, time_range = 10:20)
plotSpectra(sim, time_range = 10:20, power = 0)
plotSpectra(sim, species = c("Cod", "Herring"), power = 1)

# Returning the data frame
fr <- plotSpectra(sim, return_data = TRUE)
str(fr)
}
}
\seealso{
\link{plotting_functions}

Other plotting functions: 
\code{\link{animateSpectra}()},
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotPredMort}()},
\code{\link{plotYield}()},
\code{\link{plotYieldGear}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
