# getProportionOfLargeFish works

    Code
      prop
    Output
               0        0.5          1        1.5          2        2.5          3 
      0.26925519 0.01698413 0.03196148 0.20900194 0.44008356 0.63864680 0.77473354 
             3.5          4        4.5          5        5.5          6        6.5 
      0.85819401 0.79177149 0.25892592 0.17664525 0.33276549 0.48876696 0.57116942 
               7        7.5          8        8.5          9        9.5         10 
      0.39280523 0.14873450 0.07530515 0.06799577 0.08450497 0.10672174 0.12465102 
            10.5         11       11.5         12       12.5         13       13.5 
      0.15725916 0.20998563 0.25262044 0.22074698 0.12632169 0.12454533 0.16987230 
              14       14.5         15       15.5         16       16.5         17 
      0.21382524 0.18553926 0.09037121 0.11578632 0.18360999 0.25228806 0.26524622 
            17.5         18       18.5         19       19.5         20 
      0.10280200 0.07783290 0.12626045 0.19298462 0.24655068 0.19697190 

# getMeanWeight works

    Code
      mw
    Output
               0        0.5          1        1.5          2        2.5          3 
       767.53011   69.09766   69.89657  191.38114  387.59529  634.61024  912.27456 
             3.5          4        4.5          5        5.5          6        6.5 
      1202.18388  961.11905   75.07344   57.20683  108.01262  218.11602  287.67786 
               7        7.5          8        8.5          9        9.5         10 
        55.77707   35.71154   47.57239   75.14351  112.44499  131.75273  119.90371 
            10.5         11       11.5         12       12.5         13       13.5 
       131.73882  173.23466  181.08308   95.14511   72.24514   98.87037  155.70279 
              14       14.5         15       15.5         16       16.5         17 
       196.24131   83.83311   69.10626  111.86344  196.49824  307.22162  113.67807 
            17.5         18       18.5         19       19.5         20 
        56.97195   84.22200  147.53358  247.48012  243.83835   63.61455 

# getMeanMaxWeight works

    Code
      getMeanMaxWeight(sim, measure = "both")
    Output
         mmw_numbers mmw_biomass
      0     135.6361    4629.458
      1     600.1607    1376.281
      2     843.5139    4406.216
      3     986.9465    9063.254
      4    1094.1022   10561.412
      5    1055.7711    9431.078
      6    1229.4380    9161.926
      7    1654.1073    9700.953
      8    1923.1869    9706.206
      9    2267.9466    9551.113
      10   2535.6313    9253.220

# getYieldGear works

    Code
      y
    Output
      , , sp = Sprat
      
          gear
      time   Industrial Pelagic Beam Otter
        0      38044416       0    0     0
        1     558316006       0    0     0
        2    8229795127       0    0     0
        3   16058989646       0    0     0
        4   84325094857       0    0     0
        5  220212693088       0    0     0
        6  203621711108       0    0     0
        7  126537188612       0    0     0
        8  103313111309       0    0     0
        9   76522697786       0    0     0
        10  42658404945       0    0     0
      
      , , sp = Sandeel
      
          gear
      time   Industrial Pelagic Beam Otter
        0  6.335333e+07       0    0     0
        1  2.807324e+11       0    0     0
        2  7.195382e+11       0    0     0
        3  6.294512e+11       0    0     0
        4  8.923957e+11       0    0     0
        5  1.173624e+12       0    0     0
        6  1.196270e+12       0    0     0
        7  1.125332e+12       0    0     0
        8  1.105297e+12       0    0     0
        9  1.057050e+12       0    0     0
        10 1.000944e+12       0    0     0
      
      , , sp = N.pout
      
          gear
      time   Industrial Pelagic Beam Otter
        0      50722662       0    0     0
        1  211366746964       0    0     0
        2  279313741500       0    0     0
        3   32400674242       0    0     0
        4   36414157660       0    0     0
        5   94203749139       0    0     0
        6  112115105533       0    0     0
        7   86795893755       0    0     0
        8   93190701456       0    0     0
        9   92635220566       0    0     0
        10  91443894802       0    0     0
      
      , , sp = Herring
      
          gear
      time Industrial      Pelagic Beam Otter
        0           0     30658037    0     0
        1           0   5477035839    0     0
        2           0 240269222872    0     0
        3           0 235093127613    0     0
        4           0  76831870661    0     0
        5           0 128476347684    0     0
        6           0 355665239270    0     0
        7           0 398695209111    0     0
        8           0 295869946271    0     0
        9           0 282052687956    0     0
        10          0 276057839734    0     0
      
      , , sp = Dab
      
          gear
      time Industrial Pelagic        Beam Otter
        0           0       0    45365320     0
        1           0       0 22400577006     0
        2           0       0 57675462778     0
        3           0       0 18780950158     0
        4           0       0 11895946615     0
        5           0       0 19121152098     0
        6           0       0 19328258770     0
        7           0       0 15198687290     0
        8           0       0 12828931523     0
        9           0       0  9618321181     0
        10          0       0  7652198488     0
      
      , , sp = Whiting
      
          gear
      time Industrial Pelagic Beam        Otter
        0           0       0    0     43093552
        1           0       0    0   7240286452
        2           0       0    0 109460814009
        3           0       0    0  61917376550
        4           0       0    0  39948194825
        5           0       0    0 118403971086
        6           0       0    0 164075894541
        7           0       0    0 133905073930
        8           0       0    0 127357779567
        9           0       0    0 120665336278
        10          0       0    0 116817508835
      
      , , sp = Sole
      
          gear
      time Industrial Pelagic         Beam Otter
        0           0       0     42294188     0
        1           0       0    843009366     0
        2           0       0  25800180144     0
        3           0       0  82833388096     0
        4           0       0  86869817350     0
        5           0       0 117785662356     0
        6           0       0 178627553633     0
        7           0       0 183203100846     0
        8           0       0 139592183973     0
        9           0       0 112279353114     0
        10          0       0 103421881515     0
      
      , , sp = Gurnard
      
          gear
      time Industrial Pelagic Beam       Otter
        0           0       0    0    41047176
        1           0       0    0  1631749055
        2           0       0    0 12238303048
        3           0       0    0  4724782150
        4           0       0    0  4383508244
        5           0       0    0 17317077547
        6           0       0    0 38324622639
        7           0       0    0 38547946693
        8           0       0    0 35567923285
        9           0       0    0 40503456595
        10          0       0    0 41969161780
      
      , , sp = Plaice
      
          gear
      time Industrial Pelagic         Beam Otter
        0           0       0     37989527     0
        1           0       0     18734282     0
        2           0       0    157323296     0
        3           0       0    758391480     0
        4           0       0    884584319     0
        5           0       0   2047420621     0
        6           0       0  13379631135     0
        7           0       0  39170803422     0
        8           0       0  70604173632     0
        9           0       0 169757646571     0
        10          0       0 393502381428     0
      
      , , sp = Haddock
      
          gear
      time Industrial Pelagic Beam        Otter
        0           0       0    0 3.550657e+07
        1           0       0    0 4.693011e+10
        2           0       0    0 1.318105e+12
        3           0       0    0 1.360711e+12
        4           0       0    0 6.469540e+11
        5           0       0    0 3.490267e+11
        6           0       0    0 3.727775e+11
        7           0       0    0 4.299409e+11
        8           0       0    0 3.611812e+11
        9           0       0    0 3.517122e+11
        10          0       0    0 3.959557e+11
      
      , , sp = Cod
      
          gear
      time Industrial Pelagic Beam        Otter
        0           0       0    0     28430360
        1           0       0    0    346033675
        2           0       0    0 101364440036
        3           0       0    0 412920782014
        4           0       0    0 493468900737
        5           0       0    0 447568478029
        6           0       0    0 474874102324
        7           0       0    0 550299321303
        8           0       0    0 585450761600
        9           0       0    0 576043900031
        10          0       0    0 558075401042
      
      , , sp = Saithe
      
          gear
      time Industrial Pelagic Beam        Otter
        0           0       0    0     24170110
        1           0       0    0     21712974
        2           0       0    0   3378214617
        3           0       0    0  27617463179
        4           0       0    0 362749754076
        5           0       0    0 775185663285
        6           0       0    0 639993286233
        7           0       0    0 564958065619
        8           0       0    0 575572485756
        9           0       0    0 555930832387
        10          0       0    0 543246652629
      

# getYield works

    Code
      y
    Output
          sp
      time        Sprat      Sandeel       N.pout      Herring         Dab
        0      38044416 6.335333e+07     50722662     30658037    45365320
        1     558316006 2.807324e+11 211366746964   5477035839 22400577006
        2    8229795127 7.195382e+11 279313741500 240269222872 57675462778
        3   16058989646 6.294512e+11  32400674242 235093127613 18780950158
        4   84325094857 8.923957e+11  36414157660  76831870661 11895946615
        5  220212693088 1.173624e+12  94203749139 128476347684 19121152098
        6  203621711108 1.196270e+12 112115105533 355665239270 19328258770
        7  126537188612 1.125332e+12  86795893755 398695209111 15198687290
        8  103313111309 1.105297e+12  93190701456 295869946271 12828931523
        9   76522697786 1.057050e+12  92635220566 282052687956  9618321181
        10  42658404945 1.000944e+12  91443894802 276057839734  7652198488
          sp
      time      Whiting         Sole     Gurnard       Plaice      Haddock
        0      43093552     42294188    41047176     37989527 3.550657e+07
        1    7240286452    843009366  1631749055     18734282 4.693011e+10
        2  109460814009  25800180144 12238303048    157323296 1.318105e+12
        3   61917376550  82833388096  4724782150    758391480 1.360711e+12
        4   39948194825  86869817350  4383508244    884584319 6.469540e+11
        5  118403971086 117785662356 17317077547   2047420621 3.490267e+11
        6  164075894541 178627553633 38324622639  13379631135 3.727775e+11
        7  133905073930 183203100846 38547946693  39170803422 4.299409e+11
        8  127357779567 139592183973 35567923285  70604173632 3.611812e+11
        9  120665336278 112279353114 40503456595 169757646571 3.517122e+11
        10 116817508835 103421881515 41969161780 393502381428 3.959557e+11
          sp
      time          Cod       Saithe
        0      28430360     24170110
        1     346033675     21712974
        2  101364440036   3378214617
        3  412920782014  27617463179
        4  493468900737 362749754076
        5  447568478029 775185663285
        6  474874102324 639993286233
        7  550299321303 564958065619
        8  585450761600 575572485756
        9  576043900031 555930832387
        10 558075401042 543246652629

# getCommunitySlope works

    Code
      slope_b3
    Output
              slope intercept        r2
      0  -0.2897714  12.23882 0.5625413
      1  -1.0649175  21.68013 0.7202647
      2  -0.7952623  22.74183 0.6617018
      3  -0.6679574  23.11060 0.6872080
      4  -0.6072763  23.28407 0.7163831
      5  -0.5920434  23.41886 0.7549412
      6  -0.6124380  23.73776 0.8142898
      7  -0.6538982  24.20058 0.8573667
      8  -0.6789819  24.44596 0.8803066
      9  -0.7261858  24.76189 0.9085528
      10 -0.7721135  25.14127 0.9257311

# getDiet works with proportion = FALSE

    Code
      diet
    Output
      , , prey = Sprat
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  2.015052e-21 4.398536e-21 4.218747e-21 6.626554e-21 9.333674e-21
        Herring 1.198476e-07 1.142844e-07 9.960783e-08 8.186624e-08 7.407157e-08
        Dab     8.282534e-21 1.118312e-20 1.421536e-20 1.686739e-20 2.346327e-20
        Whiting 8.982542e-21 1.960745e-20 1.880600e-20 2.953933e-20 4.160692e-20
        Sole    0.000000e+00 0.000000e+00 1.493501e-22 0.000000e+00 8.739574e-22
        Gurnard 1.126387e-21 1.522765e-21 2.061169e-21 2.691124e-21 4.182545e-21
        Plaice  3.754528e-21 3.841347e-21 5.111025e-21 5.320837e-21 9.660924e-21
        Haddock 4.070544e-22 4.029848e-22 8.489790e-22 6.110103e-22 1.385772e-21
        Cod     2.395121e-20 2.645379e-20 2.905300e-20 2.422403e-20 4.358921e-20
        Saithe  1.284446e-21 1.490517e-21 1.426209e-21 1.659483e-21 1.830999e-21
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  1.738122e-20 2.417006e-20 4.242586e-20 6.311518e-20 9.953955e-20
        Herring 6.155943e-08 1.244409e-08 0.000000e+00 0.000000e+00 0.000000e+00
        Dab     3.232356e-20 4.556201e-20 6.137516e-20 7.729897e-20 1.078388e-19
        Whiting 7.748064e-20 1.077434e-19 1.891227e-19 2.813499e-19 4.437196e-19
        Sole    2.687962e-21 4.579307e-21 7.252079e-21 8.281143e-21 1.540627e-20
        Gurnard 5.205316e-21 6.930896e-21 9.982029e-21 1.050106e-20 1.585578e-20
        Plaice  1.044690e-20 1.474145e-20 2.152603e-20 3.186506e-20 4.392369e-20
        Haddock 2.057645e-21 4.142705e-21 5.171983e-21 8.103904e-21 1.004550e-20
        Cod     3.482277e-20 5.778104e-20 7.327276e-20 1.167390e-19 1.498053e-19
        Saithe  1.394202e-21 2.812751e-21 3.194835e-21 5.547944e-21 7.489196e-21
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 1.598782e-22 2.762475e-22 0.000000e+00 0.000000e+00
        N.pout  1.591419e-19 2.292889e-19 4.213664e-19 8.237193e-19 1.463592e-18
        Herring 0.000000e+00 0.000000e+00 7.662509e-21 0.000000e+00 0.000000e+00
        Dab     1.549201e-19 2.134851e-19 3.684252e-19 6.807422e-19 1.178876e-18
        Whiting 7.094101e-19 1.022106e-18 1.878334e-18 3.671911e-18 6.524285e-18
        Sole    1.985630e-20 4.063402e-20 6.262771e-20 1.278700e-19 2.310073e-19
        Gurnard 2.247741e-20 3.170441e-20 5.086339e-20 8.991193e-20 1.543258e-19
        Plaice  7.182316e-20 1.027300e-19 1.824574e-19 3.344750e-19 5.891954e-19
        Haddock 1.686058e-20 2.223928e-20 3.978172e-20 7.363820e-20 1.305306e-19
        Cod     2.925473e-19 4.191436e-19 7.472954e-19 1.244000e-18 2.314055e-18
        Saithe  1.487111e-20 2.359823e-20 4.036889e-20 6.895871e-20 1.237614e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   0.000000e+00 4.820573e-21 2.052149e-20 4.426242e-20 6.486590e-20
        Sandeel 2.814882e-22 9.727454e-22 1.867522e-21 0.000000e+00 0.000000e+00
        N.pout  2.247227e-18 3.144441e-18 7.783097e-18 1.298205e-17 2.473417e-17
        Herring 2.927953e-21 0.000000e+00 2.331046e-20 8.950500e-21 2.577538e-20
        Dab     1.826218e-18 2.612850e-18 6.113516e-18 1.026575e-17 1.932774e-17
        Whiting 1.001751e-17 1.401704e-17 3.469488e-17 5.787036e-17 1.102580e-16
        Sole    3.792673e-19 5.560396e-19 1.292892e-18 2.201469e-18 4.157401e-18
        Gurnard 2.472490e-19 3.576521e-19 7.923363e-19 1.350648e-18 2.513988e-18
        Plaice  9.497935e-19 1.397089e-18 3.087755e-18 5.246123e-18 9.756566e-18
        Haddock 1.999571e-19 2.917784e-19 6.773117e-19 1.134389e-18 2.140885e-18
        Cod     3.629148e-18 5.831241e-18 1.126801e-17 1.956768e-17 3.530717e-17
        Saithe  2.023674e-19 3.254186e-19 6.063892e-19 1.043177e-18 1.860981e-18
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   1.192537e-19 1.589924e-19 1.042671e-19 1.442125e-19 8.334383e-20
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 8.725733e-21 2.010248e-21
        N.pout  3.734817e-17 5.761674e-17 8.738051e-17 1.424641e-16 2.035834e-16
        Herring 9.501074e-20 1.368045e-19 2.206207e-19 3.448970e-19 4.809295e-19
        Dab     2.976956e-17 4.669428e-17 7.208594e-17 1.181512e-16 1.735221e-16
        Whiting 1.664878e-16 2.568394e-16 3.895180e-16 6.350654e-16 9.075180e-16
        Sole    6.522462e-18 1.039886e-17 1.631811e-17 2.684676e-17 4.031552e-17
        Gurnard 3.973493e-18 6.353316e-18 1.000010e-17 1.645869e-17 2.485355e-17
        Plaice  1.548660e-17 2.479628e-17 3.909050e-17 6.422140e-17 9.707543e-17
        Haddock 3.304078e-18 5.185007e-18 8.038568e-18 1.318885e-17 1.946088e-17
        Cod     5.799925e-17 9.506777e-17 1.542759e-16 2.550006e-16 4.005294e-16
        Saithe  3.107927e-18 5.189740e-18 8.553057e-18 1.427329e-17 2.292477e-17
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   9.492844e-20 1.013069e-19 7.258558e-20 8.536636e-20 1.097879e-19
        Sandeel 0.000000e+00 2.667381e-21 0.000000e+00 7.078651e-21 0.000000e+00
        N.pout  2.800671e-16 3.920783e-16 7.875370e-16 1.503025e-15 2.092521e-15
        Herring 6.262455e-19 9.572120e-19 1.949560e-18 3.589460e-18 5.046487e-18
        Dab     2.473548e-16 3.572756e-16 6.813877e-16 1.258201e-15 1.800570e-15
        Whiting 1.248461e-15 1.747776e-15 3.510621e-15 6.700065e-15 9.327875e-15
        Sole    5.896384e-17 8.696073e-17 1.595242e-16 2.874831e-16 4.211684e-16
        Gurnard 3.660548e-17 5.428840e-17 9.829991e-17 1.756696e-16 2.591366e-16
        Plaice  1.429212e-16 2.115471e-16 3.804964e-16 6.776796e-16 1.000554e-15
        Haddock 2.787436e-17 4.052586e-17 7.690007e-17 1.414936e-16 2.032693e-16
        Cod     6.151821e-16 9.422903e-16 1.600326e-15 2.725834e-15 4.166940e-15
        Saithe  3.612595e-17 5.644324e-17 9.353795e-17 1.554483e-16 2.411583e-16
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   1.338668e-19 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 2.704853e-20 0.000000e+00 3.589047e-20 0.000000e+00
        N.pout  2.996286e-15 5.325605e-15 8.998037e-15 1.513469e-14 3.295824e-14
        Herring 7.351846e-18 1.297026e-17 2.184365e-17 3.632419e-17 7.529860e-17
        Dab     2.636250e-15 4.576697e-15 7.647069e-15 1.274848e-14 2.648238e-14
        Whiting 1.335661e-14 2.374007e-14 4.011075e-14 6.746624e-14 1.469186e-13
        Sole    6.275690e-16 1.070408e-15 1.774653e-15 2.940219e-15 5.874199e-15
        Gurnard 3.879738e-16 6.579460e-16 1.087945e-15 1.799025e-15 3.551386e-15
        Plaice  1.497370e-15 2.532721e-15 4.183774e-15 6.916661e-15 1.363711e-14
        Haddock 2.987309e-16 5.173735e-16 8.633483e-16 1.437411e-15 2.963943e-15
        Cod     6.392087e-15 1.049336e-14 1.705614e-14 2.781820e-14 5.098615e-14
        Saithe  3.735578e-16 6.027446e-16 9.684836e-16 1.563401e-15 2.742898e-15
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 9.524552e-21 2.194281e-20 0.000000e+00 2.911573e-20 0.000000e+00
        N.pout  4.706340e-14 6.473718e-14 1.504277e-13 2.337490e-13 3.955637e-13
        Herring 1.092758e-16 1.537783e-16 3.419198e-16 5.331724e-16 8.993573e-16
        Dab     3.868271e-14 5.487170e-14 1.205405e-13 1.894728e-13 3.203076e-13
        Whiting 2.097955e-13 2.885803e-13 6.705649e-13 1.041988e-12 1.763313e-12
        Sole    8.767633e-15 1.276153e-14 2.670097e-14 4.243956e-14 7.167515e-14
        Gurnard 5.339374e-15 7.835253e-15 1.614708e-14 2.576871e-14 4.352074e-14
        Plaice  2.058187e-14 3.029314e-14 6.222979e-14 9.961482e-14 1.684546e-13
        Haddock 4.338514e-15 6.177029e-15 1.346402e-14 2.117546e-14 3.577075e-14
        Cod     7.975479e-14 1.225685e-13 2.316092e-13 3.782416e-13 6.392494e-13
        Saithe  4.362360e-15 6.858176e-15 1.239594e-14 2.047029e-14 3.462358e-14
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 5.795013e-20 0.000000e+00 2.563118e-20 1.180990e-19 1.700490e-19
        N.pout  6.463454e-13 1.468914e-12 2.142819e-12 3.077551e-12 4.273738e-12
        Herring 1.471887e-15 3.245142e-15 4.783207e-15 6.990992e-15 9.973537e-15
        Dab     5.257724e-13 1.149142e-12 1.714374e-12 2.526860e-12 3.625936e-12
        Whiting 2.881228e-12 6.548010e-12 9.552091e-12 1.371886e-11 1.905113e-11
        Sole    1.180992e-13 2.490754e-13 3.797638e-13 5.723803e-13 8.426655e-13
        Gurnard 7.181716e-14 1.497254e-13 2.300765e-13 3.493958e-13 5.185603e-13
        Plaice  2.783968e-13 5.787857e-13 8.935200e-13 1.361444e-12 2.025205e-12
        Haddock 5.872150e-14 1.276434e-13 1.907592e-13 2.819471e-13 4.062869e-13
        Cod     1.065491e-12 2.069960e-12 3.333939e-12 5.303054e-12 8.270868e-12
        Saithe  5.807834e-14 1.084699e-13 1.790815e-13 2.923645e-13 4.692597e-13
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 6.302164e-18 4.839674e-18
        Sandeel 3.917615e-19 3.835821e-19 4.938337e-19 1.167641e-18 1.551941e-18
        N.pout  7.533723e-12 1.107046e-11 2.058305e-11 2.911843e-11 5.782004e-11
        Herring 1.754178e-14 2.629674e-14 4.821204e-14 6.977184e-14 1.349596e-13
        Dab     6.317516e-12 9.482456e-12 1.721371e-11 2.501582e-11 4.788945e-11
        Whiting 3.358324e-11 4.934902e-11 9.175350e-11 1.298019e-10 2.577456e-10
        Sole    1.451358e-12 2.213446e-12 3.938674e-12 5.848348e-12 1.087087e-11
        Gurnard 8.896234e-13 1.363155e-12 2.409666e-12 3.601122e-12 6.630435e-12
        Plaice  3.464154e-12 5.309060e-12 9.350018e-12 1.398453e-11 2.564528e-11
        Haddock 7.076170e-13 1.065580e-12 1.930443e-12 2.816191e-12 5.369770e-12
        Cod     1.394640e-11 2.200142e-11 3.754914e-11 5.819695e-11 1.014913e-10
        Saithe  7.886304e-13 1.266502e-12 2.130854e-12 3.365519e-12 5.714788e-12
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   9.756002e-18 0.000000e+00 1.202050e-17 2.236744e-17 2.883252e-17
        Sandeel 2.800718e-18 4.576126e-18 7.985983e-18 1.311557e-17 2.190999e-17
        N.pout  1.101930e-10 2.113752e-10 3.451228e-10 5.531945e-10 8.049474e-10
        Herring 2.521084e-13 4.746579e-13 7.742696e-13 1.245056e-12 1.840709e-12
        Dab     8.920310e-11 1.679232e-10 2.757032e-10 4.456471e-10 6.636053e-10
        Whiting 4.912099e-10 9.422517e-10 1.538461e-09 2.465987e-09 3.588231e-09
        Sole    1.988261e-11 3.686544e-11 6.092423e-11 9.927925e-11 1.508099e-10
        Gurnard 1.205602e-11 2.224741e-11 3.685866e-11 6.023941e-11 9.211335e-11
        Plaice  4.655985e-11 8.589259e-11 1.426368e-10 2.336044e-10 3.582043e-10
        Haddock 9.970347e-12 1.871007e-11 3.071470e-11 4.967106e-11 7.415475e-11
        Cod     1.775969e-10 3.167904e-10 5.308982e-10 8.816763e-10 1.402057e-09
        Saithe  9.766822e-12 1.700467e-11 2.852700e-11 4.764513e-11 7.730525e-11
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   5.229187e-17 1.005280e-16 1.772147e-16 3.026922e-16 5.231658e-16
        Sandeel 3.605470e-17 6.007014e-17 9.867475e-17 1.632769e-16 2.695215e-16
        N.pout  1.103417e-09 1.544269e-09 2.852742e-09 4.276189e-09 7.021580e-09
        Herring 2.595756e-12 3.748714e-12 6.831620e-12 1.040674e-11 1.709418e-11
        Dab     9.415839e-10 1.360179e-09 2.444370e-09 3.719771e-09 6.078307e-09
        Whiting 4.918725e-09 6.883923e-09 1.271673e-08 1.906206e-08 3.130025e-08
        Sole    2.198675e-10 3.247509e-10 5.703078e-10 8.775214e-10 1.428015e-09
        Gurnard 1.354317e-10 2.013130e-10 3.508896e-10 5.415140e-10 8.797368e-10
        Plaice  5.278695e-10 7.848314e-10 1.361800e-09 2.099925e-09 3.403756e-09
        Haddock 1.056896e-10 1.534180e-10 2.751705e-10 4.198941e-10 6.863614e-10
        Cod     2.167567e-09 3.350442e-09 5.634013e-09 8.855146e-09 1.427343e-08
        Saithe  1.228517e-10 1.944513e-10 3.234461e-10 5.146808e-10 8.289544e-10
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   8.733245e-16 1.470498e-15 2.470814e-15 4.188245e-15 7.127971e-15
        Sandeel 4.452093e-16 7.355562e-16 1.216776e-15 2.012416e-15 3.328942e-15
        N.pout  9.795034e-09 1.632987e-08 2.555949e-08 4.193280e-08 6.517540e-08
        Herring 2.452133e-11 4.068309e-11 6.398530e-11 1.044290e-10 1.629469e-10
        Dab     8.726706e-09 1.437727e-08 2.254320e-08 3.665975e-08 5.713859e-08
        Whiting 4.366353e-08 7.279403e-08 1.139371e-07 1.869247e-07 2.905338e-07
        Sole    2.094554e-09 3.420038e-09 5.371719e-09 8.683357e-09 1.357353e-08
        Gurnard 1.297964e-09 2.112620e-09 3.318311e-09 5.352506e-09 8.371254e-09
        Plaice  5.019540e-09 8.145904e-09 1.277214e-08 2.056370e-08 3.213050e-08
        Haddock 9.900076e-10 1.630446e-09 2.559381e-09 4.160042e-09 6.489813e-09
        Cod     2.174903e-08 3.481570e-08 5.463363e-08 8.694077e-08 1.360366e-07
        Saithe  1.284558e-09 2.043286e-09 3.203321e-09 5.056811e-09 7.894068e-09
               w
      predator          97.8          117          139          166          198
        Sprat   1.215997e-14 2.073442e-14 3.530622e-14 5.960874e-14 9.971396e-14
        Sandeel 5.510582e-15 9.119711e-15 1.508949e-14 2.495300e-14 4.123656e-14
        N.pout  1.281634e-07 2.161510e-07 3.850296e-07 6.095680e-07 9.473266e-07
        Herring 3.084807e-10 5.143220e-10 9.001991e-10 1.425075e-09 2.224848e-09
        Dab     1.076511e-07 1.799712e-07 3.156083e-07 5.023961e-07 7.877961e-07
        Whiting 5.713165e-07 9.635410e-07 1.716355e-06 2.717285e-06 4.222918e-06
        Sole    2.475374e-08 4.115167e-08 7.130628e-08 1.141575e-07 1.804098e-07
        Gurnard 1.511827e-08 2.509509e-08 4.333752e-08 6.953164e-08 1.101858e-07
        Plaice  5.792524e-08 9.623603e-08 1.663599e-07 2.675360e-07 4.248426e-07
        Haddock 1.215290e-08 2.027905e-08 3.545277e-08 5.642744e-08 8.853366e-08
        Cod     2.319127e-07 3.799499e-07 6.410650e-07 1.039063e-06 1.672034e-06
        Saithe  1.303460e-08 2.110320e-08 3.501023e-08 5.684536e-08 9.209109e-08
               w
      predator           237          282          337          402          480
        Sprat   1.645971e-13 2.678969e-13 4.297448e-13 6.808612e-13 1.068777e-12
        Sandeel 6.810384e-14 1.124341e-13 1.854608e-13 3.057942e-13 5.031741e-13
        N.pout  1.534868e-06 2.911355e-06 5.329059e-06 1.078433e-05 1.570892e-05
        Herring 3.606387e-09 6.707082e-09 1.210466e-08 2.396462e-08 3.527267e-08
        Dab     1.278854e-06 2.370605e-06 4.281539e-06 8.468661e-06 1.261380e-05
        Whiting 6.842013e-06 1.297801e-05 2.375546e-05 4.807355e-05 7.002601e-05
        Sole    2.932132e-07 5.327147e-07 9.510710e-07 1.843109e-06 2.804620e-06
        Gurnard 1.791897e-07 3.235992e-07 5.758240e-07 1.108946e-06 1.700457e-06
        Plaice  6.916967e-07 1.248514e-06 2.223187e-06 4.281613e-06 6.596123e-06
        Haddock 1.436958e-07 2.654126e-07 4.781020e-07 9.418447e-07 1.405242e-06
        Cod     2.731804e-06 4.769531e-06 8.318958e-06 1.539493e-05 2.471954e-05
        Saithe  1.509435e-07 2.592510e-07 4.472262e-07 8.079333e-07 1.329051e-06
               w
      predator           573          683          816          973         1160
        Sprat   1.669898e-12 2.611589e-12 4.112272e-12 6.551762e-12 1.059427e-11
        Sandeel 8.277199e-13 1.359499e-12 2.229909e-12 3.653072e-12 5.978270e-12
        N.pout  2.860839e-05 4.433228e-05 6.354267e-05 8.660675e-05 1.187188e-04
        Herring 6.376550e-08 9.963291e-08 1.456402e-07 2.048542e-07 2.914385e-07
        Dab     2.277898e-05 3.581513e-05 5.272086e-05 7.455020e-05 1.060527e-04
        Whiting 1.275282e-04 1.976209e-04 2.832554e-04 3.860686e-04 5.292149e-04
        Sole    5.023510e-06 8.000357e-06 1.203901e-05 1.750605e-05 2.554289e-05
        Gurnard 3.038445e-06 4.861050e-06 7.368251e-06 1.080679e-05 1.588129e-05
        Plaice  1.178796e-05 1.890790e-05 2.873867e-05 4.223182e-05 6.205591e-05
        Haddock 2.533894e-06 3.989021e-06 5.890206e-06 8.370009e-06 1.197504e-05
        Cod     4.358958e-05 7.175691e-05 1.137711e-04 1.758208e-04 2.699594e-04
        Saithe  2.328256e-06 3.895613e-06 6.339012e-06 1.009723e-05 1.592133e-05
               w
      predator          1390         1650         1970         2360         2810
        Sprat   1.740021e-11 2.898734e-11 4.884791e-11 8.299336e-11 1.417177e-10
        Sandeel 9.778381e-12 1.599076e-11 2.613811e-11 4.268762e-11 6.971810e-11
        N.pout  1.993949e-04 4.068824e-04 7.847938e-04 1.249310e-03 2.137387e-03
        Herring 4.906941e-07 9.679153e-07 1.821499e-06 2.901779e-06 4.930039e-06
        Dab     1.763452e-04 3.429560e-04 6.427074e-04 1.028568e-03 1.749194e-03
        Whiting 8.888461e-04 1.813766e-03 3.498386e-03 5.569058e-03 9.527831e-03
        Sole    4.206548e-05 7.881446e-05 1.444332e-04 2.325944e-04 3.939837e-04
        Gurnard 2.606035e-05 4.824914e-05 8.778501e-05 1.416587e-04 2.396595e-04
        Plaice  1.013851e-04 1.866546e-04 3.387812e-04 5.472186e-04 9.258437e-04
        Haddock 1.992682e-05 3.856634e-05 7.200524e-05 1.152753e-04 1.958304e-04
        Cod     4.369989e-04 7.584052e-04 1.318307e-03 2.143990e-03 3.588925e-03
        Saithe  2.578150e-05 4.350529e-05 7.370469e-05 1.198373e-04 1.986451e-04
               w
      predator          3350         4000         4780         5700         6800
        Sprat   2.425365e-10 4.150114e-10 7.085506e-10 1.204777e-09 2.036885e-09
        Sandeel 1.138052e-10 1.858638e-10 3.041172e-10 4.971155e-10 8.131519e-10
        N.pout  3.122328e-03 5.194553e-03 1.227192e-02 1.769621e-02 2.564725e-02
        Herring 7.302811e-06 1.213630e-05 2.749779e-05 4.009618e-05 5.905125e-05
        Dab     2.607475e-03 4.327334e-03 9.700296e-03 1.431033e-02 2.122816e-02
        Whiting 1.391836e-02 2.315563e-02 5.470377e-02 7.888262e-02 1.143237e-01
        Sole    5.978820e-04 9.900865e-04 2.120449e-03 3.198055e-03 4.839821e-03
        Gurnard 3.657721e-04 6.052661e-04 1.277478e-03 1.941585e-03 2.957783e-03
        Plaice  1.415857e-03 2.342103e-03 4.926049e-03 7.518731e-03 1.148617e-02
        Haddock 2.926190e-04 4.855315e-04 1.080507e-03 1.597125e-03 2.375321e-03
        Cod     5.648499e-03 9.302926e-03 1.795315e-02 2.850879e-02 4.515478e-02
        Saithe  3.165380e-04 5.193043e-04 9.523152e-04 1.543156e-03 2.494312e-03
               w
      predator          8120         9690        11600        13800        16500
        Sprat   3.419801e-09 5.697687e-09 9.421229e-09 1.547787e-08 2.532063e-08
        Sandeel 1.331216e-09 2.181161e-09 3.579047e-09 5.875823e-09 9.659870e-09
        N.pout  3.781723e-02 5.540867e-02 9.799676e-02 1.456728e-01 2.552623e-01
        Herring 8.865007e-05 1.326992e-04 2.329816e-04 3.522170e-04 6.114010e-04
        Dab     3.195648e-02 4.784570e-02 8.324839e-02 1.259032e-01 2.171267e-01
        Whiting 1.685688e-01 2.469766e-01 4.367951e-01 6.492753e-01 1.137632e+00
        Sole    7.403088e-03 1.125710e-02 1.930554e-02 2.957477e-02 5.033809e-02
        Gurnard 4.546818e-03 6.945212e-03 1.185414e-02 1.822614e-02 3.088790e-02
        Plaice  1.767970e-02 2.701312e-02 4.597219e-02 7.067204e-02 1.194647e-01
        Haddock 3.585770e-03 5.386591e-03 9.361825e-03 1.419809e-02 2.445263e-02
        Cod     7.158299e-02 1.125300e-01 1.877855e-01 2.951792e-01 4.890158e-01
        Saithe  4.026759e-03 6.447596e-03 1.069493e-02 1.704672e-02 2.800400e-02
               w
      predator         19600        23400        28000        33400        39900
        Sprat   4.137511e-08 6.776019e-08 1.115258e-07 1.846892e-07 3.074119e-07
        Sandeel 1.590794e-08 2.621656e-08 4.320877e-08 7.125919e-08 1.176300e-07
        N.pout  5.365998e-01 9.742556e-01 1.434953e+00 2.122447e+00 3.580061e+00
        Herring 1.240587e-03 2.220310e-03 3.306937e-03 4.965274e-03 8.377827e-03
        Dab     4.371233e-01 7.837887e-01 1.177653e+00 1.777131e+00 2.990248e+00
        Whiting 2.391290e+00 4.341483e+00 6.394515e+00 9.457395e+00 1.594597e+01
        Sole    9.782257e-02 1.737008e-01 2.657448e-01 4.075274e-01 6.830078e-01
        Gurnard 5.935713e-02 1.050897e-01 1.617577e-01 2.493354e-01 4.173046e-01
        Plaice  2.288489e-01 4.053077e-01 6.257258e-01 9.662502e-01 1.616040e+00
        Haddock 4.894670e-02 8.755013e-02 1.317872e-01 1.993346e-01 3.353370e-01
        Cod     8.788680e-01 1.521889e+00 2.421693e+00 3.843061e+00 6.387539e+00
        Saithe  4.857440e-02 8.272664e-02 1.334608e-01 2.146693e-01 3.556587e-01
      
      , , prey = Sandeel
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 4.214953e-21 4.272609e-21 1.789691e-21 2.061559e-21 6.530498e-21
        N.pout  8.908858e-21 1.121176e-20 1.133883e-20 1.402077e-20 1.668203e-20
        Herring 6.487722e-08 6.327309e-08 6.135714e-08 5.728371e-08 5.397185e-08
        Dab     1.022813e-20 1.334754e-20 1.542758e-20 1.889304e-20 2.421592e-20
        Whiting 1.460370e-20 1.837869e-20 1.858699e-20 2.298331e-20 2.734573e-20
        Sole    1.675095e-21 2.090649e-21 3.099898e-21 3.988014e-21 5.470873e-21
        Gurnard 2.366688e-21 3.194609e-21 4.060835e-21 5.200879e-21 6.823124e-21
        Plaice  4.524429e-21 6.123944e-21 6.780442e-21 8.730727e-21 1.000326e-20
        Haddock 3.601206e-21 5.756962e-21 5.747204e-21 8.955620e-21 1.033734e-20
        Cod     3.764177e-20 4.476284e-20 4.925740e-20 5.334935e-20 7.118884e-20
        Saithe  5.862085e-21 7.919353e-21 7.177304e-21 9.109944e-21 9.110774e-21
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 2.735466e-21 5.514258e-21 1.814833e-21 0.000000e+00 0.000000e+00
        N.pout  2.218866e-20 2.274895e-20 3.118636e-20 3.952470e-20 8.921143e-20
        Herring 4.566192e-08 3.251320e-08 2.028553e-22 0.000000e+00 1.345835e-21
        Dab     3.113859e-20 3.833354e-20 4.563421e-20 5.011106e-20 7.040124e-20
        Whiting 3.637238e-20 3.729084e-20 5.112172e-20 6.479020e-20 1.462383e-19
        Sole    6.694362e-21 8.999572e-21 1.017667e-20 1.171886e-20 1.426352e-20
        Gurnard 7.879032e-21 1.045774e-20 1.259841e-20 1.448465e-20 1.826198e-20
        Plaice  1.359632e-20 1.463805e-20 1.885354e-20 1.835069e-20 2.709527e-20
        Haddock 1.497289e-20 1.838174e-20 2.472009e-20 2.591609e-20 3.645877e-20
        Cod     7.894562e-20 8.942881e-20 9.431702e-20 1.032255e-19 1.222896e-19
        Saithe  1.128636e-20 1.055783e-20 1.444945e-20 1.137232e-20 1.760839e-20
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   2.539920e-22 2.153827e-22 0.000000e+00 0.000000e+00 6.736451e-23
        Sandeel 8.321683e-21 0.000000e+00 0.000000e+00 8.479554e-21 1.953533e-20
        N.pout  1.861850e-19 2.718236e-19 4.832982e-19 8.003303e-19 1.272624e-18
        Herring 0.000000e+00 1.785777e-21 0.000000e+00 9.478129e-22 0.000000e+00
        Dab     9.937864e-20 1.256487e-19 1.934942e-19 2.799796e-19 4.216476e-19
        Whiting 3.052007e-19 4.455823e-19 7.922384e-19 1.311928e-18 2.086127e-18
        Sole    1.941380e-20 2.538679e-20 3.825559e-20 5.127258e-20 7.746326e-20
        Gurnard 2.390446e-20 2.974303e-20 4.001194e-20 5.738895e-20 8.154017e-20
        Plaice  3.515131e-20 5.179223e-20 6.902635e-20 1.118751e-19 1.620525e-19
        Haddock 5.224867e-20 7.169508e-20 9.548751e-20 1.483004e-19 2.224081e-19
        Cod     1.910399e-19 2.334090e-19 3.805001e-19 5.235905e-19 8.638272e-19
        Saithe  2.330158e-20 3.469995e-20 5.071227e-20 8.410997e-20 1.281010e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   7.382445e-22 7.154727e-22 1.318087e-21 2.913439e-21 4.915545e-21
        Sandeel 9.001159e-20 3.888190e-20 0.000000e+00 1.375788e-19 7.923906e-20
        N.pout  2.248451e-18 3.439573e-18 5.628704e-18 1.110587e-17 1.561963e-17
        Herring 3.772935e-21 5.794764e-21 6.675034e-21 5.766768e-21 1.771409e-20
        Dab     6.817294e-19 1.034701e-18 1.662087e-18 3.171380e-18 4.533069e-18
        Whiting 3.685736e-18 5.638263e-18 9.226759e-18 1.820511e-17 2.560422e-17
        Sole    1.201032e-19 1.804912e-19 2.821748e-19 5.377409e-19 7.873483e-19
        Gurnard 1.253553e-19 1.919271e-19 2.977726e-19 5.563380e-19 8.095616e-19
        Plaice  2.773161e-19 4.183934e-19 6.886882e-19 1.273213e-18 1.910571e-18
        Haddock 3.546399e-19 5.169504e-19 8.337635e-19 1.549972e-18 2.231848e-18
        Cod     1.379372e-18 2.222056e-18 3.641451e-18 6.617637e-18 1.035982e-17
        Saithe  2.305980e-19 3.706549e-19 6.382083e-19 1.139205e-18 1.861635e-18
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   9.340363e-21 1.251004e-20 1.028164e-20 1.042728e-20 6.570486e-21
        Sandeel 0.000000e+00 1.577125e-19 1.211135e-19 2.790231e-19 0.000000e+00
        N.pout  3.443199e-17 5.736873e-17 1.087607e-16 2.156173e-16 3.555683e-16
        Herring 2.805688e-20 4.113319e-20 7.784127e-20 1.403467e-19 2.290275e-19
        Dab     9.596970e-18 1.598055e-17 2.991510e-17 5.839016e-17 9.718022e-17
        Whiting 5.644206e-17 9.404073e-17 1.782842e-16 3.534470e-16 5.828593e-16
        Sole    1.595103e-18 2.659320e-18 4.930780e-18 9.454540e-18 1.589785e-17
        Gurnard 1.625339e-18 2.711554e-18 5.015659e-18 9.609402e-18 1.619707e-17
        Plaice  3.822109e-18 6.473032e-18 1.191233e-17 2.289897e-17 3.868227e-17
        Haddock 4.612018e-18 7.711578e-18 1.434793e-17 2.788581e-17 4.637499e-17
        Cod     1.978377e-17 3.350078e-17 6.066335e-17 1.131353e-16 1.946552e-16
        Saithe  3.406624e-18 5.851862e-18 1.041283e-17 1.912354e-17 3.318389e-17
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   5.503430e-21 1.085084e-20 1.952734e-20 2.503193e-20 2.758080e-20
        Sandeel 9.255836e-20 2.132374e-19 0.000000e+00 5.658858e-19 1.140734e-18
        N.pout  5.075984e-16 8.627138e-16 1.238224e-15 2.164799e-15 2.981868e-15
        Herring 3.258936e-19 5.720371e-19 8.236674e-19 1.407370e-18 1.985467e-18
        Dab     1.424870e-16 2.427337e-16 3.579767e-16 6.220832e-16 8.865957e-16
        Whiting 8.320723e-16 1.414189e-15 2.029739e-15 3.548610e-15 4.887977e-15
        Sole    2.386963e-17 4.072501e-17 6.136645e-17 1.059182e-16 1.550181e-16
        Gurnard 2.455457e-17 4.187709e-17 6.360489e-17 1.094925e-16 1.616572e-16
        Plaice  5.897105e-17 1.004973e-16 1.530955e-16 2.628654e-16 3.888291e-16
        Haddock 6.814744e-17 1.161014e-16 1.717859e-16 2.984182e-16 4.272591e-16
        Cod     3.116847e-16 5.338525e-16 8.490633e-16 1.446443e-15 2.244636e-15
        Saithe  5.479959e-17 9.427419e-17 1.540758e-16 2.621466e-16 4.186614e-16
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   4.428621e-20 6.875750e-20 6.131791e-20 3.531629e-20 1.084830e-19
        Sandeel 3.754345e-19 0.000000e+00 2.490805e-19 3.443013e-18 1.322011e-18
        N.pout  4.817625e-15 6.856995e-15 9.856889e-15 1.514481e-14 2.263346e-14
        Herring 3.294226e-18 4.664755e-18 7.238733e-18 1.077572e-17 1.643935e-17
        Dab     1.437091e-15 2.101770e-15 3.095723e-15 4.789414e-15 7.241923e-15
        Whiting 7.897211e-15 1.124021e-14 1.615774e-14 2.482587e-14 3.710152e-14
        Sole    2.516037e-16 3.752854e-16 5.620606e-16 8.730178e-16 1.330574e-15
        Gurnard 2.622776e-16 3.934239e-16 5.915946e-16 9.191802e-16 1.402737e-15
        Plaice  6.292434e-16 9.432261e-16 1.415380e-15 2.191196e-15 3.332599e-15
        Haddock 6.936084e-16 1.018986e-15 1.507727e-15 2.339128e-15 3.549003e-15
        Cod     3.650160e-15 5.655276e-15 8.714034e-15 1.358228e-14 2.087793e-14
        Saithe  6.846465e-16 1.081063e-15 1.690549e-15 2.646628e-15 4.087406e-15
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   1.171522e-19 0.000000e+00 2.279908e-19 2.387494e-19 1.650104e-19
        Sandeel 1.903544e-18 8.770827e-19 5.051592e-19 2.909484e-18 2.010874e-18
        N.pout  4.383498e-14 7.735523e-14 1.124446e-13 1.715767e-13 3.395722e-13
        Herring 3.072413e-17 5.274392e-17 7.758264e-17 1.193200e-16 2.270906e-16
        Dab     1.335229e-14 2.303294e-14 3.405209e-14 5.231135e-14 9.915446e-14
        Whiting 7.185575e-14 1.268033e-13 1.843229e-13 2.812542e-13 5.566381e-13
        Sole    2.369382e-15 4.024016e-15 6.038903e-15 9.334887e-15 1.711429e-14
        Gurnard 2.471090e-15 4.175699e-15 6.293169e-15 9.742435e-15 1.768508e-14
        Plaice  5.841780e-15 9.852635e-15 1.485291e-14 2.298400e-14 4.166465e-14
        Haddock 6.510444e-15 1.119932e-14 1.659995e-14 2.553455e-14 4.809689e-14
        Cod     3.464696e-14 5.665106e-14 8.697870e-14 1.353275e-13 2.316617e-13
        Saithe  6.594840e-15 1.056571e-14 1.628455e-14 2.529767e-14 4.190690e-14
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   6.335893e-19 2.189509e-19 8.407042e-20 2.905241e-19 0.000000e+00
        Sandeel 0.000000e+00 2.668212e-18 6.147069e-18 8.260999e-18 6.797078e-18
        N.pout  4.761031e-13 6.740497e-13 9.248833e-13 1.438878e-12 3.494796e-12
        Herring 3.242442e-16 4.690365e-16 6.639069e-16 1.040455e-15 2.334414e-15
        Dab     1.424916e-13 2.065837e-13 2.925165e-13 4.555779e-13 1.012922e-12
        Whiting 7.804440e-13 1.104925e-12 1.516099e-12 2.358656e-12 5.728785e-12
        Sole    2.512331e-14 3.710179e-14 5.372358e-14 8.362703e-14 1.736579e-13
        Gurnard 2.612936e-14 3.879270e-14 5.651366e-14 8.792322e-14 1.789941e-13
        Plaice  6.168409e-14 9.166875e-14 1.335685e-13 2.074852e-13 4.212281e-13
        Haddock 6.933460e-14 1.008658e-13 1.435253e-13 2.237722e-13 4.911574e-13
        Cod     3.537944e-13 5.403856e-13 8.140837e-13 1.266788e-12 2.313533e-12
        Saithe  6.481216e-14 1.002759e-13 1.537121e-13 2.401367e-13 4.167128e-13
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   5.139920e-19 1.480179e-19 1.023018e-18 1.964036e-19 3.393583e-19
        Sandeel 1.096145e-17 1.172468e-17 2.805041e-17 3.949181e-17 6.479011e-17
        N.pout  5.143065e-12 7.810028e-12 1.195704e-11 1.890371e-11 3.671485e-11
        Herring 3.464688e-15 5.295392e-15 8.161135e-15 1.292799e-14 2.432987e-14
        Dab     1.514125e-12 2.322821e-12 3.586939e-12 5.682367e-12 1.065284e-11
        Whiting 8.430683e-12 1.280246e-11 1.960038e-11 3.098758e-11 6.018420e-11
        Sole    2.633500e-13 4.075379e-13 6.335771e-13 1.004902e-12 1.830451e-12
        Gurnard 2.727199e-13 4.232293e-13 6.593722e-13 1.046259e-12 1.889739e-12
        Plaice  6.433863e-13 1.000010e-12 1.559491e-12 2.475363e-12 4.466530e-12
        Haddock 7.352470e-13 1.129028e-12 1.745147e-12 2.765170e-12 5.156182e-12
        Cod     3.612648e-12 5.693083e-12 8.979871e-12 1.429819e-11 2.462864e-11
        Saithe  6.578272e-13 1.044230e-12 1.657751e-12 2.646039e-12 4.449655e-12
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   9.121222e-19 1.651070e-18 1.037389e-18 1.792465e-18 2.294171e-18
        Sandeel 8.892351e-17 1.573058e-16 2.423047e-16 4.016795e-16 6.479167e-16
        N.pout  6.361803e-11 1.048657e-10 1.930863e-10 3.759319e-10 6.521824e-10
        Herring 4.161525e-14 6.827071e-14 1.235601e-13 2.356018e-13 4.058512e-13
        Dab     1.826792e-11 3.009052e-11 5.449188e-11 1.039651e-10 1.800708e-10
        Whiting 1.042848e-10 1.718993e-10 3.165134e-10 6.162401e-10 1.069079e-09
        Sole    3.113709e-12 5.128851e-12 9.157580e-12 1.716504e-11 2.971024e-11
        Gurnard 3.207796e-12 5.285990e-12 9.399990e-12 1.752747e-11 3.034849e-11
        Plaice  7.590085e-12 1.252870e-11 2.229258e-11 4.159102e-11 7.218472e-11
        Haddock 8.821653e-12 1.451707e-11 2.620716e-11 4.980958e-11 8.615103e-11
        Cod     4.123286e-11 6.801937e-11 1.179735e-10 2.126891e-10 3.684001e-10
        Saithe  7.379485e-12 1.215322e-11 2.075701e-11 3.661994e-11 6.324503e-11
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   3.501543e-18 5.174998e-18 8.021214e-18 1.287499e-17 2.311860e-17
        Sandeel 1.046648e-15 1.693463e-15 2.736981e-15 4.405481e-15 7.126563e-15
        N.pout  9.016299e-10 1.636695e-09 2.760638e-09 3.930105e-09 7.665776e-09
        Herring 5.711527e-13 1.029729e-12 1.737123e-12 2.521972e-12 4.846865e-12
        Dab     2.566043e-10 4.609557e-10 7.784761e-10 1.138892e-09 2.168458e-09
        Whiting 1.477982e-09 2.682925e-09 4.525329e-09 6.442359e-09 1.256599e-08
        Sole    4.352166e-11 7.736701e-11 1.307297e-10 1.956717e-10 3.645067e-10
        Gurnard 4.488199e-11 7.952815e-11 1.344325e-10 2.027333e-10 3.749637e-10
        Plaice  1.072763e-10 1.899592e-10 3.213273e-10 4.859716e-10 8.960218e-10
        Haddock 1.231233e-10 2.208638e-10 3.729557e-10 5.473414e-10 1.039544e-09
        Cod     5.768904e-10 1.005762e-09 1.706866e-09 2.695146e-09 4.794208e-09
        Saithe  1.020820e-10 1.768440e-10 3.012572e-10 4.883569e-10 8.541239e-10
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   4.049846e-17 7.387292e-17 1.311535e-16 2.318311e-16 4.051060e-16
        Sandeel 1.147525e-14 1.855874e-14 2.987433e-14 4.826507e-14 7.779945e-14
        N.pout  1.118091e-08 1.570899e-08 2.444975e-08 4.450094e-08 7.748979e-08
        Herring 7.185333e-12 1.035382e-11 1.632927e-11 2.935694e-11 5.070896e-11
        Dab     3.235688e-09 4.683800e-09 7.358886e-09 1.310480e-08 2.255559e-08
        Whiting 1.832812e-08 2.575070e-08 4.007885e-08 7.294742e-08 1.270238e-07
        Sole    5.545321e-10 8.216201e-10 1.298522e-09 2.271288e-09 3.873968e-09
        Gurnard 5.740584e-10 8.566515e-10 1.355781e-09 2.357321e-09 4.008341e-09
        Plaice  1.374751e-09 2.054353e-09 3.246466e-09 5.624211e-09 9.545784e-09
        Haddock 1.555356e-09 2.260643e-09 3.559654e-09 6.328338e-09 1.088053e-08
        Cod     7.623497e-09 1.187235e-08 1.899693e-08 3.200356e-08 5.341686e-08
        Saithe  1.387264e-09 2.213028e-09 3.573467e-09 5.943399e-09 9.825548e-09
               w
      predator          97.8          117          139          166          198
        Sprat   7.030454e-16 1.211982e-15 2.089715e-15 3.601348e-15 6.215709e-15
        Sandeel 1.256154e-13 2.028557e-13 3.278816e-13 5.307609e-13 8.607227e-13
        N.pout  1.128137e-07 1.865512e-07 2.752898e-07 5.110571e-07 9.675945e-07
        Herring 7.506564e-11 1.240041e-10 1.859438e-10 3.383593e-10 6.265119e-10
        Dab     3.352200e-08 5.520969e-08 8.290455e-08 1.497833e-07 2.764630e-07
        Whiting 1.849280e-07 3.058009e-07 4.512643e-07 8.377418e-07 1.586113e-06
        Sole    5.857520e-09 9.616997e-09 1.464312e-08 2.589320e-08 4.683316e-08
        Gurnard 6.092168e-09 9.989782e-09 1.527101e-08 2.681990e-08 4.820281e-08
        Plaice  1.451933e-08 2.377465e-08 3.634358e-08 6.366216e-08 1.142731e-07
        Haddock 1.621776e-08 2.671105e-08 4.022100e-08 7.244405e-08 1.332281e-07
        Cod     8.349289e-08 1.358673e-07 2.121383e-07 3.583253e-07 6.189300e-07
        Saithe  1.555544e-08 2.520254e-08 3.972287e-08 6.577131e-08 1.109711e-07
               w
      predator           237          282          337          402          480
        Sprat   1.073430e-14 1.849026e-14 3.166733e-14 5.371287e-14 8.997110e-14
        Sandeel 1.396975e-12 2.271370e-12 3.700699e-12 6.040485e-12 9.875613e-12
        N.pout  1.425193e-06 2.119575e-06 3.696436e-06 6.295082e-06 1.045714e-05
        Herring 9.333133e-10 1.406526e-09 2.431040e-09 4.114459e-09 6.815418e-09
        Dab     4.146123e-07 6.269241e-07 1.079426e-06 1.825086e-06 3.025181e-06
        Whiting 2.336224e-06 3.474477e-06 6.059320e-06 1.031911e-05 1.714170e-05
        Sole    7.139559e-08 1.094419e-07 1.864114e-07 3.133315e-07 5.185284e-07
        Gurnard 7.387320e-08 1.137170e-07 1.930383e-07 3.238908e-07 5.357859e-07
        Plaice  1.755060e-07 2.704835e-07 4.586816e-07 7.694678e-07 1.273351e-06
        Haddock 2.001980e-07 3.033723e-07 5.215432e-07 8.808712e-07 1.459326e-06
        Cod     9.754830e-07 1.536979e-06 2.561126e-06 4.252609e-06 7.016084e-06
        Saithe  1.768898e-07 2.817276e-07 4.653117e-07 7.684507e-07 1.265839e-06
               w
      predator           573          683          816          973         1160
        Sprat   1.484178e-13 2.408476e-13 3.844038e-13 6.041370e-13 9.371391e-13
        Sandeel 1.618067e-11 2.653062e-11 4.354705e-11 7.158314e-11 1.177609e-10
        N.pout  1.993731e-05 2.980704e-05 4.259493e-05 7.292326e-05 1.216873e-04
        Herring 1.273960e-08 1.923480e-08 2.802554e-08 4.779905e-08 7.964709e-08
        Dab     5.637397e-06 8.571833e-06 1.256014e-05 2.132992e-05 3.548286e-05
        Whiting 3.268189e-05 4.886068e-05 6.982301e-05 1.195382e-04 1.994737e-04
        Sole    9.477711e-07 1.463312e-06 2.188530e-06 3.688396e-06 6.117400e-06
        Gurnard 9.734898e-07 1.510782e-06 2.274212e-06 3.823440e-06 6.335254e-06
        Plaice  2.311660e-06 3.596866e-06 5.425952e-06 9.111684e-06 1.509022e-05
        Haddock 2.710084e-06 4.127444e-06 6.066680e-06 1.029529e-05 1.712190e-05
        Cod     1.229915e-05 1.965491e-05 3.073169e-05 5.108028e-05 8.427636e-05
        Saithe  2.175942e-06 3.527280e-06 5.627340e-06 9.322331e-06 1.537002e-05
               w
      predator          1390         1650         1970         2360         2810
        Sprat   1.440041e-12 2.202164e-12 3.368983e-12 5.182168e-12 8.046508e-12
        Sandeel 1.940352e-10 3.200572e-10 5.279587e-10 8.717007e-10 1.438482e-09
        N.pout  2.615062e-04 5.569479e-04 9.987998e-04 1.883706e-03 2.976948e-03
        Herring 1.655825e-07 3.432801e-07 6.101565e-07 1.139687e-06 1.809228e-06
        Dab     7.317624e-05 1.514680e-04 2.708996e-04 5.075412e-04 8.134947e-04
        Whiting 4.286693e-04 9.129662e-04 1.637263e-03 3.087824e-03 4.879888e-03
        Sole    1.218005e-05 2.459348e-05 4.394529e-05 8.188088e-05 1.331148e-04
        Gurnard 1.247389e-05 2.498902e-05 4.466348e-05 8.310201e-05 1.358329e-04
        Plaice  2.962783e-05 5.931389e-05 1.062725e-04 1.980286e-04 3.249804e-04
        Haddock 3.511261e-05 7.233398e-05 1.291584e-04 2.415333e-04 3.873944e-04
        Cod     1.552299e-04 2.947604e-04 5.254647e-04 9.663844e-04 1.633002e-03
        Saithe  2.731398e-05 5.006553e-05 8.860930e-05 1.611354e-04 2.769603e-04
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.263714e-11 2.006649e-11 3.214095e-11 5.175296e-11 8.349751e-11
        Sandeel 2.375976e-09 3.923769e-09 6.477372e-09 1.069401e-08 1.767097e-08
        N.pout  5.202894e-03 8.250113e-03 1.166250e-02 1.604507e-02 2.524158e-02
        Herring 3.162917e-06 5.057303e-06 7.302501e-06 1.035875e-05 1.657429e-05
        Dab     1.424469e-03 2.290194e-03 3.336417e-03 4.759374e-03 7.564457e-03
        Whiting 8.528690e-03 1.352372e-02 1.911720e-02 2.630089e-02 4.137518e-02
        Sole    2.333724e-04 3.798070e-04 5.675842e-04 8.323935e-04 1.330120e-03
        Gurnard 2.382992e-04 3.895292e-04 5.871270e-04 8.685673e-04 1.389489e-03
        Plaice  5.707866e-04 9.352819e-04 1.414593e-03 2.097037e-03 3.347359e-03
        Haddock 6.782371e-04 1.091820e-03 1.595981e-03 2.287527e-03 3.645689e-03
        Cod     2.881172e-03 4.848079e-03 7.714707e-03 1.205147e-02 1.952385e-02
        Saithe  4.905135e-04 8.403796e-04 1.381690e-03 2.231697e-03 3.665339e-03
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.346786e-10 2.170249e-10 3.497112e-10 5.647619e-10 9.166875e-10
        Sandeel 2.923381e-08 4.839973e-08 8.018417e-08 1.329680e-07 2.207259e-07
        N.pout  4.587797e-02 8.128363e-02 1.349507e-01 2.203254e-01 3.525764e-01
        Herring 2.993594e-05 5.269756e-05 8.750704e-05 1.431341e-04 2.300750e-04
        Dab     1.349128e-02 2.359728e-02 3.913364e-02 6.398850e-02 1.028785e-01
        Whiting 7.520028e-02 1.332322e-01 2.211919e-01 3.611127e-01 5.778248e-01
        Sole    2.333396e-03 4.038476e-03 6.694948e-03 1.096739e-02 1.770865e-02
        Gurnard 2.423429e-03 4.178459e-03 6.924188e-03 1.134678e-02 1.834169e-02
        Plaice  5.810840e-03 9.988847e-03 1.653187e-02 2.706936e-02 4.373615e-02
        Haddock 6.497784e-03 1.135717e-02 1.884076e-02 3.082410e-02 4.960396e-02
        Cod     3.310261e-02 5.587701e-02 9.224417e-02 1.511608e-01 2.454417e-01
        Saithe  6.166152e-03 1.032125e-02 1.700005e-02 2.781324e-02 4.516673e-02
               w
      predator         19600        23400        28000        33400        39900
        Sprat   1.499671e-09 2.477718e-09 4.137314e-09 6.978020e-09 1.186594e-08
        Sandeel 3.667624e-07 6.103761e-07 1.016634e-06 1.695839e-06 2.832119e-06
        N.pout  5.402334e-01 8.992361e-01 1.343398e+00 2.196131e+00 3.608998e+00
        Herring 3.563734e-04 5.929757e-04 8.993701e-04 1.473612e-03 2.423833e-03
        Dab     1.595363e-01 2.646068e-01 4.018632e-01 6.560833e-01 1.076016e+00
        Whiting 8.853009e-01 1.473556e+00 2.201418e+00 3.598494e+00 5.911189e+00
        Sole    2.773261e-02 4.584796e-02 7.051460e-02 1.148792e-01 1.878934e-01
        Gurnard 2.880484e-02 4.755795e-02 7.340829e-02 1.194726e-01 1.951768e-01
        Plaice  6.868121e-02 1.132410e-01 1.748076e-01 2.840963e-01 4.635539e-01
        Haddock 7.706989e-02 1.278318e-01 1.946250e-01 3.178648e-01 5.213744e-01
        Cod     3.910969e-01 6.403402e-01 1.007677e+00 1.630657e+00 2.645402e+00
        Saithe  7.235814e-02 1.178263e-01 1.869965e-01 3.018001e-01 4.880227e-01
      
      , , prey = N.pout
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   7.309215e-22 1.095024e-21 1.018507e-21 1.416235e-21 1.079058e-21
        Sandeel 6.357157e-22 6.172123e-22 7.631900e-22 1.027188e-21 1.193885e-21
        N.pout  6.100209e-20 7.838248e-20 8.715900e-20 1.265263e-19 1.984679e-19
        Herring 1.953780e-07 1.909963e-07 1.780574e-07 1.499200e-07 1.219560e-07
        Dab     2.850429e-21 4.732117e-21 5.027964e-21 6.730668e-21 9.739953e-21
        Whiting 2.452459e-20 3.151201e-20 3.504043e-20 5.086721e-20 7.978980e-20
        Sole    0.000000e+00 4.984161e-25 0.000000e+00 6.565132e-23 8.345561e-23
        Gurnard 3.380726e-21 5.215239e-21 6.057063e-21 9.540716e-21 1.148295e-20
        Plaice  1.030106e-21 1.231347e-21 1.670816e-21 1.901057e-21 3.028065e-21
        Haddock 3.608053e-21 5.415990e-21 4.341035e-21 8.700260e-21 1.460031e-20
        Cod     3.688524e-20 4.980585e-20 4.583786e-20 6.099562e-20 7.077283e-20
        Saithe  3.587780e-20 4.687406e-20 4.272575e-20 4.755450e-20 4.267985e-20
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   1.508062e-21 8.050674e-22 1.314654e-21 1.163618e-21 1.593126e-21
        Sandeel 1.215619e-21 1.414425e-21 1.629287e-21 2.102003e-21 2.767216e-21
        N.pout  2.632982e-19 4.203093e-19 6.568172e-19 1.152996e-18 1.667950e-18
        Herring 7.631581e-08 2.458529e-08 5.638017e-21 8.265697e-21 2.720377e-21
        Dab     1.252135e-20 1.642485e-20 2.322219e-20 2.973318e-20 3.974454e-20
        Whiting 1.058534e-19 1.689764e-19 2.640594e-19 4.635376e-19 6.705638e-19
        Sole    2.373130e-22 2.915103e-22 6.455207e-22 5.983407e-22 1.337942e-21
        Gurnard 1.434711e-20 2.127951e-20 2.786182e-20 3.313102e-20 3.935112e-20
        Plaice  3.576652e-21 5.354543e-21 7.645901e-21 9.489317e-21 1.334407e-20
        Haddock 1.558795e-20 3.302638e-20 4.824324e-20 5.860298e-20 9.860351e-20
        Cod     8.226236e-20 9.540579e-20 1.181064e-19 1.629226e-19 2.206738e-19
        Saithe  5.480651e-20 4.741659e-20 9.149344e-20 1.174728e-19 2.005792e-19
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   1.311012e-21 1.030589e-21 0.000000e+00 0.000000e+00 1.168123e-22
        Sandeel 3.386801e-21 3.557052e-21 5.022614e-21 5.176579e-21 5.612180e-21
        N.pout  2.527143e-18 4.599279e-18 7.601792e-18 1.366848e-17 1.877102e-17
        Herring 9.400871e-21 0.000000e+00 1.871091e-20 1.436883e-20 2.206875e-20
        Dab     5.590420e-20 8.954380e-20 1.374259e-19 2.338695e-19 3.252974e-19
        Whiting 1.015984e-18 1.849043e-18 3.056139e-18 5.495124e-18 7.546489e-18
        Sole    1.564535e-21 3.187441e-21 5.217230e-21 9.657475e-21 1.442439e-20
        Gurnard 5.697097e-20 9.067586e-20 1.331377e-19 2.166885e-19 3.122405e-19
        Plaice  2.057527e-20 3.495583e-20 5.499075e-20 9.846202e-20 1.428872e-19
        Haddock 1.364040e-19 2.293730e-19 3.637629e-19 6.699439e-19 9.428954e-19
        Cod     3.690536e-19 5.913389e-19 1.000008e-18 1.661128e-18 2.598728e-18
        Saithe  3.277962e-19 5.850463e-19 9.709950e-19 1.643168e-18 2.695154e-18
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   8.245719e-22 1.173659e-21 2.833800e-21 5.121902e-21 7.239454e-21
        Sandeel 5.656625e-21 6.515910e-21 9.650222e-21 1.111617e-20 1.138204e-20
        N.pout  4.066771e-17 6.392903e-17 1.084972e-16 1.619749e-16 2.701771e-16
        Herring 1.588823e-20 4.392426e-20 2.529835e-20 3.885515e-20 7.273102e-20
        Dab     6.562511e-19 1.035028e-18 1.755591e-18 2.681377e-18 4.451867e-18
        Whiting 1.634959e-17 2.570131e-17 4.361900e-17 6.511859e-17 1.086190e-16
        Sole    2.999132e-20 4.923605e-20 8.426175e-20 1.345892e-19 2.233299e-19
        Gurnard 5.958921e-19 9.831969e-19 1.638391e-18 2.598461e-18 4.269464e-18
        Plaice  2.836353e-19 4.511554e-19 7.742865e-19 1.207745e-18 2.019392e-18
        Haddock 1.973293e-18 3.065869e-18 5.273141e-18 7.963593e-18 1.339171e-17
        Cod     4.853964e-18 7.978878e-18 1.342881e-17 2.181170e-17 3.635675e-17
        Saithe  4.802830e-18 7.889111e-18 1.338011e-17 2.197787e-17 3.674397e-17
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   1.049389e-20 1.174579e-20 9.454360e-21 1.016153e-20 0.000000e+00
        Sandeel 1.311106e-20 7.551368e-21 1.739696e-20 2.504962e-21 4.616776e-20
        N.pout  5.139161e-16 9.599016e-16 1.590852e-15 2.989380e-15 4.334969e-15
        Herring 2.320046e-19 1.930123e-19 4.617674e-19 6.304159e-19 9.077262e-19
        Dab     8.315889e-18 1.530939e-17 2.550753e-17 4.732011e-17 7.029775e-17
        Whiting 2.066091e-16 3.859081e-16 6.395682e-16 1.201817e-15 1.742782e-15
        Sole    4.133401e-19 7.536865e-19 1.263770e-18 2.323323e-18 3.532596e-18
        Gurnard 7.852130e-18 1.414334e-17 2.383670e-17 4.355719e-17 6.672235e-17
        Plaice  3.680472e-18 6.683428e-18 1.119797e-17 2.050025e-17 3.146713e-17
        Haddock 2.487384e-17 4.585351e-17 7.632865e-17 1.415549e-16 2.106721e-16
        Cod     6.409376e-17 1.132838e-16 1.911947e-16 3.417612e-16 5.465176e-16
        Saithe  6.375070e-17 1.110209e-16 1.878497e-16 3.314733e-16 5.428538e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 3.212667e-21 0.000000e+00
        Sandeel 0.000000e+00 3.062980e-20 1.764136e-20 5.080304e-20 7.022450e-20
        N.pout  6.654022e-15 1.031763e-14 1.505240e-14 2.535332e-14 3.597005e-14
        Herring 1.568425e-18 2.318574e-18 3.260438e-18 5.433813e-18 7.455873e-18
        Dab     1.095502e-16 1.721279e-16 2.570142e-16 4.306157e-16 6.278067e-16
        Whiting 2.675108e-15 4.147983e-15 6.051500e-15 1.019277e-14 1.446099e-14
        Sole    5.575499e-18 8.850718e-18 1.344632e-17 2.241046e-17 3.334551e-17
        Gurnard 1.056651e-16 1.683073e-16 2.568884e-16 4.274462e-16 6.395778e-16
        Plaice  4.995813e-17 7.952255e-17 1.215311e-16 2.015424e-16 3.016507e-16
        Haddock 3.292029e-16 5.182808e-16 7.764099e-16 1.301367e-15 1.905527e-15
        Cod     8.889470e-16 1.443083e-15 2.276926e-15 3.752304e-15 5.811056e-15
        Saithe  8.965207e-16 1.474740e-15 2.373326e-15 3.911348e-15 6.176457e-15
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   5.384667e-21 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 2.696405e-20 0.000000e+00 3.577837e-20 0.000000e+00 0.000000e+00
        N.pout  4.918716e-14 7.747424e-14 1.389308e-13 2.423718e-13 3.607752e-13
        Herring 1.076211e-17 1.703818e-17 2.996720e-17 5.194125e-17 7.784633e-17
        Dab     8.895033e-16 1.402324e-15 2.441544e-15 4.173138e-15 6.290742e-15
        Whiting 1.977465e-14 3.114687e-14 5.585416e-14 9.744044e-14 1.450420e-13
        Sole    4.844585e-17 7.632498e-17 1.300929e-16 2.191546e-16 3.340449e-16
        Gurnard 9.354280e-16 1.472125e-15 2.491673e-15 4.177499e-15 6.386525e-15
        Plaice  4.406469e-16 6.910211e-16 1.164301e-15 1.947321e-15 2.975663e-15
        Haddock 2.715483e-15 4.289330e-15 7.450863e-15 1.270864e-14 1.919937e-14
        Cod     8.826443e-15 1.385500e-14 2.259217e-14 3.680499e-14 5.698884e-14
        Saithe  9.581884e-15 1.507975e-14 2.421123e-14 3.883531e-14 6.031303e-14
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   0.000000e+00 1.006364e-19 7.728257e-20 0.000000e+00 5.127280e-20
        Sandeel 5.468569e-20 9.448931e-20 0.000000e+00 1.671694e-19 0.000000e+00
        N.pout  5.807065e-13 7.934845e-13 1.209461e-12 2.692872e-12 3.860898e-12
        Herring 1.240782e-16 1.751285e-16 2.693563e-16 5.613850e-16 8.179842e-16
        Dab     1.008476e-14 1.421242e-14 2.178582e-14 4.515049e-14 6.603331e-14
        Whiting 2.334607e-13 3.190036e-13 4.862382e-13 1.082612e-12 1.552192e-12
        Sole    5.343681e-16 7.712350e-16 1.186972e-15 2.329337e-15 3.467342e-15
        Gurnard 1.020622e-14 1.482659e-14 2.283389e-14 4.409743e-14 6.599824e-14
        Plaice  4.750176e-15 6.900706e-15 1.061149e-14 2.044172e-14 3.065432e-14
        Haddock 3.077560e-14 4.358295e-14 6.692092e-14 1.372790e-13 2.012500e-13
        Cod     9.034137e-14 1.356077e-13 2.094195e-13 3.696144e-13 5.684046e-13
        Saithe  9.494377e-14 1.443352e-13 2.229507e-13 3.759684e-13 5.839582e-13
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   2.362461e-19 4.082006e-19 0.000000e+00 1.805460e-19 0.000000e+00
        Sandeel 1.663618e-19 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  6.187697e-12 9.405181e-12 1.502818e-11 2.060181e-11 3.946368e-11
        Herring 1.306186e-15 1.999444e-15 3.194063e-15 4.504510e-15 8.348120e-15
        Dab     1.056886e-13 1.621477e-13 2.589002e-13 3.661472e-13 6.740295e-13
        Whiting 2.487632e-12 3.781153e-12 6.041760e-12 8.282519e-12 1.586553e-11
        Sole    5.546714e-15 8.574423e-15 1.367974e-14 1.980361e-14 3.533068e-14
        Gurnard 1.055712e-13 1.635756e-13 2.609243e-13 3.802714e-13 6.722585e-13
        Plaice  4.906896e-14 7.610621e-14 1.214434e-13 1.771950e-13 3.127022e-13
        Haddock 3.219521e-13 4.944807e-13 7.893585e-13 1.121323e-12 2.052989e-12
        Cod     9.077076e-13 1.424051e-12 2.270988e-12 3.436392e-12 5.792735e-12
        Saithe  9.303768e-13 1.468017e-12 2.342884e-12 3.615472e-12 5.972151e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   2.395650e-19 0.000000e+00 6.357535e-19 0.000000e+00 1.265364e-18
        Sandeel 3.373977e-19 4.534262e-19 8.953803e-19 1.847917e-18 3.069188e-18
        N.pout  8.555341e-11 1.866120e-10 2.716037e-10 4.974342e-10 7.983018e-10
        Herring 1.724727e-14 3.621233e-14 5.306641e-14 9.608076e-14 1.545924e-13
        Dab     1.388903e-12 2.921799e-12 4.341059e-12 7.876182e-12 1.275901e-11
        Whiting 3.439493e-11 7.502339e-11 1.091925e-10 1.999829e-10 3.209403e-10
        Sole    6.982919e-14 1.423843e-13 2.160545e-13 3.886389e-13 6.350610e-13
        Gurnard 1.312378e-12 2.651185e-12 4.054168e-12 7.276296e-12 1.193064e-11
        Plaice  6.099949e-13 1.233582e-12 1.896655e-12 3.409218e-12 5.607370e-12
        Haddock 4.195580e-12 8.764746e-12 1.303727e-11 2.359919e-11 3.823708e-11
        Cod     1.051074e-11 1.994801e-11 3.189093e-11 5.643862e-11 9.451582e-11
        Saithe  1.041785e-11 1.897331e-11 3.094751e-11 5.421792e-11 9.176558e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   0.000000e+00 2.798334e-19 8.058558e-19 1.299580e-18 4.116741e-18
        Sandeel 5.189086e-18 8.539069e-18 1.437601e-17 2.344525e-17 3.830142e-17
        N.pout  1.567051e-09 2.364671e-09 3.522702e-09 6.176090e-09 9.333852e-09
        Herring 2.993272e-13 4.559730e-13 6.893595e-13 1.207981e-12 1.852263e-12
        Dab     2.463453e-11 3.787977e-11 5.762831e-11 1.005368e-10 1.547021e-10
        Whiting 6.299996e-10 9.506656e-10 1.416228e-09 2.482966e-09 3.752477e-09
        Sole    1.206740e-12 1.888125e-12 2.923332e-12 5.070179e-12 7.915314e-12
        Gurnard 2.255871e-11 3.551915e-11 5.532296e-11 9.576398e-11 1.502014e-10
        Plaice  1.059808e-11 1.675080e-11 2.615974e-11 4.522696e-11 7.102586e-11
        Haddock 7.362910e-11 1.133837e-10 1.728887e-10 3.015521e-10 4.651008e-10
        Cod     1.735975e-10 2.842871e-10 4.601084e-10 7.905076e-10 1.277552e-09
        Saithe  1.658647e-10 2.777191e-10 4.601146e-10 7.908625e-10 1.302617e-09
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   6.528093e-18 1.138605e-17 1.944880e-17 3.454615e-17 5.833560e-17
        Sandeel 6.273903e-17 1.018435e-16 1.652682e-16 2.678400e-16 4.352262e-16
        N.pout  1.920483e-08 2.866570e-08 4.528368e-08 7.827141e-08 1.204728e-07
        Herring 3.737374e-12 5.648197e-12 8.999474e-12 1.552338e-11 2.415506e-11
        Dab     3.086003e-10 4.695819e-10 7.490694e-10 1.287303e-09 2.007587e-09
        Whiting 7.720896e-09 1.152444e-08 1.820534e-08 3.146736e-08 4.843353e-08
        Sole    1.536088e-11 2.377886e-11 3.823232e-11 6.536045e-11 1.030541e-10
        Gurnard 2.888213e-10 4.496666e-10 7.247475e-10 1.236664e-09 1.956427e-09
        Plaice  1.360003e-10 2.121913e-10 3.420615e-10 5.827805e-10 9.223786e-10
        Haddock 9.248496e-10 1.410324e-09 2.253060e-09 3.871066e-09 6.048529e-09
        Cod     2.331222e-09 3.754299e-09 6.142892e-09 1.037447e-08 1.673614e-08
        Saithe  2.318878e-09 3.802858e-09 6.278221e-09 1.055588e-08 1.720124e-08
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   9.807922e-17 1.643058e-16 2.783146e-16 4.681521e-16 7.870831e-16
        Sandeel 7.054241e-16 1.146114e-15 1.864360e-15 3.036922e-15 4.949542e-15
        N.pout  1.750147e-07 2.666787e-07 4.608916e-07 7.897597e-07 1.153611e-06
        Herring 3.580648e-11 5.539554e-11 9.522390e-11 1.621525e-10 2.409082e-10
        Dab     2.984102e-09 4.606400e-09 7.858203e-09 1.332449e-08 1.984587e-08
        Whiting 7.036096e-08 1.072125e-07 1.852917e-07 3.175061e-07 4.637849e-07
        Sole    1.559761e-10 2.430113e-10 4.101366e-10 6.897932e-10 1.043836e-09
        Gurnard 2.977192e-09 4.649659e-09 7.817936e-09 1.311143e-08 1.993252e-08
        Plaice  1.404423e-09 2.190943e-09 3.673017e-09 6.147964e-09 9.348909e-09
        Haddock 9.020961e-09 1.396123e-08 2.380278e-08 4.032964e-08 6.024579e-08
        Cod     2.627968e-08 4.165962e-08 6.867692e-08 1.132633e-07 1.764740e-07
        Saithe  2.745647e-08 4.391954e-08 7.182787e-08 1.174711e-07 1.851152e-07
               w
      predator          97.8          117          139          166          198
        Sprat   1.325714e-15 2.239984e-15 3.793187e-15 6.426776e-15 1.087495e-14
        Sandeel 8.081423e-15 1.323614e-14 2.169660e-14 3.563771e-14 5.861847e-14
        N.pout  1.570619e-06 3.370051e-06 4.790161e-06 7.516488e-06 1.029894e-05
        Herring 3.386956e-10 6.941561e-10 1.005012e-09 1.584450e-09 2.236079e-09
        Dab     2.796076e-08 5.651608e-08 8.223704e-08 1.295360e-07 1.832162e-07
        Whiting 6.314341e-07 1.354857e-06 1.925782e-06 3.021844e-06 4.140470e-06
        Sole    1.508841e-09 2.911816e-09 4.321947e-09 6.829868e-09 9.895170e-09
        Gurnard 2.901970e-08 5.520871e-08 8.243336e-08 1.303651e-07 1.901526e-07
        Plaice  1.361224e-08 2.577446e-08 3.852995e-08 6.090182e-08 8.886504e-08
        Haddock 8.532833e-08 1.712519e-07 2.499914e-07 3.941270e-07 5.601529e-07
        Cod     2.671253e-07 4.695687e-07 7.231964e-07 1.147390e-06 1.735311e-06
        Saithe  2.855196e-07 4.832983e-07 7.542127e-07 1.197483e-06 1.842145e-06
               w
      predator           237          282          337          402          480
        Sprat   1.834576e-14 3.076508e-14 5.118442e-14 8.428331e-14 1.371151e-13
        Sandeel 9.660219e-14 1.594659e-13 2.634203e-13 4.358856e-13 7.218912e-13
        N.pout  1.711318e-05 3.144304e-05 4.773940e-05 1.019159e-04 2.100455e-04
        Herring 3.696332e-09 6.625443e-09 1.013341e-08 2.066503e-08 4.119447e-08
        Dab     3.010128e-07 5.365793e-07 8.224302e-07 1.668526e-06 3.330630e-06
        Whiting 6.879989e-06 1.264101e-05 1.919261e-05 4.097311e-05 8.444434e-05
        Sole    1.611222e-08 2.806470e-08 4.337145e-08 8.445477e-08 1.641474e-07
        Gurnard 3.086976e-07 5.339409e-07 8.271419e-07 1.590941e-06 3.067676e-06
        Plaice  1.439666e-07 2.485395e-07 3.852165e-07 7.398069e-07 1.427652e-06
        Haddock 9.196902e-07 1.633075e-06 2.506306e-06 5.045549e-06 1.001174e-05
        Cod     2.774864e-06 4.615165e-06 7.233676e-06 1.293723e-05 2.365304e-05
        Saithe  2.928443e-06 4.778695e-06 7.523135e-06 1.293597e-05 2.283471e-05
               w
      predator           573          683          816          973         1160
        Sprat   2.201224e-13 3.487250e-13 5.457757e-13 8.457815e-13 1.302429e-12
        Sandeel 1.195171e-12 1.977643e-12 3.271152e-12 5.411066e-12 8.940688e-12
        N.pout  3.415795e-04 4.809600e-04 6.856284e-04 1.265800e-03 2.030176e-03
        Herring 6.673066e-08 9.540296e-08 1.387366e-07 2.531509e-07 4.078893e-07
        Dab     5.444009e-06 7.871514e-06 1.151912e-05 2.087048e-05 3.367181e-05
        Whiting 1.373248e-04 1.933597e-04 2.756423e-04 5.088879e-04 8.161888e-04
        Sole    2.700452e-07 4.000713e-07 5.980124e-07 1.064696e-06 1.725137e-06
        Gurnard 5.060866e-06 7.560570e-06 1.137937e-05 2.015003e-05 3.269792e-05
        Plaice  2.363940e-06 3.547615e-06 5.354670e-06 9.466120e-06 1.537276e-05
        Haddock 1.635158e-05 2.370118e-05 3.478973e-05 6.289298e-05 1.015321e-04
        Cod     3.953996e-05 6.202838e-05 9.734219e-05 1.678008e-04 2.752666e-04
        Saithe  3.824255e-05 6.145802e-05 9.869058e-05 1.684534e-04 2.786164e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   2.001508e-12 3.083465e-12 4.780829e-12 7.480070e-12 1.182141e-11
        Sandeel 1.475229e-11 2.431408e-11 4.005003e-11 6.589775e-11 1.082457e-10
        N.pout  2.882041e-03 4.296154e-03 8.540670e-03 1.661282e-02 2.700949e-02
        Herring 5.920195e-07 8.986865e-07 1.738930e-06 3.304696e-06 5.367517e-06
        Dab     4.911014e-05 7.449593e-05 1.425183e-04 2.697946e-04 4.402251e-04
        Whiting 1.158663e-03 1.727175e-03 3.433589e-03 6.678814e-03 1.085854e-02
        Sole    2.570149e-06 3.946535e-06 7.316152e-06 1.354544e-05 2.219895e-05
        Gurnard 4.903820e-05 7.556215e-05 1.386937e-04 2.549854e-04 4.185601e-04
        Plaice  2.309662e-05 3.558196e-05 6.504686e-05 1.193693e-04 1.962071e-04
        Haddock 1.486037e-04 2.260653e-04 4.306707e-04 8.122176e-04 1.325188e-03
        Cod     4.297101e-04 6.774499e-04 1.178956e-03 2.075979e-03 3.431127e-03
        Saithe  4.451971e-04 7.128779e-04 1.212690e-03 2.085630e-03 3.449349e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.886220e-11 3.034646e-11 4.916343e-11 8.015039e-11 1.315326e-10
        Sandeel 1.775497e-10 2.910973e-10 4.763454e-10 7.788502e-10 1.272904e-09
        N.pout  4.112738e-02 7.846228e-02 1.102932e-01 1.655029e-01 2.834764e-01
        Herring 8.243814e-06 1.546136e-05 2.214084e-05 3.371863e-05 5.758107e-05
        Dab     6.797938e-04 1.269255e-03 1.833993e-03 2.798726e-03 4.755781e-03
        Whiting 1.653426e-02 3.154377e-02 4.434019e-02 6.653511e-02 1.139611e-01
        Sole    3.471437e-05 6.362701e-05 9.418328e-05 1.456191e-04 2.456108e-04
        Gurnard 6.572714e-04 1.197638e-03 1.786865e-03 2.773825e-03 4.666842e-03
        Plaice  3.086542e-04 5.615826e-04 8.404699e-04 1.305749e-03 2.193467e-03
        Haddock 2.049360e-03 3.815235e-03 5.529941e-03 8.458792e-03 1.436660e-02
        Cod     5.512794e-03 9.693960e-03 1.513177e-02 2.406195e-02 3.999484e-02
        Saithe  5.596356e-03 9.640368e-03 1.537776e-02 2.476960e-02 4.100104e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   2.175542e-10 3.632743e-10 6.132593e-10 1.046977e-09 1.805380e-09
        Sandeel 2.078035e-09 3.391753e-09 5.539981e-09 9.043373e-09 1.476019e-08
        N.pout  4.010770e-01 6.444849e-01 1.421046e+00 2.351345e+00 3.545821e+00
        Herring 8.341457e-05 1.347906e-04 2.849296e-04 4.697676e-04 7.151899e-04
        Dab     6.914181e-03 1.112363e-02 2.323057e-02 3.844079e-02 5.885762e-02
        Whiting 1.612350e-01 2.590807e-01 5.712398e-01 9.451720e-01 1.425201e+00
        Sole    3.647024e-04 5.866594e-04 1.172049e-03 1.941943e-03 3.013980e-03
        Gurnard 6.973681e-03 1.121345e-02 2.209177e-02 3.662430e-02 5.709475e-02
        Plaice  3.281102e-03 5.267446e-03 1.033187e-02 1.714498e-02 2.677717e-02
        Haddock 2.096700e-02 3.376554e-02 7.003921e-02 1.158370e-01 1.776483e-01
        Cod     6.199397e-02 9.970005e-02 1.812841e-01 3.006388e-01 4.800951e-01
        Saithe  6.481871e-02 1.045688e-01 1.827437e-01 3.023166e-01 4.879154e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   3.135399e-09 5.462306e-09 9.504579e-09 1.645392e-08 2.825559e-08
        Sandeel 2.411391e-08 3.943963e-08 6.452449e-08 1.056616e-07 1.731461e-07
        N.pout  6.531526e+00 1.320093e+01 2.248433e+01 3.829193e+01 6.113817e+01
        Herring 1.299242e-03 2.567627e-03 4.357520e-03 7.411539e-03 1.191345e-02
        Dab     1.065719e-01 2.098949e-01 3.580016e-01 6.111368e-01 9.872719e-01
        Whiting 2.625068e+00 5.305349e+00 9.036374e+00 1.538814e+01 2.455936e+01
        Sole    5.377372e-03 1.035173e-02 1.768490e-02 3.023855e-02 4.930526e-02
        Gurnard 1.013927e-01 1.937768e-01 3.313486e-01 5.670278e-01 9.276004e-01
        Plaice  4.750479e-02 9.069048e-02 1.553825e-01 2.663345e-01 4.366238e-01
        Haddock 3.208870e-01 6.294524e-01 1.072740e+00 1.830349e+00 2.959346e+00
        Cod     8.289889e-01 1.512549e+00 2.593594e+00 4.455298e+00 7.435600e+00
        Saithe  8.291609e-01 1.470375e+00 2.515623e+00 4.321013e+00 7.287940e+00
      
      , , prey = Herring
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   4.681526e-22 1.077238e-21 0.000000e+00 1.361149e-21 1.318358e-22
        Sandeel 3.060425e-22 3.231550e-22 1.546991e-22 4.454978e-22 4.618551e-22
        N.pout  1.517191e-20 2.001532e-20 1.544371e-20 2.890839e-20 3.788593e-20
        Herring 5.606858e-07 5.466696e-07 5.386419e-07 4.850697e-07 4.450405e-07
        Dab     7.744333e-21 1.184039e-20 1.333763e-20 1.808875e-20 2.449014e-20
        Whiting 2.035040e-20 2.684697e-20 2.071497e-20 3.877543e-20 5.081720e-20
        Sole    0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Gurnard 3.085161e-21 3.855237e-21 6.264688e-21 5.928169e-21 1.083380e-20
        Plaice  0.000000e+00 1.845696e-21 1.107331e-21 8.573177e-22 2.225546e-21
        Haddock 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 2.120079e-21
        Cod     3.456540e-20 4.162363e-20 3.761039e-20 6.128599e-20 6.722007e-20
        Saithe  1.565235e-20 1.545812e-20 1.734969e-20 1.518723e-20 2.373092e-20
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   7.107129e-22 0.000000e+00 0.000000e+00 3.678517e-21 0.000000e+00
        Sandeel 4.729018e-22 6.128317e-22 2.745266e-22 4.517562e-22 6.244578e-22
        N.pout  5.242118e-20 7.277191e-20 1.545855e-19 2.331949e-19 4.774466e-19
        Herring 2.978378e-07 1.004950e-07 9.079939e-21 0.000000e+00 1.506012e-20
        Dab     3.358156e-20 4.637508e-20 5.574852e-20 6.423557e-20 1.069500e-19
        Whiting 7.031363e-20 9.761050e-20 2.073487e-19 3.127893e-19 6.404092e-19
        Sole    0.000000e+00 0.000000e+00 9.306616e-22 2.410812e-22 5.271051e-21
        Gurnard 1.110219e-20 1.435649e-20 2.147403e-20 2.160744e-20 2.929135e-20
        Plaice  4.838000e-21 4.711523e-21 1.151397e-20 7.207537e-21 2.875522e-20
        Haddock 1.356958e-21 1.380388e-20 1.043005e-20 1.308077e-20 3.489918e-20
        Cod     7.657507e-20 6.504696e-20 8.704514e-20 8.337370e-20 1.895537e-19
        Saithe  1.049892e-20 1.922760e-20 5.991333e-21 2.828552e-20 4.470465e-20
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   3.932320e-21 0.000000e+00 1.612742e-21 0.000000e+00 0.000000e+00
        Sandeel 1.678408e-21 0.000000e+00 1.908913e-21 1.832410e-21 8.443071e-21
        N.pout  9.081280e-19 1.598616e-18 2.867211e-18 4.476842e-18 6.854174e-18
        Herring 6.939147e-21 2.397977e-20 9.207496e-21 4.242474e-20 1.221735e-20
        Dab     1.519389e-19 2.679140e-19 4.130465e-19 6.331336e-19 9.562067e-19
        Whiting 1.218091e-18 2.144257e-18 3.845851e-18 6.004883e-18 9.193648e-18
        Sole    1.104460e-20 2.609492e-20 4.908804e-20 9.510414e-20 1.444223e-19
        Gurnard 4.975629e-20 6.900616e-20 1.102739e-19 1.677280e-19 2.651261e-19
        Plaice  3.955226e-20 9.138748e-20 1.532076e-19 2.794297e-19 4.324164e-19
        Haddock 7.015008e-20 1.259991e-19 2.209680e-19 3.450592e-19 5.326138e-19
        Cod     3.230813e-19 6.391441e-19 1.063367e-18 1.822636e-18 2.873774e-18
        Saithe  1.072596e-19 1.690980e-19 3.271515e-19 5.295111e-19 9.219089e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   1.754470e-21 0.000000e+00 1.005539e-20 2.305750e-20 2.803757e-20
        Sandeel 5.349101e-21 5.601520e-21 2.580974e-21 4.459566e-21 5.137008e-21
        N.pout  1.214385e-17 2.147940e-17 4.409714e-17 7.192747e-17 1.346034e-16
        Herring 7.036629e-21 6.484439e-20 5.602107e-20 6.453110e-20 2.230016e-19
        Dab     1.660580e-18 2.915724e-18 5.876640e-18 9.665733e-18 1.797663e-17
        Whiting 1.628880e-17 2.881078e-17 5.914842e-17 9.647783e-17 1.805464e-16
        Sole    2.804363e-19 4.966175e-19 1.025094e-18 1.723561e-18 3.248269e-18
        Gurnard 4.392902e-19 7.645675e-19 1.493149e-18 2.515563e-18 4.600563e-18
        Plaice  7.895047e-19 1.374575e-18 2.737761e-18 4.592351e-18 8.538833e-18
        Haddock 9.881688e-19 1.706452e-18 3.464077e-18 5.682910e-18 1.063003e-17
        Cod     4.985212e-18 8.579937e-18 1.611668e-17 2.768082e-17 5.010429e-17
        Saithe  1.640853e-18 2.859248e-18 5.316198e-18 9.203810e-18 1.652931e-17
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   5.753782e-20 7.172007e-20 3.692457e-20 5.426805e-20 0.000000e+00
        Sandeel 1.577963e-20 0.000000e+00 5.234463e-21 7.235543e-20 1.389113e-20
        N.pout  1.882619e-16 2.575886e-16 3.554258e-16 5.681593e-16 1.188910e-15
        Herring 2.568773e-19 3.287767e-19 6.438247e-19 7.852518e-19 1.658319e-18
        Dab     2.589643e-17 3.679393e-17 5.259625e-17 8.458696e-17 1.687458e-16
        Whiting 2.525196e-16 3.455090e-16 4.767401e-16 7.620840e-16 1.594710e-15
        Sole    4.803538e-18 7.070404e-18 1.039824e-17 1.674520e-17 3.220296e-17
        Gurnard 6.917634e-18 1.019390e-17 1.509631e-17 2.429226e-17 4.611585e-17
        Plaice  1.283380e-17 1.904778e-17 2.819027e-17 4.525141e-17 8.531218e-17
        Haddock 1.535285e-17 2.193449e-17 3.156383e-17 5.089385e-17 1.013025e-16
        Cod     7.948295e-17 1.238605e-16 1.920290e-16 3.089093e-16 5.466176e-16
        Saithe  2.709637e-17 4.363762e-17 6.956788e-17 1.129221e-16 1.940761e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   1.630109e-20 0.000000e+00 0.000000e+00 0.000000e+00 1.302563e-20
        Sandeel 4.800390e-20 0.000000e+00 6.369598e-20 3.668595e-20 0.000000e+00
        N.pout  2.319328e-15 4.560387e-15 8.078959e-15 1.169367e-14 1.960276e-14
        Herring 2.894289e-18 5.267647e-18 9.601018e-18 1.335986e-17 2.272729e-17
        Dab     3.206286e-16 6.168773e-16 1.088105e-15 1.611971e-15 2.707531e-15
        Whiting 3.110963e-15 6.116942e-15 1.083648e-14 1.568497e-14 2.629359e-14
        Sole    5.998227e-17 1.134030e-16 1.996842e-16 3.023700e-16 5.086742e-16
        Gurnard 8.515999e-17 1.600073e-16 2.815099e-16 4.297294e-16 7.230662e-16
        Plaice  1.572310e-16 2.951109e-16 5.199145e-16 7.966839e-16 1.341333e-15
        Haddock 1.918344e-16 3.679357e-16 6.481354e-16 9.620835e-16 1.616530e-15
        Cod     9.644315e-16 1.739830e-15 3.035435e-15 4.841507e-15 8.170880e-15
        Saithe  3.339175e-16 5.863521e-16 1.012099e-15 1.646837e-15 2.781448e-15
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 1.622609e-20 1.869096e-20 0.000000e+00 0.000000e+00 8.570497e-20
        N.pout  3.336548e-14 5.435973e-14 8.054154e-14 1.688584e-13 2.338240e-13
        Herring 3.850652e-17 6.382931e-17 9.533388e-17 1.941515e-16 2.751119e-16
        Dab     4.606778e-15 7.550997e-15 1.142089e-14 2.313045e-14 3.303095e-14
        Whiting 4.475382e-14 7.291385e-14 1.080321e-13 2.264933e-13 3.136330e-13
        Sole    8.649053e-16 1.424764e-15 2.191919e-15 4.305480e-15 6.316829e-15
        Gurnard 1.229227e-15 2.027970e-15 3.136819e-15 6.099047e-15 9.028557e-15
        Plaice  2.280214e-15 3.764627e-15 5.832870e-15 1.129475e-14 1.677681e-14
        Haddock 2.749966e-15 4.511124e-15 6.840799e-15 1.380338e-14 1.977975e-14
        Cod     1.388039e-14 2.314403e-14 3.701323e-14 6.791425e-14 1.059656e-13
        Saithe  4.723767e-15 7.928223e-15 1.292604e-14 2.306379e-14 3.701428e-14
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   6.282366e-20 4.342024e-19 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 3.790707e-20 0.000000e+00 2.514928e-19 5.793931e-20
        N.pout  3.263546e-13 4.557900e-13 8.395209e-13 1.725372e-12 2.619478e-12
        Herring 3.945223e-16 5.682723e-16 1.032444e-15 2.055402e-15 3.147763e-15
        Dab     4.755820e-14 6.856102e-14 1.228577e-13 2.421397e-13 3.724983e-13
        Whiting 4.377462e-13 6.113607e-13 1.126067e-12 2.314278e-12 3.513561e-12
        Sole    9.319792e-15 1.374356e-14 2.408302e-14 4.590028e-14 7.148644e-14
        Gurnard 1.342083e-14 1.991871e-14 3.464673e-14 6.532294e-14 1.021311e-13
        Plaice  2.497764e-14 3.706963e-14 6.417508e-14 1.204960e-13 1.886056e-13
        Haddock 2.859989e-14 4.143394e-14 7.411051e-14 1.453569e-13 2.239650e-13
        Cod     1.647006e-13 2.540662e-13 4.259640e-13 7.541637e-13 1.202637e-12
        Saithe  5.899382e-14 9.308932e-14 1.540616e-13 2.643137e-13 4.247176e-13
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   2.548249e-18 0.000000e+00 2.705000e-18 0.000000e+00 2.691931e-18
        Sandeel 0.000000e+00 2.306376e-19 8.855773e-20 7.140724e-19 0.000000e+00
        N.pout  4.583070e-12 7.104537e-12 9.823369e-12 2.133352e-11 2.947312e-11
        Herring 5.456524e-15 8.516455e-15 1.207066e-14 2.525267e-14 3.561809e-14
        Dab     6.446346e-13 1.009277e-12 1.438954e-12 2.971263e-12 4.228594e-12
        Whiting 6.147368e-12 9.529464e-12 1.317629e-11 2.861510e-11 3.953291e-11
        Sole    1.226774e-13 1.938255e-13 2.832913e-13 5.609601e-13 8.191911e-13
        Gurnard 1.747891e-13 2.769556e-13 4.078574e-13 7.970259e-13 1.173547e-12
        Plaice  3.225018e-13 5.115051e-13 7.545441e-13 1.468572e-12 2.168507e-12
        Haddock 3.870418e-13 6.066850e-13 8.685444e-13 1.782266e-12 2.545473e-12
        Cod     2.021456e-12 3.250054e-12 4.991021e-12 9.045079e-12 1.394393e-11
        Saithe  7.055872e-13 1.139903e-12 1.785285e-12 3.113308e-12 4.904555e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   2.067238e-18 1.190634e-18 1.371500e-18 0.000000e+00 9.099160e-19
        Sandeel 1.353567e-19 4.677552e-19 8.082163e-19 2.172311e-18 2.978932e-18
        N.pout  5.227549e-11 8.389364e-11 1.211134e-10 1.727568e-10 2.788025e-10
        Herring 6.255331e-14 1.006561e-13 1.480275e-13 2.162714e-13 3.504616e-13
        Dab     7.395955e-12 1.191788e-11 1.760062e-11 2.574864e-11 4.149478e-11
        Whiting 7.011822e-11 1.125283e-10 1.624520e-10 2.317223e-10 3.739637e-10
        Sole    1.415935e-12 2.289795e-12 3.444188e-12 5.134121e-12 8.255032e-12
        Gurnard 2.020839e-12 3.271800e-12 4.949067e-12 7.417494e-12 1.191388e-11
        Plaice  3.729862e-12 6.042118e-12 9.152596e-12 1.372361e-11 2.200191e-11
        Haddock 4.444568e-12 7.165043e-12 1.061348e-11 1.558614e-11 2.513622e-11
        Cod     2.351040e-11 3.830812e-11 5.985526e-11 9.260606e-11 1.483068e-10
        Saithe  8.183224e-12 1.337518e-11 2.125721e-11 3.347984e-11 5.372772e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   1.572209e-18 1.207360e-18 3.824610e-18 1.121425e-17 1.153373e-17
        Sandeel 6.931538e-18 1.106761e-17 1.866799e-17 3.178367e-17 5.431363e-17
        N.pout  4.157310e-10 7.274842e-10 1.006657e-09 1.929074e-09 3.245642e-09
        Herring 5.313581e-13 9.172782e-13 1.305127e-12 2.420302e-12 4.030245e-12
        Dab     6.277761e-11 1.076014e-10 1.533416e-10 2.820499e-10 4.696308e-10
        Whiting 5.576287e-10 9.757899e-10 1.350250e-09 2.587508e-09 4.353448e-09
        Sole    1.261648e-11 2.128129e-11 3.100744e-11 5.530001e-11 9.142387e-11
        Gurnard 1.825581e-11 3.063679e-11 4.491336e-11 7.935311e-11 1.309023e-10
        Plaice  3.367957e-11 5.636819e-11 8.262875e-11 1.455426e-10 2.399885e-10
        Haddock 3.813400e-11 6.523776e-11 9.339919e-11 1.709437e-10 2.841979e-10
        Cod     2.308754e-10 3.772803e-10 5.716250e-10 9.591972e-10 1.558581e-09
        Saithe  8.449419e-11 1.366310e-10 2.103737e-10 3.445047e-10 5.541492e-10
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   1.860012e-17 2.938371e-17 5.817508e-17 1.131087e-16 2.044419e-16
        Sandeel 9.026239e-17 1.509506e-16 2.483093e-16 4.120250e-16 6.796052e-16
        N.pout  5.614763e-09 8.680342e-09 1.302928e-08 1.965922e-08 3.635886e-08
        Herring 6.873551e-12 1.066486e-11 1.616924e-11 2.466566e-11 4.461105e-11
        Dab     8.013159e-10 1.248224e-09 1.898361e-09 2.898883e-09 5.217310e-09
        Whiting 7.531199e-09 1.164313e-08 1.747644e-08 2.636933e-08 4.876891e-08
        Sole    1.544356e-10 2.423168e-10 3.725817e-10 5.741907e-10 1.010770e-09
        Gurnard 2.204704e-10 3.467446e-10 5.349472e-10 8.266416e-10 1.445564e-09
        Plaice  4.042006e-10 6.365484e-10 9.832027e-10 1.520162e-09 2.654939e-09
        Haddock 4.838054e-10 7.541046e-10 1.148733e-09 1.757177e-09 3.150633e-09
        Cod     2.572967e-09 4.090319e-09 6.423437e-09 1.007789e-08 1.699620e-08
        Saithe  9.023589e-10 1.437239e-09 2.272502e-09 3.590943e-09 5.951540e-09
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   3.517654e-16 6.206051e-16 1.089034e-15 1.891482e-15 3.253305e-15
        Sandeel 1.120983e-15 1.842057e-15 3.025926e-15 4.959017e-15 8.115791e-15
        N.pout  5.625239e-08 9.151227e-08 1.659783e-07 2.475848e-07 3.611381e-07
        Herring 6.937568e-11 1.126600e-10 2.007109e-10 3.025559e-10 4.487411e-10
        Dab     8.135973e-09 1.321568e-08 2.349626e-08 3.559812e-08 5.296552e-08
        Whiting 7.545251e-08 1.227473e-07 2.226302e-07 3.320907e-07 4.844021e-07
        Sole    1.586795e-09 2.574104e-09 4.502062e-09 6.911890e-09 1.044486e-08
        Gurnard 2.274278e-09 3.688196e-09 6.419294e-09 9.897690e-09 1.502777e-08
        Plaice  4.181507e-09 6.783300e-09 1.180092e-08 1.822948e-08 2.771218e-08
        Haddock 4.917039e-09 7.983960e-09 1.415105e-08 2.147569e-08 3.203734e-08
        Cod     2.705864e-08 4.382393e-08 7.419109e-08 1.171870e-07 1.828868e-07
        Saithe  9.529227e-09 1.543341e-08 2.576927e-08 4.119519e-08 6.524464e-08
               w
      predator          97.8          117          139          166          198
        Sprat   5.541049e-15 9.392109e-15 1.580663e-14 2.643599e-14 4.398929e-14
        Sandeel 1.327630e-14 2.168222e-14 3.533282e-14 5.753140e-14 9.359472e-14
        N.pout  9.470103e-07 1.603923e-06 2.291967e-06 3.530639e-06 6.456182e-06
        Herring 1.103043e-09 1.854114e-09 2.684788e-09 4.174728e-09 7.558399e-09
        Dab     1.285255e-07 2.176411e-07 3.186805e-07 4.975085e-07 8.968078e-07
        Whiting 1.270245e-06 2.151376e-06 3.074264e-06 4.735721e-06 8.659813e-06
        Sole    2.373352e-08 4.025384e-08 6.029491e-08 9.516117e-08 1.692699e-07
        Gurnard 3.345945e-08 5.681329e-08 8.577067e-08 1.358704e-07 2.406809e-07
        Plaice  6.143935e-08 1.046124e-07 1.586073e-07 2.517201e-07 4.454186e-07
        Haddock 7.688749e-08 1.300218e-07 1.908015e-07 2.982803e-07 5.366847e-07
        Cod     3.613212e-07 6.153544e-07 9.725340e-07 1.576421e-06 2.731399e-06
        Saithe  1.209805e-07 2.053947e-07 3.319441e-07 5.448297e-07 9.346192e-07
               w
      predator           237          282          337          402          480
        Sprat   7.294685e-14 1.208563e-13 2.006181e-13 3.345669e-13 5.616961e-13
        Sandeel 1.520310e-13 2.468484e-13 4.004383e-13 6.491375e-13 1.051632e-12
        N.pout  8.966245e-06 1.582872e-05 2.474548e-05 3.818117e-05 5.414370e-05
        Herring 1.073626e-08 1.884519e-08 2.971549e-08 4.635475e-08 6.739303e-08
        Dab     1.284318e-06 2.241566e-06 3.538478e-06 5.521753e-06 8.044502e-06
        Whiting 1.202661e-05 2.123140e-05 3.319163e-05 5.121320e-05 7.262408e-05
        Sole    2.486927e-07 4.294306e-07 6.830000e-07 1.074939e-06 1.598149e-06
        Gurnard 3.565493e-07 6.135380e-07 9.780832e-07 1.543218e-06 2.307960e-06
        Plaice  6.618256e-07 1.136880e-06 1.812959e-06 2.860379e-06 4.279497e-06
        Haddock 7.713777e-07 1.344965e-06 2.126116e-06 3.323817e-06 4.861992e-06
        Cod     4.250341e-06 7.191933e-06 1.163661e-05 1.865397e-05 2.887856e-05
        Saithe  1.493644e-06 2.514089e-06 4.107223e-06 6.651745e-06 1.049789e-05
               w
      predator           573          683          816          973         1160
        Sprat   9.490219e-13 1.610494e-12 2.735551e-12 4.632365e-12 7.793174e-12
        Sandeel 1.703622e-12 2.758296e-12 4.466922e-12 7.237473e-12 1.172760e-11
        N.pout  9.045321e-05 1.234517e-04 2.007213e-04 3.819828e-04 6.367362e-04
        Herring 1.124838e-07 1.586287e-07 2.582336e-07 4.769763e-07 7.887673e-07
        Dab     1.333675e-05 1.883653e-05 3.043717e-05 5.574105e-05 9.215440e-05
        Whiting 1.213268e-04 1.655883e-04 2.692316e-04 5.123614e-04 8.540672e-04
        Sole    2.631498e-06 3.811167e-06 6.126194e-06 1.090122e-05 1.792855e-05
        Gurnard 3.790811e-06 5.528731e-06 8.868086e-06 1.563979e-05 2.567733e-05
        Plaice  7.010967e-06 1.022356e-05 1.634869e-05 2.873113e-05 4.713604e-05
        Haddock 8.061154e-06 1.144618e-05 1.850608e-05 3.374403e-05 5.572996e-05
        Cod     4.689327e-05 7.109470e-05 1.129024e-04 1.893893e-04 3.069007e-04
        Saithe  1.700299e-05 2.629609e-05 4.165555e-05 6.820968e-05 1.094904e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   1.299439e-11 2.145467e-11 3.509273e-11 5.696051e-11 9.198157e-11
        Sandeel 1.902186e-11 3.085597e-11 5.009147e-11 8.137888e-11 1.323107e-10
        N.pout  1.277549e-03 2.022734e-03 3.346028e-03 5.511068e-03 8.988314e-03
        Herring 1.528765e-06 2.418614e-06 3.983686e-06 6.545656e-06 1.067553e-05
        Dab     1.780913e-04 2.834995e-04 4.684792e-04 7.719003e-04 1.261972e-03
        Whiting 1.713602e-03 2.713132e-03 4.488089e-03 7.392090e-03 1.205616e-02
        Sole    3.363665e-05 5.389207e-05 8.905591e-05 1.468413e-04 2.405666e-04
        Gurnard 4.773989e-05 7.666662e-05 1.267253e-04 2.090581e-04 3.428048e-04
        Plaice  8.752832e-05 1.408566e-04 2.331581e-04 3.851793e-04 6.324469e-04
        Haddock 1.070869e-04 1.704574e-04 2.814496e-04 4.634810e-04 7.576044e-04
        Cod     5.388777e-04 8.733507e-04 1.442111e-03 2.383045e-03 3.928031e-03
        Saithe  1.857545e-04 3.007803e-04 4.944227e-04 8.157740e-04 1.347257e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.482190e-10 2.390306e-10 3.866815e-10 6.282549e-10 1.025082e-09
        Sandeel 2.153272e-10 3.507883e-10 5.724556e-10 9.349110e-10 1.527500e-09
        N.pout  1.540583e-02 2.747162e-02 5.857466e-02 1.081918e-01 1.740184e-01
        Herring 1.820131e-05 3.215077e-05 6.677144e-05 1.220132e-04 1.967179e-04
        Dab     2.151877e-03 3.798831e-03 7.853048e-03 1.440397e-02 2.341626e-02
        Whiting 2.066399e-02 3.684787e-02 7.856595e-02 1.451160e-01 2.334052e-01
        Sole    4.082777e-04 7.143461e-04 1.436153e-03 2.619490e-03 4.304480e-03
        Gurnard 5.810542e-04 1.013997e-03 2.020652e-03 3.680539e-03 6.073267e-03
        Plaice  1.072607e-03 1.872254e-03 3.725945e-03 6.797766e-03 1.125535e-02
        Haddock 1.290436e-03 2.273995e-03 4.678520e-03 8.563961e-03 1.392643e-02
        Cod     6.613999e-03 1.137265e-02 2.145185e-02 3.864716e-02 6.538795e-02
        Saithe  2.261677e-03 3.860902e-03 7.057156e-03 1.259725e-02 2.158388e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.677402e-09 2.746620e-09 4.488636e-09 7.303298e-09 1.180862e-08
        Sandeel 2.497813e-09 4.086991e-09 6.698320e-09 1.097306e-08 1.799673e-08
        N.pout  2.789151e-01 4.282642e-01 7.916734e-01 1.086584e+00 1.694816e+00
        Herring 3.170517e-04 4.925307e-04 9.060738e-04 1.273751e-03 2.015128e-03
        Dab     3.795162e-02 5.926472e-02 1.083808e-01 1.538881e-01 2.430637e-01
        Whiting 3.740928e-01 5.743938e-01 1.061774e+00 1.457248e+00 2.272781e+00
        Sole    7.046331e-03 1.116065e-02 2.018804e-02 2.949881e-02 4.699272e-02
        Gurnard 9.978514e-03 1.588238e-02 2.862353e-02 4.222313e-02 6.742804e-02
        Plaice  1.853879e-02 2.957433e-02 5.320410e-02 7.875912e-02 1.257085e-01
        Haddock 2.258859e-02 3.533722e-02 6.456169e-02 9.202680e-02 1.456836e-01
        Cod     1.100069e-01 1.807349e-01 3.196385e-01 4.995077e-01 8.121021e-01
        Saithe  3.681207e-02 6.166049e-02 1.082960e-01 1.748559e-01 2.881643e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   1.895389e-08 3.019867e-08 4.780628e-08 7.534171e-08 1.185333e-07
        Sandeel 2.952103e-08 4.851140e-08 7.973444e-08 1.312725e-07 2.163089e-07
        N.pout  2.301384e+00 4.352053e+00 6.774576e+00 1.309820e+01 2.333765e+01
        Herring 2.831934e-03 5.281151e-03 8.311466e-03 1.573871e-02 2.776730e-02
        Dab     3.428856e-01 6.298890e-01 9.898624e-01 1.857520e+00 3.272338e+00
        Whiting 3.085962e+00 5.835515e+00 9.083890e+00 1.756168e+01 3.127789e+01
        Sole    6.818258e-02 1.222246e-01 1.933765e-01 3.540546e-01 6.178280e-01
        Gurnard 9.865245e-02 1.753969e-01 2.779617e-01 5.047870e-01 8.780129e-01
        Plaice  1.840962e-01 3.255453e-01 5.152477e-01 9.320816e-01 1.619272e+00
        Haddock 2.066289e-01 3.788612e-01 5.965349e-01 1.115891e+00 1.962737e+00
        Cod     1.248786e+00 2.129554e+00 3.407584e+00 5.898304e+00 1.002791e+01
        Saithe  4.559631e-01 7.658949e-01 1.233393e+00 2.083901e+00 3.489575e+00
      
      , , prey = Dab
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   5.832253e-22 6.050398e-23 1.606786e-21 5.712252e-22 2.327735e-21
        Sandeel 6.446333e-22 4.649663e-22 5.276043e-22 7.366685e-23 7.637168e-22
        N.pout  8.437249e-21 1.170609e-20 1.072531e-20 1.747980e-20 2.524922e-20
        Herring 1.797302e-07 1.733842e-07 1.647035e-07 1.608031e-07 1.496664e-07
        Dab     2.995363e-20 3.714806e-20 4.709098e-20 5.925069e-20 9.845916e-20
        Whiting 3.310033e-20 4.592439e-20 4.207664e-20 6.857533e-20 9.905569e-20
        Sole    0.000000e+00 4.574220e-22 2.629686e-21 4.498965e-21 1.082583e-20
        Gurnard 1.102428e-21 2.260211e-21 3.883667e-21 6.527828e-21 8.266606e-21
        Plaice  1.395953e-20 1.990898e-20 2.135423e-20 2.988796e-20 3.695956e-20
        Haddock 0.000000e+00 1.262931e-22 9.952690e-22 2.210012e-21 4.689454e-21
        Cod     6.697741e-20 7.071159e-20 8.562187e-20 1.083966e-19 1.526994e-19
        Saithe  5.797038e-21 7.359865e-21 8.048975e-21 9.078307e-21 9.602044e-21
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   1.838981e-21 8.579904e-22 7.006521e-22 0.000000e+00 8.964106e-23
        Sandeel 5.376136e-22 8.444745e-22 7.782054e-22 7.470174e-22 1.548891e-21
        N.pout  5.155928e-20 7.120067e-20 1.035489e-19 1.682578e-19 2.725673e-19
        Herring 1.210788e-07 4.389808e-08 0.000000e+00 1.149419e-21 1.986037e-21
        Dab     1.269562e-19 1.940753e-19 2.386814e-19 3.482905e-19 4.611570e-19
        Whiting 2.022731e-19 2.793287e-19 4.062347e-19 6.600952e-19 1.069314e-18
        Sole    1.195865e-20 2.509873e-20 3.036525e-20 4.196816e-20 5.593781e-20
        Gurnard 1.245487e-20 1.829511e-20 2.514460e-20 3.076726e-20 4.516666e-20
        Plaice  5.200007e-20 6.968336e-20 9.120546e-20 1.157096e-19 1.739058e-19
        Haddock 8.054620e-21 1.263233e-20 1.672337e-20 2.434321e-20 3.601234e-20
        Cod     1.632346e-19 2.201685e-19 2.797704e-19 3.715258e-19 4.704799e-19
        Saithe  1.188474e-20 1.586090e-20 1.928840e-20 2.396650e-20 3.717556e-20
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 7.929688e-22 0.000000e+00 3.156551e-21 2.424037e-21 3.490334e-21
        N.pout  3.641374e-19 6.417278e-19 1.117804e-18 1.696745e-18 2.463360e-18
        Herring 1.525154e-21 0.000000e+00 2.023714e-21 0.000000e+00 0.000000e+00
        Dab     6.412279e-19 9.789820e-19 1.635623e-18 2.362110e-18 3.497408e-18
        Whiting 1.428554e-18 2.517574e-18 4.385278e-18 6.656530e-18 9.664053e-18
        Sole    8.067639e-20 1.292219e-19 2.099900e-19 3.095524e-19 4.647736e-19
        Gurnard 5.929734e-20 9.123460e-20 1.351759e-19 2.007090e-19 2.892032e-19
        Plaice  2.316722e-19 3.591074e-19 5.698656e-19 8.707406e-19 1.292642e-18
        Haddock 5.095336e-20 8.010561e-20 1.316082e-19 1.986613e-19 2.893371e-19
        Cod     7.487005e-19 1.110052e-18 1.861066e-18 2.744074e-18 4.350552e-18
        Saithe  5.240131e-20 8.885186e-20 1.433443e-19 2.259484e-19 3.623959e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 1.237986e-21 1.417342e-21
        Sandeel 2.412326e-21 1.111511e-20 2.133930e-21 4.916181e-21 2.831494e-21
        N.pout  3.614315e-18 5.635577e-18 1.022740e-17 1.410974e-17 2.839219e-17
        Herring 0.000000e+00 1.068911e-20 1.231286e-20 3.782209e-20 3.812162e-20
        Dab     5.039451e-18 7.890626e-18 1.371778e-17 1.958788e-17 3.735815e-17
        Whiting 1.417938e-17 2.210903e-17 4.012329e-17 5.535416e-17 1.113859e-16
        Sole    6.847716e-19 1.052118e-18 1.805337e-18 2.667509e-18 4.909200e-18
        Gurnard 4.344674e-19 6.570734e-19 1.118218e-18 1.639108e-18 2.984387e-18
        Plaice  1.948414e-18 3.022491e-18 5.160208e-18 7.565204e-18 1.379289e-17
        Haddock 4.243894e-19 6.570934e-19 1.146599e-18 1.631930e-18 3.072787e-18
        Cod     6.577423e-18 1.049000e-17 1.717165e-17 2.638503e-17 4.510278e-17
        Saithe  5.739160e-19 9.031085e-19 1.493284e-18 2.316454e-18 3.876218e-18
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   2.168377e-20 1.906136e-20 1.157024e-20 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 1.298345e-20 0.000000e+00 0.000000e+00
        N.pout  4.036951e-17 1.069303e-16 1.507982e-16 2.900701e-16 4.759305e-16
        Herring 9.409840e-20 1.300712e-19 2.330690e-19 4.027109e-19 8.615023e-19
        Dab     5.448674e-17 1.325090e-16 1.916141e-16 3.607862e-16 5.948870e-16
        Whiting 1.583744e-16 4.195001e-16 5.915991e-16 1.137979e-15 1.867132e-15
        Sole    7.322214e-18 1.664761e-17 2.469260e-17 4.565695e-17 7.563415e-17
        Gurnard 4.432388e-18 9.890066e-18 1.476789e-17 2.718496e-17 4.511258e-17
        Plaice  2.058998e-17 4.593233e-17 6.883129e-17 1.268312e-16 2.111183e-16
        Haddock 4.495477e-18 1.077749e-17 1.561129e-17 2.926169e-17 4.822216e-17
        Cod     6.973873e-17 1.368979e-16 2.137906e-16 3.800306e-16 6.375127e-16
        Saithe  6.032836e-18 1.107612e-17 1.757600e-17 3.058070e-17 5.143686e-17
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 1.984464e-20 7.619730e-20 5.266336e-20 1.011056e-19 6.987857e-20
        N.pout  8.904866e-16 1.286905e-15 1.875507e-15 3.296756e-15 5.051192e-15
        Herring 1.552170e-18 2.256929e-18 3.207514e-18 5.717156e-18 8.601648e-18
        Dab     1.098927e-15 1.626876e-15 2.427496e-15 4.232492e-15 6.579253e-15
        Whiting 3.493484e-15 5.048681e-15 7.357835e-15 1.293356e-14 1.981642e-14
        Sole    1.381366e-16 2.090117e-16 3.178289e-16 5.494123e-16 8.636165e-16
        Gurnard 8.215248e-17 1.252745e-16 1.917151e-16 3.304209e-16 5.212586e-16
        Plaice  3.848071e-16 5.891417e-16 9.042390e-16 1.556199e-15 2.457218e-15
        Haddock 8.883569e-17 1.317749e-16 1.971023e-16 3.433790e-16 5.348004e-16
        Cod     1.136583e-15 1.815738e-15 2.891702e-15 4.925894e-15 7.953541e-15
        Saithe  9.064142e-17 1.484324e-16 2.422050e-16 4.121208e-16 6.761157e-16
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   1.023674e-20 4.716714e-20 2.716610e-20 0.000000e+00 7.209293e-20
        Sandeel 8.049367e-20 1.854426e-19 0.000000e+00 8.202072e-20 0.000000e+00
        N.pout  7.562359e-15 1.071254e-14 1.973722e-14 2.798306e-14 4.200518e-14
        Herring 1.341750e-17 1.908187e-17 3.533322e-17 5.040251e-17 7.741206e-17
        Dab     1.002857e-14 1.461232e-14 2.621670e-14 3.814903e-14 5.802101e-14
        Whiting 2.966803e-14 4.202657e-14 7.743145e-14 1.097809e-13 1.647913e-13
        Sole    1.334214e-15 1.984077e-15 3.484178e-15 5.171754e-15 7.939666e-15
        Gurnard 8.085106e-16 1.209489e-15 2.108791e-15 3.148231e-15 4.843839e-15
        Plaice  3.812077e-15 5.703596e-15 9.901979e-15 1.478273e-14 2.270509e-14
        Haddock 8.174105e-16 1.196120e-15 2.141505e-15 3.128636e-15 4.771786e-15
        Cod     1.265804e-14 1.962411e-14 3.300288e-14 5.086206e-14 7.925990e-14
        Saithe  1.094385e-15 1.733731e-15 2.876842e-15 4.507655e-15 7.075490e-15
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   8.304441e-20 0.000000e+00 4.407637e-19 7.615787e-19 1.169691e-18
        Sandeel 5.441630e-20 3.134128e-19 2.888181e-19 8.317297e-20 0.000000e+00
        N.pout  7.314753e-14 1.100946e-13 2.443066e-13 4.315367e-13 7.543504e-13
        Herring 1.332340e-16 2.026619e-16 4.250945e-16 7.401835e-16 1.277000e-15
        Dab     9.903941e-14 1.507220e-13 3.141566e-13 5.478247e-13 9.494202e-13
        Whiting 2.869664e-13 4.319140e-13 9.584439e-13 1.692970e-12 2.959406e-12
        Sole    1.335100e-14 2.050137e-14 4.070440e-14 7.035542e-14 1.212190e-13
        Gurnard 8.105086e-15 1.247357e-14 2.439930e-14 4.206511e-14 7.236742e-14
        Plaice  3.786807e-14 5.821430e-14 1.134703e-13 1.957880e-13 3.373235e-13
        Haddock 8.132724e-15 1.240427e-14 2.563593e-14 4.458769e-14 7.710682e-14
        Cod     1.290563e-13 2.006845e-13 3.595234e-13 6.069756e-13 1.029888e-12
        Saithe  1.137592e-14 1.774869e-14 3.032963e-14 5.030201e-14 8.418882e-14
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   2.021065e-18 1.552053e-18 3.575645e-18 0.000000e+00 2.372247e-18
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 1.686828e-19 9.715351e-20
        N.pout  1.088846e-12 1.932202e-12 2.738985e-12 4.929096e-12 8.349682e-12
        Herring 1.866008e-15 3.278363e-15 4.734547e-15 8.435325e-15 1.424284e-14
        Dab     1.400511e-12 2.457785e-12 3.576265e-12 6.340370e-12 1.070333e-11
        Whiting 4.271673e-12 7.580256e-12 1.074536e-11 1.933743e-11 3.275679e-11
        Sole    1.824271e-13 3.170180e-13 4.715838e-13 8.247708e-13 1.387739e-12
        Gurnard 1.096402e-13 1.899830e-13 2.846417e-13 4.957365e-13 8.333662e-13
        Plaice  5.127998e-13 8.887863e-13 1.335568e-12 2.323704e-12 3.907372e-12
        Haddock 1.139837e-13 1.996514e-13 2.913753e-13 5.155959e-13 8.697932e-13
        Cod     1.618788e-12 2.758536e-12 4.309528e-12 7.346703e-12 1.230309e-11
        Saithe  1.343838e-13 2.267788e-13 3.620920e-13 6.122487e-13 1.025231e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   0.000000e+00 1.573857e-18 5.438814e-18 4.698760e-18 1.202786e-18
        Sandeel 1.119119e-18 1.224666e-18 2.375919e-18 4.447364e-18 6.305174e-18
        N.pout  1.395678e-11 2.423798e-11 3.666875e-11 6.055737e-11 8.799242e-11
        Herring 2.377170e-14 4.103430e-14 6.275478e-14 1.037750e-13 1.536155e-13
        Dab     1.787482e-11 3.083930e-11 4.739487e-11 7.831105e-11 1.163769e-10
        Whiting 5.475411e-11 9.508847e-11 1.438558e-10 2.375737e-10 3.452047e-10
        Sole    2.315292e-12 3.971617e-12 6.185974e-12 1.022008e-11 1.546268e-11
        Gurnard 1.390155e-12 2.380592e-12 3.724271e-12 6.152791e-12 9.360824e-12
        Plaice  6.520997e-12 1.116651e-11 1.750047e-11 2.890717e-11 4.403581e-11
        Haddock 1.452039e-12 2.502470e-12 3.852613e-12 6.366783e-12 9.490112e-12
        Cod     2.052590e-11 3.482579e-11 5.593583e-11 9.252518e-11 1.454730e-10
        Saithe  1.713450e-12 2.896491e-12 4.720378e-12 7.824983e-12 1.252550e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   7.620243e-18 3.989917e-18 7.813228e-18 1.535314e-17 3.262652e-17
        Sandeel 1.174560e-17 1.934703e-17 3.184789e-17 5.108263e-17 8.486704e-17
        N.pout  1.278858e-10 2.262184e-10 3.466628e-10 5.916859e-10 1.130494e-09
        Herring 2.281223e-13 3.996743e-13 6.190410e-13 1.049171e-12 1.956161e-12
        Dab     1.729544e-10 3.004983e-10 4.652622e-10 7.850653e-10 1.456414e-09
        Whiting 5.017112e-10 8.874814e-10 1.359999e-09 2.321254e-09 4.435060e-09
        Sole    2.336068e-11 3.998391e-11 6.240072e-11 1.043468e-10 1.891115e-10
        Gurnard 1.420951e-11 2.420149e-11 3.785131e-11 6.310404e-11 1.135301e-10
        Plaice  6.685381e-11 1.135262e-10 1.774535e-10 2.952759e-10 5.301081e-10
        Haddock 1.415269e-11 2.455597e-11 3.809175e-11 6.421533e-11 1.186696e-10
        Cod     2.272335e-10 3.774899e-10 5.977242e-10 9.797617e-10 1.686605e-09
        Saithe  1.988766e-11 3.272680e-11 5.217571e-11 8.485149e-11 1.425936e-10
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   5.163237e-17 8.536993e-17 1.463423e-16 2.491012e-16 4.171167e-16
        Sandeel 1.387844e-16 2.275385e-16 3.719685e-16 6.091586e-16 9.989764e-16
        N.pout  2.268160e-09 4.002862e-09 6.460755e-09 1.015722e-08 1.545445e-08
        Herring 3.815939e-12 6.660313e-12 1.075172e-11 1.699377e-11 2.615021e-11
        Dab     2.835297e-09 4.970574e-09 8.077670e-09 1.283790e-08 1.984566e-08
        Whiting 8.898262e-09 1.570370e-08 2.534631e-08 3.984797e-08 6.062962e-08
        Sole    3.592034e-10 6.270437e-10 1.026487e-09 1.647613e-09 2.580892e-09
        Gurnard 2.139923e-10 3.731870e-10 6.126391e-10 9.868245e-10 1.552663e-09
        Plaice  9.982521e-10 1.743671e-09 2.870068e-09 4.634031e-09 7.306069e-09
        Haddock 2.299294e-10 4.023159e-10 6.537775e-10 1.039856e-09 1.610255e-09
        Cod     3.022875e-09 5.215325e-09 8.684710e-09 1.427910e-08 2.308624e-08
        Saithe  2.475879e-10 4.221345e-10 7.054455e-10 1.170691e-09 1.921264e-09
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   6.910684e-16 1.113297e-15 1.786094e-15 2.837674e-15 4.508979e-15
        Sandeel 1.635946e-15 2.683462e-15 4.400519e-15 7.220453e-15 1.184344e-14
        N.pout  2.393093e-08 3.578465e-08 5.954103e-08 8.921082e-08 1.266919e-07
        Herring 4.095392e-11 6.229396e-11 1.038876e-10 1.582131e-10 2.307276e-10
        Dab     3.112047e-08 4.738873e-08 7.862349e-08 1.197349e-07 1.746209e-07
        Whiting 9.388386e-08 1.403874e-07 2.335865e-07 3.499846e-07 4.970275e-07
        Sole    4.085630e-09 6.305718e-09 1.042349e-08 1.606543e-08 2.388274e-08
        Gurnard 2.465323e-09 3.820514e-09 6.306570e-09 9.753460e-09 1.457686e-08
        Plaice  1.161057e-08 1.800373e-08 2.966993e-08 4.587553e-08 6.853486e-08
        Haddock 2.529393e-09 3.861920e-09 6.409823e-09 9.787656e-09 1.433578e-08
        Cod     3.739926e-08 5.950587e-08 9.781558e-08 1.545602e-07 2.383714e-07
        Saithe  3.153235e-09 5.103577e-09 8.410584e-09 1.347863e-08 2.117674e-08
               w
      predator          97.8          117          139          166          198
        Sprat   7.187272e-15 1.159755e-14 1.894425e-14 3.145916e-14 5.303435e-14
        Sandeel 1.944960e-14 3.194429e-14 5.247547e-14 8.623959e-14 1.418406e-13
        N.pout  2.307808e-07 4.076158e-07 6.761072e-07 1.193192e-06 2.312548e-06
        Herring 4.132465e-10 7.199140e-10 1.188287e-09 2.068637e-09 3.912763e-09
        Dab     3.095225e-07 5.368751e-07 8.861129e-07 1.540935e-06 2.909843e-06
        Whiting 9.053804e-07 1.599125e-06 2.652449e-06 4.681035e-06 9.072397e-06
        Sole    4.143687e-08 7.089189e-08 1.166608e-07 2.006335e-07 3.709637e-07
        Gurnard 2.511701e-08 4.277990e-08 7.032690e-08 1.205312e-07 2.214120e-07
        Plaice  1.176300e-07 1.999237e-07 3.284673e-07 5.625621e-07 1.032768e-06
        Haddock 2.535176e-08 4.388813e-08 7.239522e-08 1.256253e-07 2.362473e-07
        Cod     3.963231e-07 6.575083e-07 1.071790e-06 1.795105e-06 3.159864e-06
        Saithe  3.472563e-08 5.685409e-08 9.206607e-08 1.518626e-07 2.600131e-07
               w
      predator           237          282          337          402          480
        Sprat   9.044937e-14 1.551576e-13 2.661914e-13 4.542233e-13 7.676848e-13
        Sandeel 2.331298e-13 3.835806e-13 6.310147e-13 1.038169e-12 1.708249e-12
        N.pout  3.307434e-06 6.052380e-06 9.676240e-06 1.512722e-05 2.395911e-05
        Herring 5.673267e-09 1.024072e-08 1.641486e-08 2.583874e-08 4.119182e-08
        Dab     4.259211e-06 7.670562e-06 1.234423e-05 1.949465e-05 3.111225e-05
        Whiting 1.297546e-05 2.374420e-05 3.796103e-05 5.934586e-05 9.399441e-05
        Sole    5.547452e-07 9.854740e-07 1.595537e-06 2.541095e-06 4.078687e-06
        Gurnard 3.334680e-07 5.899158e-07 9.571939e-07 1.528792e-06 2.458422e-06
        Plaice  1.560562e-06 2.759708e-06 4.485581e-06 7.174947e-06 1.154635e-05
        Haddock 3.466216e-07 6.227043e-07 1.002446e-06 1.584721e-06 2.531505e-06
        Cod     4.947254e-06 8.532553e-06 1.401249e-05 2.276750e-05 3.707097e-05
        Saithe  4.136283e-07 7.024331e-07 1.159013e-06 1.900577e-06 3.120304e-06
               w
      predator           573          683          816          973         1160
        Sprat   1.280993e-12 2.107371e-12 3.417797e-12 5.471761e-12 8.670640e-12
        Sandeel 2.810323e-12 4.627363e-12 7.618525e-12 1.254181e-11 2.063375e-11
        N.pout  3.543624e-05 6.950271e-05 1.234059e-04 2.068863e-04 2.934613e-04
        Herring 6.195191e-08 1.188783e-07 2.090173e-07 3.494418e-07 5.050089e-07
        Dab     4.691252e-05 8.918093e-05 1.566749e-04 2.625137e-04 3.822989e-04
        Whiting 1.390205e-04 2.726673e-04 4.841356e-04 8.116392e-04 1.151283e-03
        Sole    6.242344e-06 1.155442e-05 2.012281e-05 3.371900e-05 5.022407e-05
        Gurnard 3.779870e-06 6.937523e-06 1.204978e-05 2.019530e-05 3.030088e-05
        Plaice  1.777179e-05 3.251993e-05 5.646291e-05 9.470034e-05 1.424608e-04
        Haddock 3.827189e-06 7.249154e-06 1.271457e-05 2.129360e-05 3.110586e-05
        Cod     5.863099e-05 1.027777e-04 1.756226e-04 2.943833e-04 4.607528e-04
        Saithe  5.019905e-06 8.624546e-06 1.461401e-05 2.447804e-05 3.914866e-05
               w
      predator          1390         1650         1970         2360         2810
        Sprat   1.365279e-11 2.146623e-11 3.388441e-11 5.397227e-11 8.708174e-11
        Sandeel 3.396276e-11 5.588141e-11 9.195329e-11 1.512068e-10 2.486094e-10
        N.pout  5.039982e-04 7.861425e-04 1.309936e-03 1.820034e-03 2.632252e-03
        Herring 8.643947e-07 1.359612e-06 2.264805e-06 3.228543e-06 4.780126e-06
        Dab     6.520727e-04 1.027015e-03 1.706963e-03 2.445018e-03 3.617072e-03
        Whiting 1.977243e-03 3.084126e-03 5.139026e-03 7.140186e-03 1.032659e-02
        Sole    8.512056e-05 1.351064e-04 2.239950e-04 3.286528e-04 4.940998e-04
        Gurnard 5.124708e-05 8.153506e-05 1.350565e-04 1.996033e-04 3.014182e-04
        Plaice  2.406826e-04 3.830870e-04 6.340348e-04 9.383442e-04 1.416229e-03
        Haddock 5.302487e-05 8.362960e-05 1.389950e-04 1.999294e-04 2.968912e-04
        Cod     7.710415e-04 1.244435e-03 2.052510e-03 3.161781e-03 4.901458e-03
        Saithe  6.523506e-05 1.061128e-04 1.747827e-04 2.750327e-04 4.327655e-04
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.425544e-10 2.365613e-10 3.967048e-10 6.693368e-10 1.131045e-09
        Sandeel 4.091819e-10 6.727050e-10 1.106310e-09 1.819326e-09 2.991511e-09
        N.pout  5.911581e-03 8.698930e-03 1.509435e-02 2.595039e-02 4.299055e-02
        Herring 1.023024e-05 1.524316e-05 2.620131e-05 4.467896e-05 7.380160e-05
        Dab     7.621970e-03 1.141983e-02 1.959030e-02 3.340026e-02 5.526621e-02
        Whiting 2.319165e-02 3.412658e-02 5.921579e-02 1.018037e-01 1.686502e-01
        Sole    9.896733e-04 1.506633e-03 2.561554e-03 4.339789e-03 7.178191e-03
        Gurnard 5.942567e-04 9.091900e-04 1.541409e-03 2.606419e-03 4.311109e-03
        Plaice  2.777030e-03 4.254890e-03 7.207329e-03 1.218519e-02 2.016685e-02
        Haddock 6.209160e-04 9.323751e-04 1.597102e-03 2.719359e-03 4.497428e-03
        Cod     8.850785e-03 1.390432e-02 2.316182e-02 3.865466e-02 6.381984e-02
        Saithe  7.495760e-04 1.191290e-03 1.964405e-03 3.249426e-03 5.347739e-03
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.906632e-09 3.197374e-09 5.325897e-09 8.807909e-09 1.446826e-08
        Sandeel 4.916938e-09 8.080437e-09 1.328406e-08 2.182965e-08 3.587939e-08
        N.pout  6.357291e-02 9.321564e-02 1.632055e-01 2.482235e-01 4.249074e-01
        Herring 1.105829e-04 1.649857e-04 2.863428e-04 4.403965e-04 7.487721e-04
        Dab     8.322227e-02 1.244669e-01 2.147924e-01 3.307313e-01 5.602250e-01
        Whiting 2.493894e-01 3.656667e-01 6.402053e-01 9.736698e-01 1.666586e+00
        Sole    1.097713e-02 1.667179e-02 2.841374e-02 4.416860e-02 7.415258e-02
        Gurnard 6.625064e-03 1.010861e-02 1.715976e-02 2.674926e-02 4.477945e-02
        Plaice  3.104507e-02 4.741197e-02 8.034576e-02 1.252860e-01 2.094653e-01
        Haddock 6.787138e-03 1.017905e-02 1.754043e-02 2.705749e-02 4.578286e-02
        Cod     1.007917e-01 1.579666e-01 2.627178e-01 4.162978e-01 6.863961e-01
        Saithe  8.553447e-03 1.359333e-02 2.242040e-02 3.585549e-02 5.876178e-02
               w
      predator         19600        23400        28000        33400        39900
        Sprat   2.362941e-08 3.842439e-08 6.232276e-08 1.010462e-07 1.641817e-07
        Sandeel 5.896318e-08 9.684166e-08 1.590393e-07 2.611684e-07 4.289216e-07
        N.pout  7.052314e-01 9.856093e-01 1.490444e+00 2.508204e+00 4.862703e+00
        Herring 1.239116e-03 1.774036e-03 2.721295e-03 4.557361e-03 8.589036e-03
        Dab     9.261637e-01 1.331831e+00 2.039489e+00 3.397052e+00 6.363021e+00
        Whiting 2.765870e+00 3.865346e+00 5.845262e+00 9.835946e+00 1.906148e+01
        Sole    1.221824e-01 1.796567e-01 2.774094e-01 4.578256e-01 8.336041e-01
        Gurnard 7.370337e-02 1.090948e-01 1.688151e-01 2.777471e-01 5.013042e-01
        Plaice  3.446031e-01 5.107141e-01 7.897086e-01 1.296671e+00 2.334861e+00
        Haddock 7.565296e-02 1.092142e-01 1.676202e-01 2.789834e-01 5.201250e-01
        Cod     1.122648e+00 1.724427e+00 2.703420e+00 4.378201e+00 7.513092e+00
        Saithe  9.584829e-02 1.500038e-01 2.370661e-01 3.816831e-01 6.384816e-01
      
      , , prey = Whiting
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   3.634751e-21 5.627667e-21 4.585496e-21 4.670982e-21 4.761506e-21
        Sandeel 1.115246e-21 1.520182e-21 1.479810e-21 2.073936e-21 2.814419e-21
        N.pout  2.215022e-20 2.837026e-20 3.594160e-20 3.720528e-20 5.762795e-20
        Herring 3.686290e-07 3.554210e-07 3.510226e-07 3.328501e-07 3.146078e-07
        Dab     1.448730e-20 1.881512e-20 2.381194e-20 2.842206e-20 3.644192e-20
        Whiting 5.594320e-20 7.165270e-20 9.077510e-20 9.396666e-20 1.455467e-19
        Sole    1.146480e-21 1.434228e-21 1.748493e-21 2.685023e-21 2.231186e-21
        Gurnard 6.142375e-21 9.454938e-21 1.074295e-20 1.223566e-20 1.836809e-20
        Plaice  1.681855e-21 4.637023e-21 5.513132e-21 6.610986e-21 6.363982e-21
        Haddock 4.649975e-21 7.472115e-21 4.509346e-21 4.040988e-21 1.222434e-20
        Cod     5.848021e-20 6.114600e-20 8.308803e-20 7.409129e-20 1.242912e-19
        Saithe  1.391074e-20 1.637826e-20 1.810031e-20 1.544259e-20 1.669510e-20
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   4.329764e-21 3.998724e-21 2.808121e-21 5.986678e-21 7.074252e-21
        Sandeel 3.015768e-21 3.387040e-21 4.301717e-21 3.918051e-21 5.442428e-21
        N.pout  7.798094e-20 1.136381e-19 1.506427e-19 2.513383e-19 4.505183e-19
        Herring 2.922819e-07 1.399716e-07 1.287572e-20 1.631480e-20 1.366775e-20
        Dab     5.018865e-20 6.166323e-20 7.687242e-20 8.983537e-20 1.337926e-19
        Whiting 1.969508e-19 2.870076e-19 3.804674e-19 6.347870e-19 1.137841e-18
        Sole    6.767364e-21 6.957469e-21 1.178278e-20 9.129409e-21 1.717505e-20
        Gurnard 2.045685e-20 3.152391e-20 3.049913e-20 3.726165e-20 4.463974e-20
        Plaice  1.281487e-20 1.269217e-20 2.086934e-20 2.276732e-20 2.738679e-20
        Haddock 2.036578e-20 2.508423e-20 3.552499e-20 2.564933e-20 4.711866e-20
        Cod     1.138169e-19 1.504774e-19 1.608431e-19 1.703410e-19 1.962825e-19
        Saithe  1.381113e-20 2.306049e-20 2.467450e-20 2.293064e-20 3.851111e-20
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   1.222311e-20 8.379564e-21 9.743872e-21 7.657759e-21 1.814576e-20
        Sandeel 4.587202e-21 7.749915e-21 8.115625e-21 1.028330e-20 5.384277e-21
        N.pout  6.337577e-19 1.529685e-18 2.801282e-18 5.174062e-18 8.105221e-18
        Herring 1.771198e-20 2.720343e-20 3.133584e-20 1.203200e-20 5.543901e-20
        Dab     1.597948e-19 2.932614e-19 4.891855e-19 8.434216e-19 1.270927e-18
        Whiting 1.600636e-18 3.863415e-18 7.074994e-18 1.306775e-17 2.047077e-17
        Sole    1.301897e-20 3.616864e-20 5.718358e-20 1.109748e-19 1.692637e-19
        Gurnard 5.989292e-20 9.552796e-20 1.491291e-19 2.412293e-19 3.879889e-19
        Plaice  4.261359e-20 9.545267e-20 1.707846e-19 3.216974e-19 5.318010e-19
        Haddock 5.719484e-20 1.447997e-19 2.263981e-19 4.463206e-19 6.705426e-19
        Cod     3.875373e-19 6.433534e-19 1.181459e-18 1.961662e-18 3.283890e-18
        Saithe  7.655580e-20 1.498600e-19 2.516307e-19 4.461704e-19 7.852104e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   1.660457e-20 2.739651e-20 2.470320e-20 4.828994e-20 5.633285e-20
        Sandeel 2.232789e-20 1.285983e-20 2.468891e-20 1.137574e-20 1.091983e-20
        N.pout  1.304329e-17 1.832896e-17 2.501372e-17 4.039939e-17 6.619734e-17
        Herring 7.184321e-20 9.195195e-20 7.414412e-20 1.098092e-19 1.405446e-19
        Dab     2.053010e-18 2.906966e-18 4.139034e-18 6.721727e-18 1.102270e-17
        Whiting 3.294249e-17 4.629211e-17 6.317534e-17 1.020338e-16 1.671898e-16
        Sole    2.945917e-19 4.166523e-19 6.375495e-19 1.046518e-18 1.774616e-18
        Gurnard 6.256885e-19 9.162440e-19 1.336332e-18 2.208335e-18 3.594811e-18
        Plaice  8.777776e-19 1.309525e-18 1.947732e-18 3.208114e-18 5.245308e-18
        Haddock 1.180581e-18 1.618788e-18 2.373945e-18 3.839235e-18 6.394024e-18
        Cod     5.543460e-18 8.864549e-18 1.360373e-17 2.251593e-17 3.667826e-17
        Saithe  1.365027e-18 2.214904e-18 3.590481e-18 5.994042e-18 9.832485e-18
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   8.536257e-20 9.906749e-20 7.294905e-20 8.893013e-20 3.283727e-20
        Sandeel 3.522020e-20 3.477464e-20 6.676197e-21 3.076145e-20 3.543436e-20
        N.pout  1.450421e-16 2.648741e-16 4.240512e-16 6.494128e-16 1.178554e-15
        Herring 1.780838e-19 2.237849e-19 4.296326e-19 3.959177e-19 1.026137e-18
        Dab     2.300991e-17 4.149792e-17 6.693273e-17 1.040244e-16 1.865092e-16
        Whiting 3.663222e-16 6.689734e-16 1.070995e-15 1.640175e-15 2.976589e-15
        Sole    3.559961e-18 6.404362e-18 1.042991e-17 1.644945e-17 2.913958e-17
        Gurnard 7.156134e-18 1.274247e-17 2.084789e-17 3.289631e-17 5.824351e-17
        Plaice  1.039045e-17 1.855401e-17 3.031104e-17 4.800649e-17 8.478146e-17
        Haddock 1.324740e-17 2.412967e-17 3.889579e-17 6.070050e-17 1.087190e-16
        Cod     6.719908e-17 1.163698e-16 1.916939e-16 3.094443e-16 5.337743e-16
        Saithe  1.736361e-17 2.965626e-17 4.899884e-17 7.997543e-17 1.361688e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   2.752356e-20 7.398988e-20 4.501429e-20 3.105652e-20 3.983950e-20
        Sandeel 6.122567e-20 0.000000e+00 1.353997e-20 0.000000e+00 1.796607e-19
        N.pout  1.708746e-15 3.201793e-15 5.483914e-15 7.942427e-15 1.318442e-14
        Herring 1.149181e-18 2.344930e-18 3.746746e-18 5.369790e-18 9.191542e-18
        Dab     2.767933e-16 5.088505e-16 8.689580e-16 1.288267e-15 2.138235e-15
        Whiting 4.315655e-15 8.086537e-15 1.385032e-14 2.005961e-14 3.329892e-14
        Sole    4.419104e-17 7.993265e-17 1.361966e-16 2.059769e-16 3.416154e-16
        Gurnard 8.883378e-17 1.597072e-16 2.718402e-16 4.137845e-16 6.858119e-16
        Plaice  1.295931e-16 2.325280e-16 3.958909e-16 6.040398e-16 1.000679e-15
        Haddock 1.618910e-16 2.968376e-16 5.069205e-16 7.531049e-16 1.251040e-15
        Cod     8.431587e-16 1.468202e-15 2.485762e-15 3.928918e-15 6.507876e-15
        Saithe  2.191011e-16 3.754528e-16 6.334120e-16 1.021282e-15 1.694052e-15
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   1.498496e-20 7.767581e-20 3.976683e-20 0.000000e+00 0.000000e+00
        Sandeel 1.241716e-19 4.767806e-20 8.238110e-20 9.489543e-20 1.457477e-19
        N.pout  2.535499e-14 4.844395e-14 8.240763e-14 1.289900e-13 2.440725e-13
        Herring 1.704704e-17 3.183280e-17 5.336805e-17 8.427378e-17 1.573375e-16
        Dab     4.017235e-15 7.540090e-15 1.283248e-14 2.033503e-14 3.792312e-14
        Whiting 6.403727e-14 1.223514e-13 2.081310e-13 3.257808e-13 6.164362e-13
        Sole    6.290540e-16 1.163098e-15 1.982505e-15 3.177746e-15 5.848546e-15
        Gurnard 1.254942e-15 2.308573e-15 3.937490e-15 6.336236e-15 1.161159e-14
        Plaice  1.826378e-15 3.356834e-15 5.732813e-15 9.246670e-15 1.692598e-14
        Haddock 2.343769e-15 4.388018e-15 7.463404e-15 1.183921e-14 2.203643e-14
        Cod     1.146251e-14 2.043947e-14 3.493681e-14 5.755320e-14 1.027778e-13
        Saithe  2.929104e-15 5.127877e-15 8.755729e-15 1.458927e-14 2.567935e-14
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   6.078188e-20 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 2.098599e-19 0.000000e+00 1.113845e-19 6.415236e-20 1.477952e-19
        N.pout  4.454565e-13 6.527883e-13 1.017158e-12 1.862968e-12 3.383422e-12
        Herring 2.849574e-16 4.226734e-16 6.662579e-16 1.211682e-15 2.187066e-15
        Dab     6.871198e-14 1.029992e-13 1.626812e-13 2.943820e-13 5.296953e-13
        Whiting 1.125057e-12 1.648700e-12 2.568963e-12 4.705162e-12 8.545263e-12
        Sole    1.052984e-14 1.611574e-14 2.573434e-14 4.603726e-14 8.214793e-14
        Gurnard 2.086501e-14 3.216463e-14 5.154632e-14 9.185458e-14 1.634443e-13
        Plaice  3.041823e-14 4.705776e-14 7.550168e-14 1.342680e-13 2.386396e-13
        Haddock 3.987613e-14 5.990340e-14 9.477951e-14 1.713394e-13 3.079790e-13
        Cod     1.823245e-13 2.935477e-13 4.815112e-13 8.405538e-13 1.471342e-12
        Saithe  4.516323e-14 7.441965e-14 1.238188e-13 2.143657e-13 3.722528e-13
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   0.000000e+00 0.000000e+00 6.542717e-19 0.000000e+00 0.000000e+00
        Sandeel 8.512322e-20 0.000000e+00 1.129493e-19 0.000000e+00 2.997429e-19
        N.pout  4.804042e-12 7.271836e-12 1.146133e-11 1.720417e-11 2.830128e-11
        Herring 3.164872e-15 4.864114e-15 7.751249e-15 1.184371e-14 1.955069e-14
        Dab     7.729842e-13 1.190100e-12 1.892088e-12 2.887999e-12 4.738124e-12
        Whiting 1.213322e-11 1.836595e-11 2.894704e-11 4.345131e-11 7.147849e-11
        Sole    1.227818e-13 1.915450e-13 3.063376e-13 4.733461e-13 7.743593e-13
        Gurnard 2.462333e-13 3.856811e-13 6.177597e-13 9.578033e-13 1.564733e-12
        Plaice  3.605834e-13 5.650331e-13 9.041329e-13 1.400855e-12 2.282870e-12
        Haddock 4.508372e-13 6.958908e-13 1.108450e-12 1.696906e-12 2.786202e-12
        Cod     2.323746e-12 3.732901e-12 6.046358e-12 9.574129e-12 1.555001e-11
        Saithe  6.031274e-13 9.839239e-13 1.607553e-12 2.579023e-12 4.187957e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   0.000000e+00 0.000000e+00 2.653852e-18 0.000000e+00 0.000000e+00
        Sandeel 2.589572e-19 8.948843e-19 1.145360e-18 2.176926e-18 3.951399e-18
        N.pout  5.085425e-11 7.231893e-11 1.088499e-10 1.620926e-10 2.531574e-10
        Herring 3.470689e-14 5.041864e-14 7.700712e-14 1.166156e-13 1.834981e-13
        Dab     8.350340e-12 1.217444e-11 1.856442e-11 2.804369e-11 4.391104e-11
        Whiting 1.284389e-10 1.826507e-10 2.749143e-10 4.093856e-10 6.393814e-10
        Sole    1.343883e-12 1.999295e-12 3.078782e-12 4.699682e-12 7.371080e-12
        Gurnard 2.701571e-12 4.043001e-12 6.241554e-12 9.551932e-12 1.498014e-11
        Plaice  3.929551e-12 5.883743e-12 9.073225e-12 1.386560e-11 2.169754e-11
        Haddock 4.902237e-12 7.173561e-12 1.096696e-11 1.661546e-11 2.605588e-11
        Cod     2.607597e-11 4.029312e-11 6.305291e-11 9.783362e-11 1.533563e-10
        Saithe  6.928217e-12 1.086753e-11 1.711936e-11 2.674344e-11 4.192830e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   0.000000e+00 0.000000e+00 3.027526e-18 6.974861e-18 1.004300e-17
        Sandeel 7.615256e-18 1.250272e-17 2.113840e-17 3.732696e-17 6.141358e-17
        N.pout  4.353649e-10 6.653364e-10 1.468375e-09 2.026902e-09 2.938349e-09
        Herring 3.116445e-13 4.799631e-13 1.002781e-12 1.410717e-12 2.078312e-12
        Dab     7.410379e-11 1.140248e-10 2.364749e-10 3.355079e-10 4.958595e-10
        Whiting 1.099569e-09 1.680392e-09 3.708567e-09 5.119200e-09 7.421174e-09
        Sole    1.226841e-11 1.898863e-11 3.751844e-11 5.455063e-11 8.189611e-11
        Gurnard 2.482057e-11 3.846891e-11 7.490722e-11 1.097502e-10 1.655340e-10
        Plaice  3.585778e-11 5.552651e-11 1.078516e-10 1.584360e-10 2.392371e-10
        Haddock 4.389938e-11 6.765111e-11 1.390518e-10 1.979417e-10 2.933173e-10
        Cod     2.477382e-10 3.860929e-10 6.900733e-10 1.052225e-09 1.626562e-09
        Saithe  6.690568e-11 1.043957e-10 1.782525e-10 2.761680e-10 4.313806e-10
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   2.159473e-17 3.287072e-17 5.628438e-17 1.049139e-16 1.835398e-16
        Sandeel 1.038508e-16 1.742764e-16 2.905550e-16 4.822314e-16 8.037319e-16
        N.pout  4.825071e-09 8.555698e-09 1.255290e-08 2.228502e-08 3.368746e-08
        Herring 3.400377e-12 5.929787e-12 8.819233e-12 1.540678e-11 2.349920e-11
        Dab     8.094823e-10 1.407813e-09 2.101776e-09 3.661393e-09 5.602362e-09
        Whiting 1.218633e-08 2.160851e-08 3.170394e-08 5.628365e-08 8.508198e-08
        Sole    1.330408e-10 2.278076e-10 3.449709e-10 5.917506e-10 9.145075e-10
        Gurnard 2.685036e-10 4.576531e-10 6.960573e-10 1.188569e-09 1.842621e-09
        Plaice  3.879030e-10 6.608170e-10 1.006522e-09 1.717750e-09 2.666410e-09
        Haddock 4.785152e-10 8.298397e-10 1.241593e-09 2.156913e-09 3.304927e-09
        Cod     2.617462e-09 4.348305e-09 6.775256e-09 1.128645e-08 1.781147e-08
        Saithe  6.915337e-10 1.134243e-09 1.788404e-09 2.945305e-09 4.691181e-09
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   3.194776e-16 5.549409e-16 9.597259e-16 1.625003e-15 2.734055e-15
        Sandeel 1.333563e-15 2.212869e-15 3.662060e-15 6.050769e-15 9.978088e-15
        N.pout  7.712109e-08 1.198531e-07 2.047360e-07 3.561836e-07 6.010393e-07
        Herring 5.118842e-11 7.970359e-11 1.352487e-10 2.335774e-10 3.930086e-10
        Dab     1.211627e-08 1.902243e-08 3.237657e-08 5.603426e-08 9.457361e-08
        Whiting 1.947791e-07 3.027042e-07 5.170869e-07 8.995871e-07 1.518001e-06
        Sole    1.885424e-09 2.990940e-09 5.076262e-09 8.746429e-09 1.476556e-08
        Gurnard 3.744069e-09 5.962235e-09 1.011428e-08 1.740890e-08 2.940281e-08
        Plaice  5.406494e-09 8.636802e-09 1.467349e-08 2.528704e-08 4.277390e-08
        Haddock 7.086409e-09 1.112848e-08 1.891579e-08 3.268993e-08 5.513588e-08
        Cod     3.323017e-08 5.401147e-08 9.129061e-08 1.561117e-07 2.643994e-07
        Saithe  8.363935e-09 1.370315e-08 2.307686e-08 3.927321e-08 6.656041e-08
               w
      predator          97.8          117          139          166          198
        Sprat   4.540608e-15 7.508373e-15 1.233474e-14 2.023329e-14 3.327890e-14
        Sandeel 1.641768e-14 2.696106e-14 4.421236e-14 7.234754e-14 1.182079e-13
        N.pout  8.629296e-07 1.273429e-06 2.216032e-06 3.358901e-06 5.414025e-06
        Herring 5.737247e-10 8.617360e-10 1.494065e-09 2.295495e-09 3.718686e-09
        Dab     1.392084e-07 2.097437e-07 3.614847e-07 5.561137e-07 8.984961e-07
        Whiting 2.179438e-06 3.216207e-06 5.596871e-06 8.483332e-06 1.367381e-05
        Sole    2.220513e-08 3.399425e-08 5.803813e-08 9.030184e-08 1.460538e-07
        Gurnard 4.453613e-08 6.852575e-08 1.166333e-07 1.820912e-07 2.945428e-07
        Plaice  6.500038e-08 1.001554e-07 1.701612e-07 2.657538e-07 4.293931e-07
        Haddock 8.137248e-08 1.229369e-07 2.117357e-07 3.264554e-07 5.279185e-07
        Cod     4.181727e-07 6.641960e-07 1.114997e-06 1.778551e-06 2.884709e-06
        Saithe  1.077533e-07 1.744360e-07 2.919627e-07 4.720593e-07 7.689181e-07
               w
      predator           237          282          337          402          480
        Sprat   5.510748e-14 9.183438e-14 1.540530e-13 2.596351e-13 4.390442e-13
        Sandeel 1.929732e-13 3.147270e-13 5.124771e-13 8.334811e-13 1.354620e-12
        N.pout  1.073743e-05 2.108361e-05 3.271826e-05 4.514525e-05 6.153456e-05
        Herring 7.191190e-09 1.380717e-08 2.152122e-08 3.035053e-08 4.264420e-08
        Dab     1.722721e-06 3.298915e-06 5.179828e-06 7.371881e-06 1.040829e-05
        Whiting 2.711874e-05 5.324933e-05 8.263411e-05 1.140201e-04 1.554134e-04
        Sole    2.723434e-07 5.108610e-07 8.116274e-07 1.186305e-06 1.720945e-06
        Gurnard 5.443586e-07 1.014417e-06 1.618295e-06 2.385846e-06 3.489458e-06
        Plaice  7.909502e-07 1.471926e-06 2.353815e-06 3.480968e-06 5.099289e-06
        Haddock 1.008179e-06 1.923485e-06 3.022685e-06 4.317532e-06 6.125421e-06
        Cod     5.066374e-06 9.047134e-06 1.474847e-05 2.284208e-05 3.501683e-05
        Saithe  1.317316e-06 2.292457e-06 3.766772e-06 5.974807e-06 9.383400e-06
               w
      predator           573          683          816          973         1160
        Sprat   7.433695e-13 1.260232e-12 2.139306e-12 3.639210e-12 6.206536e-12
        Sandeel 2.202270e-12 3.578205e-12 5.816273e-12 9.464619e-12 1.540191e-11
        N.pout  1.118182e-04 1.649910e-04 2.807822e-04 5.959590e-04 9.726942e-04
        Herring 7.660960e-08 1.150450e-07 1.948129e-07 3.982769e-07 6.484294e-07
        Dab     1.850044e-05 2.780762e-05 4.682074e-05 9.487865e-05 1.551599e-04
        Whiting 2.824111e-04 4.167057e-04 7.091510e-04 1.505170e-03 2.456662e-03
        Sole    3.001681e-06 4.575697e-06 7.636075e-06 1.490243e-05 2.444809e-05
        Gurnard 6.049070e-06 9.258407e-06 1.540398e-05 2.970793e-05 4.879608e-05
        Plaice  8.810086e-06 1.348470e-05 2.238730e-05 4.303137e-05 7.077176e-05
        Haddock 1.086861e-05 1.638409e-05 2.756920e-05 5.552934e-05 9.078053e-05
        Cod     5.886225e-05 9.223904e-05 1.511087e-04 2.717485e-04 4.480493e-04
        Saithe  1.558579e-05 2.474384e-05 4.031500e-05 6.991717e-05 1.151347e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   1.061086e-11 1.816578e-11 3.108584e-11 5.304963e-11 9.007092e-11
        Sandeel 2.507701e-11 4.087425e-11 6.665136e-11 1.090184e-10 1.784198e-10
        N.pout  1.481313e-03 2.435229e-03 3.351434e-03 8.605813e-03 1.571625e-02
        Herring 9.952801e-07 1.635902e-06 2.309102e-06 5.609651e-06 1.011368e-05
        Dab     2.394505e-04 3.937845e-04 5.594145e-04 1.336426e-03 2.418740e-03
        Whiting 3.741241e-03 6.150471e-03 8.464459e-03 2.173501e-02 3.969320e-02
        Sole    3.818996e-05 6.282757e-05 9.157958e-05 2.056987e-04 3.698022e-04
        Gurnard 7.652870e-05 1.259212e-04 1.850122e-04 4.075137e-04 7.313223e-04
        Plaice  1.111963e-04 1.830245e-04 2.694972e-04 5.903776e-04 1.061013e-03
        Haddock 1.402860e-04 2.306875e-04 3.290682e-04 7.787731e-04 1.406258e-03
        Cod     7.179250e-04 1.181915e-03 1.816921e-03 3.570116e-03 6.311773e-03
        Saithe  1.861382e-04 3.062301e-04 4.815371e-04 8.912011e-04 1.555180e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.518320e-10 2.537051e-10 4.198006e-10 6.875785e-10 1.114852e-09
        Sandeel 2.921490e-10 4.791518e-10 7.867209e-10 1.293271e-09 2.127440e-09
        N.pout  2.384952e-02 4.050137e-02 6.703726e-02 1.123892e-01 1.734098e-01
        Herring 1.544970e-05 2.620837e-05 4.347533e-05 7.300893e-05 1.138700e-04
        Dab     3.731180e-03 6.341500e-03 1.054443e-02 1.772261e-02 2.774865e-02
        Whiting 6.023453e-02 1.022903e-01 1.693080e-01 2.838454e-01 4.379510e-01
        Sole    5.797376e-04 9.858828e-04 1.645443e-03 2.770234e-03 4.390426e-03
        Gurnard 1.153180e-03 1.961940e-03 3.279228e-03 5.524627e-03 8.791275e-03
        Plaice  1.679347e-03 2.860379e-03 4.786840e-03 8.069711e-03 1.286141e-02
        Haddock 2.171703e-03 3.689683e-03 6.136411e-03 1.031528e-02 1.617837e-02
        Cod     1.029233e-02 1.756426e-02 2.964223e-02 5.022078e-02 8.199691e-02
        Saithe  2.576001e-03 4.401418e-03 7.470987e-03 1.271384e-02 2.108470e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.790560e-09 2.851574e-09 4.509408e-09 7.093428e-09 1.112171e-08
        Sandeel 3.503938e-09 5.775521e-09 9.528597e-09 1.572829e-08 2.599394e-08
        N.pout  2.873443e-01 4.619204e-01 7.633371e-01 1.184209e+00 2.102774e+00
        Herring 1.894549e-04 3.067095e-04 5.086074e-04 7.976465e-04 1.406833e-03
        Dab     4.609947e-02 7.461873e-02 1.234985e-01 1.938365e-01 3.399611e-01
        Whiting 7.256820e-01 1.166545e+00 1.927697e+00 2.990439e+00 5.309628e+00
        Sole    7.302824e-03 1.188045e-02 1.967431e-02 3.116213e-02 5.407021e-02
        Gurnard 1.462772e-02 2.383294e-02 3.946856e-02 6.268352e-02 1.083655e-01
        Plaice  2.139227e-02 3.485162e-02 5.766929e-02 9.159026e-02 1.579874e-01
        Haddock 2.689386e-02 4.358179e-02 7.217453e-02 1.134901e-01 1.988488e-01
        Cod     1.370362e-01 2.257001e-01 3.744207e-01 6.046279e-01 1.024147e+00
        Saithe  3.542251e-02 5.882058e-02 9.789094e-02 1.596903e-01 2.680373e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   1.741885e-08 2.731293e-08 4.296688e-08 6.793607e-08 1.081059e-07
        Sandeel 4.294505e-08 7.102011e-08 1.174844e-07 1.944169e-07 3.222002e-07
        N.pout  2.872911e+00 4.531747e+00 6.737775e+00 9.851966e+00 2.055725e+01
        Herring 1.975426e-03 3.146881e-03 4.768238e-03 7.133537e-03 1.429790e-02
        Dab     4.805037e-01 7.625885e-01 1.153547e+00 1.720897e+00 3.402771e+00
        Whiting 7.253710e+00 1.144161e+01 1.701151e+01 2.487219e+01 5.187783e+01
        Sole    7.853776e-02 1.250899e-01 1.915011e-01 2.895400e-01 5.487961e-01
        Gurnard 1.587238e-01 2.529683e-01 3.884794e-01 5.893148e-01 1.102278e+00
        Plaice  2.318116e-01 3.688601e-01 5.658260e-01 8.569637e-01 1.594862e+00
        Haddock 2.823284e-01 4.488277e-01 6.810454e-01 1.019805e+00 2.004055e+00
        Cod     1.572875e+00 2.519362e+00 3.939118e+00 6.089050e+00 1.058201e+01
        Saithe  4.216315e-01 6.781801e-01 1.071010e+00 1.672958e+00 2.808303e+00
      
      , , prey = Sole
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   8.576624e-22 1.790054e-21 1.645782e-21 2.674591e-21 1.723256e-21
        Sandeel 1.601938e-22 2.832299e-22 2.273896e-22 3.815095e-22 2.361298e-22
        N.pout  9.979386e-22 1.108161e-21 1.494982e-21 1.628420e-21 2.652456e-21
        Herring 1.021014e-07 1.000226e-07 9.473179e-08 9.278005e-08 8.793232e-08
        Dab     1.581981e-20 2.119220e-20 2.275882e-20 2.988606e-20 3.608499e-20
        Whiting 1.220379e-20 1.355170e-20 1.828214e-20 1.991395e-20 3.243688e-20
        Sole    9.483459e-21 1.154137e-20 1.402215e-20 1.621281e-20 2.859501e-20
        Gurnard 2.410299e-21 2.320455e-21 3.493990e-21 3.867081e-21 5.293511e-21
        Plaice  9.641548e-21 9.059800e-21 1.271739e-20 1.272893e-20 1.948748e-20
        Haddock 9.727427e-22 9.002879e-22 1.394949e-21 1.404511e-21 2.424264e-21
        Cod     3.655227e-20 3.397040e-20 4.804351e-20 4.443332e-20 6.434191e-20
        Saithe  1.463688e-21 1.568660e-21 1.548642e-21 1.498257e-21 1.721966e-21
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   2.549886e-21 2.727458e-21 3.911492e-21 4.509065e-21 5.321811e-21
        Sandeel 6.195549e-22 2.088791e-22 5.213204e-22 1.016253e-21 1.330261e-21
        N.pout  3.112964e-21 6.939750e-21 1.174822e-20 2.310817e-20 3.668034e-20
        Herring 7.481110e-08 6.645694e-08 3.102789e-21 1.985626e-21 1.829806e-21
        Dab     5.114435e-20 6.370221e-20 9.395561e-20 1.221941e-19 1.767145e-19
        Whiting 3.806844e-20 8.486621e-20 1.436690e-19 2.825899e-19 4.485640e-19
        Sole    2.974828e-20 4.555835e-20 5.344593e-20 7.188399e-20 9.698962e-20
        Gurnard 6.101475e-21 8.477458e-21 1.014298e-20 1.298387e-20 1.663628e-20
        Plaice  1.965040e-20 3.050956e-20 3.592100e-20 5.493137e-20 7.228854e-20
        Haddock 2.220923e-21 3.931252e-21 4.607312e-21 6.802773e-21 8.436151e-21
        Cod     6.150053e-20 8.606960e-20 9.571954e-20 1.381008e-19 1.796888e-19
        Saithe  2.237518e-21 1.799668e-21 3.338601e-21 4.027812e-21 7.199222e-21
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   7.161455e-21 6.174481e-21 5.632803e-21 4.445671e-21 8.190227e-21
        Sandeel 8.581092e-22 1.412090e-21 2.602555e-21 3.560011e-21 4.316636e-21
        N.pout  7.609453e-20 1.394859e-19 2.283447e-19 4.076000e-19 8.398171e-19
        Herring 3.161652e-21 4.855909e-21 5.593559e-21 8.054081e-21 1.669961e-20
        Dab     2.805129e-19 5.012957e-19 7.602429e-19 1.336903e-18 2.601669e-18
        Whiting 9.305601e-19 1.705773e-18 2.792427e-18 4.984541e-18 1.027012e-17
        Sole    1.490681e-19 2.387994e-19 3.891123e-19 6.579128e-19 1.280735e-18
        Gurnard 2.658393e-20 4.162635e-20 6.130247e-20 1.042197e-19 1.987864e-19
        Plaice  1.368355e-19 2.176645e-19 3.689946e-19 6.398917e-19 1.283607e-18
        Haddock 1.443996e-20 2.320556e-20 3.565978e-20 6.035766e-20 1.199079e-19
        Cod     3.332871e-19 5.558512e-19 9.526411e-19 1.678601e-18 3.236505e-18
        Saithe  1.340798e-20 2.561444e-20 4.467180e-20 8.060950e-20 1.543814e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   5.269603e-21 1.634203e-20 1.783390e-20 2.610653e-20 2.526343e-20
        Sandeel 1.988946e-21 4.582166e-21 7.917349e-21 3.040019e-21 3.501821e-21
        N.pout  1.327233e-18 1.877419e-18 2.738619e-18 4.407110e-18 6.304736e-18
        Herring 1.709903e-20 3.200682e-20 3.119676e-20 4.246957e-20 6.021050e-20
        Dab     4.168258e-18 6.017871e-18 8.991573e-18 1.460208e-17 2.150477e-17
        Whiting 1.623073e-17 2.295895e-17 3.349058e-17 5.389456e-17 7.710063e-17
        Sole    2.063950e-18 3.058712e-18 4.636490e-18 7.632634e-18 1.143817e-17
        Gurnard 3.198983e-19 4.762843e-19 7.264936e-19 1.189492e-18 1.798946e-18
        Plaice  2.099461e-18 3.186897e-18 4.896657e-18 8.032286e-18 1.215599e-17
        Haddock 1.889522e-19 2.744569e-19 4.081432e-19 6.629599e-19 9.752807e-19
        Cod     5.455734e-18 8.749841e-18 1.405507e-17 2.338168e-17 3.676744e-17
        Saithe  2.723599e-19 4.525574e-19 7.544983e-19 1.273713e-18 2.059805e-18
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   4.363523e-20 5.570396e-20 5.380158e-20 5.224755e-20 4.356208e-20
        Sandeel 1.008444e-20 1.161634e-20 0.000000e+00 2.774453e-20 1.775508e-20
        N.pout  1.045420e-17 1.922971e-17 3.100795e-17 4.495548e-17 6.979877e-17
        Herring 9.103100e-20 1.497990e-19 2.300729e-19 3.379040e-19 5.113469e-19
        Dab     3.553846e-17 6.402855e-17 1.035011e-16 1.533936e-16 2.399329e-16
        Whiting 1.278444e-16 2.351601e-16 3.791963e-16 5.497606e-16 8.535693e-16
        Sole    1.891320e-17 3.341642e-17 5.433574e-17 8.186345e-17 1.289558e-16
        Gurnard 2.953326e-18 5.198472e-18 8.439728e-18 1.279281e-17 2.016733e-17
        Plaice  1.996735e-17 3.497792e-17 5.673631e-17 8.605600e-17 1.353610e-16
        Haddock 1.612801e-18 2.899991e-18 4.694879e-18 6.975157e-18 1.093384e-17
        Cod     6.043218e-17 1.025902e-16 1.667705e-16 2.597876e-16 4.116749e-16
        Saithe  3.392203e-18 5.687970e-18 9.244895e-18 1.459418e-17 2.317312e-17
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   3.572288e-20 6.522903e-20 5.016089e-20 9.831116e-20 6.849520e-20
        Sandeel 1.227133e-20 5.654175e-20 1.628272e-20 6.252064e-21 0.000000e+00
        N.pout  9.590652e-17 1.438314e-16 2.229965e-16 4.162887e-16 5.710744e-16
        Herring 7.121043e-19 1.043070e-18 1.621470e-18 2.902455e-18 4.148244e-18
        Dab     3.406494e-16 5.168699e-16 8.033123e-16 1.441262e-15 2.036553e-15
        Whiting 1.172841e-15 1.758915e-15 2.727025e-15 5.090796e-15 6.983670e-15
        Sole    1.873555e-16 2.868126e-16 4.461866e-16 7.783847e-16 1.125192e-15
        Gurnard 2.951358e-17 4.523788e-17 7.037327e-17 1.216476e-16 1.769514e-16
        Plaice  1.980704e-16 3.026552e-16 4.694614e-16 8.085233e-16 1.175825e-15
        Haddock 1.560007e-17 2.374187e-17 3.696516e-17 6.602879e-17 9.373655e-17
        Cod     6.236383e-16 9.633871e-16 1.495114e-15 2.460812e-15 3.690053e-15
        Saithe  3.566405e-17 5.530347e-17 8.579107e-17 1.379126e-16 2.093659e-16
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   1.683203e-19 1.502644e-19 0.000000e+00 7.718110e-20 1.778110e-19
        Sandeel 4.147906e-20 6.689207e-20 8.806114e-20 7.607873e-20 1.168476e-19
        N.pout  7.889704e-16 1.107591e-15 2.134878e-15 7.001686e-15 1.114158e-14
        Herring 5.866014e-18 8.461787e-18 1.540152e-17 4.433920e-17 7.006679e-17
        Dab     2.894843e-15 4.163334e-15 7.580272e-15 2.191373e-14 3.507926e-14
        Whiting 9.648320e-15 1.354474e-14 2.610743e-14 8.562363e-14 1.362503e-13
        Sole    1.632453e-15 2.385857e-15 4.176910e-15 1.091223e-14 1.762840e-14
        Gurnard 2.580458e-16 3.784992e-16 6.551434e-16 1.661390e-15 2.694371e-15
        Plaice  1.711972e-15 2.505030e-15 4.322375e-15 1.095701e-14 1.786268e-14
        Haddock 1.339350e-16 1.935597e-16 3.499564e-16 9.903951e-16 1.583402e-15
        Cod     5.517208e-15 8.237702e-15 1.343661e-14 2.842159e-14 4.685137e-14
        Saithe  3.164204e-16 4.765752e-16 7.571915e-16 1.445483e-15 2.381043e-15
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   2.730959e-19 3.145813e-19 2.717764e-19 0.000000e+00 1.202060e-18
        Sandeel 1.177729e-19 9.690254e-20 1.339474e-19 7.714750e-20 2.666004e-19
        N.pout  1.661722e-14 2.650830e-14 5.715127e-14 9.395778e-14 1.728755e-13
        Herring 1.051912e-16 1.676144e-16 3.512224e-16 5.766312e-16 1.051951e-15
        Dab     5.317208e-14 8.544220e-14 1.782973e-13 2.951086e-13 5.392808e-13
        Whiting 2.032121e-13 3.241700e-13 6.989030e-13 1.149010e-12 2.114095e-12
        Sole    2.716534e-14 4.393805e-14 8.891759e-14 1.481651e-13 2.689112e-13
        Gurnard 4.177454e-15 6.774852e-15 1.358233e-14 2.269878e-14 4.112417e-14
        Plaice  2.783252e-14 4.528505e-14 9.074878e-14 1.522040e-13 2.760956e-13
        Haddock 2.401581e-15 3.858493e-15 8.007991e-15 1.324865e-14 2.416805e-14
        Cod     7.510830e-14 1.237970e-13 2.348007e-13 3.996437e-13 7.173089e-13
        Saithe  3.865968e-15 6.416818e-15 1.179907e-14 2.027785e-14 3.624128e-14
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   5.538647e-19 0.000000e+00 1.469837e-18 2.116396e-18 4.875785e-19
        Sandeel 1.364885e-19 1.179166e-19 1.358291e-19 7.301586e-19 4.205377e-19
        N.pout  2.669491e-13 3.730756e-13 5.891237e-13 9.093787e-13 1.229586e-12
        Herring 1.637473e-15 2.337413e-15 3.736724e-15 5.855725e-15 8.202380e-15
        Dab     8.462150e-13 1.219949e-12 1.948156e-12 3.049384e-12 4.286736e-12
        Whiting 3.264520e-12 4.562342e-12 7.204395e-12 1.112079e-11 1.503661e-11
        Sole    4.281946e-13 6.337623e-13 1.019471e-12 1.611068e-12 2.330185e-12
        Gurnard 6.583859e-14 9.831851e-14 1.585139e-13 2.512081e-13 3.664107e-13
        Plaice  4.436268e-13 6.651132e-13 1.072372e-12 1.698977e-12 2.480399e-12
        Haddock 3.796535e-14 5.491530e-14 8.785649e-14 1.378445e-13 1.948554e-13
        Cod     1.189284e-12 1.878602e-12 3.085410e-12 4.992520e-12 7.659938e-12
        Saithe  6.138008e-14 1.002883e-13 1.672975e-13 2.751092e-13 4.347873e-13
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   5.616455e-19 0.000000e+00 0.000000e+00 0.000000e+00 9.888563e-19
        Sandeel 6.920295e-19 8.768696e-19 1.882409e-18 2.697230e-18 4.447217e-18
        N.pout  2.116398e-12 3.292249e-12 4.454697e-12 6.353357e-12 9.960275e-12
        Herring 1.409858e-14 2.218007e-14 3.112547e-14 4.571704e-14 7.220247e-14
        Dab     7.284691e-12 1.141547e-11 1.602576e-11 2.340947e-11 3.662008e-11
        Whiting 2.588143e-11 4.026092e-11 5.447650e-11 7.769521e-11 1.218042e-10
        Sole    3.914648e-12 6.164983e-12 8.886125e-12 1.318670e-11 2.059149e-11
        Gurnard 6.130275e-13 9.663442e-13 1.402858e-12 2.089291e-12 3.257610e-12
        Plaice  4.132365e-12 6.499724e-12 9.426712e-12 1.399744e-11 2.172985e-11
        Haddock 3.311720e-13 5.200769e-13 7.344874e-13 1.078254e-12 1.689902e-12
        Cod     1.258758e-11 1.997741e-11 3.015378e-11 4.579934e-11 7.086477e-11
        Saithe  7.124500e-13 1.137513e-12 1.750948e-12 2.687378e-12 4.147640e-12
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   0.000000e+00 4.592368e-18 3.778560e-18 1.001087e-17 1.604397e-17
        Sandeel 7.403476e-18 1.192320e-17 1.913509e-17 3.137345e-17 5.074949e-17
        N.pout  1.489230e-11 2.571075e-11 5.246013e-11 1.076462e-10 1.755706e-10
        Herring 1.096255e-13 1.853882e-13 3.581567e-13 7.014139e-13 1.133941e-12
        Dab     5.521487e-11 9.260398e-11 1.780432e-10 3.492179e-10 5.689824e-10
        Whiting 1.821180e-10 3.144168e-10 6.415351e-10 1.316406e-09 2.147054e-09
        Sole    3.123402e-11 5.140017e-11 9.473338e-11 1.795347e-10 2.930484e-10
        Gurnard 4.944693e-12 8.087659e-12 1.472093e-11 2.761747e-11 4.512767e-11
        Plaice  3.286141e-11 5.353703e-11 9.721691e-11 1.824685e-10 2.990385e-10
        Haddock 2.555847e-12 4.276403e-12 8.153957e-12 1.586844e-11 2.581552e-11
        Cod     1.077807e-10 1.702669e-10 2.877644e-10 5.047927e-10 8.242542e-10
        Saithe  6.309099e-12 9.792235e-12 1.589120e-11 2.668459e-11 4.317002e-11
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   3.060944e-17 5.006148e-17 9.272573e-17 1.752238e-16 3.223366e-16
        Sandeel 8.233323e-17 1.347191e-16 2.194860e-16 3.572434e-16 5.835331e-16
        N.pout  2.446682e-10 4.643236e-10 6.658043e-10 9.745923e-10 1.469451e-09
        Herring 1.605954e-12 2.976912e-12 4.332110e-12 6.445144e-12 9.855592e-12
        Dab     8.135796e-10 1.505439e-09 2.208372e-09 3.297746e-09 5.042976e-09
        Whiting 2.992047e-09 5.678215e-09 8.142122e-09 1.191829e-08 1.796992e-08
        Sole    4.289773e-10 7.767065e-10 1.162073e-09 1.762178e-09 2.720636e-09
        Gurnard 6.656547e-11 1.197685e-10 1.803691e-10 2.748523e-10 4.255792e-10
        Plaice  4.427192e-10 7.970485e-10 1.204540e-09 1.839356e-09 2.850190e-09
        Haddock 3.701371e-11 6.818686e-11 1.002527e-10 1.500615e-10 2.299343e-10
        Cod     1.265987e-09 2.196225e-09 3.434930e-09 5.394980e-09 8.525409e-09
        Saithe  6.735518e-11 1.144522e-10 1.824694e-10 2.918469e-10 4.682089e-10
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   5.728388e-16 1.027438e-15 1.795038e-15 3.086221e-15 5.210311e-15
        Sandeel 9.515463e-16 1.555137e-15 2.538602e-15 4.143210e-15 6.767424e-15
        N.pout  1.981688e-09 3.590747e-09 5.138650e-09 7.198072e-09 2.091539e-08
        Herring 1.377735e-11 2.450213e-11 3.587229e-11 5.175384e-11 1.353044e-10
        Dab     7.062090e-09 1.243322e-08 1.820478e-08 2.621146e-08 6.755995e-08
        Whiting 2.423407e-08 4.391125e-08 6.284056e-08 8.802523e-08 2.557743e-07
        Sole    3.912440e-09 6.729188e-09 1.001543e-08 1.469188e-08 3.452969e-08
        Gurnard 6.166738e-10 1.053173e-09 1.574607e-09 2.321050e-09 5.307286e-09
        Plaice  4.133980e-09 7.038339e-09 1.052089e-08 1.549123e-08 3.522611e-08
        Haddock 3.237534e-10 5.683439e-10 8.352090e-10 1.208212e-09 3.062390e-09
        Cod     1.292748e-08 2.137233e-08 3.282677e-08 4.976333e-08 9.736521e-08
        Saithe  7.297297e-10 1.196255e-09 1.868361e-09 2.879413e-09 5.211462e-09
               w
      predator          97.8          117          139          166          198
        Sprat   8.642621e-15 1.408483e-14 2.260436e-14 3.581018e-14 5.614595e-14
        Sandeel 1.103623e-14 1.798325e-14 2.929580e-14 4.767758e-14 7.746384e-14
        N.pout  2.945022e-08 4.325650e-08 9.018867e-08 1.764614e-07 2.649355e-07
        Herring 1.930493e-10 2.869089e-10 5.764608e-10 1.100919e-09 1.663446e-09
        Dab     9.740561e-08 1.455675e-07 2.910177e-07 5.566156e-07 8.496618e-07
        Whiting 3.601468e-07 5.289839e-07 1.102917e-06 2.157946e-06 3.239897e-06
        Sole    5.091649e-08 7.725077e-08 1.491310e-07 2.798432e-07 4.341783e-07
        Gurnard 7.884084e-09 1.201909e-08 2.295793e-08 4.283835e-08 6.685449e-08
        Plaice  5.249948e-08 8.017683e-08 1.529245e-07 2.855768e-07 4.474650e-07
        Haddock 4.425927e-09 6.627459e-09 1.316555e-08 2.507172e-08 3.831056e-08
        Cod     1.503310e-07 2.349159e-07 4.210492e-07 7.561028e-07 1.219259e-06
        Saithe  8.164370e-09 1.286823e-08 2.222837e-08 3.884667e-08 6.349040e-08
               w
      predator           237          282          337          402          480
        Sprat   8.740202e-14 1.354404e-13 2.094676e-13 3.238544e-13 5.014023e-13
        Sandeel 1.256884e-13 2.036933e-13 3.300168e-13 5.344583e-13 8.637457e-13
        N.pout  3.755806e-07 5.480389e-07 1.171993e-06 2.585114e-06 3.609865e-06
        Herring 2.400051e-09 3.569097e-09 7.401555e-09 1.584175e-08 2.243521e-08
        Dab     1.236755e-06 1.845465e-06 3.779118e-06 8.045666e-06 1.155373e-05
        Whiting 4.592976e-06 6.701969e-06 1.433230e-05 3.161336e-05 4.414504e-05
        Sole    6.465663e-07 9.814384e-07 1.934944e-06 3.991440e-06 5.888137e-06
        Gurnard 1.003185e-07 1.530990e-07 2.982468e-07 6.090243e-07 9.069947e-07
        Plaice  6.738374e-07 1.030123e-06 1.999028e-06 4.073982e-06 6.098502e-06
        Haddock 5.592002e-08 8.368288e-08 1.704655e-07 3.609987e-07 5.196633e-07
        Cod     1.913478e-06 3.019787e-06 5.509998e-06 1.055586e-05 1.663566e-05
        Saithe  1.019443e-07 1.640811e-07 2.906256e-07 5.368203e-07 8.716317e-07
               w
      predator           573          683          816          973         1160
        Sprat   7.785128e-13 1.215405e-12 1.914691e-12 3.058370e-12 4.976502e-12
        Sandeel 1.395787e-12 2.254418e-12 3.639038e-12 5.875129e-12 9.486869e-12
        N.pout  6.151027e-06 1.009179e-05 1.462134e-05 2.282394e-05 3.473295e-05
        Herring 3.819867e-08 6.288366e-08 9.277671e-08 1.465864e-07 2.265943e-07
        Dab     1.968690e-05 3.247671e-05 4.822029e-05 7.613172e-05 1.175965e-04
        Whiting 7.522091e-05 1.234124e-04 1.788043e-04 2.791139e-04 4.247491e-04
        Sole    1.002875e-05 1.661745e-05 2.518090e-05 4.007704e-05 6.257234e-05
        Gurnard 1.544883e-06 2.563956e-06 3.911206e-06 6.239756e-06 9.772135e-06
        Plaice  1.039393e-05 1.726704e-05 2.640194e-05 4.211428e-05 6.593098e-05
        Haddock 8.852319e-07 1.461010e-06 2.175604e-06 3.441521e-06 5.329523e-06
        Cod     2.837766e-05 4.760894e-05 7.564239e-05 1.227143e-04 1.961178e-04
        Saithe  1.489520e-06 2.516194e-06 4.090803e-06 6.715142e-06 1.087715e-05
               w
      predator          1390         1650         1970         2360         2810
        Sprat   8.275937e-12 1.406750e-11 2.435673e-11 4.268440e-11 7.513957e-11
        Sandeel 1.533630e-11 2.479579e-11 4.013964e-11 6.508230e-11 1.056067e-10
        N.pout  6.491985e-05 9.445870e-05 1.517126e-04 2.730102e-04 3.904621e-04
        Herring 4.177180e-07 6.189445e-07 9.992961e-07 1.775415e-06 2.589369e-06
        Dab     2.146608e-04 3.192244e-04 5.139057e-04 9.075186e-04 1.329162e-03
        Whiting 7.939042e-04 1.155134e-03 1.855291e-03 3.338632e-03 4.774939e-03
        Sole    1.119584e-04 1.694730e-04 2.732348e-04 4.753110e-04 7.098997e-04
        Gurnard 1.736945e-05 2.643362e-05 4.262272e-05 7.377822e-05 1.108375e-04
        Plaice  1.167639e-04 1.778260e-04 2.863247e-04 4.943688e-04 7.433343e-04
        Haddock 9.708644e-06 1.448273e-05 2.333944e-05 4.113977e-05 6.045684e-05
        Cod     3.364379e-04 5.278864e-04 8.522967e-04 1.433607e-03 2.222941e-03
        Saithe  1.838460e-05 2.931118e-05 4.741203e-05 7.861769e-05 1.236831e-04
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.318985e-10 2.294768e-10 3.939153e-10 6.651603e-10 1.102979e-09
        Sandeel 1.718231e-10 2.798528e-10 4.570544e-10 7.469863e-10 1.224596e-09
        N.pout  8.081681e-04 1.286923e-03 2.591347e-03 3.737295e-03 7.393289e-03
        Herring 5.183621e-06 8.265964e-06 1.622549e-05 2.370179e-05 4.598039e-05
        Dab     2.634937e-03 4.218291e-03 8.246703e-03 1.216512e-02 2.348322e-02
        Whiting 9.883011e-03 1.573762e-02 3.168899e-02 4.570214e-02 9.040891e-02
        Sole    1.359023e-03 2.188267e-03 4.173000e-03 6.286844e-03 1.187597e-02
        Gurnard 2.098508e-04 3.385457e-04 6.405551e-04 9.719231e-04 1.823439e-03
        Plaice  1.402391e-03 2.264882e-03 4.279644e-03 6.516178e-03 1.220964e-02
        Haddock 1.192120e-04 1.909141e-04 3.716010e-04 5.493758e-04 1.056770e-03
        Cod     3.944379e-03 6.414745e-03 1.154689e-02 1.823100e-02 3.281050e-02
        Saithe  2.120792e-04 3.451193e-04 6.026198e-04 9.684622e-04 1.701786e-03
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.794915e-09 2.867359e-09 4.501977e-09 6.962348e-09 1.064073e-08
        Sandeel 2.010900e-09 3.307194e-09 5.449448e-09 8.987878e-09 1.484267e-08
        N.pout  1.307695e-02 2.151200e-02 3.660688e-02 5.457951e-02 8.070312e-02
        Herring 8.074017e-05 1.329452e-04 2.260811e-04 3.416500e-04 5.143276e-04
        Dab     4.132945e-02 6.837531e-02 1.164849e-01 1.772174e-01 2.677801e-01
        Whiting 1.599087e-01 2.630492e-01 4.476173e-01 6.673567e-01 9.866963e-01
        Sole    2.081883e-02 3.463136e-02 5.904081e-02 9.139441e-02 1.404614e-01
        Gurnard 3.193424e-03 5.323553e-03 9.080098e-03 1.413879e-02 2.184748e-02
        Plaice  2.140752e-02 3.576112e-02 6.106105e-02 9.533562e-02 1.475445e-01
        Haddock 1.857294e-03 3.072775e-03 5.233275e-03 7.978719e-03 1.208983e-02
        Cod     5.703201e-02 9.626715e-02 1.647814e-01 2.660971e-01 4.255590e-01
        Saithe  2.939076e-03 4.989607e-03 8.560690e-03 1.411743e-02 2.306172e-02
               w
      predator         19600        23400        28000        33400        39900
        Sprat   1.614474e-08 2.446064e-08 3.725804e-08 5.744658e-08 9.015888e-08
        Sandeel 2.454886e-08 4.061744e-08 6.726143e-08 1.114719e-07 1.847680e-07
        N.pout  1.313311e-01 1.811751e-01 2.602265e-01 4.071582e-01 5.785640e-01
        Herring 8.435147e-04 1.199741e-03 1.773658e-03 2.814031e-03 4.125546e-03
        Dab     4.376051e-01 6.247422e-01 9.212933e-01 1.449792e+00 2.116195e+00
        Whiting 1.605563e+00 2.214837e+00 3.181263e+00 4.977095e+00 7.069519e+00
        Sole    2.299171e-01 3.367102e-01 5.052072e-01 7.964945e-01 1.182576e+00
        Gurnard 3.577154e-02 5.278704e-02 7.956858e-02 1.254161e-01 1.869659e-01
        Plaice  2.413283e-01 3.564985e-01 5.367293e-01 8.432079e-01 1.253935e+00
        Haddock 1.978052e-02 2.837533e-02 4.203343e-02 6.630392e-02 9.726865e-02
        Cod     7.006497e-01 1.082104e+00 1.678924e+00 2.652427e+00 4.047373e+00
        Saithe  3.825336e-02 6.066475e-02 9.590594e-02 1.524302e-01 2.358841e-01
      
      , , prey = Gurnard
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   7.472244e-22 7.825860e-22 7.575369e-22 9.128325e-22 7.648501e-22
        Sandeel 8.157561e-23 0.000000e+00 9.348172e-23 0.000000e+00 2.872508e-22
        N.pout  1.130587e-20 1.362536e-20 1.949966e-20 3.020600e-20 4.886258e-20
        Herring 9.785953e-08 9.335506e-08 7.934139e-08 7.722633e-08 7.300308e-08
        Dab     2.753486e-21 5.174915e-21 5.678743e-21 8.241353e-21 1.164772e-20
        Whiting 1.463036e-20 1.763189e-20 2.523353e-20 3.908806e-20 6.323060e-20
        Sole    8.602707e-24 0.000000e+00 1.334554e-22 2.959234e-22 9.906084e-22
        Gurnard 3.140622e-21 4.217462e-21 8.855303e-21 1.085207e-20 1.679782e-20
        Plaice  1.025593e-21 1.482881e-21 1.837126e-21 1.704039e-21 3.120102e-21
        Haddock 8.727863e-22 0.000000e+00 2.135231e-21 5.882664e-22 6.284960e-21
        Cod     2.234456e-20 2.092279e-20 2.526187e-20 2.973054e-20 4.501681e-20
        Saithe  6.044865e-21 7.527889e-21 7.901945e-21 9.194499e-21 8.826331e-21
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   5.781700e-22 9.384966e-22 8.000762e-22 3.941550e-22 9.445662e-23
        Sandeel 8.272160e-23 1.732503e-22 5.987051e-23 3.218381e-22 1.059222e-22
        N.pout  7.051187e-20 1.042903e-19 2.266828e-19 3.929126e-19 5.510520e-19
        Herring 6.427818e-08 3.117913e-08 0.000000e+00 0.000000e+00 2.515178e-21
        Dab     1.698354e-20 2.192360e-20 3.793436e-20 5.206832e-20 7.003514e-20
        Whiting 9.124585e-20 1.349567e-19 2.933388e-19 5.084483e-19 7.130885e-19
        Sole    1.359291e-21 2.721697e-21 4.176450e-21 5.405671e-21 7.708469e-21
        Gurnard 1.945013e-20 3.195775e-20 4.798904e-20 6.230600e-20 8.513198e-20
        Plaice  3.882033e-21 6.131523e-21 9.559086e-21 1.566151e-20 2.117907e-20
        Haddock 4.324221e-21 1.567401e-20 2.075293e-20 3.719147e-20 4.399763e-20
        Cod     4.413725e-20 6.393075e-20 9.508556e-20 1.408993e-19 1.924693e-19
        Saithe  8.619732e-21 1.520798e-20 2.399769e-20 3.764114e-20 6.437520e-20
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 1.220126e-21 7.027365e-22 9.713852e-22 1.118946e-21 6.444614e-22
        N.pout  1.017638e-18 1.520039e-18 2.712886e-18 5.235085e-18 1.038334e-17
        Herring 2.172940e-21 4.171710e-21 9.610851e-22 6.642488e-21 1.020205e-20
        Dab     1.168306e-19 1.715252e-19 2.906787e-19 5.352175e-19 1.034888e-18
        Whiting 1.316875e-18 1.967006e-18 3.510609e-18 6.774459e-18 1.343655e-17
        Sole    1.306813e-20 2.007267e-20 3.496420e-20 6.560670e-20 1.282093e-19
        Gurnard 1.398690e-19 2.010559e-19 3.218764e-19 5.969996e-19 1.112586e-18
        Plaice  4.028403e-20 5.815524e-20 1.055604e-19 1.921189e-19 3.734715e-19
        Haddock 8.691907e-20 1.258024e-19 2.287510e-19 4.217681e-19 8.230503e-19
        Cod     3.484364e-19 5.461350e-19 9.675548e-19 1.705127e-18 3.178377e-18
        Saithe  1.195275e-19 1.988854e-19 3.576926e-19 6.153526e-19 1.157779e-18
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 2.278417e-21 5.854262e-21
        Sandeel 0.000000e+00 3.420522e-21 3.283438e-21 0.000000e+00 0.000000e+00
        N.pout  1.625744e-17 2.612686e-17 3.996000e-17 5.500081e-17 7.855595e-17
        Herring 7.344885e-21 1.015276e-20 1.949173e-20 8.981071e-21 2.586341e-20
        Dab     1.631876e-18 2.635417e-18 4.102665e-18 5.853632e-18 8.594549e-18
        Whiting 2.103794e-17 3.380945e-17 5.171022e-17 7.117377e-17 1.016553e-16
        Sole    2.066630e-19 3.374080e-19 5.362636e-19 7.884305e-19 1.187384e-18
        Gurnard 1.792381e-18 2.922332e-18 4.627501e-18 6.859380e-18 1.035263e-17
        Plaice  6.022901e-19 9.991597e-19 1.589221e-18 2.370648e-18 3.570968e-18
        Haddock 1.301818e-18 2.118412e-18 3.278012e-18 4.726975e-18 6.958091e-18
        Cod     5.287275e-18 8.859624e-18 1.449831e-17 2.270082e-17 3.549402e-17
        Saithe  1.970910e-18 3.360441e-18 5.596374e-18 9.058369e-18 1.449512e-17
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   1.306662e-20 1.726009e-20 1.433260e-20 8.758294e-21 0.000000e+00
        Sandeel 4.014875e-21 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  1.234312e-16 2.245221e-16 3.144619e-16 6.997879e-16 1.097294e-15
        Herring 6.554299e-20 1.029538e-19 1.344058e-19 3.551823e-19 6.084606e-19
        Dab     1.362986e-17 2.419648e-17 3.486715e-17 7.294453e-17 1.151946e-16
        Whiting 1.597261e-16 2.905427e-16 4.069293e-16 9.055601e-16 1.419953e-15
        Sole    1.893048e-18 3.303378e-18 4.868830e-18 9.715964e-18 1.546286e-17
        Gurnard 1.644299e-17 2.851105e-17 4.225033e-17 8.302676e-17 1.324065e-16
        Plaice  5.674727e-18 9.787605e-18 1.452360e-17 2.836066e-17 4.526964e-17
        Haddock 1.104530e-17 1.960804e-17 2.844394e-17 5.906876e-17 9.339177e-17
        Cod     5.696149e-17 9.525219e-17 1.460724e-16 2.625691e-16 4.222805e-16
        Saithe  2.346216e-17 3.878664e-17 6.059619e-17 1.043035e-16 1.678521e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 2.528053e-21 1.896608e-21 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 1.620643e-20 1.866831e-20 7.168057e-21
        N.pout  1.741630e-15 2.446184e-15 5.094854e-15 8.612755e-15 1.186625e-14
        Herring 8.459023e-19 1.252802e-18 2.485360e-18 4.192771e-18 5.957322e-18
        Dab     1.836661e-16 2.649869e-16 5.277800e-16 8.885945e-16 1.261832e-15
        Whiting 2.253756e-15 3.165483e-15 6.592993e-15 1.114533e-14 1.535551e-14
        Sole    2.478356e-17 3.656372e-17 7.020633e-17 1.179231e-16 1.718677e-16
        Gurnard 2.125462e-16 3.155621e-16 5.989787e-16 1.005408e-15 1.477551e-15
        Plaice  7.266329e-17 1.080546e-16 2.044386e-16 3.434856e-16 5.062425e-16
        Haddock 1.490145e-16 2.158470e-16 4.274181e-16 7.188041e-16 1.024447e-15
        Cod     6.809597e-16 1.047610e-15 1.860569e-15 3.102881e-15 4.775576e-15
        Saithe  2.704063e-16 4.222939e-16 7.241296e-16 1.199190e-15 1.886344e-15
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   0.000000e+00 0.000000e+00 1.969410e-20 0.000000e+00 8.710645e-20
        Sandeel 8.256940e-21 1.902247e-20 2.191213e-20 0.000000e+00 0.000000e+00
        N.pout  1.902115e-14 3.979529e-14 6.531017e-14 1.025256e-13 1.574894e-13
        Herring 9.362118e-18 1.888663e-17 3.115385e-17 4.925946e-17 7.633249e-17
        Dab     2.029115e-15 4.075665e-15 6.704615e-15 1.062521e-14 1.653273e-14
        Whiting 2.461431e-14 5.149707e-14 8.451459e-14 1.326731e-13 2.037990e-13
        Sole    2.769006e-16 5.373018e-16 8.864647e-16 1.416806e-15 2.228015e-15
        Gurnard 2.381616e-15 4.571697e-15 7.551514e-15 1.210451e-14 1.910107e-14
        Plaice  8.159548e-16 1.562051e-15 2.584323e-15 4.149944e-15 6.558098e-15
        Haddock 1.648566e-15 3.293064e-15 5.415513e-15 8.588525e-15 1.338387e-14
        Cod     7.729410e-15 1.394194e-14 2.316123e-14 3.776284e-14 6.085699e-14
        Saithe  3.062886e-15 5.354095e-15 8.909900e-15 1.465440e-14 2.389914e-14
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   8.027088e-20 4.623233e-20 1.597661e-19 6.134529e-20 0.000000e+00
        Sandeel 0.000000e+00 5.786910e-20 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  2.518350e-13 5.515350e-13 7.797781e-13 1.263820e-12 2.137809e-12
        Herring 1.225723e-16 2.600544e-16 3.728984e-16 6.067868e-16 1.025472e-15
        Dab     2.658163e-14 5.573726e-14 8.090224e-14 1.317064e-13 2.221579e-13
        Whiting 3.258869e-13 7.137136e-13 1.009071e-12 1.635445e-12 2.766431e-12
        Sole    3.595983e-15 7.261250e-15 1.079456e-14 1.763296e-14 2.965922e-14
        Gurnard 3.086557e-14 6.157923e-14 9.228301e-14 1.509136e-13 2.536149e-13
        Plaice  1.059957e-14 2.107387e-14 3.169604e-14 5.185597e-14 8.711306e-14
        Haddock 2.153599e-14 4.490268e-14 6.535230e-14 1.064501e-13 1.795047e-13
        Cod     9.919890e-14 1.844151e-13 2.895518e-13 4.770896e-13 7.983816e-13
        Saithe  3.920743e-14 7.026062e-14 1.129355e-13 1.869388e-13 3.123981e-13
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 9.953132e-19 0.000000e+00
        Sandeel 8.490560e-20 2.738496e-19 9.012842e-20 2.076393e-19 2.092836e-19
        N.pout  3.591977e-12 7.088491e-12 1.090640e-11 1.790668e-11 2.573828e-11
        Herring 1.721268e-15 3.330543e-15 5.161897e-15 8.493866e-15 1.244268e-14
        Dab     3.726871e-13 7.174374e-13 1.119220e-12 1.844338e-12 2.718104e-12
        Whiting 4.648196e-12 9.172858e-12 1.411342e-11 2.317212e-11 3.330660e-11
        Sole    4.968047e-14 9.360155e-14 1.479229e-13 2.445184e-13 3.679244e-13
        Gurnard 4.246162e-13 7.944786e-13 1.261160e-12 2.086984e-12 3.161220e-12
        Plaice  1.458253e-13 2.723123e-13 4.332691e-13 7.174196e-13 1.088991e-12
        Haddock 3.010766e-13 5.776815e-13 9.023069e-13 1.487372e-12 2.198818e-12
        Cod     1.333656e-12 2.392703e-12 3.895497e-12 6.488513e-12 1.022224e-11
        Saithe  5.214310e-13 9.140784e-13 1.505951e-12 2.516409e-12 4.048138e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   6.603363e-19 0.000000e+00 1.314292e-18 0.000000e+00 1.162615e-18
        Sandeel 4.132722e-19 6.744062e-19 1.051037e-18 2.105562e-18 3.274308e-18
        N.pout  3.573248e-11 5.550566e-11 8.940961e-11 1.417824e-10 2.107382e-10
        Herring 1.777036e-14 2.799151e-14 4.537124e-14 7.241941e-14 1.094805e-13
        Dab     3.896886e-12 6.107213e-12 9.835857e-12 1.562908e-11 2.357650e-11
        Whiting 4.623960e-11 7.182707e-11 1.157005e-10 1.834735e-10 2.727057e-10
        Sole    5.405444e-13 8.514511e-13 1.369499e-12 2.178331e-12 3.321713e-12
        Gurnard 4.678629e-12 7.377532e-12 1.185554e-11 1.885394e-11 2.882731e-11
        Plaice  1.613681e-12 2.540102e-12 4.071981e-12 6.462196e-12 9.866309e-12
        Haddock 3.166659e-12 4.974164e-12 8.020575e-12 1.276153e-11 1.930803e-11
        Cod     1.580066e-11 2.515485e-11 4.033702e-11 6.416930e-11 9.959257e-11
        Saithe  6.409114e-12 1.029357e-11 1.655108e-11 2.640048e-11 4.132804e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   1.339226e-18 1.156998e-18 3.109763e-18 5.629109e-18 8.547373e-18
        Sandeel 5.797244e-18 9.815695e-18 1.584802e-17 2.588859e-17 4.368662e-17
        N.pout  4.391058e-10 6.991775e-10 9.757781e-10 1.634613e-09 2.699699e-09
        Herring 2.184799e-13 3.477090e-13 4.960085e-13 8.256031e-13 1.357084e-12
        Dab     4.653724e-11 7.425158e-11 1.064550e-10 1.766263e-10 2.899614e-10
        Whiting 5.682246e-10 9.047703e-10 1.262705e-09 2.115269e-09 3.493544e-09
        Sole    6.291407e-12 1.007044e-11 1.476382e-11 2.431562e-11 3.974293e-11
        Gurnard 5.390646e-11 8.636718e-11 1.274602e-10 2.094191e-10 3.418023e-10
        Plaice  1.837154e-11 2.944214e-11 4.350341e-11 7.139499e-11 1.164724e-10
        Haddock 3.786276e-11 6.042054e-11 8.695051e-11 1.441301e-10 2.364445e-10
        Cod     1.732529e-10 2.780210e-10 4.247120e-10 6.878974e-10 1.112364e-09
        Saithe  6.940276e-11 1.110695e-10 1.720878e-10 2.763691e-10 4.440444e-10
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   1.578721e-17 2.781585e-17 4.876584e-17 8.604444e-17 1.504101e-16
        Sandeel 7.203160e-17 1.187904e-16 1.959492e-16 3.230113e-16 5.320717e-16
        N.pout  3.864918e-09 5.235039e-09 1.126218e-08 1.720248e-08 3.130081e-08
        Herring 1.980515e-12 2.773873e-12 5.660933e-12 8.695499e-12 1.548961e-11
        Dab     4.243873e-10 5.951511e-10 1.200582e-09 1.850310e-09 3.291063e-09
        Whiting 5.001394e-09 6.774400e-09 1.457381e-08 2.226086e-08 4.050480e-08
        Sole    5.919867e-11 8.514609e-11 1.634419e-10 2.539335e-10 4.436136e-10
        Gurnard 5.117389e-10 7.412016e-10 1.401966e-09 2.183637e-09 3.794571e-09
        Plaice  1.745239e-10 2.528442e-10 4.765635e-10 7.430304e-10 1.290752e-09
        Haddock 3.471604e-10 4.894495e-10 9.790904e-10 1.510425e-09 2.676906e-09
        Cod     1.711513e-09 2.575054e-09 4.499961e-09 7.096588e-09 1.195147e-08
        Saithe  6.915135e-10 1.059939e-09 1.786100e-09 2.831033e-09 4.688429e-09
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   2.591778e-16 4.451093e-16 7.559537e-16 1.274199e-15 2.124242e-15
        Sandeel 8.756962e-16 1.441001e-15 2.368449e-15 3.892193e-15 6.389231e-15
        N.pout  5.547170e-08 8.710427e-08 1.275905e-07 2.474113e-07 4.415167e-07
        Herring 2.701700e-11 4.249640e-11 6.311036e-11 1.194843e-10 2.106209e-10
        Dab     5.749053e-09 9.091021e-09 1.357514e-08 2.557121e-08 4.512740e-08
        Whiting 7.178313e-08 1.127172e-07 1.651084e-07 3.201625e-07 5.713444e-07
        Sole    7.662644e-10 1.219962e-09 1.851223e-09 3.401429e-09 5.946968e-09
        Gurnard 6.533751e-09 1.042808e-08 1.590626e-08 2.900697e-08 5.058282e-08
        Plaice  2.224212e-09 3.557501e-09 5.438478e-09 9.905843e-09 1.728651e-08
        Haddock 4.663143e-09 7.375245e-09 1.103678e-08 2.070209e-08 3.645227e-08
        Cod     2.016125e-08 3.259332e-08 5.121276e-08 8.953145e-08 1.536151e-07
        Saithe  7.807311e-09 1.267931e-08 2.021607e-08 3.459849e-08 5.877631e-08
               w
      predator          97.8          117          139          166          198
        Sprat   3.504556e-15 5.717821e-15 9.236592e-15 1.479211e-14 2.355877e-14
        Sandeel 1.047601e-14 1.716484e-14 2.809058e-14 4.589990e-14 7.492696e-14
        N.pout  6.777027e-07 1.190270e-06 1.964596e-06 2.794774e-06 4.293306e-06
        Herring 3.254428e-10 5.672436e-10 9.361279e-10 1.357688e-09 2.112073e-09
        Dab     7.017360e-08 1.222484e-07 2.022369e-07 2.953838e-07 4.595410e-07
        Whiting 8.769809e-07 1.540269e-06 2.542284e-06 3.616575e-06 5.555750e-06
        Sole    9.356245e-09 1.617958e-08 2.681663e-08 4.003697e-08 6.285283e-08
        Gurnard 7.990704e-08 1.378900e-07 2.287405e-07 3.439465e-07 5.414232e-07
        Plaice  2.737732e-08 4.725294e-08 7.847453e-08 1.183098e-07 1.862783e-07
        Haddock 5.674040e-08 9.870194e-08 1.632582e-07 2.391907e-07 3.728454e-07
        Cod     2.485095e-07 4.238943e-07 7.071216e-07 1.109311e-06 1.778458e-06
        Saithe  9.620670e-08 1.631629e-07 2.730452e-07 4.383225e-07 7.113459e-07
               w
      predator           237          282          337          402          480
        Sprat   3.747809e-14 5.981857e-14 9.617793e-14 1.562171e-13 2.564250e-13
        Sandeel 1.221992e-13 1.991302e-13 3.243500e-13 5.283617e-13 8.591374e-13
        N.pout  7.157907e-06 1.257607e-05 2.476646e-05 5.455508e-05 7.912776e-05
        Herring 3.523710e-09 6.140046e-09 1.181270e-08 2.521016e-08 3.690921e-08
        Dab     7.634769e-07 1.324364e-06 2.534369e-06 5.387218e-06 7.989256e-06
        Whiting 9.262685e-06 1.627406e-05 3.204903e-05 7.059697e-05 1.023952e-04
        Sole    1.040100e-07 1.784721e-07 3.334733e-07 6.873356e-07 1.042306e-06
        Gurnard 8.946950e-07 1.529812e-06 2.836775e-06 5.789190e-06 8.849200e-06
        Plaice  3.073937e-07 5.246867e-07 9.708113e-07 1.977717e-06 3.037163e-06
        Haddock 6.195168e-07 1.073288e-06 2.046086e-06 4.325583e-06 6.425727e-06
        Cod     2.923884e-06 4.906080e-06 8.689255e-06 1.660057e-05 2.655944e-05
        Saithe  1.170310e-06 1.948815e-06 3.367355e-06 6.170029e-06 1.007824e-05
               w
      predator           573          683          816          973         1160
        Sprat   4.247428e-13 7.080318e-13 1.184480e-12 1.983935e-12 3.322242e-12
        Sandeel 1.397822e-12 2.274687e-12 3.698355e-12 6.023236e-12 9.809251e-12
        N.pout  1.456750e-04 2.670052e-04 3.759677e-04 7.114056e-04 1.096872e-03
        Herring 6.734624e-08 1.225002e-07 1.753559e-07 3.292672e-07 5.129258e-07
        Dab     1.456786e-05 2.651354e-05 3.840799e-05 7.166280e-05 1.122304e-04
        Whiting 1.885107e-04 3.455179e-04 4.865206e-04 9.205936e-04 1.419406e-03
        Sole    1.884305e-06 3.408051e-06 5.067280e-06 9.326141e-06 1.480516e-05
        Gurnard 1.595596e-05 2.880625e-05 4.321997e-05 7.918415e-05 1.262886e-04
        Plaice  5.476839e-06 9.892771e-06 1.490999e-05 2.726814e-05 4.357907e-05
        Haddock 1.169720e-05 2.125794e-05 3.087896e-05 5.753006e-05 9.024682e-05
        Cod     4.708158e-05 8.395348e-05 1.330521e-04 2.378023e-04 3.904652e-04
        Saithe  1.765577e-05 3.119206e-05 5.090149e-05 8.995756e-05 1.502662e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   5.558715e-12 9.292881e-12 1.552677e-11 2.593534e-11 4.331504e-11
        Sandeel 1.598647e-11 2.607582e-11 4.259902e-11 6.969309e-11 1.142791e-10
        N.pout  1.621814e-03 2.266584e-03 3.485092e-03 5.397081e-03 1.017569e-02
        Herring 7.716157e-07 1.108881e-06 1.734969e-06 2.727352e-06 5.044553e-06
        Dab     1.696095e-04 2.447449e-04 3.811388e-04 5.958686e-04 1.088998e-03
        Whiting 2.098706e-03 2.933068e-03 4.509873e-03 6.984069e-03 1.316779e-02
        Sole    2.277589e-05 3.367781e-05 5.286204e-05 8.311931e-05 1.482295e-04
        Gurnard 1.954001e-04 2.910978e-04 4.577968e-04 7.206520e-04 1.274815e-03
        Plaice  6.754413e-05 1.007605e-04 1.581916e-04 2.484503e-04 4.374336e-04
        Haddock 1.367656e-04 1.982267e-04 3.095766e-04 4.852463e-04 8.845329e-04
        Cod     6.263858e-04 9.768424e-04 1.559711e-03 2.479310e-03 4.199656e-03
        Saithe  2.463939e-04 3.948448e-04 6.386604e-04 1.024882e-03 1.705139e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   7.232299e-11 1.206762e-10 2.010727e-10 3.341977e-10 5.533238e-10
        Sandeel 1.875493e-10 3.084086e-10 5.077398e-10 8.374213e-10 1.383129e-09
        N.pout  1.458512e-02 2.330647e-02 3.150532e-02 4.833107e-02 7.467443e-02
        Herring 7.383883e-06 1.184745e-05 1.656941e-05 2.571500e-05 4.006476e-05
        Dab     1.597779e-03 2.553628e-03 3.576525e-03 5.516659e-03 8.544748e-03
        Whiting 1.887371e-02 3.015942e-02 4.076867e-02 6.254109e-02 9.662853e-02
        Sole    2.215724e-04 3.542235e-04 5.093557e-04 7.884760e-04 1.223434e-03
        Gurnard 1.915731e-03 3.061345e-03 4.433843e-03 6.865550e-03 1.065060e-02
        Plaice  6.572759e-04 1.048139e-03 1.517300e-03 2.342939e-03 3.624666e-03
        Haddock 1.302557e-03 2.083915e-03 2.935210e-03 4.537586e-03 7.040703e-03
        Cod     6.494387e-03 1.034700e-02 1.556210e-02 2.413132e-02 3.736228e-02
        Saithe  2.673864e-03 4.253709e-03 6.506665e-03 1.009673e-02 1.561131e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   9.111810e-10 1.490085e-09 2.416846e-09 3.885247e-09 6.191423e-09
        Sandeel 2.286924e-09 3.784870e-09 6.270181e-09 1.039048e-08 1.722876e-08
        N.pout  1.083460e-01 1.550366e-01 2.607910e-01 3.923928e-01 7.661853e-01
        Herring 5.935729e-05 8.704923e-05 1.440992e-04 2.186490e-04 4.055933e-04
        Dab     1.260602e-02 1.838784e-02 3.020064e-02 4.565757e-02 8.437621e-02
        Whiting 1.401968e-01 2.006089e-01 3.374400e-01 5.077025e-01 9.912583e-01
        Sole    1.826374e-03 2.699089e-03 4.362756e-03 6.622752e-03 1.177182e-02
        Gurnard 1.594042e-02 2.362224e-02 3.798843e-02 5.769631e-02 1.014245e-01
        Plaice  5.412437e-03 7.999277e-03 1.282283e-02 1.943679e-02 3.411987e-02
        Haddock 1.042543e-02 1.527173e-02 2.503507e-02 3.791447e-02 6.951209e-02
        Cod     5.660052e-02 8.497372e-02 1.329437e-01 2.019517e-01 3.335619e-01
        Saithe  2.376045e-02 3.586307e-02 5.540842e-02 8.406439e-02 1.345531e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   9.792331e-09 1.540581e-08 2.418302e-08 3.800364e-08 5.996639e-08
        Sandeel 2.858981e-08 4.737251e-08 7.844332e-08 1.297724e-07 2.144843e-07
        N.pout  1.944905e+00 2.765992e+00 4.002458e+00 5.962516e+00 1.029990e+01
        Herring 9.465967e-04 1.357698e-03 1.988197e-03 2.997615e-03 5.133727e-03
        Dab     1.972290e-01 2.864285e-01 4.229274e-01 6.403456e-01 1.094894e+00
        Whiting 2.516042e+00 3.578112e+00 5.177674e+00 7.712625e+00 1.331777e+01
        Sole    2.575747e-02 3.820037e-02 5.740048e-02 8.796158e-02 1.487775e-01
        Gurnard 2.177243e-01 3.252461e-01 4.915837e-01 7.562865e-01 1.275314e+00
        Plaice  7.333155e-02 1.100657e-01 1.669597e-01 2.574806e-01 4.344121e-01
        Haddock 1.601168e-01 2.328714e-01 3.444349e-01 5.222903e-01 8.912140e-01
        Cod     6.362137e-01 9.862682e-01 1.538694e+00 2.423039e+00 4.028966e+00
        Saithe  2.394809e-01 3.758868e-01 5.940950e-01 9.467013e-01 1.566872e+00
      
      , , prey = Plaice
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  6.285523e-21 7.205075e-21 8.165340e-21 1.022386e-20 1.594219e-20
        Herring 1.226680e-07 1.190245e-07 1.135562e-07 1.113369e-07 1.018115e-07
        Dab     1.795982e-20 2.058860e-20 2.946400e-20 3.467844e-20 5.720839e-20
        Whiting 2.520885e-20 2.889682e-20 3.274808e-20 4.100401e-20 6.393807e-20
        Sole    0.000000e+00 1.037857e-21 0.000000e+00 4.936672e-21 7.709644e-21
        Gurnard 1.090580e-21 1.863205e-21 3.209518e-21 3.525252e-21 6.367118e-21
        Plaice  1.098190e-20 1.807250e-20 1.754514e-20 2.920725e-20 2.943561e-20
        Haddock 0.000000e+00 0.000000e+00 4.375145e-22 7.858004e-22 2.931378e-21
        Cod     5.402052e-20 5.156704e-20 7.296715e-20 6.878546e-20 1.034086e-19
        Saithe  4.897074e-21 6.341089e-21 6.345749e-21 7.567023e-21 7.206098e-21
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  2.322361e-20 3.132013e-20 5.310995e-20 7.117934e-20 1.404781e-19
        Herring 4.604526e-08 2.471905e-08 0.000000e+00 0.000000e+00 0.000000e+00
        Dab     7.024526e-20 9.995830e-20 1.194368e-19 1.520366e-19 2.188958e-19
        Whiting 9.314107e-20 1.256132e-19 2.130039e-19 2.854733e-19 5.634042e-19
        Sole    1.167382e-20 1.709745e-20 2.403479e-20 2.697344e-20 4.380674e-20
        Gurnard 7.815233e-21 1.109665e-20 1.321628e-20 1.588728e-20 2.128497e-20
        Plaice  4.670748e-20 4.656959e-20 7.701164e-20 7.732516e-20 1.407964e-19
        Haddock 4.235004e-21 7.056561e-21 1.022230e-20 1.149758e-20 2.202195e-20
        Cod     1.114138e-19 1.487293e-19 1.577991e-19 1.889552e-19 2.562674e-19
        Saithe  9.545076e-21 1.023557e-20 1.391205e-20 1.588666e-20 2.517313e-20
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 5.593514e-22
        N.pout  2.671897e-19 5.011106e-19 8.268616e-19 1.168940e-18 1.971760e-18
        Herring 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 2.576585e-21
        Dab     3.612317e-19 6.027130e-19 9.319142e-19 1.278163e-18 2.121737e-18
        Whiting 1.071597e-18 2.009765e-18 3.316228e-18 4.688175e-18 7.907982e-18
        Sole    6.412286e-20 1.134974e-19 1.701745e-19 2.486744e-19 3.992840e-19
        Gurnard 3.353495e-20 5.240281e-20 7.834244e-20 1.102796e-19 1.820715e-19
        Plaice  2.008294e-19 3.593309e-19 5.351660e-19 8.372744e-19 1.346669e-18
        Haddock 3.438080e-20 5.936250e-20 8.971498e-20 1.329751e-19 2.145004e-19
        Cod     4.553067e-19 6.936472e-19 1.140519e-18 1.717051e-18 2.837443e-18
        Saithe  3.738261e-20 6.475653e-20 1.022063e-19 1.666789e-19 2.800702e-19
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 8.549444e-22 0.000000e+00 0.000000e+00
        N.pout  3.909370e-18 5.646607e-18 9.947079e-18 1.738324e-17 3.293556e-17
        Herring 8.903965e-21 0.000000e+00 0.000000e+00 3.629154e-20 6.793232e-20
        Dab     3.991383e-18 5.901436e-18 1.018479e-17 1.779012e-17 3.309417e-17
        Whiting 1.567900e-17 2.264640e-17 3.989396e-17 6.971758e-17 1.320921e-16
        Sole    7.351794e-19 1.106120e-18 1.933119e-18 3.347564e-18 6.156810e-18
        Gurnard 3.261601e-19 4.925905e-19 8.375661e-19 1.457404e-18 2.663961e-18
        Plaice  2.554850e-18 3.820584e-18 6.691523e-18 1.154422e-17 2.122306e-17
        Haddock 4.078850e-19 5.856476e-19 1.025899e-18 1.760349e-18 3.287540e-18
        Cod     5.081377e-18 8.016286e-18 1.375726e-17 2.366278e-17 4.221121e-17
        Saithe  5.014472e-19 8.154684e-19 1.404775e-18 2.422821e-18 4.282189e-18
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   0.000000e+00 1.637823e-21 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 5.226982e-21 0.000000e+00 1.387128e-20 7.989216e-21 0.000000e+00
        N.pout  6.147704e-17 8.653842e-17 1.273079e-16 1.912846e-16 2.836407e-16
        Herring 1.143680e-19 1.456089e-19 2.316244e-19 3.128116e-19 4.875055e-19
        Dab     6.115797e-17 8.847217e-17 1.331251e-16 2.037167e-16 3.082698e-16
        Whiting 2.465611e-16 3.470728e-16 5.105836e-16 7.671698e-16 1.137575e-15
        Sole    1.123891e-17 1.670454e-17 2.561183e-17 3.971909e-17 6.100675e-17
        Gurnard 4.858752e-18 7.273504e-18 1.121996e-17 1.747584e-17 2.695945e-17
        Plaice  3.872459e-17 5.840433e-17 9.014224e-17 1.406772e-16 2.165942e-16
        Haddock 6.027262e-18 8.762724e-18 1.319503e-17 2.027974e-17 3.075187e-17
        Cod     7.585686e-17 1.198290e-16 1.916205e-16 3.064916e-16 4.846600e-16
        Saithe  7.589853e-18 1.236484e-17 2.017788e-17 3.284533e-17 5.280110e-17
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 5.879401e-20
        Sandeel 0.000000e+00 0.000000e+00 7.033072e-21 0.000000e+00 0.000000e+00
        N.pout  4.595181e-16 6.629495e-16 1.019169e-15 1.520737e-15 2.183653e-15
        Herring 8.667577e-19 1.321858e-18 2.089607e-18 3.116083e-18 4.621136e-18
        Dab     4.998136e-16 7.382609e-16 1.144114e-15 1.730165e-15 2.537407e-15
        Whiting 1.842953e-15 2.658839e-15 4.087501e-15 6.099100e-15 8.757804e-15
        Sole    9.873989e-17 1.483326e-16 2.310107e-16 3.526100e-16 5.246076e-16
        Gurnard 4.363549e-17 6.584409e-17 1.026377e-16 1.569614e-16 2.343413e-16
        Plaice  3.499220e-16 5.273457e-16 8.201102e-16 1.250678e-15 1.862343e-15
        Haddock 4.994500e-17 7.402297e-17 1.150409e-16 1.744651e-16 2.570376e-16
        Cod     7.837252e-16 1.214556e-15 1.905149e-15 2.945143e-15 4.473126e-15
        Saithe  8.572348e-17 1.349471e-16 2.129603e-16 3.315129e-16 5.081106e-16
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   8.899168e-20 1.206002e-19 1.250283e-19 1.920281e-19 1.105994e-19
        Sandeel 0.000000e+00 0.000000e+00 4.279124e-20 4.929157e-20 0.000000e+00
        N.pout  3.004672e-15 5.131175e-15 7.323353e-15 1.015202e-14 2.907309e-14
        Herring 6.684851e-18 1.106566e-17 1.626180e-17 2.350026e-17 5.823784e-17
        Dab     3.601950e-15 5.980500e-15 8.694839e-15 1.236500e-14 3.068188e-14
        Whiting 1.205060e-14 2.057920e-14 2.937119e-14 4.071592e-14 1.166011e-13
        Sole    7.601589e-16 1.238964e-15 1.825441e-15 2.641186e-15 5.920582e-15
        Gurnard 3.411451e-16 5.526680e-16 8.164504e-16 1.185581e-15 2.583053e-15
        Plaice  2.702698e-15 4.357931e-15 6.419119e-15 9.290176e-15 2.019922e-14
        Haddock 3.670375e-16 6.084301e-16 8.882392e-16 1.270115e-15 3.084350e-15
        Cod     6.668094e-15 1.046203e-14 1.563352e-14 2.305480e-14 4.285115e-14
        Saithe  7.658969e-16 1.185454e-15 1.777280e-15 2.633963e-15 4.519557e-15
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   4.246675e-19 3.913423e-19 5.634877e-19 2.596344e-19 5.981497e-19
        Sandeel 0.000000e+00 0.000000e+00 5.785651e-20 0.000000e+00 1.535386e-19
        N.pout  6.137912e-14 1.321326e-13 2.851265e-13 4.614941e-13 7.059910e-13
        Herring 1.168458e-16 2.420059e-16 5.069669e-16 8.189061e-16 1.259802e-15
        Dab     6.196086e-14 1.291412e-13 2.728197e-13 4.464628e-13 6.954435e-13
        Whiting 2.461684e-13 5.299339e-13 1.143534e-12 1.850878e-12 2.831462e-12
        Sole    1.154904e-14 2.342406e-14 4.855676e-14 8.049470e-14 1.276312e-13
        Gurnard 4.989045e-15 1.004179e-14 2.070869e-14 3.452245e-14 5.511950e-14
        Plaice  3.911864e-14 7.904525e-14 1.636909e-13 2.746472e-13 4.410503e-13
        Haddock 6.172995e-15 1.276848e-14 2.682027e-14 4.385662e-14 6.836221e-14
        Cod     7.722884e-14 1.467926e-13 2.907736e-13 5.012565e-13 8.373412e-13
        Saithe  7.758359e-15 1.408733e-14 2.692569e-14 4.709859e-14 8.078899e-14
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   1.722533e-18 1.587360e-18 1.371369e-18 0.000000e+00 2.426211e-18
        Sandeel 2.210779e-19 0.000000e+00 4.693543e-19 2.703264e-19 2.335433e-19
        N.pout  1.148147e-12 2.042190e-12 3.126390e-12 5.110831e-12 7.654326e-12
        Herring 2.060364e-15 3.666890e-15 5.684367e-15 9.371573e-15 1.428559e-14
        Dab     1.143592e-12 2.032600e-12 3.170243e-12 5.225966e-12 7.992101e-12
        Whiting 4.604782e-12 8.190451e-12 1.253877e-11 2.049760e-11 3.069860e-11
        Sole    2.117695e-13 3.754104e-13 5.947655e-13 9.859184e-13 1.532609e-12
        Gurnard 9.178431e-14 1.626144e-13 2.590660e-13 4.302471e-13 6.723575e-13
        Plaice  7.367644e-13 1.306052e-12 2.086637e-12 3.466490e-12 5.423918e-12
        Haddock 1.124780e-13 1.998521e-13 3.122856e-13 5.154291e-13 7.904554e-13
        Cod     1.432228e-12 2.542842e-12 4.209214e-12 7.106614e-12 1.150573e-11
        Saithe  1.409240e-13 2.520568e-13 4.286044e-13 7.349223e-13 1.219151e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   3.493464e-18 8.048296e-19 1.854179e-18 5.339608e-19 6.150736e-18
        Sandeel 6.277143e-19 1.291195e-18 1.725311e-18 2.946833e-18 4.894367e-18
        N.pout  1.682224e-11 2.591060e-11 4.004212e-11 6.426413e-11 9.726931e-11
        Herring 3.069709e-14 4.771723e-14 7.456944e-14 1.206424e-13 1.853999e-13
        Dab     1.689676e-11 2.643080e-11 4.144045e-11 6.700445e-11 1.031010e-10
        Whiting 6.746764e-11 1.039176e-10 1.605937e-10 2.577391e-10 3.901103e-10
        Sole    3.129451e-12 4.965587e-12 7.882006e-12 1.281850e-11 1.998382e-11
        Gurnard 1.356699e-12 2.163151e-12 3.447212e-12 5.615413e-12 8.788452e-12
        Plaice  1.087739e-11 1.737465e-11 2.771068e-11 4.511503e-11 7.060878e-11
        Haddock 1.665228e-12 2.609169e-12 4.098847e-12 6.636940e-12 1.023906e-11
        Cod     2.169600e-11 3.560145e-11 5.809966e-11 9.562949e-11 1.531553e-10
        Saithe  2.227259e-12 3.712313e-12 6.137624e-12 1.016336e-11 1.647735e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   3.542540e-18 3.264544e-18 8.931077e-18 1.624386e-17 2.089443e-17
        Sandeel 8.002123e-18 1.319808e-17 2.153755e-17 3.565029e-17 5.887706e-17
        N.pout  1.722414e-10 3.038843e-10 4.537215e-10 6.868227e-10 1.019507e-09
        Herring 3.266773e-13 5.726847e-13 8.666518e-13 1.330031e-12 2.009791e-12
        Dab     1.803614e-10 3.149113e-10 4.784831e-10 7.349485e-10 1.110344e-09
        Whiting 6.907951e-10 1.218765e-09 1.819705e-09 2.754585e-09 4.088854e-09
        Sole    3.459536e-11 5.989663e-11 9.239085e-11 1.435760e-10 2.198279e-10
        Gurnard 1.515766e-11 2.616556e-11 4.054893e-11 6.322540e-11 9.716343e-11
        Plaice  1.214330e-10 2.092269e-10 3.245352e-10 5.059904e-10 7.772481e-10
        Haddock 1.790146e-11 3.122969e-11 4.756440e-11 7.323249e-11 1.109719e-10
        Cod     2.587361e-10 4.384785e-10 6.970852e-10 1.107649e-09 1.738661e-09
        Saithe  2.756602e-11 4.622775e-11 7.435093e-11 1.192512e-10 1.892986e-10
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   3.089384e-17 5.669068e-17 9.247206e-17 1.662305e-16 2.950502e-16
        Sandeel 9.672899e-17 1.598053e-16 2.642837e-16 4.373016e-16 7.268405e-16
        N.pout  1.425056e-09 2.043390e-09 3.923448e-09 6.209744e-09 1.216163e-08
        Herring 2.894093e-12 4.267107e-12 7.942818e-12 1.259708e-11 2.383078e-11
        Dab     1.598851e-09 2.347118e-09 4.309895e-09 6.821955e-09 1.283426e-08
        Whiting 5.715359e-09 8.195264e-09 1.573546e-08 2.490493e-08 4.877569e-08
        Sole    3.234313e-10 4.822926e-10 8.568579e-10 1.357424e-09 2.477001e-09
        Gurnard 1.438011e-10 2.152502e-10 3.785054e-10 5.995318e-10 1.083819e-09
        Plaice  1.149714e-09 1.717521e-09 3.005479e-09 4.753854e-09 8.574597e-09
        Haddock 1.605719e-10 2.367993e-10 4.329440e-10 6.857533e-10 1.283129e-09
        Cod     2.659788e-09 4.070162e-09 6.782996e-09 1.071676e-08 1.832406e-08
        Saithe  2.946777e-10 4.568424e-10 7.445801e-10 1.174474e-09 1.949361e-09
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   5.111720e-16 8.983930e-16 1.557193e-15 2.684942e-15 4.575793e-15
        Sandeel 1.208145e-15 2.013483e-15 3.356717e-15 5.598139e-15 9.342973e-15
        N.pout  2.033920e-08 3.525112e-08 5.418782e-08 7.546155e-08 1.302935e-07
        Herring 3.949720e-11 6.759141e-11 1.044065e-10 1.486545e-10 2.545518e-10
        Dab     2.132455e-08 3.655877e-08 5.677372e-08 8.133359e-08 1.387030e-07
        Whiting 8.157283e-08 1.413789e-07 2.173268e-07 3.026476e-07 5.225579e-07
        Sole    4.100679e-09 6.975500e-09 1.093758e-08 1.603766e-08 2.705465e-08
        Gurnard 1.792438e-09 3.042306e-09 4.785878e-09 7.068179e-09 1.188441e-08
        Plaice  1.418935e-08 2.410158e-08 3.799267e-08 5.624156e-08 9.449096e-08
        Haddock 2.129014e-09 3.642094e-09 5.660344e-09 8.137990e-09 1.385687e-08
        Cod     2.999575e-08 5.007419e-08 8.006876e-08 1.231010e-07 2.035853e-07
        Saithe  3.160237e-09 5.206660e-09 8.365626e-09 1.310718e-08 2.152736e-08
               w
      predator          97.8          117          139          166          198
        Sprat   7.767168e-15 1.307301e-14 2.191758e-14 3.641572e-14 6.005009e-14
        Sandeel 1.560053e-14 2.605551e-14 4.347695e-14 7.248453e-14 1.206756e-13
        N.pout  2.354723e-07 4.794897e-07 8.327836e-07 1.404953e-06 2.142804e-06
        Herring 4.529911e-10 8.959578e-10 1.542399e-09 2.592050e-09 3.986861e-09
        Dab     2.460836e-07 4.851319e-07 8.390014e-07 1.416718e-06 2.194744e-06
        Whiting 9.443901e-07 1.923051e-06 3.339979e-06 5.634733e-06 8.593975e-06
        Sole    4.725928e-08 9.062429e-08 1.562965e-07 2.642987e-07 4.152293e-07
        Gurnard 2.066309e-08 3.928939e-08 6.773364e-08 1.146455e-07 1.810092e-07
        Plaice  1.641887e-07 3.119385e-07 5.388140e-07 9.139300e-07 1.447271e-06
        Haddock 2.451775e-08 4.808647e-08 8.302441e-08 1.400766e-07 2.172809e-07
        Cod     3.449308e-07 6.230671e-07 1.069179e-06 1.817998e-06 2.957580e-06
        Saithe  3.602416e-08 6.325044e-08 1.079875e-07 1.837637e-07 3.037469e-07
               w
      predator           237          282          337          402          480
        Sprat   9.791569e-14 1.577476e-13 2.505483e-13 3.923282e-13 6.058311e-13
        Sandeel 2.007095e-13 3.332889e-13 5.523830e-13 9.140090e-13 1.509994e-12
        N.pout  3.561591e-06 5.528798e-06 7.684187e-06 1.079504e-05 1.595367e-05
        Herring 6.636736e-09 1.040286e-08 1.483972e-08 2.147786e-08 3.250418e-08
        Dab     3.656665e-06 5.749504e-06 8.249250e-06 1.194901e-05 1.799602e-05
        Whiting 1.428419e-05 2.217391e-05 3.081836e-05 4.329481e-05 6.398412e-05
        Sole    6.927528e-07 1.100470e-06 1.618915e-06 2.396502e-06 3.652214e-06
        Gurnard 3.021807e-07 4.816754e-07 7.141687e-07 1.063855e-06 1.626042e-06
        Plaice  2.418019e-06 3.859722e-06 5.734846e-06 8.545157e-06 1.303696e-05
        Haddock 3.620319e-07 5.700735e-07 8.212969e-07 1.195176e-06 1.806861e-06
        Cod     4.965637e-06 8.092393e-06 1.257937e-05 1.947658e-05 3.037925e-05
        Saithe  5.122924e-07 8.462956e-07 1.351393e-06 2.141747e-06 3.391043e-06
               w
      predator           573          683          816          973         1160
        Sprat   9.249382e-13 1.401776e-12 2.123110e-12 3.242106e-12 5.045418e-12
        Sandeel 2.490411e-12 4.102286e-12 6.749525e-12 1.108521e-11 1.818920e-11
        N.pout  2.358728e-05 4.168291e-05 8.062081e-05 1.235418e-04 2.140240e-04
        Herring 4.918816e-08 8.564164e-08 1.602364e-07 2.468781e-07 4.216642e-07
        Dab     2.706567e-05 4.658138e-05 8.646267e-05 1.335194e-04 2.277240e-04
        Whiting 9.459961e-05 1.671743e-04 3.233394e-04 4.954790e-04 8.583686e-04
        Sole    5.550752e-06 9.366997e-06 1.686597e-05 2.624563e-05 4.426847e-05
        Gurnard 2.477050e-06 4.153171e-06 7.407324e-06 1.155120e-05 1.941536e-05
        Plaice  1.980803e-05 3.305642e-05 5.873688e-05 9.158215e-05 1.537755e-04
        Haddock 2.727989e-06 4.687129e-06 8.658705e-06 1.338767e-05 2.278587e-05
        Cod     4.702381e-05 7.634536e-05 1.289251e-04 2.026652e-04 3.327028e-04
        Saithe  5.313731e-06 8.531686e-06 1.402721e-05 2.206169e-05 3.564990e-05
               w
      predator          1390         1650         1970         2360         2810
        Sprat   8.085821e-12 1.344117e-11 2.319810e-11 4.131752e-11 7.511881e-11
        Sandeel 2.980219e-11 4.882895e-11 7.993948e-11 1.307441e-10 2.138683e-10
        N.pout  3.081086e-04 6.438293e-04 1.171066e-03 1.779146e-03 3.236004e-03
        Herring 6.167841e-07 1.236864e-06 2.208828e-06 3.374333e-06 6.054512e-06
        Dab     3.345289e-04 6.666440e-04 1.193421e-03 1.837444e-03 3.296255e-03
        Whiting 1.235706e-03 2.582152e-03 4.696692e-03 7.135457e-03 1.297832e-02
        Sole    6.616344e-05 1.269267e-04 2.244467e-04 3.500467e-04 6.204781e-04
        Gurnard 2.916663e-05 5.530989e-05 9.746304e-05 1.526891e-04 2.697147e-04
        Plaice  2.312341e-04 4.376633e-04 7.720595e-04 1.213248e-03 2.144487e-03
        Haddock 3.356656e-05 6.643223e-05 1.185434e-04 1.826743e-04 3.268581e-04
        Cod     5.125401e-04 9.072790e-04 1.558824e-03 2.500977e-03 4.325788e-03
        Saithe  5.536993e-05 9.427571e-05 1.588854e-04 2.571129e-04 4.390436e-04
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.377117e-10 2.518389e-10 4.557840e-10 8.123714e-10 1.422808e-09
        Sandeel 3.497771e-10 5.716440e-10 9.344589e-10 1.528103e-09 2.500711e-09
        N.pout  5.697248e-03 8.191478e-03 1.317298e-02 2.344752e-02 4.717023e-02
        Herring 1.056751e-05 1.542416e-05 2.493819e-05 4.408259e-05 8.688191e-05
        Dab     5.765411e-03 8.492016e-03 1.374038e-02 2.420056e-02 4.743593e-02
        Whiting 2.284932e-02 3.285257e-02 5.283082e-02 9.403655e-02 1.891743e-01
        Sole    1.079188e-03 1.623779e-03 2.638162e-03 4.600087e-03 8.810322e-03
        Gurnard 4.684578e-04 7.099733e-04 1.155174e-03 2.007972e-03 3.817448e-03
        Plaice  3.729810e-03 5.673638e-03 9.239425e-03 1.604705e-02 3.045216e-02
        Haddock 5.707113e-04 8.426183e-04 1.364283e-03 2.399672e-03 4.686742e-03
        Cod     7.447441e-03 1.178680e-02 1.939812e-02 3.320833e-02 6.043479e-02
        Saithe  7.514689e-04 1.217683e-03 2.022400e-03 3.446551e-03 6.133227e-03
               w
      predator          8120         9690        11600        13800        16500
        Sprat   2.448519e-09 4.146529e-09 6.928120e-09 1.145616e-08 1.880498e-08
        Sandeel 4.088270e-09 6.686054e-09 1.094076e-08 1.791179e-08 2.931222e-08
        N.pout  6.554771e-02 9.929407e-02 1.725496e-01 3.167624e-01 4.740718e-01
        Herring 1.229787e-04 1.888613e-04 3.272172e-04 5.941896e-04 9.006341e-04
        Dab     6.790336e-02 1.045687e-01 1.802925e-01 3.258438e-01 4.964426e-01
        Whiting 2.628716e-01 3.981990e-01 6.919562e-01 1.270230e+00 1.900894e+00
        Sole    1.295211e-02 2.020522e-02 3.457095e-02 6.163358e-02 9.534240e-02
        Gurnard 5.662809e-03 8.870383e-03 1.513816e-02 2.686847e-02 4.176779e-02
        Plaice  4.535591e-02 7.112576e-02 1.211884e-01 2.147053e-01 3.342868e-01
        Haddock 6.729622e-03 1.038576e-02 1.789738e-02 3.228853e-02 4.929879e-02
        Cod     9.457947e-02 1.520463e-01 2.563016e-01 4.433997e-01 7.090471e-01
        Saithe  9.877954e-03 1.612935e-02 2.708817e-02 4.627424e-02 7.506549e-02
               w
      predator         19600        23400        28000        33400        39900
        Sprat   3.071744e-08 5.000799e-08 8.118215e-08 1.313737e-07 2.117578e-07
        Sandeel 4.797619e-08 7.851080e-08 1.285152e-07 2.105661e-07 3.448459e-07
        N.pout  7.131873e-01 9.710432e-01 1.431315e+00 2.868074e+00 4.254409e+00
        Herring 1.374872e-03 1.933353e-03 2.917361e-03 5.666081e-03 8.537860e-03
        Dab     7.594499e-01 1.072010e+00 1.611230e+00 3.084452e+00 4.654374e+00
        Whiting 2.859459e+00 3.893161e+00 5.738573e+00 1.149804e+01 1.704898e+01
        Sole    1.477738e-01 2.142811e-01 3.260675e-01 6.019639e-01 9.201022e-01
        Gurnard 6.499409e-02 9.499332e-02 1.449924e-01 2.646151e-01 4.058951e-01
        Plaice  5.204532e-01 7.613808e-01 1.160172e+00 2.106239e+00 3.229807e+00
        Haddock 7.559782e-02 1.072590e-01 1.618114e-01 3.083217e-01 4.664796e-01
        Cod     1.129497e+00 1.727246e+00 2.687597e+00 4.612403e+00 7.205575e+00
        Saithe  1.210979e-01 1.896249e-01 2.987079e-01 4.991021e-01 7.863960e-01
      
      , , prey = Haddock
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   3.347027e-22 2.856888e-22 4.495734e-22 4.068348e-22 5.890351e-22
        Sandeel 4.650925e-23 1.942071e-22 2.622791e-22 3.732088e-22 3.070729e-22
        N.pout  3.297398e-20 4.987535e-20 6.156032e-20 8.187784e-20 1.292329e-19
        Herring 1.784423e-07 1.725807e-07 1.614856e-07 1.566749e-07 1.327256e-07
        Dab     4.713778e-21 6.239011e-21 8.159562e-21 9.391877e-21 1.393949e-20
        Whiting 2.511198e-20 3.798355e-20 4.688246e-20 6.235566e-20 9.841987e-20
        Sole    1.480057e-22 3.598203e-22 2.524522e-22 6.794683e-22 9.130476e-22
        Gurnard 4.365269e-21 6.828776e-21 6.988264e-21 1.169397e-20 1.235261e-20
        Plaice  1.902002e-21 2.594356e-21 3.000923e-21 3.826892e-21 4.864475e-21
        Haddock 9.608525e-21 1.263019e-20 2.029729e-20 2.444797e-20 3.705920e-20
        Cod     4.474520e-20 6.043974e-20 5.935993e-20 7.329817e-20 6.821435e-20
        Saithe  3.365995e-20 4.624549e-20 4.458649e-20 4.227949e-20 4.913220e-20
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   8.389675e-22 4.352778e-22 7.387560e-22 1.244492e-21 1.271352e-21
        Sandeel 8.017646e-22 2.173080e-22 5.006375e-22 0.000000e+00 5.812552e-22
        N.pout  1.792333e-19 2.233836e-19 4.250295e-19 7.219767e-19 1.167322e-18
        Herring 8.349855e-08 4.439078e-08 1.200119e-21 2.073640e-21 7.962141e-22
        Dab     1.704108e-20 2.257945e-20 3.109358e-20 4.048210e-20 5.844146e-20
        Whiting 1.364986e-19 1.701221e-19 3.236895e-19 5.498355e-19 8.889965e-19
        Sole    1.214102e-21 1.643493e-21 2.497831e-21 2.490481e-21 4.144317e-21
        Gurnard 1.956886e-20 2.307402e-20 3.283130e-20 3.666745e-20 5.857525e-20
        Plaice  6.065908e-21 7.659894e-21 1.096041e-20 1.425557e-20 2.156499e-20
        Haddock 4.444645e-20 6.417087e-20 9.133851e-20 1.282600e-19 1.845856e-19
        Cod     1.039228e-19 9.788395e-20 1.488744e-19 1.829148e-19 3.034416e-19
        Saithe  5.247282e-20 6.286474e-20 9.093081e-20 1.338041e-19 1.911920e-19
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   9.786658e-22 1.778155e-21 3.899812e-22 9.447583e-22 0.000000e+00
        Sandeel 1.721706e-21 6.610823e-22 5.076705e-21 2.339159e-21 6.736238e-22
        N.pout  1.746121e-18 2.369961e-18 3.273229e-18 9.244449e-18 1.521572e-17
        Herring 0.000000e+00 4.225959e-21 4.867915e-21 0.000000e+00 1.291839e-20
        Dab     8.002496e-20 1.057744e-19 1.367602e-19 3.296931e-19 5.269668e-19
        Whiting 1.329792e-18 1.804890e-18 2.492791e-18 7.040290e-18 1.158783e-17
        Sole    5.231905e-21 7.890562e-21 9.637641e-21 2.306481e-20 3.636034e-20
        Gurnard 6.919604e-20 1.011639e-19 1.211474e-19 2.591343e-19 4.061582e-19
        Plaice  3.074743e-20 4.352364e-20 5.906204e-20 1.352289e-19 2.231557e-19
        Haddock 2.480867e-19 3.498724e-19 4.426998e-19 1.074307e-18 1.721234e-18
        Cod     3.986151e-19 6.815607e-19 9.325171e-19 1.997707e-18 3.211261e-18
        Saithe  3.286984e-19 4.799493e-19 7.688665e-19 1.395572e-18 2.358581e-18
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   1.149651e-21 3.016393e-22 1.741330e-21 4.507693e-21 5.919651e-21
        Sandeel 7.759525e-22 8.938257e-22 8.236838e-21 1.423212e-20 4.098522e-21
        N.pout  2.204545e-17 4.020813e-17 6.856993e-17 1.001389e-16 1.957186e-16
        Herring 1.488080e-20 8.570652e-21 4.936300e-20 6.823396e-20 9.824903e-20
        Dab     7.766866e-19 1.374089e-18 2.334886e-18 3.482996e-18 6.658988e-18
        Whiting 1.678914e-17 3.062129e-17 5.222077e-17 7.626272e-17 1.490533e-16
        Sole    5.515509e-20 9.507017e-20 1.647515e-19 2.501861e-19 4.710059e-19
        Gurnard 6.099154e-19 1.048705e-18 1.786064e-18 2.715158e-18 5.050198e-18
        Plaice  3.412254e-19 5.935192e-19 1.018581e-18 1.568056e-18 2.899816e-18
        Haddock 2.595373e-18 4.478566e-18 7.590590e-18 1.137119e-17 2.160537e-17
        Cod     5.167502e-18 8.779872e-18 1.507387e-17 2.389369e-17 4.268193e-17
        Saithe  3.785004e-18 6.449824e-18 1.088153e-17 1.769711e-17 3.079155e-17
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   5.884292e-21 1.138173e-20 7.734994e-21 1.403852e-20 0.000000e+00
        Sandeel 6.294826e-21 0.000000e+00 1.252883e-20 9.621368e-21 1.662439e-20
        N.pout  2.863596e-16 3.947409e-16 6.301755e-16 1.199966e-15 2.463332e-15
        Herring 9.053906e-20 1.564390e-19 2.402710e-19 3.920909e-19 8.767374e-19
        Dab     9.934539e-18 1.415375e-17 2.268762e-17 4.202335e-17 8.334745e-17
        Whiting 2.180827e-16 3.006226e-16 4.799225e-16 9.138576e-16 1.875999e-15
        Sole    7.168142e-19 1.050211e-18 1.687759e-18 3.052139e-18 5.884528e-18
        Gurnard 7.714252e-18 1.141351e-17 1.831793e-17 3.287398e-17 6.283639e-17
        Plaice  4.460140e-18 6.593959e-18 1.058825e-17 1.894038e-17 3.610881e-17
        Haddock 3.224473e-17 4.627504e-17 7.426532e-17 1.369589e-16 2.703508e-16
        Cod     6.791072e-17 1.051040e-16 1.694077e-16 2.918953e-16 5.267809e-16
        Saithe  4.999053e-17 7.927618e-17 1.287773e-16 2.178563e-16 3.815545e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   8.885232e-22 2.191301e-21 6.832506e-21 6.277899e-21 1.334098e-20
        Sandeel 0.000000e+00 1.470585e-20 4.234945e-20 1.561045e-19 6.743175e-20
        N.pout  3.703628e-15 5.604045e-15 8.731771e-15 1.262876e-14 2.500330e-14
        Herring 1.300655e-18 2.079903e-18 3.208011e-18 4.396978e-18 8.890540e-18
        Dab     1.273852e-16 1.956888e-16 3.079562e-16 4.558099e-16 8.709299e-16
        Whiting 2.820570e-15 4.267870e-15 6.649851e-15 9.617682e-15 1.904175e-14
        Sole    9.137139e-18 1.422188e-17 2.256034e-17 3.398149e-17 6.306079e-17
        Gurnard 9.806990e-17 1.532578e-16 2.436854e-16 3.691707e-16 6.784664e-16
        Plaice  5.647376e-17 8.843191e-17 1.406434e-16 2.132110e-16 3.904105e-16
        Haddock 4.138532e-16 6.367765e-16 1.003410e-15 1.490100e-15 2.835822e-15
        Cod     8.458021e-16 1.354327e-15 2.183944e-15 3.412293e-15 5.955100e-15
        Saithe  6.203076e-16 1.005097e-15 1.632813e-15 2.593544e-15 4.417901e-15
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   5.744891e-21 1.985275e-20 0.000000e+00 1.756163e-20 1.618351e-20
        Sandeel 2.589172e-20 0.000000e+00 1.374220e-19 0.000000e+00 0.000000e+00
        N.pout  4.147833e-14 7.130052e-14 1.228090e-13 2.084882e-13 4.115217e-13
        Herring 1.427545e-17 2.480899e-17 4.158998e-17 7.010670e-17 1.356140e-16
        Dab     1.442821e-15 2.463386e-15 4.217199e-15 7.138542e-15 1.376976e-14
        Whiting 3.158863e-14 5.430030e-14 9.352758e-14 1.587782e-13 3.134024e-13
        Sole    1.044007e-16 1.773233e-16 3.021430e-16 5.104282e-16 9.650874e-16
        Gurnard 1.123041e-15 1.904285e-15 3.240071e-15 5.470883e-15 1.027874e-14
        Plaice  6.462428e-16 1.095438e-15 1.864097e-15 3.149001e-15 5.910308e-15
        Haddock 4.696527e-15 8.010630e-15 1.369868e-14 2.317137e-14 4.454046e-14
        Cod     9.833392e-15 1.649475e-14 2.779546e-14 4.673132e-14 8.436259e-14
        Saithe  7.280539e-15 1.213183e-14 2.031124e-14 3.401547e-14 5.995761e-14
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   0.000000e+00 2.147376e-20 1.731505e-19 2.849335e-19 0.000000e+00
        Sandeel 1.050218e-19 6.048771e-20 2.090288e-19 0.000000e+00 0.000000e+00
        N.pout  6.534420e-13 1.004489e-12 1.849762e-12 3.294049e-12 4.676954e-12
        Herring 2.163846e-16 3.350952e-16 6.128210e-16 1.083593e-15 1.566898e-15
        Dab     2.207810e-14 3.443528e-14 6.260612e-14 1.107999e-13 1.616468e-13
        Whiting 4.976415e-13 7.649881e-13 1.408722e-12 2.508647e-12 3.561826e-12
        Sole    1.562456e-15 2.468372e-15 4.434883e-15 7.805365e-15 1.166222e-14
        Gurnard 1.669973e-14 2.649830e-14 4.742799e-14 8.333331e-14 1.255094e-13
        Plaice  9.626898e-15 1.531005e-14 2.737400e-14 4.809861e-14 7.268741e-14
        Haddock 7.144936e-14 1.115952e-13 2.025608e-13 3.581079e-13 5.239871e-13
        Cod     1.397775e-13 2.276923e-13 3.989421e-13 6.939702e-13 1.096545e-12
        Saithe  1.001612e-13 1.653954e-13 2.867698e-13 4.961248e-13 8.046200e-13
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   0.000000e+00 3.484068e-19 0.000000e+00 2.311490e-19 2.662624e-19
        Sandeel 0.000000e+00 3.680247e-19 6.358958e-19 4.069408e-19 7.500132e-19
        N.pout  7.882652e-12 1.136724e-11 1.708466e-11 2.720128e-11 5.146577e-11
        Herring 2.646113e-15 3.896188e-15 5.959902e-15 9.576983e-15 1.778546e-14
        Dab     2.723008e-13 4.026496e-13 6.155952e-13 9.844726e-13 1.810207e-12
        Whiting 6.003188e-12 8.656946e-12 1.301116e-11 2.071566e-11 3.919476e-11
        Sole    1.961646e-14 2.959491e-14 4.580461e-14 7.341467e-14 1.319080e-13
        Gurnard 2.109951e-13 3.203337e-13 4.975240e-13 7.976121e-13 1.422320e-12
        Plaice  1.221132e-13 1.856785e-13 2.882805e-13 4.612950e-13 8.194527e-13
        Haddock 8.829147e-13 1.309908e-12 2.008469e-12 3.217208e-12 5.899576e-12
        Cod     1.842074e-12 2.905474e-12 4.616160e-12 7.432300e-12 1.271414e-11
        Saithe  1.354814e-12 2.184332e-12 3.522639e-12 5.705159e-12 9.581701e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   0.000000e+00 1.766506e-19 2.034853e-19 2.343963e-19 1.080011e-18
        Sandeel 8.639460e-19 1.554978e-18 2.221078e-18 4.044044e-18 6.179465e-18
        N.pout  7.402554e-11 1.034753e-10 1.739413e-10 2.388652e-10 4.433335e-10
        Herring 2.607616e-14 3.745936e-14 6.271543e-14 8.887110e-14 1.607175e-13
        Dab     2.664335e-12 3.833765e-12 6.371318e-12 9.033364e-12 1.617419e-11
        Whiting 5.637559e-11 7.880364e-11 1.324684e-10 1.819125e-10 3.376293e-10
        Sole    1.978460e-13 2.909780e-13 4.792177e-13 6.956018e-13 1.212700e-12
        Gurnard 2.145347e-12 3.174725e-12 5.211679e-12 7.613201e-12 1.316274e-11
        Plaice  1.236863e-12 1.830179e-12 2.995662e-12 4.373407e-12 7.533116e-12
        Haddock 8.711976e-12 1.259275e-11 2.092151e-11 2.981721e-11 5.319108e-11
        Cod     1.978039e-11 3.028211e-11 4.888304e-11 7.385878e-11 1.220638e-10
        Saithe  1.513475e-11 2.356334e-11 3.777663e-11 5.798196e-11 9.383921e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   7.775460e-19 7.165291e-19 2.372954e-18 3.921870e-18 5.818163e-18
        Sandeel 1.002020e-17 1.728198e-17 2.702736e-17 4.536048e-17 7.505069e-17
        N.pout  6.688761e-10 1.441772e-09 1.983920e-09 2.919631e-09 4.363810e-09
        Herring 2.449282e-13 5.019514e-13 7.047056e-13 1.051623e-12 1.592540e-12
        Dab     2.464564e-11 5.014158e-11 7.097084e-11 1.061587e-10 1.607330e-10
        Whiting 5.093956e-10 1.098010e-09 1.510893e-09 2.223502e-09 3.323344e-09
        Sole    1.863297e-12 3.624649e-12 5.259692e-12 7.972042e-12 1.218717e-11
        Gurnard 2.026696e-11 3.889350e-11 5.687517e-11 8.653868e-11 1.326468e-10
        Plaice  1.159048e-11 2.218506e-11 3.252101e-11 4.952190e-11 7.591203e-11
        Haddock 8.120526e-11 1.638690e-10 2.327577e-10 3.489611e-10 5.294656e-10
        Cod     1.897089e-10 3.360955e-10 5.115900e-10 7.942275e-10 1.235403e-09
        Saithe  1.462353e-10 2.482026e-10 3.838590e-10 6.007617e-10 9.410786e-10
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   9.777017e-18 1.489520e-17 2.521373e-17 4.199916e-17 7.059054e-17
        Sandeel 1.248188e-16 2.055642e-16 3.399357e-16 5.605017e-16 9.246002e-16
        N.pout  6.846502e-09 1.408791e-08 2.706359e-08 4.162468e-08 7.288234e-08
        Herring 2.510159e-12 4.947817e-12 9.242430e-12 1.425911e-11 2.469377e-11
        Dab     2.526888e-10 4.946252e-10 9.245251e-10 1.437212e-09 2.493407e-09
        Whiting 5.214087e-09 1.072892e-08 2.061080e-08 3.170009e-08 5.550497e-08
        Sole    1.917810e-11 3.608483e-11 6.597301e-11 1.036467e-10 1.784464e-10
        Gurnard 2.087522e-10 3.881992e-10 7.051557e-10 1.112037e-09 1.910741e-09
        Plaice  1.193849e-10 2.215657e-10 4.026470e-10 6.368489e-10 1.095545e-09
        Haddock 8.329859e-10 1.618976e-09 3.011343e-09 4.683360e-09 8.108092e-09
        Cod     1.947090e-09 3.392039e-09 5.915364e-09 9.516334e-09 1.614772e-08
        Saithe  1.486073e-09 2.508117e-09 4.269467e-09 6.921551e-09 1.164920e-08
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   1.151346e-16 1.903713e-16 3.162044e-16 5.294623e-16 8.805862e-16
        Sandeel 1.523710e-15 2.513682e-15 4.139710e-15 6.806653e-15 1.118141e-14
        N.pout  1.077438e-07 2.338290e-07 4.485168e-07 6.556862e-07 1.236609e-06
        Herring 3.692397e-11 7.754979e-11 1.463201e-10 2.161113e-10 4.034708e-10
        Dab     3.754842e-09 7.829555e-09 1.480056e-08 2.211727e-08 4.119081e-08
        Whiting 8.205442e-08 1.780771e-07 3.415767e-07 4.993506e-07 9.417640e-07
        Sole    2.730911e-10 5.495514e-10 1.025715e-09 1.565354e-09 2.880203e-09
        Gurnard 2.940132e-09 5.851484e-09 1.088147e-08 1.673228e-08 3.067220e-08
        Plaice  1.690688e-09 3.358365e-09 6.251602e-09 9.657547e-09 1.769736e-08
        Haddock 1.223152e-08 2.535495e-08 4.778258e-08 7.152342e-08 1.329389e-07
        Cod     2.564853e-08 4.783439e-08 8.677445e-08 1.396339e-07 2.505654e-07
        Saithe  1.880062e-08 3.385734e-08 6.038571e-08 9.948970e-08 1.765389e-07
               w
      predator          97.8          117          139          166          198
        Sprat   1.475798e-15 2.461607e-15 4.104501e-15 6.807825e-15 1.125664e-14
        Sandeel 1.834526e-14 3.006602e-14 4.925360e-14 8.058996e-14 1.318013e-13
        N.pout  1.925426e-06 3.207756e-06 5.794419e-06 9.545998e-06 1.606003e-05
        Herring 6.329133e-10 1.057699e-09 1.901681e-09 3.143852e-09 5.299586e-09
        Dab     6.505182e-08 1.088254e-07 1.950983e-07 3.232880e-07 5.451542e-07
        Whiting 1.466346e-06 2.442929e-06 4.412853e-06 7.269941e-06 1.223083e-05
        Sole    4.607213e-09 7.729579e-09 1.375437e-08 2.290506e-08 3.868916e-08
        Gurnard 4.929014e-08 8.278546e-08 1.469574e-07 2.451578e-07 4.143383e-07
        Plaice  2.851874e-08 4.793321e-08 8.501660e-08 1.419497e-07 2.399362e-07
        Haddock 2.101851e-07 3.517488e-07 6.300442e-07 1.044588e-06 1.762017e-06
        Cod     4.144383e-07 7.022156e-07 1.230868e-06 2.077191e-06 3.526713e-06
        Saithe  2.968074e-07 5.063512e-07 8.832532e-07 1.501680e-06 2.559275e-06
               w
      predator           237          282          337          402          480
        Sprat   1.852813e-14 3.042333e-14 4.989163e-14 8.188593e-14 1.346707e-13
        Sandeel 2.154442e-13 3.519811e-13 5.749392e-13 9.399270e-13 1.536369e-12
        N.pout  2.672315e-05 4.081228e-05 6.023849e-05 1.044394e-04 1.490079e-04
        Herring 8.845093e-09 1.367705e-08 2.056529e-08 3.560665e-08 5.198861e-08
        Dab     9.103247e-07 1.412861e-06 2.130403e-06 3.663120e-06 5.366059e-06
        Whiting 2.035153e-05 3.108139e-05 4.587579e-05 7.953782e-05 1.134798e-04
        Sole    6.478571e-08 1.019168e-07 1.562907e-07 2.666493e-07 3.987892e-07
        Gurnard 6.944484e-07 1.097240e-06 1.691394e-06 2.877523e-06 4.330225e-06
        Plaice  4.021883e-07 6.362173e-07 9.815074e-07 1.665552e-06 2.507999e-06
        Haddock 2.943819e-06 4.578421e-06 6.924739e-06 1.190579e-05 1.750790e-05
        Cod     5.948442e-06 9.653231e-06 1.535973e-05 2.576999e-05 4.019770e-05
        Saithe  4.336138e-06 7.144926e-06 1.157802e-05 1.934230e-05 3.075973e-05
               w
      predator           573          683          816          973         1160
        Sprat   2.221246e-13 3.677093e-13 6.112712e-13 1.020802e-12 1.713029e-12
        Sandeel 2.513032e-12 4.121044e-12 6.761801e-12 1.110832e-11 1.827861e-11
        N.pout  2.124444e-04 4.719567e-04 7.811520e-04 1.204234e-03 1.881203e-03
        Herring 7.612695e-08 1.619679e-07 2.673137e-07 4.150507e-07 6.527240e-07
        Dab     7.855755e-06 1.642202e-05 2.713980e-05 4.228191e-05 6.657218e-05
        Whiting 1.617911e-04 3.594277e-04 5.949014e-04 9.171073e-04 1.432666e-03
        Sole    5.951410e-07 1.185556e-06 1.959452e-06 3.082542e-06 4.886640e-06
        Gurnard 6.496786e-06 1.274419e-05 2.106185e-05 3.323324e-05 5.278841e-05
        Plaice  3.760480e-06 7.329677e-06 1.211140e-05 1.912441e-05 3.038262e-05
        Haddock 2.574369e-05 5.346555e-05 8.833907e-05 1.378125e-04 2.172460e-04
        Cod     6.220823e-05 1.119881e-04 1.844091e-04 2.953140e-04 4.737857e-04
        Saithe  4.843126e-05 8.371905e-05 1.372261e-04 2.208443e-04 3.554942e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   2.888536e-12 4.890718e-12 8.302479e-12 1.409967e-11 2.388959e-11
        Sandeel 3.013315e-11 4.977530e-11 8.233786e-11 1.363512e-10 2.260674e-10
        N.pout  3.091643e-03 5.412529e-03 8.672150e-03 1.227427e-02 1.685394e-02
        Herring 1.072577e-06 1.860294e-06 2.987396e-06 4.318947e-06 6.116524e-06
        Dab     1.092263e-04 1.888892e-04 3.038105e-04 4.413553e-04 6.264178e-04
        Whiting 2.354499e-03 4.122012e-03 6.604433e-03 9.347683e-03 1.283538e-02
        Sole    8.007619e-06 1.371125e-05 2.213357e-05 3.284075e-05 4.776561e-05
        Gurnard 8.645637e-05 1.475681e-04 2.384876e-04 3.561442e-04 5.216398e-04
        Plaice  4.973045e-05 8.479874e-05 1.371165e-04 2.050836e-04 3.005711e-04
        Haddock 3.564583e-04 6.155061e-04 9.903801e-04 1.443778e-03 2.059250e-03
        Cod     7.730294e-04 1.294502e-03 2.103565e-03 3.257318e-03 4.964820e-03
        Saithe  5.783280e-04 9.580538e-04 1.559208e-03 2.458295e-03 3.826790e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   4.027207e-11 6.737850e-11 1.116691e-10 1.831195e-10 2.970008e-10
        Sandeel 3.753859e-10 6.239504e-10 1.037161e-09 1.726607e-09 2.872371e-09
        N.pout  2.764817e-02 4.735685e-02 6.604170e-02 1.481576e-01 2.360674e-01
        Herring 1.004479e-05 1.704994e-05 2.441809e-05 5.175094e-05 8.231883e-05
        Dab     1.021202e-03 1.722668e-03 2.470610e-03 5.178273e-03 8.272725e-03
        Whiting 2.105584e-02 3.606516e-02 5.029440e-02 1.128292e-01 1.797745e-01
        Sole    7.740257e-05 1.290019e-04 1.889420e-04 3.756565e-04 6.024163e-04
        Gurnard 8.434301e-04 1.400182e-03 2.062777e-03 4.036348e-03 6.481479e-03
        Plaice  4.848384e-04 8.030696e-04 1.183081e-03 2.306004e-03 3.707416e-03
        Haddock 3.358010e-03 5.657473e-03 8.149425e-03 1.692699e-02 2.703758e-02
        Cod     7.956447e-03 1.294654e-02 1.969160e-02 3.522835e-02 5.680451e-02
        Saithe  6.129420e-03 9.902719e-03 1.531114e-02 2.621843e-02 4.222010e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   4.766235e-10 7.576775e-10 1.195251e-09 1.875401e-09 2.934499e-09
        Sandeel 4.776611e-09 7.936894e-09 1.318784e-08 2.188480e-08 3.627005e-08
        N.pout  3.627540e-01 5.134221e-01 1.009770e+00 1.691259e+00 2.695485e+00
        Herring 1.271604e-04 1.836934e-04 3.505796e-04 5.835002e-04 9.313771e-04
        Dab     1.283105e-02 1.861823e-02 3.528803e-02 5.884973e-02 9.424111e-02
        Whiting 2.762462e-01 3.909753e-01 7.689267e-01 1.287826e+00 2.052337e+00
        Sole    9.424007e-04 1.395169e-03 2.565396e-03 4.265012e-03 6.858825e-03
        Gurnard 1.016745e-02 1.514362e-02 2.759125e-02 4.583674e-02 7.382564e-02
        Plaice  5.823544e-03 8.686718e-03 1.579614e-02 2.626415e-02 4.235888e-02
        Haddock 4.197314e-02 6.110732e-02 1.152341e-01 1.919557e-01 3.074371e-01
        Cod     9.031891e-02 1.390373e-01 2.406060e-01 3.973730e-01 6.451364e-01
        Saithe  6.740065e-02 1.053130e-01 1.775280e-01 2.916978e-01 4.748844e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   4.591608e-09 7.203054e-09 1.135440e-08 1.801575e-08 2.880503e-08
        Sandeel 6.004014e-08 9.919908e-08 1.637018e-07 2.697694e-07 4.437205e-07
        N.pout  4.545532e+00 6.419986e+00 1.077735e+01 1.925253e+01 2.995253e+01
        Herring 1.562826e-03 2.253516e-03 3.775328e-03 6.667915e-03 1.045544e-02
        Dab     1.582252e-01 2.295545e-01 3.833928e-01 6.747441e-01 1.060748e+00
        Whiting 3.460692e+00 4.887603e+00 8.204997e+00 1.465612e+01 2.279242e+01
        Sole    1.147000e-02 1.700419e-02 2.823717e-02 4.902447e-02 7.765052e-02
        Gurnard 1.233283e-01 1.840776e-01 3.051243e-01 5.275139e-01 8.374950e-01
        Plaice  7.079916e-02 1.059144e-01 1.754327e-01 3.029605e-01 4.813961e-01
        Haddock 5.156505e-01 7.505503e-01 1.252846e+00 2.200347e+00 3.462924e+00
        Cod     1.071149e+00 1.662487e+00 2.733695e+00 4.618175e+00 7.432022e+00
        Saithe  7.857096e-01 1.244453e+00 2.043035e+00 3.416504e+00 5.540046e+00
      
      , , prey = Cod
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   2.638676e-22 9.667373e-22 6.437181e-22 8.115931e-22 0.000000e+00
        Sandeel 2.153397e-23 0.000000e+00 0.000000e+00 8.933730e-23 0.000000e+00
        N.pout  2.023419e-20 1.949735e-20 2.566810e-20 3.264036e-20 6.784832e-20
        Herring 1.278955e-07 1.216597e-07 9.646724e-08 6.968881e-08 6.219090e-08
        Dab     1.092456e-20 1.416257e-20 1.640636e-20 2.282985e-20 3.234925e-20
        Whiting 2.929210e-20 2.822540e-20 3.715851e-20 4.725193e-20 9.822086e-20
        Sole    7.199264e-22 1.885295e-21 1.391568e-21 3.224425e-21 3.830212e-21
        Gurnard 2.787704e-21 4.893079e-21 5.082602e-21 7.861118e-21 9.538251e-21
        Plaice  5.877078e-21 7.281498e-21 7.922593e-21 9.724312e-21 1.434603e-20
        Haddock 1.496946e-21 2.834056e-21 3.809871e-21 4.381205e-21 9.439147e-21
        Cod     8.838622e-20 1.008425e-19 1.132980e-19 1.191374e-19 1.480964e-19
        Saithe  2.607083e-20 2.814921e-20 2.518452e-20 3.027031e-20 3.092609e-20
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  1.339973e-19 1.835308e-19 2.887077e-19 4.660215e-19 8.413598e-19
        Herring 3.148830e-08 2.279831e-08 0.000000e+00 0.000000e+00 0.000000e+00
        Dab     4.893784e-20 6.191164e-20 9.182541e-20 1.200425e-19 1.923916e-19
        Whiting 1.939816e-19 2.656890e-19 4.179486e-19 6.746376e-19 1.217997e-18
        Sole    7.867685e-21 9.589072e-21 1.540064e-20 1.832619e-20 3.312395e-20
        Gurnard 1.560504e-20 1.946630e-20 2.960378e-20 3.633132e-20 5.480441e-20
        Plaice  2.190701e-20 2.599583e-20 3.651468e-20 4.730134e-20 8.147251e-20
        Haddock 1.620359e-20 3.002419e-20 3.966487e-20 5.341078e-20 9.017610e-20
        Cod     1.779007e-19 2.197557e-19 3.057644e-19 4.115218e-19 6.521655e-19
        Saithe  3.844838e-20 4.709371e-20 6.335710e-20 9.683002e-20 1.581118e-19
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 1.049430e-21 5.372651e-22 9.283198e-22 0.000000e+00
        N.pout  1.300361e-18 2.459267e-18 3.630977e-18 6.038781e-18 9.335588e-18
        Herring 0.000000e+00 0.000000e+00 0.000000e+00 1.140238e-20 0.000000e+00
        Dab     2.786181e-19 4.851253e-19 6.974631e-19 1.148504e-18 1.774946e-18
        Whiting 1.882472e-18 3.560166e-18 5.256396e-18 8.742062e-18 1.351470e-17
        Sole    4.334713e-20 8.161203e-20 1.128936e-19 1.917474e-19 2.947411e-19
        Gurnard 7.417123e-20 1.240389e-19 1.761068e-19 2.851720e-19 4.405609e-19
        Plaice  1.126877e-19 2.037457e-19 2.939916e-19 4.998980e-19 7.707499e-19
        Haddock 1.293627e-19 2.301312e-19 3.402517e-19 5.443296e-19 8.484005e-19
        Cod     9.763232e-19 1.729988e-18 2.707094e-18 4.595716e-18 7.374985e-18
        Saithe  2.631005e-19 4.661587e-19 7.722676e-19 1.314426e-18 2.185242e-18
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   0.000000e+00 0.000000e+00 5.826501e-22 1.348354e-20 1.885002e-20
        Sandeel 0.000000e+00 9.459311e-22 0.000000e+00 3.765444e-21 7.229074e-21
        N.pout  1.458128e-17 1.986950e-17 3.791789e-17 7.331222e-17 1.040364e-16
        Herring 0.000000e+00 0.000000e+00 1.720757e-20 1.982153e-20 7.610859e-20
        Dab     2.776530e-18 3.885971e-18 7.178559e-18 1.348176e-17 1.965227e-17
        Whiting 2.110864e-17 2.876414e-17 5.489197e-17 1.061307e-16 1.506086e-16
        Sole    4.780564e-19 6.773955e-19 1.239472e-18 2.270310e-18 3.399834e-18
        Gurnard 6.842872e-19 9.928887e-19 1.774091e-18 3.225801e-18 4.846867e-18
        Plaice  1.244499e-18 1.796422e-18 3.215324e-18 5.853114e-18 8.806860e-18
        Haddock 1.321252e-18 1.874228e-18 3.425855e-18 6.420738e-18 9.360478e-18
        Cod     1.221676e-17 1.857231e-17 3.208889e-17 5.614781e-17 8.784738e-17
        Saithe  3.631022e-18 5.752433e-18 9.737086e-18 1.672518e-17 2.656164e-17
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   2.740234e-20 3.063203e-20 1.826351e-20 1.048715e-20 0.000000e+00
        Sandeel 1.665445e-21 0.000000e+00 1.325919e-20 7.636683e-21 0.000000e+00
        N.pout  1.691166e-16 3.325813e-16 5.763490e-16 8.455251e-16 1.211770e-15
        Herring 7.013606e-20 2.120745e-19 3.489860e-19 5.761996e-19 8.026488e-19
        Dab     3.195138e-17 6.095797e-17 1.049485e-16 1.571325e-16 2.307760e-16
        Whiting 2.448222e-16 4.814625e-16 8.343537e-16 1.224027e-15 1.754223e-15
        Sole    5.518025e-18 1.029328e-17 1.763581e-17 2.688796e-17 4.027617e-17
        Gurnard 7.857236e-18 1.453678e-17 2.488204e-17 3.815135e-17 5.752447e-17
        Plaice  1.432478e-17 2.641260e-17 4.522975e-17 6.955690e-17 1.050898e-16
        Haddock 1.518954e-17 2.889808e-17 4.967110e-17 7.451468e-17 1.098284e-16
        Cod     1.427975e-16 2.515102e-16 4.255076e-16 6.747964e-16 1.053741e-15
        Saithe  4.327088e-17 7.405560e-17 1.241762e-16 1.996182e-16 3.175814e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 2.702147e-20 0.000000e+00 0.000000e+00 0.000000e+00 1.189378e-20
        N.pout  1.816867e-15 3.651388e-15 6.035662e-15 9.981435e-15 1.370078e-14
        Herring 1.226843e-18 2.519201e-18 4.034331e-18 6.658236e-18 9.579266e-18
        Dab     3.516483e-16 6.797573e-16 1.122529e-15 1.854946e-15 2.628846e-15
        Whiting 2.630194e-15 5.285944e-15 8.737547e-15 1.444966e-14 1.983399e-14
        Sole    6.211428e-17 1.162657e-16 1.919865e-16 3.171440e-16 4.614420e-16
        Gurnard 8.898046e-17 1.648552e-16 2.721998e-16 4.496244e-16 6.594437e-16
        Plaice  1.625165e-16 2.999915e-16 4.953548e-16 8.184730e-16 1.203016e-15
        Haddock 1.677453e-16 3.227956e-16 5.329371e-16 8.803838e-16 1.252844e-15
        Cod     1.664063e-15 2.915356e-15 4.807926e-15 7.933450e-15 1.218337e-14
        Saithe  5.073906e-16 8.669086e-16 1.428323e-15 2.355389e-15 3.702650e-15
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   0.000000e+00 3.432409e-20 1.897833e-20 3.643548e-20 1.343050e-19
        Sandeel 0.000000e+00 0.000000e+00 1.090748e-19 6.282203e-20 4.824346e-20
        N.pout  1.947013e-14 4.171842e-14 6.926319e-14 1.080895e-13 1.588479e-13
        Herring 1.381107e-17 2.861973e-17 4.679536e-17 7.330496e-17 1.093918e-16
        Dab     3.834867e-15 7.781865e-15 1.288718e-14 2.027749e-14 3.036642e-14
        Whiting 2.818600e-14 6.039382e-14 1.002691e-13 1.564762e-13 2.299567e-13
        Sole    6.861882e-16 1.332868e-15 2.204544e-15 3.494889e-15 5.314915e-15
        Gurnard 9.860283e-16 1.889252e-15 3.123749e-15 4.963902e-15 7.584438e-15
        Plaice  1.799408e-15 3.431676e-15 5.675915e-15 9.028145e-15 1.381030e-14
        Haddock 1.834836e-15 3.699406e-15 6.122707e-15 9.642424e-15 1.447619e-14
        Cod     1.881208e-14 3.345159e-14 5.510407e-14 8.866446e-14 1.390922e-13
        Saithe  5.819549e-15 9.995581e-15 1.640767e-14 2.652868e-14 4.214717e-14
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   2.707372e-19 2.227602e-19 3.592389e-19 0.000000e+00 2.723835e-19
        Sandeel 0.000000e+00 3.200692e-20 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  2.279024e-13 3.843834e-13 7.453811e-13 1.301293e-12 2.472948e-12
        Herring 1.604552e-16 2.699152e-16 5.079094e-16 8.767030e-16 1.631931e-15
        Dab     4.460485e-14 7.444989e-14 1.394665e-13 2.407206e-13 4.476480e-13
        Whiting 3.299237e-13 5.564539e-13 1.079054e-12 1.883822e-12 3.579972e-12
        Sole    7.947308e-15 1.314735e-14 2.395717e-14 4.099734e-14 7.489920e-14
        Gurnard 1.139927e-14 1.880222e-14 3.396912e-14 5.798253e-14 1.053608e-13
        Plaice  2.076621e-14 3.418525e-14 6.161070e-14 1.051712e-13 1.910860e-13
        Haddock 2.133905e-14 3.559416e-14 6.638279e-14 1.143523e-13 2.118732e-13
        Cod     2.152920e-13 3.500286e-13 6.023991e-13 1.010726e-12 1.773394e-12
        Saithe  6.623248e-14 1.071424e-13 1.800060e-13 2.986848e-13 5.126227e-13
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   0.000000e+00 0.000000e+00 2.497958e-18 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 0.000000e+00 8.613266e-20 4.960844e-19
        N.pout  3.906272e-12 6.445362e-12 1.239476e-11 1.917256e-11 2.677770e-11
        Herring 2.581397e-15 4.253906e-15 8.047056e-15 1.252629e-14 1.787307e-14
        Dab     7.130085e-13 1.178746e-12 2.223363e-12 3.485570e-12 5.015849e-12
        Whiting 5.654928e-12 9.330651e-12 1.794332e-11 2.775522e-11 3.876483e-11
        Sole    1.203169e-13 1.993040e-13 3.695209e-13 5.865533e-13 8.655770e-13
        Gurnard 1.697774e-13 2.814937e-13 5.191376e-13 8.277107e-13 1.231565e-12
        Plaice  3.086815e-13 5.125328e-13 9.447608e-13 1.510599e-12 2.254983e-12
        Haddock 3.375541e-13 5.578638e-13 1.049036e-12 1.646176e-12 2.377022e-12
        Cod     2.903730e-12 4.836882e-12 8.636448e-12 1.413421e-11 2.209543e-11
        Saithe  8.437298e-13 1.406530e-12 2.464585e-12 4.086088e-12 6.561909e-12
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   6.363369e-19 2.932006e-18 0.000000e+00 9.726134e-19 2.240722e-18
        Sandeel 1.200031e-18 1.448151e-18 2.805501e-18 3.668392e-18 7.143360e-18
        N.pout  3.645471e-11 7.150307e-11 1.213715e-10 1.899529e-10 3.063228e-10
        Herring 2.510632e-14 4.826080e-14 8.166928e-14 1.287372e-13 2.083089e-13
        Dab     7.081323e-12 1.342114e-11 2.266248e-11 3.577742e-11 5.785241e-11
        Whiting 5.277379e-11 1.035117e-10 1.757039e-10 2.749860e-10 4.434492e-10
        Sole    1.256153e-12 2.311937e-12 3.886169e-12 6.179559e-12 1.001367e-11
        Gurnard 1.802374e-12 3.286215e-12 5.515388e-12 8.789486e-12 1.425032e-11
        Plaice  3.306496e-12 6.001831e-12 1.006325e-11 1.604081e-11 2.599352e-11
        Haddock 3.372242e-12 6.370862e-12 1.075304e-11 1.699736e-11 2.750295e-11
        Cod     3.401052e-11 5.912242e-11 9.845662e-11 1.589335e-10 2.585251e-10
        Saithe  1.039531e-11 1.774768e-11 2.949842e-11 4.798000e-11 7.823921e-11
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   1.935829e-18 0.000000e+00 7.705905e-18 1.134218e-17 2.044980e-17
        Sandeel 1.106790e-17 1.802243e-17 2.875669e-17 4.729621e-17 7.820147e-17
        N.pout  6.036541e-10 1.168878e-09 1.771877e-09 3.186784e-09 5.401610e-09
        Herring 4.009056e-13 7.610258e-13 1.161861e-12 2.071952e-12 3.504915e-12
        Dab     1.105868e-10 2.095993e-10 3.227025e-10 5.749804e-10 9.749039e-10
        Whiting 8.738819e-10 1.692131e-09 2.565064e-09 4.613358e-09 7.819659e-09
        Sole    1.866492e-11 3.475726e-11 5.432844e-11 9.602234e-11 1.629092e-10
        Gurnard 2.634833e-11 4.879210e-11 7.666822e-11 1.351719e-10 2.294262e-10
        Plaice  4.793518e-11 8.869689e-11 1.397804e-10 2.464266e-10 4.187000e-10
        Haddock 5.237235e-11 9.893183e-11 1.525092e-10 2.713168e-10 4.598319e-10
        Cod     4.556036e-10 8.128100e-10 1.314489e-09 2.280825e-09 3.877196e-09
        Saithe  1.344038e-10 2.340512e-10 3.829490e-10 6.572684e-10 1.116043e-09
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   3.304423e-17 6.557544e-17 1.169953e-16 2.089026e-16 3.562746e-16
        Sandeel 1.284519e-16 2.113202e-16 3.471212e-16 5.710369e-16 9.391341e-16
        N.pout  8.445529e-09 1.280574e-08 2.377493e-08 3.926760e-08 5.603181e-08
        Herring 5.520176e-12 8.478121e-12 1.558958e-11 2.579949e-11 3.755933e-11
        Dab     1.542900e-09 2.378859e-09 4.344913e-09 7.197631e-09 1.054527e-08
        Whiting 1.222620e-08 1.853828e-08 3.441787e-08 5.684588e-08 8.111465e-08
        Sole    2.606073e-10 4.073544e-10 7.329770e-10 1.217223e-09 1.822883e-09
        Gurnard 3.683771e-10 5.783907e-10 1.035632e-09 1.721274e-09 2.595860e-09
        Plaice  6.735968e-10 1.059307e-09 1.892800e-09 3.147076e-09 4.756252e-09
        Haddock 7.285732e-10 1.125605e-09 2.052434e-09 3.401061e-09 4.999323e-09
        Cod     6.364731e-09 1.027350e-08 1.791436e-08 2.994198e-08 4.707728e-08
        Saithe  1.852888e-09 3.038466e-09 5.238743e-09 8.792162e-09 1.414682e-08
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   6.028202e-16 1.003947e-15 1.647958e-15 2.683083e-15 4.353426e-15
        Sandeel 1.544993e-15 2.547100e-15 4.198512e-15 6.926029e-15 1.143548e-14
        N.pout  7.691613e-08 1.189664e-07 1.702015e-07 2.619421e-07 4.137159e-07
        Herring 5.315322e-11 8.345875e-11 1.227833e-10 1.916527e-10 3.046206e-10
        Dab     1.498464e-08 2.340060e-08 3.433354e-08 5.319373e-08 8.391743e-08
        Whiting 1.113479e-07 1.722221e-07 2.463928e-07 3.792013e-07 5.989173e-07
        Sole    2.659081e-09 4.175785e-09 6.232986e-09 9.691958e-09 1.527057e-08
        Gurnard 3.816492e-09 6.000336e-09 8.996551e-09 1.399316e-08 2.202253e-08
        Plaice  7.001337e-09 1.098591e-08 1.644792e-08 2.550259e-08 4.000007e-08
        Haddock 7.138495e-09 1.117563e-08 1.647155e-08 2.558577e-08 4.042451e-08
        Cod     7.250003e-08 1.151499e-07 1.773385e-07 2.769475e-07 4.336879e-07
        Saithe  2.236119e-08 3.585259e-08 5.612476e-08 8.813315e-08 1.380052e-07
               w
      predator          97.8          117          139          166          198
        Sprat   7.034446e-15 1.139508e-14 1.853241e-14 3.027750e-14 4.971247e-14
        Sandeel 1.889765e-14 3.124716e-14 5.169837e-14 8.558467e-14 1.417278e-13
        N.pout  7.444393e-07 1.319364e-06 2.483681e-06 4.645375e-06 8.530163e-06
        Herring 5.359703e-10 9.306981e-10 1.702036e-09 3.106041e-09 5.597768e-09
        Dab     1.464082e-07 2.534071e-07 4.628659e-07 8.463073e-07 1.531027e-06
        Whiting 1.077690e-06 1.909981e-06 3.595510e-06 6.724894e-06 1.234872e-05
        Sole    2.606206e-08 4.436244e-08 7.923039e-08 1.423809e-07 2.546410e-07
        Gurnard 3.732282e-08 6.319665e-08 1.120995e-07 2.004231e-07 3.573143e-07
        Plaice  6.753569e-08 1.141310e-07 2.022760e-07 3.618966e-07 6.463160e-07
        Haddock 7.032103e-08 1.213625e-07 2.206574e-07 4.017641e-07 7.243671e-07
        Cod     7.069028e-07 1.157981e-06 1.964334e-06 3.386638e-06 5.891120e-06
        Saithe  2.208992e-07 3.549701e-07 5.853463e-07 9.825924e-07 1.673844e-06
               w
      predator           237          282          337          402          480
        Sprat   8.187968e-14 1.349927e-13 2.223236e-13 3.651009e-13 5.973426e-13
        Sandeel 2.345992e-13 3.885654e-13 6.441790e-13 1.066905e-12 1.765660e-12
        N.pout  1.297692e-05 2.348398e-05 4.981901e-05 8.123240e-05 1.170200e-04
        Herring 8.556481e-09 1.530981e-08 3.170403e-08 5.169832e-08 7.554635e-08
        Dab     2.361687e-06 4.228225e-06 8.728334e-06 1.435437e-05 2.120728e-05
        Whiting 1.878608e-05 3.399666e-05 7.212066e-05 1.175964e-04 1.694044e-04
        Sole    3.982542e-07 7.061892e-07 1.421375e-06 2.358455e-06 3.565385e-06
        Gurnard 5.616178e-07 9.932111e-07 1.983369e-06 3.302951e-06 5.033921e-06
        Plaice  1.019638e-06 1.805197e-06 3.603692e-06 6.023677e-06 9.222511e-06
        Haddock 1.118182e-06 1.997364e-06 4.104195e-06 6.748501e-06 9.992716e-06
        Cod     9.509649e-06 1.654468e-05 3.144547e-05 5.352223e-05 8.581671e-05
        Saithe  2.727456e-06 4.694154e-06 8.660342e-06 1.490276e-05 2.460836e-05
               w
      predator           573          683          816          973         1160
        Sprat   9.732356e-13 1.580168e-12 2.559186e-12 4.139832e-12 6.697126e-12
        Sandeel 2.920285e-12 4.828095e-12 7.985031e-12 1.318749e-11 2.176575e-11
        N.pout  1.606781e-04 2.300899e-04 4.356577e-04 6.143287e-04 8.802625e-04
        Herring 1.064203e-07 1.565290e-07 2.928856e-07 4.236808e-07 6.234613e-07
        Dab     3.013941e-05 4.439600e-05 8.191492e-05 1.189095e-04 1.748093e-04
        Whiting 2.326062e-04 3.330904e-04 6.306812e-04 8.893347e-04 1.274314e-03
        Sole    5.211594e-06 7.833293e-06 1.412363e-05 2.096241e-05 3.137848e-05
        Gurnard 7.426562e-06 1.123113e-05 2.009657e-05 3.002715e-05 4.517090e-05
        Plaice  1.365584e-05 2.067178e-05 3.682177e-05 5.506263e-05 8.276215e-05
        Haddock 1.425786e-05 2.108738e-05 3.883742e-05 5.661115e-05 8.358485e-05
        Cod     1.341319e-04 2.112080e-04 3.644401e-04 5.668666e-04 8.789105e-04
        Saithe  3.981885e-05 6.441760e-05 1.099972e-04 1.752464e-04 2.768481e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   1.084780e-11 1.761179e-11 2.868986e-11 4.694404e-11 7.723436e-11
        Sandeel 3.596135e-11 5.929184e-11 9.774485e-11 1.609866e-10 2.650292e-10
        N.pout  2.131291e-03 2.953556e-03 4.722946e-03 6.536433e-03 9.332731e-03
        Herring 1.426542e-06 2.017607e-06 3.237325e-06 4.601019e-06 6.738142e-06
        Dab     3.922760e-04 5.595367e-04 8.973149e-04 1.280155e-03 1.872405e-03
        Whiting 3.085368e-03 4.275720e-03 6.837176e-03 9.462462e-03 1.351050e-02
        Sole    6.630094e-05 9.699860e-05 1.559831e-04 2.279196e-04 3.391898e-04
        Gurnard 9.363717e-05 1.380898e-04 2.222005e-04 3.269468e-04 4.887990e-04
        Plaice  1.702957e-04 2.516832e-04 4.046962e-04 5.958799e-04 8.900337e-04
        Haddock 1.859622e-04 2.662141e-04 4.272487e-04 6.122504e-04 8.992587e-04
        Cod     1.635879e-03 2.519230e-03 4.061644e-03 6.204717e-03 9.510799e-03
        Saithe  4.893771e-04 7.683279e-04 1.237605e-03 1.922078e-03 2.980492e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   1.278660e-10 2.130603e-10 3.570654e-10 6.008415e-10 1.012651e-09
        Sandeel 4.362021e-10 7.176802e-10 1.180354e-09 1.940806e-09 3.190805e-09
        N.pout  1.465691e-02 2.334169e-02 3.630247e-02 5.753620e-02 9.756517e-02
        Herring 1.066473e-05 1.703371e-05 2.664728e-05 4.226536e-05 7.067528e-05
        Dab     2.944474e-03 4.675969e-03 7.285988e-03 1.151235e-02 1.917930e-02
        Whiting 2.121796e-02 3.379033e-02 5.255241e-02 8.329021e-02 1.412349e-01
        Sole    5.335135e-04 8.452851e-04 1.319067e-03 2.080255e-03 3.422520e-03
        Gurnard 7.684075e-04 1.215930e-03 1.897274e-03 2.989080e-03 4.898450e-03
        Plaice  1.395588e-03 2.202999e-03 3.430805e-03 5.395233e-03 8.827120e-03
        Haddock 1.416297e-03 2.250967e-03 3.511840e-03 5.551446e-03 9.230486e-03
        Cod     1.492004e-02 2.345510e-02 3.655519e-02 5.721994e-02 9.164351e-02
        Saithe  4.674980e-03 7.331137e-03 1.142162e-02 1.782412e-02 2.821920e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.704637e-09 2.858820e-09 4.768952e-09 7.910448e-09 1.306200e-08
        Sandeel 5.243130e-09 8.613508e-09 1.414330e-08 2.322026e-08 3.810617e-08
        N.pout  1.416609e-01 2.151820e-01 2.965872e-01 5.165502e-01 9.174976e-01
        Herring 1.042573e-04 1.595993e-04 2.266411e-04 3.858477e-04 6.672011e-04
        Dab     2.831297e-02 4.326514e-02 6.136602e-02 1.038623e-01 1.792495e-01
        Whiting 2.050639e-01 3.114839e-01 4.293092e-01 7.476779e-01 1.327919e+00
        Sole    5.119487e-03 7.859910e-03 1.137819e-02 1.886406e-02 3.187775e-02
        Gurnard 7.352949e-03 1.130024e-02 1.644431e-02 2.709834e-02 4.551688e-02
        Plaice  1.324713e-02 2.034135e-02 2.957935e-02 4.865012e-02 8.166493e-02
        Haddock 1.366385e-02 2.090915e-02 2.980056e-02 5.026655e-02 8.638141e-02
        Cod     1.399053e-01 2.159296e-01 3.227739e-01 5.153450e-01 8.364993e-01
        Saithe  4.336828e-02 6.703083e-02 1.014333e-01 1.597164e-01 2.547574e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   2.152304e-08 3.550419e-08 5.881865e-08 9.807584e-08 1.646758e-07
        Sandeel 6.255771e-08 1.026081e-07 1.680647e-07 2.750852e-07 4.496459e-07
        N.pout  2.426218e+00 4.647376e+00 6.776224e+00 1.082504e+01 1.523664e+01
        Herring 1.620973e-03 3.025301e-03 4.441477e-03 7.114479e-03 1.022324e-02
        Dab     4.351184e-01 8.192828e-01 1.219444e+00 1.966347e+00 2.850744e+00
        Whiting 3.511262e+00 6.725501e+00 9.806395e+00 1.566449e+01 2.203948e+01
        Sole    7.213662e-02 1.339696e-01 2.035056e-01 3.305813e-01 4.907755e-01
        Gurnard 1.009086e-01 1.867613e-01 2.858354e-01 4.657138e-01 6.968944e-01
        Plaice  1.810934e-01 3.364546e-01 5.178848e-01 8.466662e-01 1.272001e+00
        Haddock 2.065958e-01 3.870807e-01 5.767006e-01 9.298783e-01 1.352124e+00
        Cod     1.636297e+00 2.943504e+00 4.701533e+00 7.802847e+00 1.225954e+01
        Saithe  4.638486e-01 8.133652e-01 1.323281e+00 2.215555e+00 3.578181e+00
      
      , , prey = Saithe
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   7.273381e-23 1.175918e-22 1.180896e-22 2.091140e-22 1.277080e-22
        Sandeel 1.105106e-22 1.536751e-22 1.770195e-22 2.039101e-22 1.998281e-22
        N.pout  1.318015e-20 1.715495e-20 2.297950e-20 3.508577e-20 5.983781e-20
        Herring 6.155845e-08 5.930316e-08 5.811854e-08 5.171208e-08 3.637777e-08
        Dab     8.927587e-22 8.739613e-22 1.364475e-21 1.531030e-21 2.873050e-21
        Whiting 4.880192e-21 6.351933e-21 8.508577e-21 1.299114e-20 2.215604e-20
        Sole    0.000000e+00 1.391759e-23 0.000000e+00 7.669242e-23 1.262299e-22
        Gurnard 1.017117e-21 1.454441e-21 1.737508e-21 2.265612e-21 3.265196e-21
        Plaice  4.187268e-22 3.823206e-22 5.728943e-22 7.210835e-22 1.074819e-21
        Haddock 1.148099e-21 3.110667e-21 9.721547e-22 3.392718e-21 8.166201e-21
        Cod     1.965442e-20 2.793655e-20 2.533491e-20 3.378423e-20 3.611897e-20
        Saithe  7.162798e-20 6.606109e-20 7.378044e-20 5.518739e-20 8.635561e-20
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   1.895180e-22 1.026036e-22 2.105380e-22 2.225757e-22 2.349130e-22
        Sandeel 2.463368e-22 2.698020e-22 3.215038e-22 3.456532e-22 3.697206e-22
        N.pout  1.044579e-19 1.524440e-19 2.153557e-19 3.026307e-19 6.561939e-19
        Herring 2.387987e-08 9.650403e-09 0.000000e+00 2.003365e-21 2.019231e-21
        Dab     3.510859e-21 4.722167e-21 5.863947e-21 7.675666e-21 1.288833e-20
        Whiting 3.867744e-20 5.644516e-20 7.973938e-20 1.120545e-19 2.429677e-19
        Sole    2.748914e-22 2.932404e-22 4.407121e-22 5.377433e-22 1.118225e-21
        Gurnard 5.236275e-21 6.530301e-21 8.719718e-21 1.016409e-20 1.662324e-20
        Plaice  1.350061e-21 1.965466e-21 2.653670e-21 3.237115e-21 5.530513e-21
        Haddock 7.558515e-21 1.522873e-20 2.090605e-20 2.458283e-20 4.760508e-20
        Cod     4.628254e-20 6.064711e-20 7.482799e-20 9.476287e-20 1.571201e-19
        Saithe  6.644932e-20 1.352891e-19 1.246833e-19 2.377268e-19 3.840696e-19
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   2.340082e-22 2.040122e-22 1.312463e-22 0.000000e+00 1.549708e-22
        Sandeel 3.603634e-22 3.396317e-22 4.346938e-22 9.513817e-22 5.767916e-22
        N.pout  9.394967e-19 1.471003e-18 2.737203e-18 4.039879e-18 7.074003e-18
        Herring 3.322811e-21 7.655143e-21 3.527208e-21 3.047263e-21 5.850277e-21
        Dab     1.725552e-20 2.629340e-20 4.465163e-20 6.427558e-20 1.103722e-19
        Whiting 3.478658e-19 5.446658e-19 1.013499e-18 1.495839e-18 2.619279e-18
        Sole    1.517078e-21 2.445699e-21 4.296047e-21 6.298522e-21 1.093598e-20
        Gurnard 2.096500e-20 3.325921e-20 5.026838e-20 7.610628e-20 1.229748e-19
        Plaice  8.560348e-21 1.281468e-20 2.261453e-20 3.406251e-20 5.930302e-20
        Haddock 6.683508e-20 1.048376e-19 1.796550e-19 2.677297e-19 4.637186e-19
        Cod     2.380440e-19 3.619312e-19 6.269156e-19 9.781336e-19 1.658790e-18
        Saithe  7.167119e-19 1.148268e-18 2.117183e-18 3.314202e-18 5.791138e-18
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   8.503684e-23 5.780234e-22 0.000000e+00 1.495529e-21 9.160148e-22
        Sandeel 7.972928e-22 1.377612e-21 1.234241e-21 0.000000e+00 2.105620e-21
        N.pout  1.385230e-17 1.983089e-17 3.185603e-17 5.885499e-17 1.039938e-16
        Herring 8.086776e-21 1.397283e-20 1.967217e-20 1.854043e-20 2.847582e-20
        Dab     2.082560e-19 3.040397e-19 4.910504e-19 8.936870e-19 1.567163e-18
        Whiting 5.129065e-18 7.342750e-18 1.179528e-17 2.179213e-17 3.850560e-17
        Sole    2.111510e-20 3.182883e-20 5.217502e-20 9.537270e-20 1.667025e-19
        Gurnard 2.315112e-19 3.403225e-19 5.556481e-19 9.947955e-19 1.723395e-18
        Plaice  1.094881e-19 1.663843e-19 2.703860e-19 4.845730e-19 8.414996e-19
        Haddock 8.639801e-19 1.261961e-18 2.018265e-18 3.703789e-18 6.476238e-18
        Cod     2.933275e-18 4.626697e-18 7.554912e-18 1.315219e-17 2.252658e-17
        Saithe  1.001710e-17 1.624607e-17 2.674711e-17 4.612185e-17 7.826051e-17
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   2.491111e-21 1.909594e-21 2.205287e-21 7.206862e-22 0.000000e+00
        Sandeel 0.000000e+00 0.000000e+00 5.006321e-21 2.471494e-21 3.795911e-21
        N.pout  1.485778e-16 2.308242e-16 4.530096e-16 7.186441e-16 1.320541e-15
        Herring 6.013613e-20 7.241997e-20 1.160642e-19 1.838309e-19 3.031965e-19
        Dab     2.295892e-18 3.607510e-18 6.887348e-18 1.101312e-17 1.994690e-17
        Whiting 5.501364e-17 8.546688e-17 1.677351e-16 2.660911e-16 4.889545e-16
        Sole    2.511876e-19 3.977393e-19 7.434991e-19 1.197070e-18 2.142513e-18
        Gurnard 2.603273e-18 4.134615e-18 7.650694e-18 1.236169e-17 2.201617e-17
        Plaice  1.276951e-18 2.028203e-18 3.739405e-18 6.043545e-18 1.074960e-17
        Haddock 9.538512e-18 1.499941e-17 2.858192e-17 4.570942e-17 8.273212e-17
        Cod     3.545190e-17 5.710375e-17 1.006739e-16 1.645451e-16 2.856292e-16
        Saithe  1.259298e-16 2.046421e-16 3.533663e-16 5.814056e-16 9.958727e-16
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 1.073721e-21 0.000000e+00
        Sandeel 4.372540e-21 3.777572e-21 1.450472e-21 1.002486e-20 0.000000e+00
        N.pout  1.818996e-15 3.022679e-15 4.970580e-15 7.590283e-15 1.104956e-14
        Herring 4.268665e-19 7.407592e-19 1.206370e-18 1.796348e-18 2.654857e-18
        Dab     2.834410e-17 4.705243e-17 7.740241e-17 1.197589e-16 1.781299e-16
        Whiting 6.735166e-16 1.119202e-15 1.840448e-15 2.810440e-15 4.091300e-15
        Sole    3.129071e-18 5.185212e-18 8.528831e-18 1.333306e-17 2.016132e-17
        Gurnard 3.243052e-17 5.369762e-17 8.831459e-17 1.384855e-16 2.103836e-16
        Plaice  1.588296e-17 2.628061e-17 4.318893e-17 6.773903e-17 1.029233e-16
        Haddock 1.179797e-16 1.959126e-16 3.223284e-16 4.997828e-16 7.457678e-16
        Cod     4.424898e-16 7.306875e-16 1.201696e-15 1.918315e-15 2.996156e-15
        Saithe  1.583019e-15 2.615805e-15 4.306922e-15 6.947805e-15 1.101887e-14
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   5.936297e-21 0.000000e+00 1.890437e-21 0.000000e+00 1.672270e-21
        Sandeel 4.433966e-21 0.000000e+00 0.000000e+00 6.777125e-21 1.170994e-20
        N.pout  2.015704e-14 2.827877e-14 5.126726e-14 1.071236e-13 2.111876e-13
        Herring 4.902035e-18 7.019512e-18 1.229285e-17 2.464292e-17 4.731063e-17
        Dab     3.174922e-16 4.579217e-16 8.107009e-16 1.623686e-15 3.125774e-15
        Whiting 7.463513e-15 1.047073e-14 1.898264e-14 3.966447e-14 7.819605e-14
        Sole    3.526470e-17 5.198486e-17 9.032231e-17 1.747918e-16 3.300493e-16
        Gurnard 3.656832e-16 5.425342e-16 9.368927e-16 1.793598e-15 3.366515e-15
        Plaice  1.783407e-16 2.647925e-16 4.560126e-16 8.708067e-16 1.634580e-15
        Haddock 1.326421e-15 1.920799e-15 3.392398e-15 6.754255e-15 1.294812e-14
        Cod     5.038586e-15 7.746285e-15 1.294108e-14 2.320503e-14 4.178050e-14
        Saithe  1.827448e-14 2.860059e-14 4.706443e-14 8.138656e-14 1.423942e-13
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   0.000000e+00 3.106490e-20 1.533596e-20 0.000000e+00 1.356610e-20
        Sandeel 4.496255e-20 2.071709e-20 1.193209e-20 0.000000e+00 1.583258e-20
        N.pout  3.605501e-13 5.599529e-13 8.960224e-13 1.679029e-12 2.572294e-12
        Herring 8.012726e-17 1.249218e-16 2.007194e-16 3.725016e-16 5.761045e-16
        Dab     5.333265e-15 8.390110e-15 1.354286e-14 2.502672e-14 3.894894e-14
        Whiting 1.335003e-13 2.073328e-13 3.317686e-13 6.216911e-13 9.524388e-13
        Sole    5.638097e-16 8.981982e-16 1.460783e-15 2.664363e-15 4.204568e-15
        Gurnard 5.755922e-15 9.211617e-15 1.502212e-14 2.728598e-14 4.326745e-14
        Plaice  2.801494e-15 4.497949e-15 7.349381e-15 1.333918e-14 2.120597e-14
        Haddock 2.206532e-14 3.473804e-14 5.610722e-14 1.034811e-13 1.612861e-13
        Cod     7.150340e-14 1.174181e-13 1.947066e-13 3.454786e-13 5.643616e-13
        Saithe  2.423867e-13 4.023057e-13 6.726780e-13 1.179435e-12 1.959360e-12
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   0.000000e+00 5.400224e-20 1.036760e-19 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 1.050406e-20 3.629913e-20 2.787550e-20 8.027502e-20
        N.pout  4.145878e-12 6.813958e-12 1.264967e-11 1.903924e-11 3.272122e-11
        Herring 9.341540e-16 1.542174e-15 2.835374e-15 4.320834e-15 7.414955e-15
        Dab     6.325618e-14 1.043697e-13 1.908603e-13 2.924049e-13 5.003995e-13
        Whiting 1.535087e-12 2.522992e-12 4.683772e-12 7.049625e-12 1.211563e-11
        Sole    6.868211e-15 1.135996e-14 2.049331e-14 3.188168e-14 5.433730e-14
        Gurnard 7.081588e-14 1.172195e-13 2.105152e-13 3.291570e-13 5.601947e-13
        Plaice  3.473520e-14 5.749638e-14 1.030624e-13 1.614355e-13 2.744619e-13
        Haddock 2.621830e-13 4.328747e-13 7.903172e-13 1.213296e-12 2.075899e-12
        Cod     9.365829e-13 1.561248e-12 2.734834e-12 4.407489e-12 7.447685e-12
        Saithe  3.284160e-12 5.511742e-12 9.551066e-12 1.565561e-11 2.639804e-11
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   3.169285e-20 7.301449e-20 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 5.548165e-20 1.810776e-19 2.944725e-19 6.077427e-19 1.009394e-18
        N.pout  6.085584e-11 9.275746e-11 1.560113e-10 2.600043e-10 3.619980e-10
        Herring 1.364004e-14 2.099714e-14 3.533005e-14 5.894431e-14 8.403642e-14
        Dab     9.163053e-13 1.418325e-12 2.383887e-12 3.975560e-12 5.706562e-12
        Whiting 2.253298e-11 3.434514e-11 5.776604e-11 9.627132e-11 1.340364e-10
        Sole    9.817197e-14 1.540724e-13 2.587661e-13 4.317601e-13 6.355308e-13
        Gurnard 1.007618e-12 1.588618e-12 2.667245e-12 4.450837e-12 6.603380e-12
        Plaice  4.928011e-13 7.782998e-13 1.306155e-12 2.179048e-12 3.239755e-12
        Haddock 3.794478e-12 5.883478e-12 9.889779e-12 1.649662e-11 2.377239e-11
        Cod     1.304358e-11 2.111198e-11 3.538614e-11 5.908014e-11 9.175063e-11
        Saithe  4.558273e-11 7.473782e-11 1.251491e-10 2.089473e-10 3.321984e-10
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   1.285523e-19 2.961608e-19 2.985062e-19 5.648992e-19 1.103381e-18
        Sandeel 1.715963e-18 2.786725e-18 4.628445e-18 7.825327e-18 1.300930e-17
        N.pout  5.540620e-10 9.591136e-10 1.328531e-09 2.010192e-09 2.729561e-09
        Herring 1.305164e-13 2.249520e-13 3.204419e-13 4.926727e-13 6.944316e-13
        Dab     8.848022e-12 1.513943e-11 2.163560e-11 3.313619e-11 4.664418e-11
        Whiting 2.051515e-10 3.551293e-10 4.919130e-10 7.443103e-10 1.010670e-09
        Sole    9.945094e-13 1.684628e-12 2.465921e-12 3.807872e-12 5.495601e-12
        Gurnard 1.035932e-11 1.748669e-11 2.577585e-11 3.987859e-11 5.793181e-11
        Plaice  5.079058e-12 8.551009e-12 1.261149e-11 1.947762e-11 2.826126e-11
        Haddock 3.694796e-11 6.318607e-11 9.071594e-11 1.393189e-10 1.972943e-10
        Cod     1.462889e-10 2.426018e-10 3.719226e-10 5.823360e-10 8.769305e-10
        Saithe  5.351139e-10 8.818255e-10 1.379730e-09 2.178013e-09 3.342154e-09
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   1.531709e-18 2.993829e-18 5.059409e-18 8.773092e-18 1.474628e-17
        Sandeel 2.156544e-17 3.598060e-17 5.963982e-17 9.930700e-17 1.647835e-16
        N.pout  4.788434e-09 8.257442e-09 1.272294e-08 1.753754e-08 2.483565e-08
        Herring 1.200043e-12 2.039780e-12 3.159597e-12 4.479899e-12 6.509046e-12
        Dab     7.967956e-11 1.346272e-10 2.083642e-10 2.956194e-10 4.281441e-10
        Whiting 1.773005e-09 3.057468e-09 4.710900e-09 6.493592e-09 9.195851e-09
        Sole    9.206318e-12 1.533094e-11 2.383307e-11 3.455937e-11 5.084855e-11
        Gurnard 9.643352e-11 1.598280e-10 2.486927e-10 3.627142e-10 5.356899e-10
        Plaice  4.683897e-11 7.741509e-11 1.203301e-10 1.753981e-10 2.586061e-10
        Haddock 3.364307e-10 5.673979e-10 8.792281e-10 1.253377e-09 1.823080e-09
        Cod     1.413817e-09 2.280794e-09 3.557462e-09 5.340397e-09 8.035874e-09
        Saithe  5.324580e-09 8.479970e-09 1.321674e-08 2.007283e-08 3.043777e-08
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   2.451703e-17 4.093688e-17 6.783093e-17 1.118167e-16 1.859798e-16
        Sandeel 2.740492e-16 4.547596e-16 7.551263e-16 1.251289e-15 2.073820e-15
        N.pout  5.440068e-08 7.732497e-08 1.099863e-07 1.655568e-07 3.723790e-07
        Herring 1.332443e-11 1.925269e-11 2.792794e-11 4.244732e-11 8.919894e-11
        Dab     8.683786e-10 1.259970e-09 1.830091e-09 2.776430e-09 5.803066e-09
        Whiting 2.014284e-08 2.863098e-08 4.072445e-08 6.130044e-08 1.378801e-07
        Sole    9.750532e-11 1.439831e-10 2.125701e-10 3.243253e-10 6.405534e-10
        Gurnard 1.010679e-09 1.500029e-09 2.224473e-09 3.398490e-09 6.604238e-09
        Plaice  4.864354e-10 7.226849e-10 1.072013e-09 1.636926e-09 3.177156e-09
        Haddock 3.658942e-09 5.324207e-09 7.758529e-09 1.178914e-08 2.436371e-08
        Cod     1.387025e-08 2.109130e-08 3.198040e-08 4.919353e-08 8.733658e-08
        Saithe  5.030456e-08 7.710468e-08 1.179213e-07 1.819220e-07 3.086966e-07
               w
      predator          97.8          117          139          166          198
        Sprat   3.084286e-16 5.134953e-16 8.548413e-16 1.422181e-15 2.362325e-15
        Sandeel 3.433954e-15 5.678461e-15 9.371951e-15 1.544444e-14 2.540060e-14
        N.pout  8.416249e-07 1.547913e-06 2.565471e-06 4.143108e-06 6.245553e-06
        Herring 1.911691e-10 3.446787e-10 5.680993e-10 9.177801e-10 1.397661e-09
        Dab     1.246501e-08 2.266558e-08 3.772142e-08 6.142816e-08 9.430489e-08
        Whiting 3.116270e-07 5.731429e-07 9.499124e-07 1.534061e-06 2.312530e-06
        Sole    1.318543e-09 2.377345e-09 3.977350e-09 6.528839e-09 1.018356e-08
        Gurnard 1.342641e-08 2.416506e-08 4.053531e-08 6.676339e-08 1.047354e-07
        Plaice  6.468287e-09 1.168610e-08 1.968956e-08 3.255536e-08 5.126603e-08
        Haddock 5.183490e-08 9.389716e-08 1.560747e-07 2.540939e-07 3.906350e-07
        Cod     1.639732e-07 2.903635e-07 4.938314e-07 8.304953e-07 1.351574e-06
        Saithe  5.518026e-07 9.612183e-07 1.640091e-06 2.786684e-06 4.633643e-06
               w
      predator           237          282          337          402          480
        Sprat   3.916250e-15 6.469547e-15 1.065028e-14 1.746538e-14 2.854418e-14
        Sandeel 4.172109e-14 6.837744e-14 1.118391e-13 1.825880e-13 2.976457e-13
        N.pout  1.099022e-05 1.669304e-05 2.358379e-05 3.399154e-05 5.612087e-05
        Herring 2.451779e-09 3.769530e-09 5.454581e-09 8.065585e-09 1.338283e-08
        Dab     1.651858e-07 2.552937e-07 3.714894e-07 5.495871e-07 9.047033e-07
        Whiting 4.069330e-06 6.180901e-06 8.732328e-06 1.258599e-05 2.077977e-05
        Sole    1.773685e-08 2.780257e-08 4.140050e-08 6.238418e-08 1.022549e-07
        Gurnard 1.821395e-07 2.868962e-07 4.303752e-07 6.520352e-07 1.066878e-06
        Plaice  8.918435e-08 1.408102e-07 2.117108e-07 3.208445e-07 5.234855e-07
        Haddock 6.836289e-07 1.058448e-06 1.545906e-06 2.296094e-06 3.783272e-06
        Cod     2.338906e-06 3.804343e-06 5.978336e-06 9.383302e-06 1.528335e-05
        Saithe  8.027891e-06 1.333196e-05 2.155949e-05 3.464306e-05 5.665674e-05
               w
      predator           573          683          816          973         1160
        Sprat   4.651522e-14 7.570417e-14 1.233161e-13 2.016462e-13 3.320503e-13
        Sandeel 4.844636e-13 7.873863e-13 1.278574e-12 2.072540e-12 3.358468e-12
        N.pout  9.722193e-05 1.669564e-04 3.233576e-04 4.693910e-04 8.393642e-04
        Herring 2.305169e-08 3.932134e-08 7.434093e-08 1.094158e-07 1.932918e-07
        Dab     1.546840e-06 2.627914e-06 4.942456e-06 7.325007e-06 1.290312e-05
        Whiting 3.599819e-05 6.181866e-05 1.197290e-04 1.738005e-04 3.107897e-04
        Sole    1.729154e-07 2.913239e-07 5.353157e-07 8.083543e-07 1.406975e-06
        Gurnard 1.797265e-06 3.019254e-06 5.506638e-06 8.364863e-06 1.450360e-05
        Plaice  8.791096e-07 1.473589e-06 2.680620e-06 4.079393e-06 7.064509e-06
        Haddock 6.464662e-06 1.097443e-05 2.056400e-05 3.055326e-05 5.371732e-05
        Cod     2.526789e-05 4.174721e-05 7.269047e-05 1.139225e-04 1.927491e-04
        Saithe  9.317166e-05 1.527944e-04 2.591801e-04 4.111786e-04 6.848401e-04
               w
      predator          1390         1650         1970         2360         2810
        Sprat   5.521248e-13 9.282652e-13 1.577128e-12 2.701120e-12 4.645978e-12
        Sandeel 5.441381e-12 8.810417e-12 1.426369e-11 2.310777e-11 3.744174e-11
        N.pout  1.611799e-03 2.587275e-03 3.930374e-03 6.627346e-03 9.563302e-03
        Herring 3.637808e-07 5.844913e-07 8.963070e-07 1.509577e-06 2.219216e-06
        Dab     2.421860e-05 3.912416e-05 6.033229e-05 1.015238e-04 1.500421e-04
        Whiting 5.967973e-04 9.579844e-04 1.455290e-03 2.453888e-03 3.540970e-03
        Sole    2.591604e-06 4.215032e-06 6.587036e-06 1.106007e-05 1.666820e-05
        Gurnard 2.655702e-05 4.329887e-05 6.796697e-05 1.140476e-04 1.729447e-04
        Plaice  1.292234e-05 2.110955e-05 3.320656e-05 5.572350e-05 8.466817e-05
        Haddock 1.004842e-04 1.623561e-04 2.507490e-04 4.218133e-04 6.252648e-04
        Cod     3.395604e-04 5.600746e-04 9.015151e-04 1.508204e-03 2.372488e-03
        Saithe  1.176703e-03 1.944522e-03 3.165311e-03 5.288691e-03 8.487443e-03
               w
      predator          3350         4000         4780         5700         6800
        Sprat   7.992448e-12 1.370247e-11 2.335399e-11 3.952314e-11 6.641545e-11
        Sandeel 6.072301e-11 9.856392e-11 1.602675e-10 2.608678e-10 4.252937e-10
        N.pout  1.436651e-02 2.024232e-02 3.628990e-02 5.622874e-02 9.496469e-02
        Herring 3.388411e-06 4.910351e-06 8.696328e-06 1.359677e-05 2.282010e-05
        Dab     2.291376e-04 3.323017e-04 5.823404e-04 9.089837e-04 1.518924e-03
        Whiting 5.319421e-03 7.495011e-03 1.343674e-02 2.081915e-02 3.516099e-02
        Sole    2.576210e-05 3.814352e-05 6.560581e-05 1.029635e-04 1.706412e-04
        Gurnard 2.682449e-04 3.995203e-04 6.830090e-04 1.073341e-03 1.773870e-03
        Plaice  1.313562e-04 1.956759e-04 3.333276e-04 5.232857e-04 8.631262e-04
        Haddock 9.573216e-04 1.394502e-03 2.439557e-03 3.814174e-03 6.368662e-03
        Cod     3.763815e-03 5.808618e-03 9.641662e-03 1.527783e-02 2.486588e-02
        Saithe  1.366284e-02 2.154072e-02 3.542883e-02 5.650039e-02 9.139917e-02
               w
      predator          8120         9690        11600        13800        16500
        Sprat   1.109108e-10 1.842794e-10 3.049522e-10 5.028754e-10 8.261507e-10
        Sandeel 6.940342e-10 1.134491e-09 1.855994e-09 3.040254e-09 4.985208e-09
        N.pout  1.349257e-01 2.294142e-01 3.260846e-01 5.366502e-01 9.445708e-01
        Herring 3.315142e-05 5.586001e-05 8.118509e-05 1.329787e-04 2.298526e-04
        Dab     2.210870e-03 3.705601e-03 5.391551e-03 8.790288e-03 1.513468e-02
        Whiting 4.995578e-02 8.493799e-02 1.207257e-01 1.986759e-01 3.496658e-01
        Sole    2.530791e-04 4.195780e-04 6.214906e-04 1.006135e-03 1.703909e-03
        Gurnard 2.644784e-03 4.369040e-03 6.503374e-03 1.050264e-02 1.769617e-02
        Plaice  1.286935e-03 2.121290e-03 3.156815e-03 5.088321e-03 8.559685e-03
        Haddock 9.304793e-03 1.557708e-02 2.274948e-02 3.707130e-02 6.365185e-02
        Cod     3.814340e-02 6.176493e-02 9.431222e-02 1.502204e-01 2.456875e-01
        Saithe  1.421313e-01 2.279566e-01 3.519207e-01 5.565245e-01 8.955916e-01
               w
      predator         19600        23400        28000        33400        39900
        Sprat   1.350859e-09 2.195240e-09 3.539854e-09 5.656236e-09 8.948768e-09
        Sandeel 8.175965e-09 1.342265e-08 2.205284e-08 3.621712e-08 5.946070e-08
        N.pout  1.324893e+00 2.580524e+00 5.642596e+00 9.534614e+00 1.516689e+01
        Herring 3.296965e-04 6.197824e-04 1.294078e-03 2.168117e-03 3.454611e-03
        Dab     2.177404e-02 4.070401e-02 8.481738e-02 1.431336e-01 2.297242e-01
        Whiting 4.904174e-01 9.551611e-01 2.088586e+00 3.528916e+00 5.611263e+00
        Sole    2.500942e-03 4.527588e-03 9.061945e-03 1.528902e-02 2.472697e-02
        Gurnard 2.612162e-02 4.683965e-02 9.262008e-02 1.563435e-01 2.535984e-01
        Plaice  1.264226e-02 2.262910e-02 4.472645e-02 7.571698e-02 1.232002e-01
        Haddock 9.191850e-02 1.708357e-01 3.530914e-01 5.948313e-01 9.546149e-01
        Cod     3.733224e-01 6.339965e-01 1.162176e+00 1.958390e+00 3.225943e+00
        Saithe  1.376893e+00 2.273551e+00 3.984881e+00 6.669844e+00 1.104241e+01
      
      , , prey = Resource
      
               w
      predator         0.001      0.00119      0.00142       0.0017      0.00203
        Sprat   4.948939e-22 5.527896e-21 5.855334e-21 6.055632e-21 1.251478e-20
        Sandeel 4.702539e-21 5.131792e-21 8.210210e-21 6.052739e-21 1.132982e-20
        N.pout  6.081808e-20 1.450592e-19 1.157938e-19 2.180904e-19 2.435658e-19
        Herring 1.214926e-06 1.188883e-06 1.174787e-06 1.138463e-06 1.006548e-06
        Dab     3.517260e-20 4.823514e-20 6.716140e-20 7.278969e-20 1.195474e-19
        Whiting 6.494679e-20 1.549067e-19 1.236546e-19 2.328957e-19 2.601006e-19
        Sole    0.000000e+00 0.000000e+00 0.000000e+00 5.658126e-21 7.811100e-21
        Gurnard 8.506105e-21 1.245307e-20 1.983436e-20 2.914860e-20 4.516384e-20
        Plaice  1.032318e-20 2.069452e-20 2.640829e-20 3.300607e-20 4.027481e-20
        Haddock 8.363252e-21 1.950554e-20 6.110780e-21 2.463958e-20 4.854017e-20
        Cod     1.159186e-19 2.173182e-19 1.782256e-19 2.457034e-19 3.004729e-19
        Saithe  2.083264e-19 1.395948e-19 2.112486e-19 1.040338e-19 2.302166e-19
               w
      predator       0.00242      0.00289      0.00345      0.00411      0.00491
        Sprat   1.269106e-20 3.238363e-21 8.037682e-21 7.000217e-21 1.828041e-20
        Sandeel 1.054112e-20 6.938513e-21 1.864923e-20 1.227554e-20 3.888579e-20
        N.pout  4.230076e-19 6.438567e-19 1.181621e-18 1.769210e-18 2.802569e-18
        Herring 9.435078e-07 8.437004e-07 0.000000e+00 1.190534e-20 0.000000e+00
        Dab     1.577626e-19 2.445417e-19 3.268182e-19 4.173889e-19 5.769862e-19
        Whiting 4.517240e-19 6.875657e-19 1.261836e-18 1.889315e-18 2.992824e-18
        Sole    2.180915e-20 3.683854e-20 7.378900e-20 6.300026e-20 1.073743e-19
        Gurnard 5.250589e-20 7.971339e-20 1.067145e-19 1.388377e-19 1.723760e-19
        Plaice  6.491803e-20 7.937065e-20 1.196455e-19 1.330813e-19 2.140767e-19
        Haddock 6.649023e-20 1.028930e-19 1.712014e-19 1.762040e-19 2.771328e-19
        Cod     4.031700e-19 3.400591e-19 5.250838e-19 5.315858e-19 7.650920e-19
        Saithe  6.216461e-20 2.028357e-19 1.831062e-19 5.431315e-19 3.981825e-19
               w
      predator       0.00586      0.00699      0.00834      0.00995       0.0119
        Sprat   2.914547e-20 1.655638e-20 8.352875e-21 1.591163e-20 3.455763e-20
        Sandeel 3.664869e-20 3.752526e-20 2.161282e-20 8.713591e-20 8.603360e-20
        N.pout  5.047455e-18 7.388023e-18 1.473353e-17 2.196630e-17 3.520622e-17
        Herring 0.000000e+00 2.426239e-20 0.000000e+00 0.000000e+00 1.112520e-19
        Dab     9.240937e-19 1.263271e-18 2.287297e-18 3.333782e-18 5.231081e-18
        Whiting 5.390107e-18 7.889568e-18 1.573373e-17 2.345751e-17 3.759623e-17
        Sole    1.563905e-19 2.441244e-19 4.818720e-19 7.460496e-19 1.255277e-18
        Gurnard 2.449597e-19 3.502543e-19 6.243093e-19 9.237205e-19 1.495515e-18
        Plaice  3.992968e-19 5.545349e-19 1.021487e-18 1.634767e-18 2.645878e-18
        Haddock 3.902329e-19 6.311747e-19 1.051155e-18 1.656054e-18 2.556780e-18
        Cod     1.538220e-18 2.335827e-18 4.142357e-18 7.082506e-18 1.145481e-17
        Saithe  1.496148e-18 2.131028e-18 4.724486e-18 6.951253e-18 1.281221e-17
               w
      predator        0.0142       0.0169       0.0202       0.0241       0.0288
        Sprat   3.822993e-20 2.809874e-20 4.617047e-20 1.063581e-19 1.340042e-19
        Sandeel 1.651713e-20 3.805242e-20 1.753315e-19 1.514743e-19 1.163230e-19
        N.pout  5.571474e-17 9.400025e-17 1.469434e-16 2.781354e-16 4.558588e-16
        Herring 0.000000e+00 7.380970e-20 5.668131e-20 4.243957e-19 2.632349e-19
        Dab     8.234626e-18 1.367511e-17 2.147880e-17 3.992232e-17 6.548391e-17
        Whiting 5.949699e-17 1.003816e-16 1.569188e-16 2.970170e-16 4.868053e-16
        Sole    2.067828e-18 3.492584e-18 5.553204e-18 1.049769e-17 1.752666e-17
        Gurnard 2.318029e-18 3.845189e-18 6.073847e-18 1.116581e-17 1.838772e-17
        Plaice  4.206378e-18 7.075551e-18 1.135780e-17 2.055782e-17 3.400916e-17
        Haddock 4.115548e-18 6.756834e-18 1.073063e-17 1.976113e-17 3.257361e-17
        Cod     1.857294e-17 3.105425e-17 5.041702e-17 8.822411e-17 1.463637e-16
        Saithe  2.046032e-17 3.526637e-17 5.690138e-17 9.922406e-17 1.626892e-16
               w
      predator        0.0343       0.0409       0.0489       0.0583       0.0696
        Sprat   2.425842e-19 2.988242e-19 3.102526e-19 1.800801e-19 0.000000e+00
        Sandeel 2.009900e-19 5.402178e-19 6.222811e-19 2.048030e-19 3.538713e-19
        N.pout  6.403954e-16 9.957748e-16 1.414911e-15 2.045720e-15 2.989623e-15
        Herring 6.497620e-19 7.484659e-19 9.196413e-19 1.191760e-18 2.059196e-18
        Dab     9.462577e-17 1.484604e-16 2.168604e-16 3.202882e-16 4.775221e-16
        Whiting 6.838694e-16 1.063374e-15 1.510964e-15 2.184596e-15 3.192577e-15
        Sole    2.619983e-17 4.158912e-17 6.215451e-17 9.354390e-17 1.412268e-16
        Gurnard 2.747427e-17 4.364943e-17 6.551317e-17 9.873442e-17 1.497853e-16
        Plaice  5.090835e-17 8.056748e-17 1.207186e-16 1.817714e-16 2.739017e-16
        Haddock 4.687634e-17 7.439154e-17 1.089869e-16 1.620850e-16 2.419182e-16
        Cod     2.286447e-16 3.654568e-16 5.646959e-16 8.696107e-16 1.336680e-15
        Saithe  2.603810e-16 4.180481e-16 6.578406e-16 1.026396e-15 1.595285e-15
               w
      predator         0.083       0.0991        0.118        0.141        0.168
        Sprat   0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 1.358757e-19 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  6.117975e-15 1.000543e-14 1.679930e-14 3.093100e-14 4.279254e-14
        Herring 3.514080e-18 6.071844e-18 9.791887e-18 1.772469e-17 2.443879e-17
        Dab     9.229030e-16 1.500794e-15 2.495534e-15 4.486578e-15 6.381886e-15
        Whiting 6.533301e-15 1.068466e-14 1.793974e-14 3.303078e-14 4.569756e-14
        Sole    2.615947e-16 4.247981e-16 7.018446e-16 1.239099e-15 1.806287e-15
        Gurnard 2.735786e-16 4.438677e-16 7.316008e-16 1.283759e-15 1.886052e-15
        Plaice  4.984941e-16 8.066972e-16 1.328961e-15 2.331145e-15 3.432461e-15
        Haddock 4.654916e-16 7.556045e-16 1.255676e-15 2.247612e-15 3.208940e-15
        Cod     2.274957e-15 3.650624e-15 5.926520e-15 1.003923e-14 1.534213e-14
        Saithe  2.634317e-15 4.202702e-15 6.754811e-15 1.119265e-14 1.739301e-14
               w
      predator         0.201         0.24        0.286        0.342        0.408
        Sprat   1.694752e-19 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 2.204552e-18 2.539440e-18 2.193901e-18 5.054343e-18 0.000000e+00
        N.pout  6.521836e-14 1.147382e-13 1.755287e-13 3.219824e-13 4.756490e-13
        Herring 4.026694e-17 6.608666e-17 9.787596e-17 1.802816e-16 2.628785e-16
        Dab     9.826609e-15 1.698808e-14 2.624524e-14 4.703335e-14 7.067178e-14
        Whiting 6.964578e-14 1.225274e-13 1.874446e-13 3.438406e-13 5.079390e-13
        Sole    2.803900e-15 4.779517e-15 7.443532e-15 1.308878e-14 1.994961e-14
        Gurnard 2.934341e-15 4.980063e-15 7.774573e-15 1.359269e-14 2.081007e-14
        Plaice  5.342402e-15 9.058562e-15 1.415424e-14 2.472474e-14 3.792184e-14
        Haddock 4.947905e-15 8.533995e-15 1.319926e-14 2.357516e-14 3.548881e-14
        Cod     2.416971e-14 4.005655e-14 6.339446e-14 1.073299e-13 1.685580e-13
        Saithe  2.753802e-14 4.510210e-14 7.184763e-14 1.197499e-13 1.904755e-13
               w
      predator         0.486         0.58        0.693        0.827        0.987
        Sprat   4.582828e-19 0.000000e+00 6.080916e-19 0.000000e+00 0.000000e+00
        Sandeel 2.235522e-18 6.437787e-19 0.000000e+00 0.000000e+00 0.000000e+00
        N.pout  6.863900e-13 1.000479e-12 1.990637e-12 3.119406e-12 5.210594e-12
        Herring 3.873679e-16 5.752473e-16 1.110460e-15 1.743639e-15 2.889661e-15
        Dab     1.042171e-13 1.548950e-13 2.947844e-13 4.642965e-13 7.703344e-13
        Whiting 7.329864e-13 1.068398e-12 2.125773e-12 3.331171e-12 5.564322e-12
        Sole    2.991518e-14 4.507828e-14 8.281951e-14 1.310465e-13 2.163157e-13
        Gurnard 3.136122e-14 4.744060e-14 8.623857e-14 1.366549e-13 2.252308e-13
        Plaice  5.721233e-14 8.654752e-14 1.568599e-13 2.487103e-13 4.098818e-13
        Haddock 5.249392e-14 7.825948e-14 1.481008e-13 2.333802e-13 3.867973e-13
        Cod     2.614711e-13 4.048612e-13 6.954627e-13 1.110383e-12 1.813600e-12
        Saithe  3.001526e-13 4.713002e-13 7.896548e-13 1.265188e-12 2.056059e-12
               w
      predator          1.18          1.4         1.68            2         2.39
        Sprat   7.435534e-18 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 0.000000e+00 2.611291e-18 0.000000e+00 1.212715e-17 1.995622e-18
        N.pout  7.601271e-12 1.108032e-11 2.782504e-11 3.902055e-11 6.729352e-11
        Herring 4.286463e-15 6.360897e-15 1.491883e-14 2.123889e-14 3.629852e-14
        Dab     1.145181e-12 1.701311e-12 3.945580e-12 5.676226e-12 9.707809e-12
        Whiting 8.117292e-12 1.183252e-11 2.971397e-11 4.166951e-11 7.186182e-11
        Sole    3.265478e-13 4.920926e-13 1.069571e-12 1.575488e-12 2.676200e-12
        Gurnard 3.415919e-13 5.168673e-13 1.101483e-12 1.635254e-12 2.772486e-12
        Plaice  6.223552e-13 9.419727e-13 1.999487e-12 2.979157e-12 5.053552e-12
        Haddock 5.764385e-13 8.588534e-13 1.969483e-12 2.840752e-12 4.850502e-12
        Cod     2.821760e-12 4.368909e-12 8.309414e-12 1.287713e-11 2.157489e-11
        Saithe  3.237485e-12 5.070594e-12 9.090152e-12 1.435285e-11 2.385643e-11
               w
      predator          2.85          3.4         4.06         4.84         5.78
        Sprat   0.000000e+00 4.342687e-18 0.000000e+00 0.000000e+00 0.000000e+00
        Sandeel 5.746933e-18 1.588785e-17 3.202734e-17 3.689254e-17 6.880435e-17
        N.pout  9.339647e-11 1.983395e-10 3.162391e-10 5.150816e-10 7.636259e-10
        Herring 5.148092e-14 1.056181e-13 1.686510e-13 2.748741e-13 4.131569e-13
        Dab     1.387313e-11 2.820882e-11 4.528318e-11 7.401660e-11 1.118249e-10
        Whiting 9.973680e-11 2.118040e-10 3.377074e-10 5.500485e-10 8.154656e-10
        Sole    3.919143e-12 7.677847e-12 1.240622e-11 2.034102e-11 3.121632e-11
        Gurnard 4.091780e-12 7.924303e-12 1.283569e-11 2.107111e-11 3.250200e-11
        Plaice  7.478990e-12 1.444593e-11 2.344700e-11 3.853984e-11 5.956652e-11
        Haddock 6.956053e-12 1.406015e-11 2.257454e-11 3.689836e-11 5.586787e-11
        Cod     3.327650e-11 6.035443e-11 9.906905e-11 1.638305e-10 2.605185e-10
        Saithe  3.759768e-11 6.595091e-11 1.088624e-10 1.806897e-10 2.921373e-10
               w
      predator           6.9         8.23         9.82         11.7           14
        Sprat   0.000000e+00 0.000000e+00 1.648611e-17 2.337289e-17 7.319805e-17
        Sandeel 9.557373e-17 1.731937e-16 2.922954e-16 4.542741e-16 7.510635e-16
        N.pout  1.347524e-09 2.177944e-09 3.477457e-09 6.279928e-09 1.161094e-08
        Herring 7.236535e-13 1.173082e-12 1.882178e-12 3.361344e-12 6.128455e-12
        Dab     1.951216e-10 3.166488e-10 5.085011e-10 9.046181e-10 1.645866e-09
        Whiting 1.439002e-09 2.325797e-09 3.713528e-09 6.706248e-09 1.239916e-08
        Sole    5.391351e-11 8.776832e-11 1.415747e-10 2.486417e-10 4.463122e-10
        Gurnard 5.595423e-11 9.118749e-11 1.472978e-10 2.576379e-10 4.605026e-10
        Plaice  1.024409e-10 1.670217e-10 2.698812e-10 4.714025e-10 8.418694e-10
        Haddock 9.735294e-11 1.580568e-10 2.540185e-10 4.510639e-10 8.187416e-10
        Cod     4.411828e-10 7.241009e-10 1.180428e-09 2.017593e-09 3.512690e-09
        Saithe  4.915932e-10 8.107347e-10 1.329570e-09 2.247553e-09 3.854712e-09
               w
      predator          16.7         19.9         23.8         28.4         33.8
        Sprat   1.414982e-16 2.701662e-16 4.410903e-16 7.558474e-16 1.266114e-15
        Sandeel 1.236275e-15 2.000648e-15 3.258849e-15 5.251477e-15 8.544233e-15
        N.pout  2.116809e-08 3.700970e-08 6.342586e-08 8.900618e-08 1.531784e-07
        Herring 1.104433e-11 1.918965e-11 3.278687e-11 4.686475e-11 8.065636e-11
        Dab     2.967299e-09 5.169633e-09 8.859660e-09 1.279650e-08 2.194996e-08
        Whiting 2.260511e-08 3.952215e-08 6.773159e-08 9.504847e-08 1.635771e-07
        Sole    7.973306e-10 1.385792e-09 2.376195e-09 3.521145e-09 6.015785e-09
        Gurnard 8.204086e-10 1.425189e-09 2.444867e-09 3.654404e-09 6.235111e-09
        Plaice  1.499963e-09 2.608378e-09 4.480325e-09 6.722742e-09 1.146124e-08
        Haddock 1.473154e-09 2.563673e-09 4.390960e-09 6.361391e-09 1.091045e-08
        Cod     6.140842e-09 1.061249e-08 1.823152e-08 2.869430e-08 4.869919e-08
        Saithe  6.652621e-09 1.143053e-08 1.960724e-08 3.170467e-08 5.377561e-08
               w
      predator          40.4         48.2         57.5         68.7         81.9
        Sprat   2.120349e-15 3.513953e-15 5.829888e-15 9.546084e-15 1.559692e-14
        Sandeel 1.386197e-14 2.253096e-14 3.664752e-14 5.978588e-14 9.754683e-14
        N.pout  2.838851e-07 4.215562e-07 5.840523e-07 1.122389e-06 1.620628e-06
        Herring 1.481569e-10 2.230567e-10 3.172635e-10 6.005586e-10 8.841499e-10
        Dab     4.011912e-08 6.078448e-08 8.698952e-08 1.627123e-07 2.405996e-07
        Whiting 3.031570e-07 4.501740e-07 6.237014e-07 1.198583e-06 1.730646e-06
        Sole    1.085652e-08 1.673771e-08 2.458075e-08 4.491508e-08 6.771360e-08
        Gurnard 1.120537e-08 1.737550e-08 2.572430e-08 4.664233e-08 7.073779e-08
        Plaice  2.056423e-08 3.195802e-08 4.740997e-08 8.561463e-08 1.299913e-07
        Haddock 1.991071e-08 3.023579e-08 4.345436e-08 8.108985e-08 1.202972e-07
        Cod     8.548709e-08 1.372331e-07 2.131895e-07 3.710217e-07 5.825510e-07
        Saithe  9.336428e-08 1.527744e-07 2.437928e-07 4.171889e-07 6.675086e-07
               w
      predator          97.8          117          139          166          198
        Sprat   2.538381e-14 4.102680e-14 6.604210e-14 1.057539e-13 1.686228e-13
        Sandeel 1.595320e-13 2.612981e-13 4.286527e-13 7.045331e-13 1.159851e-12
        N.pout  2.306287e-06 4.066097e-06 6.526950e-06 1.212843e-05 2.126781e-05
        Herring 1.290160e-09 2.255573e-09 3.633729e-09 6.621859e-09 1.147913e-08
        Dab     3.516431e-07 6.091235e-07 9.789150e-07 1.773050e-06 3.071766e-06
        Whiting 2.462852e-06 4.342129e-06 6.970039e-06 1.295178e-05 2.271160e-05
        Sole    1.009680e-07 1.723886e-07 2.773266e-07 4.923393e-07 8.454150e-07
        Gurnard 1.060891e-07 1.802466e-07 2.899555e-07 5.114501e-07 8.757556e-07
        Plaice  1.949787e-07 3.301331e-07 5.303238e-07 9.330400e-07 1.596682e-06
        Haddock 1.765412e-07 3.054852e-07 4.913534e-07 8.873502e-07 1.534614e-06
        Cod     9.036469e-07 1.497089e-06 2.407055e-06 4.086572e-06 6.861012e-06
        Saithe  1.054989e-06 1.731157e-06 2.783841e-06 4.631940e-06 7.672769e-06
               w
      predator           237          282          337          402          480
        Sprat   2.674809e-13 4.227368e-13 6.665814e-13 1.051780e-12 1.665894e-12
        Sandeel 1.911778e-12 3.159173e-12 5.224522e-12 8.648451e-12 1.432664e-11
        N.pout  3.421166e-05 7.021103e-05 1.182268e-04 1.869239e-04 2.764455e-04
        Herring 1.847021e-08 3.685975e-08 6.177086e-08 9.803016e-08 1.469849e-07
        Dab     4.957758e-06 9.847824e-06 1.658804e-05 2.648466e-05 3.996575e-05
        Whiting 3.653416e-05 7.497739e-05 1.262527e-04 1.996134e-04 2.952124e-04
        Sole    1.369865e-06 2.647011e-06 4.466067e-06 7.197761e-06 1.105084e-05
        Gurnard 1.420893e-06 2.721841e-06 4.596532e-06 7.433225e-06 1.147833e-05
        Plaice  2.592794e-06 4.959447e-06 8.392149e-06 1.360511e-05 2.106421e-05
        Haddock 2.477168e-06 4.896745e-06 8.241073e-06 1.316490e-05 1.990919e-05
        Cod     1.118373e-05 2.027862e-05 3.431843e-05 5.655956e-05 9.040118e-05
        Saithe  1.249226e-05 2.190845e-05 3.694776e-05 6.136672e-05 9.988664e-05
               w
      predator           573          683          816          973         1160
        Sprat   2.654371e-12 4.261216e-12 6.889494e-12 1.119804e-11 1.824453e-11
        Sandeel 2.375792e-11 3.942541e-11 6.545627e-11 1.086845e-10 1.806748e-10
        N.pout  4.369268e-04 6.984119e-04 1.111567e-03 1.670123e-03 3.360113e-03
        Herring 2.343097e-07 3.773016e-07 6.050743e-07 9.235075e-07 1.809187e-06
        Dab     6.373456e-05 1.025198e-04 1.641907e-04 2.506960e-04 4.858453e-04
        Whiting 4.665881e-04 7.458243e-04 1.187026e-03 1.783500e-03 3.588216e-03
        Sole    1.773714e-05 2.864713e-05 4.606917e-05 7.118783e-05 1.337578e-04
        Gurnard 1.846123e-05 2.985250e-05 4.806283e-05 7.452786e-05 1.386549e-04
        Plaice  3.389910e-05 5.481280e-05 8.821842e-05 1.367985e-04 2.535211e-04
        Haddock 3.178934e-05 5.119068e-05 8.208293e-05 1.256493e-04 2.424838e-04
        Cod     1.475144e-04 2.408918e-04 3.914496e-04 6.204836e-04 1.092625e-03
        Saithe  1.646270e-04 2.711121e-04 4.442089e-04 7.142584e-04 1.226508e-03
               w
      predator          1390         1650         1970         2360         2810
        Sprat   2.970922e-11 4.824419e-11 7.803595e-11 1.257401e-10 2.020657e-10
        Sandeel 3.000675e-10 4.982140e-10 8.274669e-10 1.372877e-09 2.276475e-09
        N.pout  4.930944e-03 7.044403e-03 1.243557e-02 1.741015e-02 2.445421e-02
        Herring 2.693511e-06 3.932036e-06 6.869697e-06 9.858905e-06 1.424429e-05
        Dab     7.271071e-04 1.064785e-03 1.847619e-03 2.660286e-03 3.841645e-03
        Whiting 5.265682e-03 7.522611e-03 1.327974e-02 1.859200e-02 2.611419e-02
        Sole    2.035750e-04 3.039768e-04 5.201090e-04 7.654736e-04 1.127612e-03
        Gurnard 2.121450e-04 3.186074e-04 5.426452e-04 8.037572e-04 1.190378e-03
        Plaice  3.884448e-04 5.838036e-04 9.918389e-04 1.470013e-03 2.175680e-03
        Haddock 3.638001e-04 5.346627e-04 9.263485e-04 1.339300e-03 1.942954e-03
        Cod     1.721926e-03 2.672057e-03 4.439805e-03 6.810965e-03 1.039134e-02
        Saithe  1.961791e-03 3.095695e-03 5.086719e-03 7.935466e-03 1.228844e-02
               w
      predator          3350         4000         4780         5700         6800
        Sprat   3.245033e-10 5.219964e-10 8.430514e-10 1.369554e-09 2.240361e-09
        Sandeel 3.775082e-09 6.259928e-09 1.036666e-08 1.716041e-08 2.837651e-08
        N.pout  4.670671e-02 1.005458e-01 1.620091e-01 2.814079e-01 4.335960e-01
        Herring 2.642809e-05 5.437702e-05 8.734809e-05 1.501307e-04 2.326006e-04
        Dab     7.048723e-03 1.440815e-02 2.327814e-02 4.010595e-02 6.251127e-02
        Whiting 4.987705e-02 1.073704e-01 1.730041e-01 3.005034e-01 4.630126e-01
        Sole    2.006702e-03 3.936789e-03 6.387276e-03 1.093972e-02 1.723516e-02
        Gurnard 2.098450e-03 4.064986e-03 6.605892e-03 1.129619e-02 1.786282e-02
        Plaice  3.820238e-03 7.381010e-03 1.201624e-02 2.056887e-02 3.260263e-02
        Haddock 3.549801e-03 7.202914e-03 1.163225e-02 2.000405e-02 3.120615e-02
        Cod     1.741616e-02 3.125667e-02 5.104082e-02 8.618376e-02 1.390157e-01
        Saithe  2.013275e-02 3.464860e-02 5.643360e-02 9.425603e-02 1.531877e-01
               w
      predator          8120         9690        11600        13800        16500
        Sprat   3.690967e-09 6.119702e-09 1.019709e-08 1.704605e-08 2.853804e-08
        Sandeel 4.692572e-08 7.755975e-08 1.279972e-07 2.112258e-07 3.483450e-07
        N.pout  8.289164e-01 1.532385e+00 2.190963e+00 3.725975e+00 6.097223e+00
        Herring 4.365931e-04 7.966153e-04 1.155638e-03 1.964068e-03 3.225791e-03
        Dab     1.170025e-01 2.136758e-01 3.132705e-01 5.320790e-01 8.748479e-01
        Whiting 8.851364e-01 1.636281e+00 2.339446e+00 3.978344e+00 6.509674e+00
        Sole    3.166677e-02 5.722249e-02 8.583063e-02 1.454728e-01 2.399645e-01
        Gurnard 3.263458e-02 5.879083e-02 8.887894e-02 1.505606e-01 2.486484e-01
        Plaice  5.953863e-02 1.073418e-01 1.629477e-01 2.761286e-01 4.563653e-01
        Haddock 5.821294e-02 1.060494e-01 1.558461e-01 2.646077e-01 4.352580e-01
        Cod     2.454641e-01 4.334525e-01 6.866163e-01 1.162147e+00 1.936509e+00
        Saithe  2.652205e-01 4.622169e-01 7.502882e-01 1.271921e+00 2.134264e+00
               w
      predator         19600        23400        28000        33400        39900
        Sprat   4.778385e-08 7.995756e-08 1.336986e-07 2.235364e-07 3.741123e-07
        Sandeel 5.738082e-07 9.448626e-07 1.556199e-06 2.560183e-06 4.210027e-06
        N.pout  8.367938e+00 1.253707e+01 2.399424e+01 3.539836e+01 5.283498e+01
        Herring 4.545379e-03 6.942980e-03 1.306310e-02 1.961105e-02 2.980260e-02
        Dab     1.242078e+00 1.895055e+00 3.523968e+00 5.304333e+00 8.057545e+00
        Whiting 8.933304e+00 1.338361e+01 2.561468e+01 3.778592e+01 5.637596e+01
        Sole    3.500979e-01 5.407143e-01 9.806814e-01 1.498806e+00 2.304476e+00
        Gurnard 3.659217e-01 5.671256e-01 1.020253e+00 1.566352e+00 2.416225e+00
        Plaice  6.734583e-01 1.043479e+00 1.869538e+00 2.871445e+00 4.426521e+00
        Haddock 6.205454e-01 9.495843e-01 1.761027e+00 2.658224e+00 4.049627e+00
        Cod     3.002041e+00 4.763716e+00 8.214362e+00 1.294631e+01 2.035887e+01
        Saithe  3.407671e+00 5.497502e+00 9.324405e+00 1.491433e+01 2.372086e+01
      
      , , prey = External
      
               w
      predator  0.001 0.00119 0.00142 0.0017 0.00203 0.00242 0.00289 0.00345 0.00411
        Sprat       0       0       0      0       0       0       0       0       0
        Sandeel     0       0       0      0       0       0       0       0       0
        N.pout      0       0       0      0       0       0       0       0       0
        Herring     0       0       0      0       0       0       0       0       0
        Dab         0       0       0      0       0       0       0       0       0
        Whiting     0       0       0      0       0       0       0       0       0
        Sole        0       0       0      0       0       0       0       0       0
        Gurnard     0       0       0      0       0       0       0       0       0
        Plaice      0       0       0      0       0       0       0       0       0
        Haddock     0       0       0      0       0       0       0       0       0
        Cod         0       0       0      0       0       0       0       0       0
        Saithe      0       0       0      0       0       0       0       0       0
               w
      predator  0.00491 0.00586 0.00699 0.00834 0.00995 0.0119 0.0142 0.0169 0.0202
        Sprat         0       0       0       0       0      0      0      0      0
        Sandeel       0       0       0       0       0      0      0      0      0
        N.pout        0       0       0       0       0      0      0      0      0
        Herring       0       0       0       0       0      0      0      0      0
        Dab           0       0       0       0       0      0      0      0      0
        Whiting       0       0       0       0       0      0      0      0      0
        Sole          0       0       0       0       0      0      0      0      0
        Gurnard       0       0       0       0       0      0      0      0      0
        Plaice        0       0       0       0       0      0      0      0      0
        Haddock       0       0       0       0       0      0      0      0      0
        Cod           0       0       0       0       0      0      0      0      0
        Saithe        0       0       0       0       0      0      0      0      0
               w
      predator  0.0241 0.0288 0.0343 0.0409 0.0489 0.0583 0.0696 0.083 0.0991 0.118
        Sprat        0      0      0      0      0      0      0     0      0     0
        Sandeel      0      0      0      0      0      0      0     0      0     0
        N.pout       0      0      0      0      0      0      0     0      0     0
        Herring      0      0      0      0      0      0      0     0      0     0
        Dab          0      0      0      0      0      0      0     0      0     0
        Whiting      0      0      0      0      0      0      0     0      0     0
        Sole         0      0      0      0      0      0      0     0      0     0
        Gurnard      0      0      0      0      0      0      0     0      0     0
        Plaice       0      0      0      0      0      0      0     0      0     0
        Haddock      0      0      0      0      0      0      0     0      0     0
        Cod          0      0      0      0      0      0      0     0      0     0
        Saithe       0      0      0      0      0      0      0     0      0     0
               w
      predator  0.141 0.168 0.201 0.24 0.286 0.342 0.408 0.486 0.58 0.693 0.827 0.987
        Sprat       0     0     0    0     0     0     0     0    0     0     0     0
        Sandeel     0     0     0    0     0     0     0     0    0     0     0     0
        N.pout      0     0     0    0     0     0     0     0    0     0     0     0
        Herring     0     0     0    0     0     0     0     0    0     0     0     0
        Dab         0     0     0    0     0     0     0     0    0     0     0     0
        Whiting     0     0     0    0     0     0     0     0    0     0     0     0
        Sole        0     0     0    0     0     0     0     0    0     0     0     0
        Gurnard     0     0     0    0     0     0     0     0    0     0     0     0
        Plaice      0     0     0    0     0     0     0     0    0     0     0     0
        Haddock     0     0     0    0     0     0     0     0    0     0     0     0
        Cod         0     0     0    0     0     0     0     0    0     0     0     0
        Saithe      0     0     0    0     0     0     0     0    0     0     0     0
               w
      predator  1.18 1.4 1.68 2 2.39 2.85 3.4 4.06 4.84 5.78 6.9 8.23 9.82 11.7 14
        Sprat      0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Sandeel    0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        N.pout     0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Herring    0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Dab        0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Whiting    0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Sole       0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Gurnard    0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Plaice     0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Haddock    0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Cod        0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
        Saithe     0   0    0 0    0    0   0    0    0    0   0    0    0    0  0
               w
      predator  16.7 19.9 23.8 28.4 33.8 40.4 48.2 57.5 68.7 81.9 97.8 117 139 166
        Sprat      0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Sandeel    0    0    0    0    0    0    0    0    0    0    0   0   0   0
        N.pout     0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Herring    0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Dab        0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Whiting    0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Sole       0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Gurnard    0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Plaice     0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Haddock    0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Cod        0    0    0    0    0    0    0    0    0    0    0   0   0   0
        Saithe     0    0    0    0    0    0    0    0    0    0    0   0   0   0
               w
      predator  198 237 282 337 402 480 573 683 816 973 1160 1390 1650 1970 2360 2810
        Sprat     0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Sandeel   0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        N.pout    0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Herring   0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Dab       0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Whiting   0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Sole      0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Gurnard   0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Plaice    0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Haddock   0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Cod       0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
        Saithe    0   0   0   0   0   0   0   0   0   0    0    0    0    0    0    0
               w
      predator  3350 4000 4780 5700 6800 8120 9690 11600 13800 16500 19600 23400
        Sprat      0    0    0    0    0    0    0     0     0     0     0     0
        Sandeel    0    0    0    0    0    0    0     0     0     0     0     0
        N.pout     0    0    0    0    0    0    0     0     0     0     0     0
        Herring    0    0    0    0    0    0    0     0     0     0     0     0
        Dab        0    0    0    0    0    0    0     0     0     0     0     0
        Whiting    0    0    0    0    0    0    0     0     0     0     0     0
        Sole       0    0    0    0    0    0    0     0     0     0     0     0
        Gurnard    0    0    0    0    0    0    0     0     0     0     0     0
        Plaice     0    0    0    0    0    0    0     0     0     0     0     0
        Haddock    0    0    0    0    0    0    0     0     0     0     0     0
        Cod        0    0    0    0    0    0    0     0     0     0     0     0
        Saithe     0    0    0    0    0    0    0     0     0     0     0     0
               w
      predator  28000 33400 39900
        Sprat       0     0     0
        Sandeel     0     0     0
        N.pout      0     0     0
        Herring     0     0     0
        Dab         0     0     0
        Whiting     0     0     0
        Sole        0     0     0
        Gurnard     0     0     0
        Plaice      0     0     0
        Haddock     0     0     0
        Cod         0     0     0
        Saithe      0     0     0
      

# getSSB works

    Code
      ssb
    Output
          sp
      time        Sprat      Sandeel       N.pout      Herring         Dab
        0      37145900 6.265789e+07     49724174     31588079    45428510
        1     575917716 2.613923e+11 190446858362   7824606777 23076661624
        2    7814067032 7.023337e+11 271273904288 270515349103 57551710161
        3   15802330342 6.113390e+11  31948910838 239363784908 18883825809
        4   81414749920 8.656643e+11  33037600027  84871890996 12185174104
        5  206842833684 1.147589e+12  85333066000 157694761775 19329838688
        6  191611002518 1.173251e+12 103953018251 406406706351 19436621770
        7  120100099090 1.102303e+12  80626050471 431631982246 15311238161
        8   97746469646 1.082858e+12  86043484898 324859176054 12913410822
        9   72098491250 1.036235e+12  85671196460 311784666462  9660305299
        10  40492738633 9.805665e+11  84668035671 301870465791  7686734673
          sp
      time      Whiting         Sole     Gurnard       Plaice      Haddock
        0      43043944     42060666    40851880     37988807 3.536803e+07
        1    7399841911    834864907  1514149261     19890445 4.109643e+10
        2  107891631132  24414397894 11226476531    201605268 1.199978e+12
        3   61509649423  77023573984  4555011538    841756688 1.331796e+12
        4   40099219044  82144972003  4144212499    907094609 6.446614e+11
        5  117230103298 111328023824 15972236414   2364047363 3.422567e+11
        6  162379171056 167863246939 35246908855  14841378014 3.504180e+11
        7  132932145842 173572659430 35999685171  40920662981 4.066822e+11
        8  126270227213 133685285530 33208806725  73962659086 3.440670e+11
        9  119625305144 107246262643 37603583093 179369325753 3.321260e+11
        10 115842330792  98786211305 39171709580 402988935429 3.736885e+11
          sp
      time          Cod       Saithe
        0      28345640     24147443
        1     317801202     23025844
        2   95054359211   3326443515
        3  399329760670  27864977275
        4  486929119822 354651541387
        5  442885308583 764517034908
        6  467537989947 638622021004
        7  541688096699 561901096462
        8  577562657758 570688513875
        9  569271264625 551987825099
        10 550974880423 539397319631

# getBiomass works

    Code
      biomass
    Output
          sp
      time        Sprat      Sandeel       N.pout      Herring         Dab
        0      65513764 7.073435e+07     64140470 4.734134e+07    48975867
        1   13776542673 4.431722e+11 884311461350 1.679406e+11 52125246231
        2   69927090828 8.334279e+11 398113892165 6.633953e+11 69311641184
        3  196178298542 7.655039e+11 263062470907 4.911663e+11 26400310128
        4  467001820977 1.057086e+12 388815396674 6.554603e+11 25336503008
        5  586122472820 1.326234e+12 432427619741 1.051799e+12 31316617256
        6  439864049292 1.338340e+12 382607796520 1.290685e+12 27971617047
        7  325431393775 1.268699e+12 382528078657 1.126221e+12 22793785496
        8  259438366675 1.241672e+12 385314743329 9.853990e+11 18616401195
        9  168072108987 1.187429e+12 374618086140 9.111329e+11 13366247507
        10 112805317823 1.130052e+12 369689726718 8.352748e+11 10705808689
          sp
      time      Whiting         Sole      Gurnard       Plaice      Haddock
        0      45940000     46360962     43758415 3.944022e+07 3.686245e+07
        1   72325557621  32974490507  23988311156 3.733324e+09 5.604403e+11
        2  173308427835 179202796422  40793946473 7.137713e+09 2.119497e+12
        3  117846970097 249863834334  60856405479 1.183756e+10 1.486612e+12
        4  203658370643 270326828529 112409616387 5.413724e+10 9.738437e+11
        5  295431079864 353136907023 150599989861 1.197220e+11 9.025969e+11
        6  285987000126 386905955236 171493119697 2.196872e+11 9.652997e+11
        7  249731861732 325763395644 178431271162 5.582246e+11 9.081844e+11
        8  243238355964 255841252168 183165332241 1.044344e+12 8.601281e+11
        9  218537576517 208399616056 175732741240 1.439675e+12 8.780346e+11
        10 216920528940 175305133554 166304704675 2.077124e+12 8.937868e+11
          sp
      time          Cod       Saithe
        0      29516031     24941126
        1    8844683276    628447917
        2  222717740533  65157077687
        3  519940305983 332255306825
        4  541663127233 802202230048
        5  511830172129 941350225783
        6  565465750259 884216821268
        7  641525006539 859898246255
        8  666602257799 840871498264
        9  649647263455 814937817724
        10 642008780708 816924674119

# getN works

    Code
      N
    Output
          sp
      time        Sprat      Sandeel       N.pout      Herring        Dab
        0      23713127     21850922 7.615182e+06      2142447    2216418
        1   34583248992 247600863018 1.274992e+12 121318364034 7907052028
        2  230119751914 241972967242 1.238590e+12 197979209800 5085071434
        3  328776028465 250800357309 1.176283e+12 244251821097 4329912688
        4  381969496585 297036226772 1.063123e+12 270492480143 4838340296
        5  346792116610 305809303216 1.166909e+12 247415551330 4447322515
        6  310119103012 293236732494 1.215371e+12 233390436367 3927367907
        7  278023064449 287152986319 1.197628e+12 227629388621 3535160928
        8  226780745986 279434533301 1.183927e+12 211875688687 2866656461
        9  207644130903 270396964090 1.183458e+12 205288338511 2506411772
        10 178818045890 263526732256 1.183037e+12 195736661084 2207416601
          sp
      time      Whiting         Sole      Gurnard       Plaice      Haddock
        0  5.685237e+05 7.942002e+05      1036991 2.159202e+05 1.454882e+05
        1  6.492671e+10 1.216035e+10  31879437974 2.026290e+09 2.003195e+11
        2  8.790001e+10 2.422797e+10 173785869704 3.935872e+09 1.868930e+11
        3  1.093769e+11 2.528947e+10 184703190172 2.703342e+10 2.332071e+11
        4  1.145599e+11 2.679343e+10 142095437977 6.077422e+10 2.634273e+11
        5  1.029377e+11 2.534224e+10 211815145232 8.502026e+10 2.379120e+11
        6  9.875065e+10 2.232665e+10 263115420442 4.272288e+11 2.251337e+11
        7  9.738546e+10 1.979589e+10 273170037913 1.346858e+12 2.306667e+11
        8  9.030275e+10 1.683392e+10 255764608143 2.176369e+12 2.284867e+11
        9  8.855942e+10 1.500565e+10 257055318804 4.372260e+12 2.261960e+11
        10 8.493232e+10 1.341573e+10 255418593359 8.279013e+12 2.250781e+11
          sp
      time          Cod       Saithe
        0  1.372279e+04 1.367845e+04
        1  8.536863e+08 1.248493e+08
        2  1.568876e+09 1.769911e+10
        3  1.719043e+09 2.327989e+10
        4  1.886512e+09 2.605695e+10
        5  1.853967e+09 2.656917e+10
        6  1.801151e+09 2.485131e+10
        7  1.780834e+09 2.497648e+10
        8  1.679305e+09 2.540937e+10
        9  1.617074e+09 2.521490e+10
        10 1.580292e+09 2.509015e+10

