% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/illparms.R
\name{illparms}
\alias{illparms}
\alias{illparms.mkinfit}
\alias{print.illparms.mkinfit}
\alias{illparms.mmkin}
\alias{print.illparms.mmkin}
\alias{illparms.saem.mmkin}
\alias{print.illparms.saem.mmkin}
\alias{illparms.mhmkin}
\alias{print.illparms.mhmkin}
\title{Method to get the names of ill-defined parameters}
\usage{
illparms(object, ...)

\method{illparms}{mkinfit}(object, conf.level = 0.95, ...)

\method{print}{illparms.mkinfit}(x, ...)

\method{illparms}{mmkin}(object, conf.level = 0.95, ...)

\method{print}{illparms.mmkin}(x, ...)

\method{illparms}{saem.mmkin}(object, conf.level = 0.95, random = TRUE, errmod = TRUE, ...)

\method{print}{illparms.saem.mmkin}(x, ...)

\method{illparms}{mhmkin}(object, conf.level = 0.95, random = TRUE, errmod = TRUE, ...)

\method{print}{illparms.mhmkin}(x, ...)
}
\arguments{
\item{object}{The object to investigate}

\item{\dots}{For potential future extensions}

\item{conf.level}{The confidence level for checking p values}

\item{x}{The object to be printed}

\item{random}{For hierarchical fits, should random effects be tested?}

\item{errmod}{For hierarchical fits, should error model parameters be
tested?}
}
\value{
For \link{mkinfit} or \link{saem} objects, a character vector of parameter
names. For \link{mmkin} or \link{mhmkin} objects, a matrix like object of class
'illparms.mmkin' or 'illparms.mhmkin'.
}
\description{
The method for generalised nonlinear regression fits as obtained
with \link{mkinfit} and \link{mmkin} checks if the degradation parameters
pass the Wald test (in degradation kinetics often simply called t-test) for
significant difference from zero. For this test, the parameterisation
without parameter transformations is used.
}
\details{
The method for hierarchical model fits, also known as nonlinear
mixed-effects model fits as obtained with \link{saem} and \link{mhmkin}
checks if any of the confidence intervals for the random
effects expressed as standard deviations include zero, and if
the confidence intervals for the error model parameters include
zero.
}
\note{
All return objects have printing methods. For the single fits, printing
does not output anything in the case no ill-defined parameters are found.
}
\examples{
fit <- mkinfit("FOMC", FOCUS_2006_A, quiet = TRUE)
illparms(fit)
\dontrun{
fits <- mmkin(
  c("SFO", "FOMC"),
  list("FOCUS A" = FOCUS_2006_A,
       "FOCUS C" = FOCUS_2006_C),
  quiet = TRUE)
illparms(fits)
}
}
