% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensors.R
\docType{data}
\name{sensors}
\alias{sensors}
\title{Sensors}
\format{
A data frame with the following variables:
\describe{
\item{\code{sensor_id}}{Identifier for the integrated sensor.}
\item{\code{sensor_nu}}{Serial number for the sensor.}
\item{\code{sensor_brand_nm}}{Brand name.}
\item{\code{sensor_model_cd}}{Model code.}
\item{\code{press_unit_cd}}{Pressure unit code.}
\item{\code{temp_unit_cd}}{Temperature unit code.}
\item{\code{sensor_tp}}{Integrated sensor types.}
\item{\code{temp_lower_va}}{Lower temperature range, in degree Celsius.}
\item{\code{temp_upper_va}}{Upper temperature range, in degree Celsius.}
\item{\code{press_lower_va}}{Lower fluid pressure range, in pounds per square inch (psi).}
\item{\code{press_upper_va}}{Upper fluid pressure range, in psi.}
\item{\code{press_res_va}}{Pressure resolution, in psi.}
\item{\code{press_acc_va}}{Pressure accuracy, in psi.}
\item{\code{press_repeat_acc_va}}{Repeated pressure accuracy, in psi.}
\item{\code{press_hyster_acc_va}}{Hysteresis error of the pressure sensor, in psi.}
\item{\code{response_time_tx}}{Response time description.}
}
}
\source{
The dataset originates from the USGS INL Project Office
and underwent processing using the \code{\link{read_sensors_json}} function.
}
\usage{
sensors
}
\description{
Dataset of sensors used to make measurements at port couplings
in the Multilevel Monitoring System (MLMS) wells of the
U.S. Geological Survey (USGS) aquifer-monitoring network,
Idaho National Laboratory (INL), Idaho.
Sensor calibration measurements are stored in the \code{\link{calibrations}} dataset.
}
\examples{
str(sensors)
}
\keyword{datasets}
