/**
 * @file src/bayesian_linear_regression.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R bayesian_linear_regression binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/bayesian_linear_regression/bayesian_linear_regression_main.cpp>

// [[Rcpp::export]]
void bayesian_linear_regression_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a BayesianLinearRegression parameter.
// [[Rcpp::export]]
SEXP IO_GetParamBayesianLinearRegressionPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<BayesianLinearRegression>) IO::GetParam<BayesianLinearRegression*>(paramName));
}

// Set the pointer to a BayesianLinearRegression parameter.
// [[Rcpp::export]]
void IO_SetParamBayesianLinearRegressionPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<BayesianLinearRegression*>(paramName) =  Rcpp::as<Rcpp::XPtr<BayesianLinearRegression>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a BayesianLinearRegression pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeBayesianLinearRegressionPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("BayesianLinearRegression",
          *Rcpp::as<Rcpp::XPtr<BayesianLinearRegression>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "BayesianLinearRegression";
  return raw_vec;
}

// Deserialize a BayesianLinearRegression pointer.
// [[Rcpp::export]]
SEXP DeserializeBayesianLinearRegressionPtr(Rcpp::RawVector str)
{
  BayesianLinearRegression* ptr = new BayesianLinearRegression();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("BayesianLinearRegression", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<BayesianLinearRegression>)ptr);
}


